//
// C++ Implementation: kpg7stepswizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpg7stepswizard.h"

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <kcursor.h>
#include <klocale.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../DbObjects/kpgconnection.h"

KPG7StepsWizard::KPG7StepsWizard(QWidget *parent, const char *name)
 : KPG7StepsWizardBase(parent, name)
{
	m_pConnection = 0;
    m_pTextEditSQL->setFont( KPoGreView::configuration()->sqleditor()->font() );   
	m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditSQL);
	
	m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
  	m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
    	
	setNextEnabled(WizardPage1, false);
	setNextEnabled(WizardPage2, false);
}


KPG7StepsWizard::~KPG7StepsWizard()
{
	delete m_pSyntaxHighlighter;
	
	if(m_pConnection)
	{
		KPGNoticer * pPgNoticer = m_pConnection->kpgNoticer();
		disconnect(pPgNoticer, SIGNAL(sigNotice(QString)), this, SLOT(slotProcessNotice(QString)));
	}
}

// Set connection for wizard operation
void KPG7StepsWizard::setConnection(KPGConnection * pConnection)
{
	m_pConnection = pConnection;
	KPGNoticer * pPgNoticer = pConnection->kpgNoticer();
	connect(pPgNoticer, SIGNAL(sigNotice(QString)), this, SLOT(slotProcessNotice(QString)));
}

// Run SQL query - as final Wizard operation
void KPG7StepsWizard::runQuery(bool bWithTransaction) 
{
	m_listOfNotifications.clear();
	m_pTextEditResult->clear();
	 
   	// Run SQL statement
   	if(m_pConnection == 0)
    {
      kdError() << "KPG7StepsWizard::runQuery - Database not connected to server !" << endl;
      m_pTextEditResult->setText("Database not connected to server !");
    }
    else
    { 
      try
      { 
        setCursor(KCursor::waitCursor());
        
        pqxx::result R = m_pConnection->runQuery(m_pTextEditSQL->text(), bWithTransaction ? KPGConnection::eTransNormal : KPGConnection::eTransNone);
        
		if(m_listOfNotifications.count() > 0)
        {
			m_pTextEditResult->setText(m_listOfNotifications.join(""));
			m_listOfNotifications.clear();
        }
        
		m_pTextEditResult->append(i18n("\nOperation finished"));
				
        setFinishEnabled(WizardPage7, true);
        setCursor(KCursor::arrowCursor());
      }
      catch (const std::exception &e)
      {
		m_pTextEditResult->append(e.what());
		setCursor(KCursor::arrowCursor());
      } 
    }
}

// Enable/disable next button for 1st page
void KPG7StepsWizard::slotEnableNextButton1(bool bEnable)
{
	  setNextEnabled(WizardPage1, bEnable);
}

// Enable/disable next button for 2nd page
void KPG7StepsWizard::slotEnableNextButton2(bool bEnable)
{
	  setNextEnabled(WizardPage2, bEnable);
}

// Enable/disable next button for 3rd page
void KPG7StepsWizard::slotEnableNextButton3(bool bEnable)
{
	  setNextEnabled(WizardPage3, bEnable);
}

// Enable/disable next button for 4th page
void KPG7StepsWizard::slotEnableNextButton4(bool bEnable)
{
	  setNextEnabled(WizardPage4, bEnable);
}

// Enable/disable next button for 5th page
void KPG7StepsWizard::slotEnableNextButton5(bool bEnable)
{
	  setNextEnabled(WizardPage5, bEnable);
}

// Process notice from connection
void KPG7StepsWizard::slotProcessNotice(QString strNotice)
{
	m_listOfNotifications << strNotice;
}

#include "kpg7stepswizard.moc"
