//
// C++ Implementation: kpgcreatetablewidget2
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablewidget2.h"

// include files for Qt
#include <qlabel.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kcombobox.h> 
#include <klistview.h>
#include <kpushbutton.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgdomainsfolder.h"
#include "../DbObjects/kpgtypesfolder.h"
#include "../kpgutil.h"


#define NUM_BASIC_TYPES 35


KPGCreateTableWidget2::KPGCreateTableWidget2(QWidget *parent, const char *name, KPGDatabase *pDatabase)
	: KPGCreateTableWidget2Base(parent, name)
{
	m_pDatabase = pDatabase;
    
    m_pListViewColumns->setAllColumnsShowFocus(true);
    m_pListViewColumns->setSortColumn(-1);
  
    // fill schemas to combobox
    KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxSchema, true); // only user schemas
	
	m_bIsDirty1 = false;
	m_bIsDirty2 = false;
}


KPGCreateTableWidget2::~KPGCreateTableWidget2()
{
}

void KPGCreateTableWidget2::refreshListOfDatatypes()
{
  m_pComboBoxDataType->clear();
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "char(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "varchar(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "text");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnXml, "xml");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "smallint");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "integer");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigint");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "decimal(p, s)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "numeric(p, s)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "real");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "double precision");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "money");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "serial");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigserial");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnUuid, "uuid");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit varying(n)");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBool, "bool");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)]");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)] with time zone");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "date");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)]");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)] with time zone");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "interval [(p)]");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBin, "bytea");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "point");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "line");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "lseg");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "polygon");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "box");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "path");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "circle");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "inet");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "cidr");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "macaddr");
  
  if(m_pComboBoxDataType->count() != NUM_BASIC_TYPES)
    kdDebug() << "KPGCreateTableWidget2::refreshListOfDatatypes : NUM_BASIC_TYPES wrong number" << endl;
  
  fillDomains();
  fillUserDatatypes();
}

void KPGCreateTableWidget2::fillDomains()
{
  QString strNamespace(m_pComboBoxSchema->currentText());
  
  KPGTreeItem *pItem = m_pDatabase->getChildByName(strNamespace);
  if(!pItem)
  {
    kdDebug() << "KPGCreateTableWidget2::fillDomains: no item found: " << strNamespace << endl;
    return;
  }
        
  KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
  KPGDomainsFolder *pDomainsFolder = pSchema->getDomainsFolder();
  
  pDomainsFolder->fillComboBoxWithChildItems(m_pComboBoxDataType);
  
  m_pComboBoxDataType->setCurrentItem(0);
}

void KPGCreateTableWidget2::fillUserDatatypes()
{
  QString strNamespace(m_pComboBoxSchema->currentText());
  
  KPGTreeItem *pItem = m_pDatabase->getChildByName(strNamespace);
  if(!pItem)
  {
    kdDebug() << "KPGCreateTableWidget2::fillUserDatatypes: no item found: " << strNamespace << endl;
    return;
  }
        
  KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
  KPGTypesFolder *pTypesFolder = pSchema->getTypesFolder();
  
  pTypesFolder->fillComboBoxWithChildItems(m_pComboBoxDataType, true);
  
  m_pComboBoxDataType->setCurrentItem(0);
  slotComboDataTypeActivated(m_pComboBoxDataType->currentText());
}

void KPGCreateTableWidget2::slotSchemaActivated(int)
{
  refreshListOfDatatypes();
}

// Display comment for selected data type
void KPGCreateTableWidget2::slotComboDataTypeActivated(const QString& strText)
{
	// Enable/disable precision and scale spins
	m_pSpinBoxPrecision->setEnabled(false);
	m_pSpinBoxScale->setEnabled(false);
	m_pCheckBoxDefault->setEnabled(true);
	m_pButtonSetDefaultNow->setEnabled(false);
	
	if(strText.find("(n)") > 0)
	{
		m_pSpinBoxPrecision->setEnabled(true);
	}
	
	if(strText.find("(p, s)") > 0)
	{
		m_pSpinBoxPrecision->setEnabled(true);
		m_pSpinBoxScale->setEnabled(true);
	}
	
	if(strText.find("[(p)]") > 0)
	{
		m_pSpinBoxPrecision->setEnabled(true);
	}

	// Set help text for selected data type
	if(strText == "char(n)")
	{	
		m_pTextLabelComment->setText("fixed-length, blank padded character string");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
		
		m_pSpinBoxPrecision->setValue( 10 );
		
		return;
	}    

	if(strText == "varchar(n)")
	{	
		m_pTextLabelComment->setText("variable-length character string");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
		
		m_pSpinBoxPrecision->setValue( 10 );
		
		return;
	}    

	if(strText == "text")
	{	
		m_pTextLabelComment->setText("variable-length character string, unlimited length");
		return;
	}
	  
	if(strText == "xml")
	{	
		m_pTextLabelComment->setText("XML well-formed data, unlimited length");
		return;
	}  


	if(strText == "smallint")
	{	
		m_pTextLabelComment->setText("2 bytes, small range fixed-precision, -32768 to +32767");
		return;
	}    

	if(strText == "integer")
	{	
		m_pTextLabelComment->setText("4 bytes, usual choice for fixed-precision, -2147483648 to +2147483647");
		return;
	}    

	if(strText == "bigint")
	{	
		m_pTextLabelComment->setText("8 bytes, large range fixed-precision, -9223372036854775808 to 9223372036854775807");
		return;
	}    

	if((strText == "decimal(p, s)") || (strText == "numeric(p, s)"))
	{	
		m_pTextLabelComment->setText("variable, user-specified precision, exact, no limit");
		
		m_pSpinBoxPrecision->setMinValue( 1 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
    
		m_pSpinBoxScale->setMinValue( 0 );
		m_pSpinBoxScale->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 10 );
		return;
	}    

	if(strText == "real")
	{	
		m_pTextLabelComment->setText("4 bytes, variable-precision, inexact, 6 decimal digits precision");
		return;
	}    

	if(strText == "double precision")
	{	
		m_pTextLabelComment->setText("8 bytes, variable-precision, inexact, 15 decimal digits precision");
		return;
	}    

	if(strText == "money")
	{	
		m_pTextLabelComment->setText("currency amount. This datatype is deprecated. Use a numeric datatype instead");
		return;
	}  
	
	if(strText == "serial")
	{	
		m_pTextLabelComment->setText("4 bytes, autoincrementing integer, 1 to 2147483647");
		m_pCheckBoxDefault->setEnabled(false);
		return;
	}    

	if(strText == "bigserial")
	{	
		m_pTextLabelComment->setText("8 bytes, large autoincrementing integer, 1 to 9223372036854775807");
		m_pCheckBoxDefault->setEnabled(false);
		return;
	}
	
	if(strText == "uuid")
	{	
		m_pTextLabelComment->setText("Universally Unique Identifier  (UUID)");
		return;
	}  
	
	if(strText == "bit(n)")
	{	
		m_pTextLabelComment->setText("fixed-length bit string");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
		
		m_pSpinBoxPrecision->setValue( 255 );	
		return;
	}
	
	if(strText == "bit varying(n)")
	{	
		m_pTextLabelComment->setText("variable-length bit string");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 999 );
		
		m_pSpinBoxPrecision->setValue( 255 );
		
		return;
	}
		
	if(strText == "bool")
	{	
		m_pTextLabelComment->setText("logical Boolean (true/false)");
		return;
	}
	
	if(strText == "date")
	{	
		m_pTextLabelComment->setText("date, 4 bytes, 4713 BC - AD 32767");
		m_pButtonSetDefaultNow->setEnabled(true);
		return;
	}
		
	if(strText == "time [(p)]")
	{	
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 13 );
		
		m_pSpinBoxPrecision->setValue( 13 );
		
		m_pTextLabelComment->setText("time of day, 8 bytes, 00:00:00.00 - 23:59:59.99");
		return;
	}
	
	if(strText == "time [(p)] with time zone")
	{	
		m_pTextLabelComment->setText("time of day including time zone, 12 bytes, 00:00:00.00+12 - 23:59:59.99-12");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 13 );
		
		m_pSpinBoxPrecision->setValue( 13 );
		return;
	}
	
	if(strText == "timestamp [(p)]")
	{	
		m_pTextLabelComment->setText("date and time, 8 bytes, 4713 BC - AD 1465001");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 6 );
		
		m_pSpinBoxPrecision->setValue( 6 );
		m_pButtonSetDefaultNow->setEnabled(true);

		return;
	}
	
	if(strText == "timestamp [(p)] with time zone")
	{	
		m_pTextLabelComment->setText("date and time, including time zone, 8 bytes, 4713 BC - AD 1465001");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 6 );
		
		m_pSpinBoxPrecision->setValue( 6 );
		m_pButtonSetDefaultNow->setEnabled(true);
		return;
	}
	
	if(strText == "interval [(p)]")
	{	
		m_pTextLabelComment->setText("time span, 12 bytes, from -178000000 years to 178000000 years");
		
		m_pSpinBoxPrecision->setMinValue( 0 );
		m_pSpinBoxPrecision->setMaxValue( 6 );
		
		m_pSpinBoxPrecision->setValue( 6 );
		
		return;
	}
	
	if(strText == "bytea")
	{	
		m_pTextLabelComment->setText("variable-length binary data, 4 bytes plus the data");
		return;
	}
		
	if(strText == "point")
	{	
		m_pTextLabelComment->setText("geometric point in 2D plane");
		return;
	}
	
	if(strText == "line")
	{	
		m_pTextLabelComment->setText("infinite line in 2D plane");
		return;
	}
	
	if(strText == "lseg")
	{	
		m_pTextLabelComment->setText("line segment in 2D plane");
		return;
	}
	
	if(strText == "polygon")
	{	
		m_pTextLabelComment->setText("closed geometric path in 2D plane");
		return;
	}
	
	if(strText == "box")
	{	
		m_pTextLabelComment->setText("rectangular box in 2D plane");
		return;
	}
	
	if(strText == "path")
	{	
		m_pTextLabelComment->setText("open and closed geometric path in 2D plane");
		return;
	}
	
	if(strText == "circle")
	{	
		m_pTextLabelComment->setText("circle (center and radius) in 2D plane");
		return;
	}
	
	if(strText == "inet")
	{	
		m_pTextLabelComment->setText("IP host address, 12 bytes");
		return;
	}
	
	if(strText == "cidr")
	{	
		m_pTextLabelComment->setText("IP network address, 12 bytes");
		return;
	}
	
	if(strText == "macaddr")
	{	
		m_pTextLabelComment->setText("MAC address (Ethernet card hardware address), 6 bytes");
		return;
	}
	
	m_pTextLabelComment->setText("");
}

// Add new column to list
void KPGCreateTableWidget2::slotColumnAdd()
{
	QString strColumnName(m_pLineEditColumnName->text());
	QString strNamespace(m_pComboBoxSchema->currentText());
	
	QString strDefinition;
	
	if((m_pComboBoxDataType->currentItem() <= NUM_BASIC_TYPES - 1) || (strNamespace == "public"))
		strDefinition = m_pComboBoxDataType->currentText(); // Don't quote build-in names
	else
		strDefinition = KPGUtil::fullyQualifiedName(strNamespace, m_pComboBoxDataType->currentText());
		
	if(strColumnName.isEmpty())
	{
		kdDebug() << "KPGCreateTableWidget2::slotColumnAdd - column name is empty !" << endl;
		return;
	}
	
	// Avoid column name duplicity
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewColumns->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		
		if(pItem->text(0) == strColumnName)
		{ 
			KMessageBox::sorry(this, i18n("Column name already exists !"));
			return;		
		}	
	  
		pItem = pItem->nextSibling();
	}
	
	//-----------------------------------------------------------	
	int i;
	if((i = strDefinition.find("(n)")) > 0)
	{
		strDefinition = strDefinition.left(strDefinition.length() - 3); // strip (n)
				
		strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
	}
	
	if((i = strDefinition.find("(p, s)")) > 0)
	{
		strDefinition = strDefinition.left(strDefinition.length() - 6); // strip (p, s)
		
		strDefinition.append(QString("(%1, %2)").arg(m_pSpinBoxPrecision->value()).arg(m_pSpinBoxScale->value()));
	}
	
	if((i = strDefinition.find("[(p)]")) > 0)
	{
		QString strDefinitionPostfix(strDefinition.mid(i + 5, strDefinition.length() - i - 5));
		strDefinition = strDefinition.left(i); // strip (n)
		
		strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
		strDefinition.append(strDefinitionPostfix);
	}
	
	// Append another properties
	if(m_pSpinBoxNumDimensions->value() > 0)
		strDefinition.append(m_pLineEditArrayDimDef->text());
	
	if(m_pCheckBoxUnique->isChecked())	
		strDefinition.append(" UNIQUE");
	
	if(m_pCheckBoxNotNull->isChecked())	
		strDefinition.append(" NOT NULL");
					
	if(m_pCheckBoxDefault->isChecked() && ! m_pLineEditDefaultValue->text().isEmpty())	
	{
		if(m_pCheckBoxQuotedDefault->isChecked() == false)
			strDefinition.append(" DEFAULT " + m_pLineEditDefaultValue->text());
		else
			strDefinition.append(" DEFAULT '" + m_pLineEditDefaultValue->text() + "'");
	}
	
	if(m_pCheckBoxCheck->isChecked() && ! m_pLineEditCheck->text().isEmpty())	
		strDefinition.append(" CHECK (" + m_pLineEditCheck->text() + ")");
				
	// Create item for new column
	QListViewItem *pNewItem;
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewColumns, strColumnName, strDefinition);
	else
		pNewItem = new QListViewItem(m_pListViewColumns, pLastItem, strColumnName, strDefinition);
	
	pNewItem->setPixmap(0, * m_pComboBoxDataType->pixmap(m_pComboBoxDataType->currentItem()));
	
	// Add column info to list
	m_listOfColumns.appendColumn(new KPGTableColumnWizInfo(strColumnName, m_pComboBoxDataType->currentText(), m_pSpinBoxNumDimensions->value(), 1, *pNewItem->pixmap(0), QString::null));
	
	emit sigEnableNextButton(true);
	m_pLineEditColumnName->setFocus(); // prepare for new column
	m_pLineEditColumnName->setText("");
	m_pLineEditDefaultValue->setText("");
	m_pLineEditCheck->setText("");
	m_pCheckBoxDefault->setChecked(false);
	m_pCheckBoxCheck->setChecked(false);
	m_pCheckBoxUnique->setChecked(false);
	
	m_bIsDirty1 = true;
	m_bIsDirty2 = true;
}

// Delete selected column
void KPGCreateTableWidget2::slotColumnDelete()
{
    QListViewItem *pSelectedItem = m_pListViewColumns->selectedItem();
	if(pSelectedItem)
	{ 
		m_listOfColumns.removeColumn(pSelectedItem->text(0));
		delete pSelectedItem;
	}
			
	if(!m_pListViewColumns->firstChild())
		emit sigEnableNextButton(false);
			
	m_bIsDirty1 = true;
	m_bIsDirty2 = true;
}

// Move selected column Up
void KPGCreateTableWidget2::slotColumnUp()
{
    QListViewItem *pSelectedItem = m_pListViewColumns->selectedItem();
	if(!pSelectedItem) return;
		
	QListViewItem *pPrevItem = pSelectedItem->itemAbove();
	if(!pPrevItem) return;
		
	pPrevItem = pPrevItem->itemAbove();
				
	m_pListViewColumns->takeItem(pSelectedItem);
		
	QListViewItem *pNewItem;
		 
	if(pPrevItem)
		pNewItem = new QListViewItem(m_pListViewColumns, pPrevItem, pSelectedItem->text(0),  pSelectedItem->text(1));
	else
		pNewItem = new QListViewItem(m_pListViewColumns, pSelectedItem->text(0),  pSelectedItem->text(1));
		
	pNewItem->setPixmap(0, * pSelectedItem->pixmap(0));
		 		 
	delete pSelectedItem;
		 
	m_pListViewColumns->setCurrentItem(pNewItem);
	m_pListViewColumns->setSelected(pNewItem, true);
		
	m_bIsDirty1 = true;
	m_bIsDirty2 = true;
}

// Move selected column Down
void KPGCreateTableWidget2::slotColumnDown()
{
    QListViewItem *pSelectedItem = m_pListViewColumns->selectedItem();
	if(!pSelectedItem) return;
		
	QListViewItem *pAfterItem = pSelectedItem->itemBelow();
	if(!pAfterItem) return;
		
	m_pListViewColumns->takeItem(pSelectedItem);
		 
	QListViewItem *pNewItem = new QListViewItem(m_pListViewColumns, pAfterItem, pSelectedItem->text(0), pSelectedItem->text(1));
	pNewItem->setPixmap(0, * pSelectedItem->pixmap(0));
		 		 
	delete pSelectedItem;
		 
	m_pListViewColumns->setCurrentItem(pNewItem);
	m_pListViewColumns->setSelected(pNewItem, true);
		
	m_bIsDirty1 = true;
	m_bIsDirty2 = true;
}

// Fired, when user change column name
void KPGCreateTableWidget2::slotColumnNameChanged(const QString& strText)
{
    m_pBtnAddColumn->setEnabled(! strText.isEmpty());
}


void KPGCreateTableWidget2::slotColumnSelectionChanged(QListViewItem *pItem)
{
    m_pBtnDelColumn->setEnabled(pItem != 0);
	m_pBtnColumnUp->setEnabled(pItem != 0);
	m_pBtnColumnDown->setEnabled(pItem != 0);
}

void KPGCreateTableWidget2::slotColumnCurrentChanged(QListViewItem *pItem)
{
    m_pBtnDelColumn->setEnabled(pItem != 0);
	m_pBtnColumnUp->setEnabled(pItem != 0);
	m_pBtnColumnDown->setEnabled(pItem != 0);
}

void KPGCreateTableWidget2::slotNumDimensionsChanged(int nDimensions)
{
    if(nDimensions > 0)
	{
		m_pLineEditArrayDimDef->setEnabled(true);
		QString strDimensionsDef;
		for(int i = 0; i < nDimensions; i++)
		 strDimensionsDef.append("[]");
			 
		 m_pLineEditArrayDimDef->setText(strDimensionsDef);
	}
	else
	{
		m_pLineEditArrayDimDef->setEnabled(false);
		m_pLineEditArrayDimDef->setText("");
	}
}

void KPGCreateTableWidget2::slotCheckToggled(bool bCheck)
{
    m_pLineEditCheck->setEnabled(bCheck);
		
	if(bCheck)
	{
		m_pLineEditCheck->setFocus();
		m_pLineEditCheck->setText(m_pLineEditColumnName->text() + " ");
	}
}

void KPGCreateTableWidget2::slotDefaultToggled(bool bDefault)
{
    m_pLineEditDefaultValue->setEnabled(bDefault);
	m_pCheckBoxQuotedDefault->setEnabled(bDefault);
	m_pLineEditDefaultValue->setFocus();
}

void KPGCreateTableWidget2::slotSetDefaultToNow()
{
	m_pCheckBoxDefault->setChecked(true);
	m_pCheckBoxQuotedDefault->setChecked(false);
	m_pLineEditDefaultValue->setEnabled(true);
	m_pCheckBoxQuotedDefault->setEnabled(true);
	m_pLineEditDefaultValue->setText("now()");
}

// Return part of SQL statement for CREATE TABLE
const QString KPGCreateTableWidget2::getSQL() const
{
	QString strSql;
	
	QListViewItem * pItem = m_pListViewColumns->firstChild();
	while(pItem)
	{
		strSql.append(KPGUtil::quotedName(pItem->text(0))); // column name
		strSql.append(" ");
		strSql.append(pItem->text(1)); // definition
			  
		pItem = pItem->nextSibling();
		
		if(pItem)
			strSql.append(",\n");
	}
	
	return strSql;
}


#include "kpgcreatetablewidget2.moc"
