//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifytablecolumnwizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <knuminput.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgtablecolumn.h"
#include "kpgmodifycolumnstatswidget1.h"
#include "kpgmodifycolumnstoragewidget1.h"
#include "kpgmodifycolumntypewidget1.h"
#include "kpgmodifycolumndefaultwidget1.h"
#include "../kpgutil.h"


KPGModifyTableColumnWizard::KPGModifyTableColumnWizard(QWidget *parent, const char *name, KPGSchema *pSchema, KPGTable *pTable, KPGTableColumn *pColumn, EWizardMode eWizardMode)
 : KPG3StepsWizard(parent, name)
{
  m_strTableName = pTable->text(0);
  m_strNamespaceName = pSchema->text(0);
  m_strColumnName = pColumn->text(0);
  m_eWizardMode = eWizardMode;
  
  switch(m_eWizardMode)
    {
      case modeDefault:
          {
            KPGModifyColumnDefaultWidget1 *pModifyColumnWidget1 = new KPGModifyColumnDefaultWidget1(WizardPage1, "KPGModifyColumnDefaultWidget1");
            m_pPageWidget1 = pModifyColumnWidget1;
            WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
            connect(pModifyColumnWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
          }
          break;
          
      case modeType:
          {
            KPGModifyColumnTypeWidget1 *pModifyColumnWidget1 = new KPGModifyColumnTypeWidget1(WizardPage1, "KPGModifyColumnTypeWidget1", pSchema->getDomainsFolder());
            m_pPageWidget1 = pModifyColumnWidget1;
            WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
            setNextEnabled(WizardPage1, true);
          }
          break;
          
      case modeStorage:
          {
            KPGModifyColumnStorageWidget1 *pModifyColumnWidget1 = new KPGModifyColumnStorageWidget1(WizardPage1, "KPGModifyColumnStorageWidget1");
            m_pPageWidget1 = pModifyColumnWidget1;
            WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
            setNextEnabled(WizardPage1, true);
          }
          break;
          
      case modeStats:
          {
            KPGModifyColumnStatsWidget1 *pModifyColumnWidget1 = new KPGModifyColumnStatsWidget1(WizardPage1, "KPGModifyColumnStatsWidget1");
            m_pPageWidget1 = pModifyColumnWidget1;
            WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
            setNextEnabled(WizardPage1, true);
          }
          break;
    }
          
  languageChange();
}


KPGModifyTableColumnWizard::~KPGModifyTableColumnWizard()
{
}

void KPGModifyTableColumnWizard::setDefaultExpression(const QString &strText)
{
  if(m_eWizardMode != modeDefault)
  {
    kdDebug() << "KPGModifyTableColumnWizard::setDefaultExpression: wrong usage !" << endl;
    return;
  }
  
  KPGModifyColumnDefaultWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnDefaultWidget1 *> (m_pPageWidget1);
  pModifyColumnWidget1->m_pLineEditDefaultExpression->setText(strText);
}

void KPGModifyTableColumnWizard::setStorage(const QString &strText)
{
  if(m_eWizardMode != modeStorage)
  {
    kdDebug() << "KPGModifyTableColumnWizard::setStorage: wrong usage !" << endl;
    return;
  }
  
  // remove given text from combobox
  KPGModifyColumnStorageWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnStorageWidget1 *> (m_pPageWidget1);
  for(int i = 0; i < pModifyColumnWidget1->m_pComboBoxStorage->count(); i++)
  {
    if(pModifyColumnWidget1->m_pComboBoxStorage->text(i) == strText)
    {
      pModifyColumnWidget1->m_pComboBoxStorage->removeItem(i);
      pModifyColumnWidget1->m_pComboBoxStorage->setCurrentItem(0);
      break;
    }  
  }
}

void KPGModifyTableColumnWizard::setStatTarget(int iStatTarget)
{
  if(m_eWizardMode != modeStats)
  {
    kdDebug() << "KPGModifyTableColumnWizard::setStatTarget: wrong usage !" << endl;
    return;
  }
  
  // remove given text from combobox
  KPGModifyColumnStatsWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnStatsWidget1 *> (m_pPageWidget1);
  pModifyColumnWidget1->m_pIntNumInputStatistics->setValue(iStatTarget);
}

void KPGModifyTableColumnWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Modify table column" ) );
    
    switch(m_eWizardMode)
    {
      case modeDefault:
          setTitle( WizardPage1, i18n( "Step 1 - Set column default" ) );
          break;
          
      case modeType:
          setTitle( WizardPage1, i18n( "Step 1 -  Choose column type" ) );
          break;
          
      case modeStorage:
          setTitle( WizardPage1, i18n( "Step 1 - Choose storage type" ) );
          break;
          
      case modeStats:
          setTitle( WizardPage1, i18n( "Step 1 - Set column statistics" ) );
          break;
    }
    
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGModifyTableColumnWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    // prepare SQL statement
    QString strSql("ALTER TABLE ");
    strSql.append(KPGUtil::fullyQualifiedName(m_strNamespaceName, m_strTableName));
    strSql.append(" ALTER COLUMN ");
    strSql.append(KPGUtil::quotedName(m_strColumnName));
    strSql.append(" ");
    
    switch(m_eWizardMode)
    {
      case modeDefault:
          {
            KPGModifyColumnDefaultWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnDefaultWidget1 *> (m_pPageWidget1);
            strSql.append(pModifyColumnWidget1->getSQL());
          }
          break;
          
      case modeType:
          {
            KPGModifyColumnTypeWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnTypeWidget1 *> (m_pPageWidget1);
            strSql.append(pModifyColumnWidget1->getSQL());
          }
          break;
          
      case modeStorage:
          {
          KPGModifyColumnStorageWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnStorageWidget1 *> (m_pPageWidget1);
          strSql.append(pModifyColumnWidget1->getSQL());
         }
          break;
          
      case modeStats:
          {
            KPGModifyColumnStatsWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnStatsWidget1 *> (m_pPageWidget1);
            strSql.append(pModifyColumnWidget1->getSQL());
          }
          break;
    }
          
    strSql.append(";\n");
    
    m_pTextEditSQL->setText(strSql);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG3StepsWizard::showPage(pPage);
}


#include "kpgmodifytablecolumnwizard.moc"
