/***************************************************************************
                          kpogreview.cpp  -  description
                          -------------------
    begin                : Fre Sep  7 16:06:25 CEST 2001
    copyright            : (C) 2004-2006 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for libpgxx 
#include <pqxx/util> 

// include files for Qt
#include <qtextcodec.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qptrlist.h> 
#include <qtoolbutton.h>

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kcursor.h>
#include <kpopupmenu.h>
#include <dcopclient.h>
#include <kstatusbar.h>
#include <kconfig.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <ktabwidget.h>
#include <kapplication.h>

// application specific includes
#include "kpogreview.h"
#include "kpgconnectdialog.h"

#include "kpogrecontroller.h"
#include "kpgbookmarksbutton.h"
#include "kpgconfiguration.h"
#include "kpgutil.h"
#include "kpgsqldialog.h"

// Database objects includes
#include "DbObjects/kpgconnection.h"
#include "DbObjects/kpgserver.h"

#include "DbObjects/kpgtablespacesfolder.h"
#include "DbObjects/kpgtablespace.h"
#include "DbObjects/kpguser.h"
#include "DbObjects/kpgusersfolder.h"
#include "DbObjects/kpggroupsfolder.h"
#include "DbObjects/kpggroup.h"
#include "DbObjects/kpgdatabase.h"

#include "DbObjects/kpgschema.h"
#include "DbObjects/kpgtablesfolder.h"
#include "DbObjects/kpgviewsfolder.h"
#include "DbObjects/kpgtypesfolder.h"
#include "DbObjects/kpgview.h"
#include "DbObjects/kpgtable.h"
#include "DbObjects/kpgtype.h"
#include "DbObjects/kpgsequencesfolder.h"
#include "DbObjects/kpgsequence.h"
#include "DbObjects/kpgdomainsfolder.h"
#include "DbObjects/kpgdomain.h"
#include "DbObjects/kpgdomainconstraint.h"
#include "DbObjects/kpgdomainconstraintsfolder.h"
#include "DbObjects/kpgfunctionsfolder.h"
#include "DbObjects/kpgfunction.h"
#include "DbObjects/kpgoperatorsfolder.h"
#include "DbObjects/kpgoperator.h"
#include "DbObjects/kpgaggregate.h"
#include "DbObjects/kpglanguage.h"
#include "DbObjects/kpglanguagesfolder.h"

#include "DbObjects/kpgtablecolumnsfolder.h"
#include "DbObjects/kpgtablecolumn.h"
#include "DbObjects/kpgtableconstraintsfolder.h"
#include "DbObjects/kpgprimarykeyconstr.h"
#include "DbObjects/kpgforeignkeyconstr.h"
#include "DbObjects/kpgcheckconstr.h"
#include "DbObjects/kpguniqueconstr.h"
#include "DbObjects/kpgtableindexesfolder.h"
#include "DbObjects/kpgprimarykey.h"
#include "DbObjects/kpgindex.h"
#include "DbObjects/kpgrulesfolder.h"
#include "DbObjects/kpgrule.h"
#include "DbObjects/kpgtriggersfolder.h"
#include "DbObjects/kpgtrigger.h"

// Wizards includes
#include "Wizards/kpgnewobjectdialog.h"
#include "Wizards/kpgdropobjectwizard.h"
#include "Wizards/kpgdroptableobjectwizard.h"
#include "Wizards/kpg2stepswizard.h"
#include "Wizards/kpgrenameobjectwizard.h"
#include "Wizards/kpgcreatetablespacewizard.h"
#include "Wizards/kpgcreatedatabasewizard.h"
#include "Wizards/kpgcreateschemawizard.h"
#include "Wizards/kpgcreatetablewizard.h"
#include "Wizards/kpgcreateviewwizard.h"
#include "Wizards/kpgmodifyviewwizard.h"
#include "Wizards/kpgcreateuserwizard.h"
#include "Wizards/kpgmodifyuserwizard.h"
#include "Wizards/kpgcreategroupwizard.h"
#include "Wizards/kpgmodifygroupwizard.h"
#include "Wizards/kpgcreatelanguagewizard.h"
#include "Wizards/kpgcreatedomainwizard.h"
#include "Wizards/kpgcreatefunctionwizard.h"
#include "Wizards/kpgmodifyfunctionwizard.h"
#include "Wizards/kpgcreatesequencewizard.h"
#include "Wizards/kpgmodifysequencewizard.h"
#include "Wizards/kpgcreatetableconstraintwizard.h"
#include "Wizards/kpgcreatetableindexwizard.h"
#include "Wizards/kpgcreatetablecolumnwizard.h"
#include "Wizards/kpgmodifytablecolumnwizard.h"
#include "Wizards/kpgcreaterulewizard.h"
#include "Wizards/kpgcreatetriggerwizard.h"
#include "Wizards/kpganalysetablewizard.h"
#include "Wizards/kpgvacuumtablewizard.h"
#include "Wizards/kpgcopyfromtablewizard.h"
#include "Wizards/kpgcopytotablewizard.h"
#include "Wizards/kpgsetclustertablewizard.h"
#include "Wizards/kpgsetownerwizard.h"
#include "Wizards/kpgsettablespacewizard.h"
#include "Wizards/kpgsetdomaindefaultwizard.h"
#include "Wizards/kpgcreatedomainconstraintwizard.h"
#include "Wizards/kpgcreatebasetypewizard.h"
#include "Wizards/kpgcreatecompositetypewizard.h"
#include "Wizards/kpgdumpdatabasewizard.h"
#include "Wizards/kpgrestoredatabasewizard.h"
#include "Wizards/kpgprivilegeswizard.h"
#include "Wizards/kpgsetdescriptionwizard.h"

// Wizard pages includes
#include "Wizards/kpgmodifyviewwidget1.h"

// Property page includes
#include "PropertyPages/kpgabstractpropertypage.h"
#include "PropertyPages/kpgpropertypagechildview.h"

// Query result includes
#include "QueryResult/kpgqueryresultchildview.h"
#include "QueryResult/kpgqueryresultwindow.h"

// Data table includes 
#include "DataTable/kpgdatatablechildview.h"
#include "DataTable/kpgdatatabledialog.h"

// Function executor includes 
#include "Executor/kpgexecutorchildview.h"
#include "Executor/kpgexecutor.h"

// PL/pgSQL debugger includes 
#include "Debugger/kpgdebuggerchildview.h"
#include "Debugger/kpgdebugger.h"

// XML support includes 
#include "XmlSupport/kxetexteditordialog.h"
#include "DataTable/kpgkatexmleditordialog.h"

KPGConfiguration * KPoGreView::s_pKPGConfig = 0L;


KPoGreView::KPoGreView(KMdi::MdiMode mode) 
	: KMdiMainFrm(0, "KPoGre", mode)
{
    //kdDebug() << "short int has size: " << QString::number(sizeof(short int)) << endl;
  	//kdDebug() << "int has size: " << QString::number(sizeof(int)) << endl;
    //kdDebug() << "long has size: " << QString::number(sizeof(long)) << endl;
    //kdDebug() << "long long has size: " << QString::number(sizeof(long long)) << endl;
    //kdDebug() << "pqxx::oid has size: " << QString::number(sizeof(pqxx::oid)) << endl;
    
  	resize( 800, 600 ); // start at 800x600 the first time

	setManagedDockPositionModeEnabled(true);
	setStandardMDIMenuEnabled(false);
	 
	// Initialize GUI
	config=kapp->config();
	
	initStatusBar();
	m_pController = new KPoGreController(this);
	m_pController->initActions(actionCollection());
	
	//-----------------------------------------------------------------
	// View menu
  	m_pActEditDeselect = new KAction( i18n("D&eselect Node"), CTRL+Key_E, this,
										SLOT(slotEditDeselect()), actionCollection(), "edit_deselect" );
	
	m_pActViewNodeUp = new KAction( i18n("To &Parent Item"), "up", 0, this,
	                                SLOT(slotViewNodeUp()), actionCollection(), "treeitem_up" );
																	
	m_pActViewNodeBack = new KAction( i18n("To &Back Item"), "back", 0, this,
	                                SLOT(slotViewNodeBack()), actionCollection(), "treeitem_back" );
																	
	m_pActViewNodeForward = new KAction( i18n("To &Forward Item"), "forward", 0, this,
	                                SLOT(slotViewNodeForward()), actionCollection(), "treeitem_forward" );
	m_pActViewNodeUp->setEnabled(false);
	m_pActViewNodeBack->setEnabled(false);
	m_pActViewNodeForward->setEnabled(false);
	m_pActEditDeselect->setEnabled(false);
		
	//-----------------------------------------------------------------
	setXMLFile("kpogreui.rc");
  	createGUI(0);

	// ... create the bookmark list
	KToolBar * pDatabaseToolBar = toolBar("dbToolBar");
	
	m_pBookmarksButton = new KPGBookmarksButton( pDatabaseToolBar );
	connect( m_pBookmarksButton, SIGNAL( pressed() ), m_pController, SLOT( slotBookmarksButtonPressed() ) );
	m_pBookmarksButton->enableAddBookmarkMenu(false);
	connect( m_pBookmarksButton, SIGNAL( openUrl( const QString& ) ), this, SLOT( slotOpenUrl( const QString& ) ) );
			
	readOptions();
	
	///////////////////////////////////////////////////////////////////
			 
	// Initialize global pixmaps
	KPGTreeItem::m_pIconServer = new QPixmap(UserIcon("server"));
	
	KPGTreeItem::m_pIconTablespaceSys = new QPixmap(UserIcon("tblspace_sys"));
	KPGTreeItem::m_pIconTablespaceUsr = new QPixmap(UserIcon("tblspace_usr"));
	
	KPGTreeItem::m_pIconDatabase = new QPixmap(UserIcon("database"));
	KPGTreeItem::m_pIconDatabaseSys = new QPixmap(UserIcon("database_sys"));
	KPGTreeItem::m_pIconDatabaseUsr = new QPixmap(UserIcon("database_usr"));
		
	KPGTreeItem::m_pIconSchema = new QPixmap(UserIcon("schema"));
  	KPGTreeItem::m_pIconSchemaUnl = new QPixmap(UserIcon("schema_unl"));
	KPGTreeItem::m_pIconSchemaSys = new QPixmap(UserIcon("schema_sys"));
	KPGTreeItem::m_pIconSchemaUsr = new QPixmap(UserIcon("schema_usr"));
		
  	KPGTreeItem::m_pIconTable = new QPixmap(UserIcon("table"));
  	KPGTreeItem::m_pIconToastTable = new QPixmap(UserIcon("toast_table"));
	KPGTreeItem::m_pIconFunction = new QPixmap(UserIcon("function"));
	KPGTreeItem::m_pIconFunctionC = new QPixmap(UserIcon("function_c"));
	KPGTreeItem::m_pIconFunctionSql = new QPixmap(UserIcon("function_sql"));
	KPGTreeItem::m_pIconFunctionPl = new QPixmap(UserIcon("function_pl"));
	KPGTreeItem::m_pIconView = new QPixmap(UserIcon("view"));
	KPGTreeItem::m_pIconSequence = new QPixmap(UserIcon("sequence"));
	KPGTreeItem::m_pIconOperator = new QPixmap(UserIcon("operator"));
	KPGTreeItem::m_pIconOperatorClass = new QPixmap(UserIcon("operator_class"));
	KPGTreeItem::m_pIconAggregate = new QPixmap(UserIcon("aggregate"));
	KPGTreeItem::m_pIconUser = new QPixmap(UserIcon("user"));
	KPGTreeItem::m_pIconUserSuper = new QPixmap(UserIcon("user_super"));
	KPGTreeItem::m_pIconUserCanCreateDb = new QPixmap(UserIcon("user_crt_db"));
	KPGTreeItem::m_pIconGroup = new QPixmap(UserIcon("group"));
	KPGTreeItem::m_pIconType = new QPixmap(UserIcon("type"));
	KPGTreeItem::m_pIconTypeBase = new QPixmap(UserIcon("type_base"));
	KPGTreeItem::m_pIconTypeComposite = new QPixmap(UserIcon("type_composite"));
	KPGTreeItem::m_pIconTypeStandalone = new QPixmap(UserIcon("type_standalone"));
	KPGTreeItem::m_pIconLanguage = new QPixmap(UserIcon("language"));
	KPGTreeItem::m_pIconDomain = new QPixmap(UserIcon("domain"));
	KPGTreeItem::m_pIconConversion = new QPixmap(UserIcon("conversion"));
	KPGTreeItem::m_pIconCast = new QPixmap(UserIcon("cast"));
	
	KPGTreeItem::m_pIconColumnOther = new QPixmap(UserIcon("column"));
	KPGTreeItem::m_pIconColumnBool = new QPixmap(UserIcon("column_bool"));
	KPGTreeItem::m_pIconColumnGeo = new QPixmap(UserIcon("column_geo"));   	
	KPGTreeItem::m_pIconColumnNet = new QPixmap(UserIcon("column_net"));
	KPGTreeItem::m_pIconColumnOid = new QPixmap(UserIcon("column_oid")); 
	KPGTreeItem::m_pIconColumnXid = new QPixmap(UserIcon("column_xid"));
	KPGTreeItem::m_pIconColumnTid = new QPixmap(UserIcon("column_tid"));
	KPGTreeItem::m_pIconColumnCid = new QPixmap(UserIcon("column_cid"));
	KPGTreeItem::m_pIconColumnDate = new QPixmap(UserIcon("column_date"));
	KPGTreeItem::m_pIconColumnChar = new QPixmap(UserIcon("column_char"));  
	KPGTreeItem::m_pIconColumnNum = new QPixmap(UserIcon("column_num"));
	KPGTreeItem::m_pIconColumnTime = new QPixmap(UserIcon("column_time"));
	KPGTreeItem::m_pIconColumnBit = new QPixmap(UserIcon("column_bit"));
	KPGTreeItem::m_pIconColumnBin = new QPixmap(UserIcon("column_bin"));
	KPGTreeItem::m_pIconColumnXml = new QPixmap(UserIcon("column_xml"));
	KPGTreeItem::m_pIconColumnUuid = new QPixmap(UserIcon("column_uuid"));
		 
	KPGTreeItem::m_pIconPrimaryKeyConstr = new QPixmap(UserIcon("primary_key"));
	KPGTreeItem::m_pIconForeignKeyConstr = new QPixmap(UserIcon("foreign_key"));
	KPGTreeItem::m_pIconUniqueConstr = new QPixmap(UserIcon("index"));
	KPGTreeItem::m_pIconCheckConstr = new QPixmap(UserIcon("check"));
	KPGTreeItem::m_pIconPrimaryKey = new QPixmap(UserIcon("primary_key"));
	KPGTreeItem::m_pIconIndex = new QPixmap(UserIcon("index"));
	KPGTreeItem::m_pIconRule = new QPixmap(UserIcon("rule"));
	KPGTreeItem::m_pIconTrigger = new QPixmap(UserIcon("trigger"));
	 
	KPGTreeItem::m_pIconFolderBlueClosed = new QPixmap(SmallIcon("folder"));
	KPGTreeItem::m_pIconFolderRedClosed = new QPixmap(SmallIcon("folder_red"));
	KPGTreeItem::m_pIconFolderCyanClosed = new QPixmap(SmallIcon("folder_cyan"));
	KPGTreeItem::m_pIconFolderGreenClosed = new QPixmap(SmallIcon("folder_green"));
	KPGTreeItem::m_pIconFolderYellowClosed = new QPixmap(SmallIcon("folder_yellow"));
	KPGTreeItem::m_pIconFolderVioletClosed = new QPixmap(SmallIcon("folder_violet"));
	KPGTreeItem::m_pIconFolderGreyClosed = new QPixmap(SmallIcon("folder_grey"));
	KPGTreeItem::m_pIconFolderOrangeClosed = new QPixmap(SmallIcon("folder_orange"));
	
	KPGTreeItem::m_pIconFolderBlueOpen = new QPixmap(SmallIcon("folder_open"));
	KPGTreeItem::m_pIconFolderRedOpen = new QPixmap(SmallIcon("folder_red_open"));
	KPGTreeItem::m_pIconFolderCyanOpen = new QPixmap(SmallIcon("folder_cyan_open"));
	KPGTreeItem::m_pIconFolderGreenOpen = new QPixmap(SmallIcon("folder_green_open"));
	KPGTreeItem::m_pIconFolderYellowOpen = new QPixmap(SmallIcon("folder_yellow_open"));
	KPGTreeItem::m_pIconFolderVioletOpen = new QPixmap(SmallIcon("folder_violet_open"));
	KPGTreeItem::m_pIconFolderGreyOpen = new QPixmap(SmallIcon("folder_grey_open"));
	KPGTreeItem::m_pIconFolderOrangeOpen = new QPixmap(SmallIcon("folder_orange_open"));
	
	KPGTreeItem::m_pIconNull = new QPixmap(SmallIcon("null"));
	
	KPGTreeItem::m_pIconLock = new QPixmap(UserIcon("lock"));
	
	KPGUtil::m_pIconTrue = new QPixmap(UserIcon("true"));
    KPGUtil::m_pIconFalse = new QPixmap(UserIcon("false"));
	
	// MDI close button
#if KDE_IS_VERSION(3, 3, 0)
	setToolviewStyle( KMdi::TextAndIcon );
	tabWidget()->setHoverCloseButton( false );
	
//	if (Settings::showCloseTabsButton())
//	{
		QToolButton *but = new QToolButton(tabWidget());
		but->setIconSet(SmallIcon("tab_remove"));
		but->adjustSize();
		but->hide();
		connect(but, SIGNAL(clicked()), actionCollection()->action( "file_close" ), SIGNAL(activated()));
		tabWidget()->setCornerWidget(but, TopRight);
//	}
#endif
	
		
	// Left tree view
	m_pViewTree = new QListView(this, "treeListView");
	m_pViewTree->setIcon( SmallIcon("view_tree") );
	m_pViewTree->setCaption( i18n("Servers") );
	m_pViewTree->addColumn(i18n("Tree"));
	m_pViewTree->setRootIsDecorated(true);
	m_pViewTree->setAllColumnsShowFocus(true);
	m_pViewTree->setSortColumn(-1);
	addToolWindow( m_pViewTree, KDockWidget::DockLeft, getMainDockWidget(), 20, i18n("Database objects browser"));

	connect(m_pViewTree, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)), this, SLOT  (slotTreeViewRightButtonPressed(QListViewItem*, const QPoint&, int)) );
	
	connect( m_pViewTree, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));
			
	// Left code snippets view
	m_pViewSnippets = new QToolBox(this, "snippetsToolBox");
	m_pViewSnippets->setIcon( SmallIcon("editcut") );
	m_pViewSnippets->setCaption( i18n("Snippets") );
	addToolWindow( m_pViewSnippets, KDockWidget::DockLeft, getMainDockWidget(), 20, i18n("Code snippets"));
	
	initializeSnippets();
	prevToolViewInDock();
	
	// Connect some signals/slots
	connect( this, SIGNAL(sigContextMenuRequested(const QString&, const QPoint&)), this, SLOT(slotContextMenuRequested(const QString&,const QPoint&)) );
	
	connect( this, SIGNAL( viewActivated( KMdiChildView * ) ), this, SLOT( slotCurrentChildViewChanged( KMdiChildView * ) ) );
	
	// Property page
	createPropertyPageChildView(0);
	
	setAutoSaveSettings();
	
	// Read the dock config only if the app was started at least only once - kmdi is tricky
    KConfig *cfg = new KConfig("KPoGre_dockposrc");
    if (cfg->readNumEntry("KPoGre_main_dock_settings", 0) == 1) manager()->readConfig(cfg);
    cfg->writeEntry("KPoGre_main_dock_settings", 1);
    delete cfg;
    
    // Hide tollbars for MDI child views on startup
    KToolBar * pToolBar = toolBar("dataTableToolBar");
	if(pToolBar != 0) pToolBar->hide();
	
	pToolBar = toolBar("queryResultToolBar");
	if(pToolBar != 0) pToolBar->hide();
	
	pToolBar = toolBar("executorToolBar");
	if(pToolBar != 0) pToolBar->hide();
	
	pToolBar = toolBar("debuggerToolBar");
	if(pToolBar != 0) pToolBar->hide();
	
	m_eActiveView = KPoGreView::eMdiChildNone;
	
	KXETextEditorDialog xx(this); // does nothing, only solve fcking linker error
	
	m_pKateXmlEditorDialog = new KPGKateXmlEditorDialog(this, createKatePartFactory());
}

KPoGreView::~KPoGreView()
{
	KConfig *cfg = new KConfig("KPoGre_dockposrc");
    manager()->writeConfig(cfg);
    delete cfg;
        
	delete m_pViewTree;
	delete m_pViewSnippets;
	
	if ( s_pKPGConfig )
		delete s_pKPGConfig;

	s_pKPGConfig = 0L;

  	if(m_pBookmarksButton)
    	delete m_pBookmarksButton;
		
	delete m_pController;
	delete m_pKateXmlEditorDialog;
}

/////////////////////////////////////////////////////////////////////
//                     PUBLIC FUNCTIONS
/////////////////////////////////////////////////////////////////////

KPGConfiguration * KPoGreView::configuration()
{
	if ( ! s_pKPGConfig )
		s_pKPGConfig = new KPGConfiguration();

	return s_pKPGConfig;
}

void KPoGreView::setWaitCursor()
{
  setCursor(KCursor::waitCursor());
  m_pViewTree->setCursor(KCursor::waitCursor());
}

void KPoGreView::setNormalCursor()
{
  setCursor(KCursor::arrowCursor());
  m_pViewTree->setCursor(KCursor::arrowCursor());
}

KPGPropertyPageChildView * KPoGreView::createPropertyPageChildView(KPGTreeItem * pItem)
{
 	KMdiIterator<KMdiChildView*>* it = createIterator();
    for ( it->first(); !it->isDone(); it->next() )
    {
    	KMdiChildView * pMdiChildView = it->currentItem();
         
        if(pMdiChildView->className() == QString("KPGPropertyPageChildView"))
		{
			// already exists
			KPGPropertyPageChildView *pChildView = static_cast <KPGPropertyPageChildView*> (pMdiChildView);
			/*m_pWidgetProperties = */pChildView->createPropertiesWidget(pItem);
			delete it;
			return pChildView;
		}
                      
    }
    delete it;
	 	
	KPGPropertyPageChildView *pChildView = new KPGPropertyPageChildView(this, factory());
	/*m_pWidgetProperties = */pChildView->createPropertiesWidget(pItem);
	
	addWindow( pChildView );
	
	return pChildView;
}


// Open query result window, try search selected schema to pass it as argument
KPGQueryResultChildView * KPoGreView::createQueryResultChildView(const QString & strSelectedName, const QString & strDatabase)
{
	QString strNamespaceName = QString::null;
	
	// Try find schema, for selected item or it's parent tree
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(pSelectedItem)
	{
		KPGSchema *pSchema = 0;
		
		if((static_cast <KPGTreeItem *> (pSelectedItem))->type() == KPGTreeItem::nodeSchema)
		{
			pSchema = static_cast <KPGSchema *> (pSelectedItem);
		}
		else
		{
			pSchema = static_cast <KPGSchema *> (pSelectedItem->getParentByType(KPGTreeItem::nodeSchema));
		}
		
		if((pSchema) && (pSchema->text(0) != "public"))
		{
			strNamespaceName = pSchema->text(0);
		}
	}
		
	return createQueryResultChildView(strSelectedName, strNamespaceName, strDatabase);
}

// Open query result window
KPGQueryResultChildView * KPoGreView::createQueryResultChildView(const QString & strSelectedName, const QString & strNamespaceName, const QString & strDatabase)
{
	KPGQueryResultChildView *pChildView = new KPGQueryResultChildView(this, createKatePartFactory(), factory(), strNamespaceName, strSelectedName);

	addWindow( pChildView );
	
	// connect signals to slots
	KPGQueryResultWindow *pQueryResultWindow = pChildView->getQueryResultWindow();
	
	connect(pQueryResultWindow, SIGNAL(sigRequestDatabasesList(KPGQueryResultWindow *, const QString&)), 
	this, SLOT(slotRequestDatabasesList(KPGQueryResultWindow *, const QString&)));
		
	connect(pQueryResultWindow, SIGNAL(sigRequestListOfDatabaseObjectsForCodeCompletion(KPGQueryResultWindow *, const QString&)), 
	this, SLOT(slotRequestListOfDatabaseObjectsForCodeCompletion(KPGQueryResultWindow *, const QString&)));
		
	connect(pQueryResultWindow, SIGNAL(sigRequestTableColumnsListsForCodeCompletion(KPGQueryResultWindow *, const KPGOidNameAliases *)), 
	this, SLOT(slotRequestTableColumnsListsForCodeCompletion(KPGQueryResultWindow *, const KPGOidNameAliases *)));

    connect(pQueryResultWindow, SIGNAL(sigRequestSchemaChildsListsForCodeCompletion(KPGQueryResultWindow *, pqxx::oid)), this,
SLOT(slotRequestSchemaChildsListsForCodeCompletion(KPGQueryResultWindow *, pqxx::oid)));

    connect(pQueryResultWindow, SIGNAL(sigRequestFunctionReturnTypeAttributesListsForCodeCompletion(KPGQueryResultWindow *, const KPGOidNameAliases *)), 
	this, SLOT(slotRequestFunctionReturnTypeAttributesListsForCodeCompletion(KPGQueryResultWindow *, const KPGOidNameAliases *)));
	
	connect(pQueryResultWindow, SIGNAL(sigSetTerminalIcon(KPGQueryResultWindow *, int)), this, SLOT(slotSetTerminalIcon(KPGQueryResultWindow *, int)));
	
	connect(pChildView, SIGNAL(sigUpdateTabTooltip(KMdiChildView *, const QString &)),
	this, SLOT(slotUpdateTabTooltip(KMdiChildView *, const QString &)));
	
	if(strDatabase != QString::null)
	{
		pQueryResultWindow->m_pComboBoxDatabase->insertItem(strDatabase);	
	}
		
	return pChildView;
}

KPGDataTableChildView * KPoGreView::createDataTableChildView(KPGConnection * pConnection, 
	const QString & strNamespace, 
	const QString & strTableName,
	const ListTableColumns & listTableColumns,
	const MapIndexKey & mapIndexKey, 
	const QString &strWherePredicate, 
	const QString &strOrderByPredicate)
{
	KPGDataTableChildView *pChildView = new KPGDataTableChildView(this, 
		factory(), 
		pConnection->options(), 
		strNamespace, 
		strTableName, 
		listTableColumns,
		mapIndexKey, 
		strWherePredicate, 
		strOrderByPredicate, 
		m_pKateXmlEditorDialog);
	
	addWindow( pChildView );
	
	tabWidget()->setTabToolTip(pChildView, strNamespace + "." + strTableName);
	
	// connect signals to slots
	//KPGDataTable *pDataTable = pChildView->getDataTable();
	
	return pChildView;
}

KPGExecutorChildView * KPoGreView::createExecutorChildView(KPGConnection * pConnection, 
	const QString & strNamespace, 
	KPGFunction *pFunction)
{
	KPGExecutorChildView *pChildView = new KPGExecutorChildView(this, 
		factory(),
		pConnection->options(), 
		strNamespace, 
		pFunction);

	addWindow( pChildView );
	
	tabWidget()->setTabToolTip(pChildView, strNamespace + "." + pFunction->text(0));
	
	// connect signals to slots
	KPGExecutor *pExecutor = pChildView->getExecutor();
	
	pExecutor->updateActions();
	
	return pChildView;
}

KPGDebuggerChildView * KPoGreView::createDebuggerChildView(KPGConnection * pConnection, 
	const QString & strNamespace, 
	KPGFunction *pFunction)
{
	KPGDebuggerChildView *pChildView = new KPGDebuggerChildView(this, 
		createKatePartFactory(),
		factory(),
		pConnection->options(), 
		strNamespace, 
		pFunction);
	addWindow( pChildView );
	
	tabWidget()->setTabToolTip(pChildView, strNamespace + "." + pFunction->text(0));
	
	// connect signals to slots
	//KPGDebugger *pDebugger = pChildView->getDebugger();
	
	return pChildView;
}

// Get type of active MDI child view
KPoGreView::EMdiChildView KPoGreView::getActiveChildViewType()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if(pMdiChildView == 0) return eMdiChildNone;
	
	if(pMdiChildView->className() == QString("KPGPropertyPageChildView"))
	{
		return eMdiChildProperties;
	}
	if(pMdiChildView->className() == QString("KPGQueryResultChildView"))
	{
		return eMdiChildQueryResult;
	}
	if(pMdiChildView->className() == QString("KPGDataTableChildView"))
	{
		return eMdiChildDataTable;
	}
	if(pMdiChildView->className() == QString("KPGExecutorChildView"))
	{
		return eMdiChildExecutor;
	}
	if(pMdiChildView->className() == QString("KPGDebuggerChildView"))
	{
		return eMdiChildDebugger;
	}
	
	kdError() << "KPoGreView::getActiveChildViewType Unknown MDI child type " << endl;
	return eMdiChildNone;
}

// Return active Properties MDI child view
KPGPropertyPageChildView * KPoGreView::getActivePropertyPageChildView()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if(pMdiChildView == 0) return 0;
	if(pMdiChildView->className() == QString("KPGPropertyPageChildView"))
	{
		KPGPropertyPageChildView *pChildView = static_cast <KPGPropertyPageChildView*> (pMdiChildView);
		return pChildView;
	}
	return 0;
}

// Display properties of underlying database object
void KPoGreView::displayProperties()
{
	KPGPropertyPageChildView *pChildView = getActivePropertyPageChildView();
	if(pChildView)
	{
		return pChildView->displayProperties();
	}
}

// Return active property window
KPGAbstractPropertyPage * KPoGreView::getActivePropertyPage()
{
	KPGPropertyPageChildView *pChildView = getActivePropertyPageChildView();
	if(pChildView)
	{
		return pChildView->getPropertyPage();
	}
	return 0;
}

// Return active Query/result MDI child view
KPGQueryResultChildView * KPoGreView::getActiveQueryResultChildView()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if(pMdiChildView == 0) return 0;
	if(pMdiChildView->className() == QString("KPGQueryResultChildView"))
	{
		KPGQueryResultChildView *pChildView = static_cast <KPGQueryResultChildView*> (pMdiChildView);
		return pChildView;
	}
	return 0;
}

// Return active Query/result window
KPGQueryResultWindow * KPoGreView::getActiveQueryResultWindow()
{
	KPGQueryResultChildView *pChildView = getActiveQueryResultChildView();
	if(pChildView)
	{
		return pChildView->getQueryResultWindow();
	}
	return 0;
}


// Return active Datatable MDI child view
KPGDataTableChildView * KPoGreView::getActiveDataTableChildView()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if(pMdiChildView == 0) return 0;
	if(pMdiChildView->className() == QString("KPGDataTableChildView"))
	{
		KPGDataTableChildView *pChildView = static_cast <KPGDataTableChildView*> (pMdiChildView);
		return pChildView;
	}
	return 0;
}

// Return active Datatable window
KPGDataTable * KPoGreView::getActiveDataTable()
{
	KPGDataTableChildView *pChildView = getActiveDataTableChildView();
	if(pChildView)
	{
		return pChildView->getDataTable();
	}
	return 0;	
}

// Return active Executor MDI child view
KPGExecutorChildView * KPoGreView::getActiveExecutorChildView()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if(pMdiChildView == 0) return 0;
	if(pMdiChildView->className() == QString("KPGExecutorChildView"))
	{
		KPGExecutorChildView *pChildView = static_cast <KPGExecutorChildView*> (pMdiChildView);
		return pChildView;
	}
	return 0;
}
	
// Return active Executor window
KPGExecutor * KPoGreView::getActiveExecutor()
{
	KPGExecutorChildView *pChildView = getActiveExecutorChildView();
	if(pChildView)
	{
		return pChildView->getExecutor();
	}
	return 0;
}

// Return active Debugger MDI child view
KPGDebuggerChildView * KPoGreView::getActiveDebuggerChildView()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if(pMdiChildView == 0) return 0;
	if(pMdiChildView->className() == QString("KPGDebuggerChildView"))
	{
		KPGDebuggerChildView *pChildView = static_cast <KPGDebuggerChildView*> (pMdiChildView);
		return pChildView;
	}
	return 0;
}
	
// Return active Debugger window
KPGDebugger * KPoGreView::getActiveDebugger()
{
	KPGDebuggerChildView *pChildView = getActiveDebuggerChildView();
	if(pChildView)
	{
		return pChildView->getDebugger();
	}
	return 0;
}

// Return the currently selected result table (e.g. for saving the content to a file
QTable* KPoGreView::getCurrentlySelectedTableResult()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if(pMdiChildView == 0) return 0;
	
	if(pMdiChildView->className() == QString("KPGPropertyPageChildView"))
	{
		KPGPropertyPageChildView *pChildView = static_cast <KPGPropertyPageChildView*> (pMdiChildView);
		return pChildView->getPropertyPage()->tableResult();
	}
	else if(pMdiChildView->className() == QString("KPGQueryResultChildView"))
	{
		KPGQueryResultChildView *pChildView = static_cast <KPGQueryResultChildView*> (pMdiChildView);
		return pChildView->getQueryResultWindow()->tableResult();
		
	}
	else if(pMdiChildView->className() == QString("KPGDataTableChildView"))
	{
		KPGDataTableChildView *pChildView = static_cast <KPGDataTableChildView*> (pMdiChildView);
		return pChildView->getDataTable();
		
	}
	else if(pMdiChildView->className() == QString("KPGExecutorChildView"))
	{
		KPGExecutorChildView *pChildView = static_cast <KPGExecutorChildView*> (pMdiChildView);
		return pChildView->getExecutor()->tableResult();
	}
	else
	{
		kdError() <<  k_funcinfo << "Unhandled MDI view: " << pMdiChildView->className() << endl;
	}
	
	return 0;
}

bool KPoGreView::requestClose()
{
	KMdiChildView* pMdiChildView = activeWindow();
	if (pMdiChildView == 0) return false;
	
	QString strMdiChildViewClassName(pMdiChildView->className());
	
	if(strMdiChildViewClassName == QString("KPGPropertyPageChildView"))
	{
		KPGPropertyPageChildView *pPropertyPageChildView = static_cast <KPGPropertyPageChildView *> (pMdiChildView);
		if(pPropertyPageChildView->requestClose() == false)
			return false;
	}
	else if(strMdiChildViewClassName == QString("KPGQueryResultChildView"))
	{
		KPGQueryResultChildView *pQueryResultChildView = static_cast <KPGQueryResultChildView *> (pMdiChildView);
		if(pQueryResultChildView->requestClose() == false)
			return false;
	}
	else if(strMdiChildViewClassName == QString("KPGDataTableChildView"))
	{
		KPGDataTableChildView *pDataTableChildView = static_cast <KPGDataTableChildView *> (pMdiChildView);
		if(pDataTableChildView->requestClose() == false)
			return false;
	}
	else if(strMdiChildViewClassName == QString("KPGDebuggerChildView"))
	{
		KPGDebuggerChildView *pDebuggerChildView = static_cast <KPGDebuggerChildView *> (pMdiChildView);
		if(pDebuggerChildView->requestClose() == false)
			return false;
	}
	else if(strMdiChildViewClassName == QString("KPGExecutorChildView"))
	{
		KPGExecutorChildView *pExecutorChildView = static_cast <KPGExecutorChildView *> (pMdiChildView);
		if(pExecutorChildView->requestClose() == false)
			return false;
	}
			
	closeWindow(pMdiChildView);
	return true;
}

// Close application
void KPoGreView::close()
{
	// Look if connected server
	bool bServerFound = false;
	
	// search server
	QListViewItem * pItem = m_pViewTree->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
		{
			bServerFound = true;
			break;
		}
	}

	// Count child MDI windows
	int iMdiCount = 0;
	KMdiIterator<KMdiChildView*>* it = createIterator();
    for ( it->first(); !it->isDone(); it->next() )
    {
    	KMdiChildView * pMdiChildView = it->currentItem();
         
        if(pMdiChildView->className() == QString("KPGPropertyPageChildView"))
		{
			;
		}
		else
			iMdiCount++;
                      
    }
    delete it;


	if(bServerFound || (iMdiCount > 0))
	{
		if (KMessageBox::questionYesNo(this, i18n("Exit KPoGre ?")) == KMessageBox::Yes) 
		{
			KMdiMainFrm::close();
			kdDebug() << "Closing application" << endl;
		}
	}
	else
	{
		// Close without question
		KMdiMainFrm::close();
		kdDebug() << "Closing application" << endl;
	}
}

// Create Kate part view
KParts::Factory* KPoGreView::createKatePartFactory()
{
    // Get KPart factory for the katepart library.
    // This returns 0, if the library can not be found
    KParts::Factory* factory = (KParts::Factory *) KLibLoader::self()->factory ("libkatepart");

    if (factory)
    {
        return factory;
    }
    else
    {
        KMessageBox::error(this, i18n("A KDE text-editor component could not be found;\n"
        "please check your KDE installation."));
      	exit(1); 
    }
}

/////////////////////////////////////////////////////////////////////
//                     PROTECTED FUNCTIONS
/////////////////////////////////////////////////////////////////////	


void KPoGreView::initStatusBar()
{
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void KPoGreView::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size());
	config->writeEntry("Show Toolbar", m_pController->isActViewToolBarChecked());
	config->writeEntry("Show Statusbar",m_pController->isActViewStatusBarChecked());
	config->writeEntry("mainToolBarPos", (int) toolBar("mainToolBar")->barPos());
	config->writeEntry("pathToolBarPos", (int) toolBar("pathToolBar")->barPos());
	config->writeEntry("dbToolBarPos", (int) toolBar("dbToolBar")->barPos());
  	m_pController->getRecentFilesAction()->saveEntries(config,"Recent Files");
}

void KPoGreView::readOptions()
{
	config->setGroup("General Options");
	
	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
	m_pController->setActViewToolBarChecked(bViewToolbar);
	m_pController->slotViewToolBar();
	
	bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	m_pController->setActViewStatusBarChecked(bViewStatusbar);
	m_pController->slotViewStatusBar();
	
	// bar position settings
	KToolBar::BarPosition toolBarPos;
	toolBarPos=(KToolBar::BarPosition) config->readNumEntry("mainToolBarPos", KToolBar::Top);
	toolBar("mainToolBar")->setBarPos(toolBarPos);
		
	toolBarPos=(KToolBar::BarPosition) config->readNumEntry("pathToolBarPos", KToolBar::Top);
	toolBar("pathToolBar")->setBarPos(toolBarPos);
		
	toolBarPos=(KToolBar::BarPosition) config->readNumEntry("dbToolBarPos", KToolBar::Left);
	toolBar("dbToolBar")->setBarPos(toolBarPos);
		
	// initialize the recent file list
	m_pController->getRecentFilesAction()->loadEntries(config,"Recent Files");
	
	QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
	{
		resize(size);
	}
}


// Select given tree item
void KPoGreView::selectItem(KPGTreeItem * const pItem)
{
	if ( ! pItem  )
	{
		kdDebug() << k_funcinfo << "The given pointer is a null pointer" << endl;
		return;
	}

	m_pViewTree->setSelected( pItem, true );
	m_pViewTree->setCurrentItem( pItem );
	m_pViewTree->ensureItemVisible( pItem );
}

// Select item defined by OID and path
KPGTreeItem* KPoGreView::findItem(const KPGOidLink & oidLink)
{
	QString strPath = oidLink.path();
	
	int iPos = strPath.find('/');
	if(iPos <= 0) return 0;

	QString strServer = strPath.mid(0, iPos);
	
	// search server
	QListViewItem * pItem = m_pViewTree->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
		{
			KPGServer *pServer = static_cast <KPGServer *> (pItem);
			if(pServer->text(0) != strServer)
			{ 
				pItem = pItem->nextSibling(); continue; 
			}
			// remove server name from path
			QString strPath2 = strPath.mid(iPos + 1, strPath.length() - iPos - 1);
									
			//--- traverse list of databases
			KPGTreeItem * pItem2 = static_cast <KPGTreeItem *> (pServer->firstChild());
					
			while(pItem2)
			{
				KPGTreeItem * pFoundItem = 0;
					
				if((pFoundItem = pItem2->searchObject(strPath2, oidLink.oid())) != 0)
				{
					return pFoundItem;
				}
				pItem2 = static_cast <KPGTreeItem *> (pItem2->nextSibling());
			}
			pItem = pItem->nextSibling();
		}
	}

	return 0;
}

KPGDatabase * KPoGreView::lookUpParentDatabaseAndListOfSchemas(KPGTreeItem * pItem, QPtrList<QListViewItem> & listOfSchemas)
{
	KPGDatabase * pDatabase = 0;
	 
	if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeSchema)
		{
			pDatabase = static_cast <KPGDatabase *> (pItem->parent());
			listOfSchemas.append(static_cast <KPGSchema *> (pItem));
		}
		else
		{
			if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeDatabase)
			{
				pDatabase = static_cast <KPGDatabase *> (pItem);
				
				// Traverse Database childs and add schemas to combobox
				QListViewItem * pChildItem = pItem->firstChild();
				while(pChildItem)
				{			
					if((static_cast <KPGTreeItem *> (pChildItem))->type() == KPGTreeItem::nodeSchema)
					{
						listOfSchemas.append(static_cast <KPGSchema *> (pChildItem));
					}
		
					pChildItem = pChildItem->nextSibling();
				}
			}
		}
		
	return pDatabase;
}

void KPoGreView::refreshItemsFolder(KPGTreeItem * pItem, const QString & strFolderName)
{
	if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeSchema)
	{
		KPGItemsFolder *pItemsFolder = static_cast <KPGItemsFolder *> (pItem->getChildByName(strFolderName));
		try
		{
			pItemsFolder->refresh(); // refresh folder
		}
		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	else
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeDatabase)
		{
			//KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pItem);
					
			// Traverse Database childs refresh schemas table folders
			try
			{
				QListViewItem * pChildItem = pItem->firstChild();
				while(pChildItem)
				{			
					if((static_cast <KPGTreeItem *> (pChildItem))->type() == KPGTreeItem::nodeSchema)
					{
						KPGSchema *pSchema = static_cast <KPGSchema *> (pChildItem);	
				
						KPGItemsFolder *pItemsFolder = static_cast <KPGItemsFolder *> (pSchema->getChildByName(strFolderName));
						if(!pItemsFolder)
						{
							kdDebug() << k_funcinfo << "Return null pointer for " << strFolderName << endl;
							return;
						}
						pItemsFolder->refresh(); // refresh all schemas tables folder under database
					}
				
					pChildItem = pChildItem->nextSibling();
				}
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
		}
	}
}

// Walk through m_pViewTree items
KPGTreeItem * KPoGreView::nextTreeItem(const KPGTreeItem *pItem)
{
	if(pItem == 0)
	{
		kdDebug() << k_funcinfo << "The given item is null" << endl;
		return 0;
	}
	
	// checking for a child
	if ( ! pItem->firstChild() == 0 )
		return static_cast <KPGTreeItem *> (pItem->firstChild());

	// there is no child -> checking for the next sibling
	if ( ! pItem->nextSibling() == 0 )
		return static_cast <KPGTreeItem *> (pItem->nextSibling());

	// there is no next sibling -> checking for parents' next sibling(s)
	KPGTreeItem *pItemParent = static_cast <KPGTreeItem *> (pItem->parent());
	while ( ! pItemParent == 0 )
	{
		if ( ! pItemParent->nextSibling() == 0 )
			return static_cast <KPGTreeItem *> (pItemParent->nextSibling());

		pItemParent = static_cast <KPGTreeItem *> (pItemParent->parent()); // parent has no sibling - try its parent
	}

	// parent has no parents anymore
	return 0;
}


/////////////////////////////////////////////////////////////////////
//                     ACTION FUNCTIONS
/////////////////////////////////////////////////////////////////////

// Called when user choose bookmark
void KPoGreView::openUrl(const QString& strUrl)
{
    
	QString strHost;
	QString strPort;
	QString strUser;
	QString strDatabase;
	
	int pos = 0;        
	
	// find host name in URL
	QRegExp patternHost("host=\\S*[\\s,]", false); // search keyword
				
	pos=patternHost.search(strUrl, 0);
	if(pos >= 0)
	{
		int l = patternHost.matchedLength();
		strHost = strUrl.mid(pos + 5, l - 6);
	} 
	else
		KMessageBox::sorry(this, i18n("Cannot parse URL"));
	
	// find port number in URL
	QRegExp patternPort("port=\\S*[\\s,]", false); // search keyword
				
	pos=patternPort.search(strUrl, 0);
	if(pos >= 0)
	{
		int l = patternPort.matchedLength();
		strPort = strUrl.mid(pos + 5, l - 6);
	} 
	else
		KMessageBox::sorry(this, i18n("Cannot parse URL"));
	
	// find user name in URL
	QRegExp patternUser("user=\\S*", false); // search keyword
				
	pos=patternUser.search(strUrl, 0);
	if(pos >= 0)
	{
		int l = patternUser.matchedLength();
		strUser = strUrl.mid(pos + 5, l - 5);
	}
	else
		KMessageBox::sorry(this, i18n("Cannot parse URL"));
		
	// find database name in URL
	QRegExp patternDatabase("dbname=\\S*", false); // search keyword
				
	pos=patternDatabase.search(strUrl, 0);
	if(pos >= 0)
	{
		int l = patternDatabase.matchedLength();
		strDatabase = strUrl.mid(pos + 7, l - 7);
	}
	else
		KMessageBox::sorry(this, i18n("Cannot parse URL"));
		
	
	// display connect dialog
	KPGConnectDialog dlg( this, "connect dialog" );
	dlg.setHostName(strHost);
	dlg.setUserName(strUser);
	dlg.setPortNumber(strPort);
	dlg.setDatabaseName(strDatabase);
	dlg.setGui();
				
	KPGServer *pServer = 0;
		
	do
	{
		if( dlg.exec() != QDialog::Accepted )
		{
			return;
		}
			
		//--- check if server is already connected
		QListViewItem * pItem = m_pViewTree->firstChild();
		while(pItem)
		{
			if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
			{
				KPGServer *pServer = static_cast <KPGServer *> (pItem);
				if(pServer->text(0) == dlg.hostName())
				{ 
					KMessageBox::sorry(this, i18n("Server is already connected"));
					return;
				}	
				pItem = pItem->nextSibling();
			}
		}	
	
		pServer = new KPGServer(m_pViewTree);
					
		try
		{
			setWaitCursor();
			
			pServer->connectToServer(dlg.hostName(), dlg.portNumber(), dlg.databaseName(), dlg.userName(), dlg.password());
			
			// Inform active MDI child about change of available servers
			KMdiChildView *activeMdiView = activeWindow();
			if(activeMdiView)
			{
				slotCurrentChildViewChanged(activeMdiView);
			}
		}
		catch(const std::exception &e)
		{
			setNormalCursor();
			delete pServer; // delete unsucessfull connection
			pServer = 0;
			QTextCodec *pTextCodec = QTextCodec::codecForLocale(); 
			KMessageBox::sorry(this, pTextCodec->toUnicode(e.what()));
		}

	} while(pServer == 0);
	
	if(pServer)
	{
		try
		{
			pServer->refresh();
		}
		catch (const KPGSqlException &e)
		{
			delete pServer; // delete unsucessfull connection
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
			return;
		}
	}
	
	setNormalCursor();
}

// Connect to PostgreSQL server
void KPoGreView::databaseConnect()
{
  	KPGConnectDialog dlg( this, "connect dialog" );
	KPGServer *pServer = 0;
	
	do
	{
		if( dlg.exec() != QDialog::Accepted )
		{
			return;
		}
			
		//--- check if server is already connected
		QListViewItem * pItem = m_pViewTree->firstChild();
		while(pItem)
		{
			if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
			{
				KPGServer *pServer = static_cast <KPGServer *> (pItem);
				
				if(pServer->text(0) == dlg.hostName())
				{ 
					KMessageBox::sorry(this, i18n("Server is already connected"));
					return;		
				}	
			pItem = pItem->nextSibling();
			}
		}
		
		
		pServer = new KPGServer(m_pViewTree);
		setWaitCursor();
	
		try
		{
			pServer->connectToServer(dlg.hostName(), dlg.portNumber(), dlg.databaseName(), dlg.userName(), dlg.password());
			
			// Inform active MDI child about change of available servers, databases
			KMdiChildView *activeMdiView = activeWindow();
			if(activeMdiView)
			{
				slotCurrentChildViewChanged(activeMdiView);
			}
		}
		catch(const std::exception &e)
		{
			delete pServer; // delete unsucessfull connection
			pServer = 0;
			setNormalCursor();
			QTextCodec *pTextCodec = QTextCodec::codecForLocale(); 
			KMessageBox::sorry(this, pTextCodec->toUnicode(e.what()));
		}
	} while(pServer == 0);
	
	if(pServer)
	{
		try
		{
			pServer->refresh();
		}
		catch (const KPGSqlException &e)
		{
			delete pServer; // delete unsucessfull connection
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
			return;
		}
	}
	
	setNormalCursor();
}

// Disconnect from selected server
void KPoGreView::databaseDisconnect()
{

	KPGTreeItem * pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
		if(pItem )
	{
		if(pItem->type() != KPGTreeItem::nodeServer)
		return;
			
		QString question = "Disconnect from ";
			question.append(pItem->text(0));
			question.append(" ?");
		if( KMessageBox::questionYesNo(this, question, "Question") == KMessageBox::Yes )
		{
			delete pItem;
			
			// Inform active MDI child about change of available servers, databases
			KMdiChildView *activeMdiView = activeWindow();
			if(activeMdiView)
			{
				slotCurrentChildViewChanged(activeMdiView);
			}
		}
	}  
}

void KPoGreView::databaseWizard()
{
	KPGTreeItem * pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(!pItem) return;
	
	//---------------------------------------------------------------------------------
	KPGNewObjectDialog::eNewObjectIconSet eIconSet; // icon set for dialog
	QString strCaption;
	bool bTablespces = false;
   
	if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
	{ 
    	if((static_cast <KPGServer *> (pItem))->versionMajor() >= 8) 
        	bTablespces = true;
        
      	eIconSet = KPGNewObjectDialog::iconSetServer;
		strCaption = i18n("New server object");
	}
	else if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeDatabase)
	{
		eIconSet = KPGNewObjectDialog::iconSetDatabase; 
		strCaption = i18n("New database object");
	}
	else
	{
        if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeSchema)
        {
          eIconSet = KPGNewObjectDialog::iconSetSchema; 
          strCaption = i18n("New schema object");
        } 
        else
        {
            if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeTable)
            {
              eIconSet = KPGNewObjectDialog::iconSetTable; 
              strCaption = i18n("New table object");
        	}         
            else 
              return;
    	}
	}
     
	KPGNewObjectDialog dlg(this, "KPGNewObjectDialog", eIconSet, strCaption, bTablespces);
	if(dlg.exec() != QDialog::Accepted)
  	return;
	
	//******************************************************************************************
	//
	// Main objects
	//
	//******************************************************************************************
          
	if(dlg.objectType() == "database")
	{
		if(createDatabaseWizard(static_cast <KPGServer *> (pItem)))
		{	
			try
			{
				pItem->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
		}
		return;
	}
		
	if(dlg.objectType() == "tablespace")
	{
		if(createTablespaceWizard(static_cast <KPGServer *> (pItem)))
		{
			setWaitCursor();
			KPGItemsFolder *pFolder = (static_cast <KPGServer *> (pItem))->getTablespacesFolder();
			
			try
			{
				pFolder->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
		return;
	}
  
	if(dlg.objectType() == "group")
	{
		if(createGroupWizard(static_cast <KPGServer *> (pItem)))
		{
			setWaitCursor();
			KPGItemsFolder *pFolder = (static_cast <KPGServer *> (pItem))->getGroupsFolder();
			try
			{
				pFolder->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
		return;
	}
	
	if(dlg.objectType() == "user")
	{
		if(createUserWizard(static_cast <KPGServer *> (pItem)))
		{
			setWaitCursor();
			KPGItemsFolder *pFolder = (static_cast <KPGServer *> (pItem))->getUsersFolder();
			try
			{
				pFolder->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
		return;
	}

  //******************************************************************************************
  //
  // Database objects
  //
  //******************************************************************************************
        
	if(dlg.objectType() == "schema")
	{
		if(createSchemaWizard(static_cast <KPGDatabase *> (pItem)))
		{
			setWaitCursor();
			try
			{
				pItem->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
		return;
	}
  
	if(dlg.objectType() == "language")
	{
		if(createLanguageWizard(static_cast <KPGDatabase *> (pItem)))
		{
			setWaitCursor();
			KPGItemsFolder *pFolder = (static_cast <KPGDatabase *> (pItem))->getLanguagesFolder();
			try
			{
				pFolder->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
		return;
  	}
		
	if(dlg.objectType() == "table")
	{
		// Setup namespace(s) and find connection
		QPtrList<QListViewItem> listOfSchemas;
		KPGDatabase *pDatabase = lookUpParentDatabaseAndListOfSchemas(pItem, listOfSchemas);
					
		if(createTableWizard(pDatabase, listOfSchemas))
			refreshItemsFolder(pItem, i18n("Tables"));
			
		return;
	}
  
	if(dlg.objectType() == "base type")
	{
		// Setup namespace(s) and find connection
		QPtrList<QListViewItem> listOfSchemas;
		KPGDatabase *pDatabase = lookUpParentDatabaseAndListOfSchemas(pItem, listOfSchemas);
			
		if(createBaseTypeWizard(pDatabase, listOfSchemas))
		refreshItemsFolder(pItem, i18n("Types"));
		
		return;
	}
  
	if(dlg.objectType() == "composite type")
	{
		// Setup namespace(s) and find connection
		QPtrList<QListViewItem> listOfSchemas;
		KPGDatabase *pDatabase = lookUpParentDatabaseAndListOfSchemas(pItem, listOfSchemas);
			
		if(createCompositeTypeWizard(pDatabase, listOfSchemas))
		refreshItemsFolder(pItem, i18n("Types"));
		
		return;
	}
	
	if(dlg.objectType() == "view")
	{
		// Setup namespace(s) and find connection
		QPtrList<QListViewItem> listOfSchemas;
		KPGDatabase *pDatabase = lookUpParentDatabaseAndListOfSchemas(pItem, listOfSchemas);
					
		if(createViewWizard(pDatabase, listOfSchemas))
			refreshItemsFolder(pItem, i18n("Views"));
			
		return;
	}
	
	if(dlg.objectType() == "function")
	{
		// Setup namespace(s) and find connection
		QPtrList<QListViewItem> listOfSchemas;
		KPGDatabase *pDatabase = lookUpParentDatabaseAndListOfSchemas(pItem, listOfSchemas);
			
		if(createFunctionWizard(pDatabase, listOfSchemas))
		refreshItemsFolder(pItem, i18n("Functions"));
		
		return;
	}
  
	if(dlg.objectType() == "domain")
	{
		// Setup namespace(s) and find connection
		QPtrList<QListViewItem> listOfSchemas;
		KPGDatabase *pDatabase = lookUpParentDatabaseAndListOfSchemas(pItem, listOfSchemas);
			
		if(createDomainWizard(pDatabase, listOfSchemas))
		refreshItemsFolder(pItem, i18n("Domains"));
		
		return;
	}
	
	if(dlg.objectType() == "sequence")
  	{
    	// Setup namespace(s) and find connection
		QPtrList<QListViewItem> listOfSchemas;
		KPGDatabase *pDatabase = lookUpParentDatabaseAndListOfSchemas(pItem, listOfSchemas);
			
		if(createSequenceWizard(pDatabase, listOfSchemas))
		refreshItemsFolder(pItem, i18n("Sequences"));
		
		return;
	}
  
	//******************************************************************************************
	//
	// Table objects
	//
	//******************************************************************************************

	if(dlg.objectType() == "column")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(createColumnWizard(pDatabase, pSchema, pTable))
		{
			setWaitCursor();
			try
			{
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	}     
  
	if(dlg.objectType() == "primary key")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(pTable->primaryKeyName().isEmpty() == false)
		{
		KMessageBox::sorry(this, i18n("Primary key already exists !"));
		return;   
		}
			
		if(createConstraintWizard(pDatabase, pSchema, pTable, 0))
		{
			setWaitCursor();
			try
			{
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	} 
  
	if(dlg.objectType() == "foreign key")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(createConstraintWizard(pDatabase, pSchema, pTable, 1))
		{
			setWaitCursor();
			try
			{
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	}
  
	if(dlg.objectType() == "unique")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(createConstraintWizard(pDatabase, pSchema, pTable, 2))
		{
			setWaitCursor();
			try
			{
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	}
  
	if(dlg.objectType() == "check")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(createConstraintWizard(pDatabase, pSchema, pTable, 3))
		{
			setWaitCursor();
			try
			{
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	}
  
	if(dlg.objectType() == "index")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(createIndexWizard(pDatabase, pSchema, pTable))
		{
			setWaitCursor();
			try
			{
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	}
	
	if(dlg.objectType() == "rule")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(createRuleWizard(pDatabase, pSchema, pTable))
		{
			setWaitCursor();
			try
			{	
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	}
	
	if(dlg.objectType() == "trigger")
	{
		KPGTable *pTable = static_cast <KPGTable *> (pItem);
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		if(createTriggerWizard(pDatabase, pSchema, pTable))
		{
			setWaitCursor();
			try
			{
				static_cast <KPGTableItemsFolder *> (pTable->getTableConstraintsFolder())->refresh();
			
			}
			catch (const KPGSqlException &e)
			{
				setNormalCursor();
				KPGSqlDialog dlg(this, e.getSql(), e.what());
				dlg.exec();
			}
			setNormalCursor();
		}
	}       
}

// Called when user launch Find or Find Next menu item 
void KPoGreView::editFind(const QString &strSearchString, bool bInOIDs, bool bInNames)
{
	// Start find from current item or from first item - if no selected
	KPGTreeItem *pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());

	if(!pItem)
	{
	  pItem = static_cast <KPGTreeItem *> (m_pViewTree->firstChild());
			
		if(!pItem)
		{ 
			KMessageBox::sorry(this, i18n("No server is connected"));
			kdError() << k_funcinfo << "Item is not selected " << endl;
			return;    
		}
	}
	else
		pItem = nextTreeItem(pItem);
	
			
	//--- Search item ---------------------------------
	while(pItem)
	{
		if(bInNames && (pItem->text(0) == strSearchString)) 
		{
			selectItem(pItem);
			return;
		}
		
		if(bInOIDs && (pItem->hasOid()))
		{
			KPGObject *pObject = static_cast <KPGObject *> (pItem);
			QString strOid(QString("%1").arg(pObject->oid()));
			
			if(strOid == strSearchString)
			{
				selectItem(pItem);
				return;
			}
		}
		
		pItem = nextTreeItem(pItem);
	}
	
	KMessageBox::sorry(this, i18n("Searched item not found"));
}

// Deselects currently selected item
void KPoGreView::slotEditDeselect()
{
	m_pViewTree->clearSelection();
}


void KPoGreView::slotViewNodeUp()
{
	// Start find from current item or from first item - if no selected
	KPGTreeItem *pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());

	if(!pItem)
	{
	  kdError() << k_funcinfo << "Not current item " << endl;
		return; 
	}
		
	KPGTreeItem *pParentItem = static_cast <KPGTreeItem *> (pItem->parent());
	if(pParentItem)
		selectItem(pParentItem);
}

void KPoGreView::slotViewNodeBack()
{
	// Start find from current items parent server
	KPGTreeItem *pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());

	if(!pSelectedItem)
	{
	  KMessageBox::sorry(this, i18n("No item selected "));
			kdError() << k_funcinfo << "Item is not selected " << endl;
			return;    
	}
	
	KPGOidLink oidLink = m_stackBackNodes.pop();	
	KPGTreeItem *pItem = findItem(oidLink);
	if(!pItem) return;
	
			
	// store info about previously selected item to stack
	if((pSelectedItem->hasOid()))
	{
		KPGObject *pOldObject = static_cast <KPGObject *> (pSelectedItem);
			
		m_stackForwardNodes.push(KPGOidLink(pOldObject->oid(), pOldObject->path()));
	}
	else
		m_stackForwardNodes.push(KPGOidLink(0, pSelectedItem->path()));
		
	selectItem(pItem);
}
	
void KPoGreView::slotViewNodeForward()
{
	// Start find from current items parent server
	KPGTreeItem *pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());

	if(!pSelectedItem)
	{
	  KMessageBox::sorry(this, i18n("No item selected "));
			kdError() << k_funcinfo << "Item is not selected " << endl;
			return;    
	}
	
	KPGOidLink oidLink = m_stackForwardNodes.pop();
	KPGTreeItem *pItem = findItem(oidLink);
	if(!pItem) return;
		
	// store info about previously selected item to stack
	if((pSelectedItem->hasOid()))
	{
		KPGObject *pOldObject = static_cast <KPGObject *> (pSelectedItem);
				
		m_stackBackNodes.push(KPGOidLink(pOldObject->oid(), pOldObject->path()));
	}
	else
		m_stackBackNodes.push(KPGOidLink(0, pSelectedItem->path()));
		
	selectItem(pItem);
}

// Refresh actually selected tree item
void KPoGreView::refresh()
{
	KPGTreeItem * pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());

	if(!pItem)
	{ 
		kdError() << k_funcinfo << "Item is not selected " << endl;
		return;    
    }
	
	setWaitCursor();	
	
	try
	{
	   pItem->smartRefresh();
	}
	catch (const KPGSqlException &e)
	{
	   setNormalCursor();
       KPGSqlDialog dlg(this, e.getSql(), e.what());
	   dlg.exec();
	} 
	
	displayProperties();
	
	setNormalCursor();
}

// Select item in tree view by given path 
bool KPoGreView::selectItemByPath(const QString &strPath)
{
	// find host name in URL
  	QRegExp patternOid("[[]\\d+[]]$", false); // search OID in path - server/namespace/database/.../object[nnnn]
 
	QString strPathWithoutOid(strPath);
	pqxx::oid _oid = 0;
	              
	int pos = patternOid.search(strPath, 0);
	if(pos > 0)
	{
		int l = patternOid.matchedLength();
		QString strOid(strPath.mid(pos + 1, l - 2));
		_oid = strOid.toInt();
			
		strPathWithoutOid = strPath.left(strPath.length() - l);
	}
		
	KPGTreeItem *pItem = findItem(KPGOidLink(_oid, strPathWithoutOid));
	if(!pItem) return false;
		
	selectItem(pItem);
	return true;
}	

/////////////////////////////////////////////////////////////////////
//                   WIZARD ACTION FUNCTIONS
/////////////////////////////////////////////////////////////////////

// Run Create Database Wizard 
void KPoGreView::createDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeServer)
	{
		kdDebug() << k_funcinfo << " Ttem types mismatch" << endl;
		return;
	}
	
	KPGServer *pServer = static_cast <KPGServer *> (pSelectedItem);
	
	if(createDatabaseWizard(pServer))
	{	
	   setWaitCursor();	
	
       	try
       	{
         	pServer->smartRefresh();
       	}
       	catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}		 
       	setNormalCursor();
	}
}

// Run Drop Database Wizard 
void KPoGreView::dropDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	// Disconnect deleted database
	KPGDatabase *pDatabase  = static_cast <KPGDatabase *> (pSelectedItem);
	pDatabase->disconnectFromDB();
	
	// Run Wizard
	QString strSQL("DROP DATABASE ");
	strSQL.append(KPGUtil::quotedName(pSelectedItem->text(0)));
	strSQL.append(";");
	
	KPGServer *pServer = static_cast <KPGServer *> (pSelectedItem->parent());
	KPG2StepsWizard wzd(this, i18n("Drop database"), strSQL, false);
  	wzd.setConnection(pServer->connection());
		
	if(wzd.exec() != QDialog::Accepted)
     return;
  
	// Refresh parent item
	setWaitCursor();
	
	try
	{
       pServer->smartRefresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run ANALYSE Wizard
void KPoGreView::analyseDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase  = static_cast <KPGDatabase *> (pSelectedItem);
	
	KPG2StepsWizard wzd(this, i18n("Analyse database"), "ANALYZE VERBOSE;", true);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
}

// Run REINDEX DATABASE
void KPoGreView::reindexDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase  = static_cast <KPGDatabase *> (pSelectedItem);
	
	KPG2StepsWizard wzd(this, i18n("Reindex database"), "REINDEX DATABASE " + KPGUtil::quotedName(pDatabase->text(0)) + ";", false);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
}

// Run ALTER DATABASE name OWNER TO new_owner Wizard
void KPoGreView::setOwnerDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << "KPoGreView::setOwnerDatabase: no item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase  = static_cast <KPGDatabase *> (pSelectedItem);
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
		
	KPGSetOwnerWizard wzd(this, 
		"KPGSetOwnerWizard", 
		pServer->getUsersFolder(), 
		"DATABASE", 
		KPGUtil::quotedName(pDatabase->text(0)), 
		pDatabase->owner()
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{	
		pDatabase->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run GRANT privileges Wizard for database
void KPoGreView::grantPrivilegesDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSelectedItem);
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeDatabase, 
		true, 
		pServer, 
		"", 
		pDatabase->text(0)
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{	
		pDatabase->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run REVOKE privileges Wizard for database
void KPoGreView::revokePrivilegesDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSelectedItem);
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeDatabase, 
		false, 
		pServer, 
		"", 
		pDatabase->text(0));
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{	
		pDatabase->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}  

// Run DUMP DATABASE Wizard
void KPoGreView::dumpDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase  = static_cast <KPGDatabase *> (pSelectedItem);
	
	KPGDumpDatabaseWizard wzd(
		this, 
		"KPGDumpDatabaseWizard", 
		KApplication::dcopClient(), 
		pDatabase->text(0),
		pDatabase->connection()->hostname(),
		pDatabase->connection()->port(),
		pDatabase->connection()->username()
	);
			
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run RESTORE DATABASE Wizard
void KPoGreView::restoreDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase  = static_cast <KPGDatabase *> (pSelectedItem);
	
	KPGRestoreDatabaseWizard wzd(
		this, 
		"KPGDumpDatabaseWizard", 
		KApplication::dcopClient(),
		pDatabase->text(0),
		pDatabase->connection()->hostname(),
		pDatabase->connection()->port(),
		pDatabase->connection()->username()
	);
			
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{	
		pDatabase->refresh();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
  
// Close connection to database
void KPoGreView::disconnectDatabase()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	// Disconnect deleted database
	KPGDatabase *pDatabase  = static_cast <KPGDatabase *> (pSelectedItem);
	pDatabase->disconnectFromDB();
	
	// Inform active MDI child about change of available servers, databases
	KMdiChildView *activeMdiView = activeWindow();
	if(activeMdiView)
	{
		slotCurrentChildViewChanged(activeMdiView);
	}
}

// Run Create Schema Wizard 
void KPoGreView::createSchema()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDatabase)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSelectedItem);
		
	if(createSchemaWizard(pDatabase))
		refresh();
}

// Run Drop Schema Wizard 
void KPoGreView::dropSchema()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
		
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem);
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeSchema, "SCHEMA", pDatabase->connection(), "");
}

// Run Create Schema Wizard 
void KPoGreView::modifySchema()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSchema)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem);
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGRenameObjectWizard wzd(this, "KPGRenameObjectWizard",
		KPGUtil::quotedName(pSchema->text(0)), 
		"SCHEMA", 
		i18n("schema")
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{	
		pDatabase->refresh();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run ALTER Schema OWNER TO new_owner Wizard 
void KPoGreView::setOwnerSchema()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSchema)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem);
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGSetOwnerWizard wzd(this, 
		"KPGSetOwnerWizard", 
		pServer->getUsersFolder(), 
		"SCHEMA", 
		KPGUtil::quotedName(pSchema->text(0)), 
		pSchema->owner()
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{	
		pSchema->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run GRANT privileges Wizard for schema
void KPoGreView::grantPrivilegesSchema()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSchema)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem);
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeSchema, 
		true, 
		pServer, 
		"", 
		pSchema->text(0));
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{	
		pSchema->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run REVOKE privileges Wizard for schema
void KPoGreView::revokePrivilegesSchema()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSchema)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem);
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeSchema, 
		false, 
		pServer, 
		"", 
		pSchema->text(0));
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{	
		pSchema->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run Create Table Wizard 
void KPoGreView::createTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTables)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QPtrList<QListViewItem> listOfSchemas;
	listOfSchemas.append(pSchema);
	
	if(createTableWizard(pDatabase, listOfSchemas))
		refresh();
}

// Run Drop Table Wizard 
void KPoGreView::dropTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pTablesFolder = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTablesFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
	if(pSchema->isSystemObject() || pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really drop ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeTable, "TABLE", pDatabase->connection(), pSchema->text(0));
}

// Run ALTER Table RENAME Wizard 
void KPoGreView::renameTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really rename ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	KPGRenameObjectWizard wzd(this, 
		"KPGRenameObjectWizard", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)), 
		"TABLE", 
		i18n("table")
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;    
		
	setWaitCursor();
	try
	{	
		pFolderTables->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}


// Run ANALYSE Table Wizard
void KPoGreView::analyseTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really drop ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	KPGAnalyseTableWizard wzd(this, "KPGAnalyseTableWizard", pSchema->text(0), pTable);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run VACUUM Table Wizard
void KPoGreView::vacuumTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really vacuum ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	KPGVacuumTableWizard wzd(this, "KPGVacuumTableWizard", pSchema->text(0), pTable);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run REINDEX Table Wizard
void KPoGreView::reindexTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("REINDEX TABLE ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)));
	strSQL.append(";");
	
	KPG2StepsWizard wzd(this, i18n("Reindex table"), strSQL, false);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
}

// Run ALTER Table CLUSTER ON Wizard
void KPoGreView::setClusterOnTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(pTable->getTableIndexesFolder()->childCount() == 0)
	{
		KMessageBox::sorry(this, i18n("Table has no index"));
		return;
	}
	
	KPGSetClusterTableWizard wzd(this, "KPGSetClusterTableWizard", pSchema->text(0),  pTable);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run ALTER Table SET WITHOUT CLUSTER Wizard
void KPoGreView::setWithoutClusterTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("ALTER TABLE ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)));
	strSQL.append(" SET WITHOUT CLUSTER;");
	
	KPG2StepsWizard wzd(this, i18n("Set without cluster"), strSQL, false);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
}

// Run CLUSTER Table Wizard
void KPoGreView::clusterTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("CLUSTER ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)));
	strSQL.append(";");
	
	KPG2StepsWizard wzd(this, i18n("Cluster table"), strSQL, false);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
}

// Run COPY Table FROM Wizard
void KPoGreView::copyFromTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGCopyFromTableWizard wzd(this, "KPGCopyFromTableWizard", pSchema->text(0),  pTable);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run COPY Table TO Wizard
void KPoGreView::copyToTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGCopyToTableWizard wzd(this, "KPGCopyToTableWizard", pSchema->text(0),  pTable);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run ALTER Table OWNER TO new_owner Wizard
void KPoGreView::setOwnerTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGSetOwnerWizard wzd(this, 
		"KPGSetOwnerWizard", 
		pServer->getUsersFolder(), 
		"TABLE", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)), 
		pTable->owner()
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{
		pTable->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run GRANT privileges Wizard for table
void KPoGreView::grantPrivilegesTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeTable, 
		true, 
		pServer, 
		pSchema->text(0), 
		pTable->text(0)
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pTable->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run REVOKE privileges Wizard for table
void KPoGreView::revokePrivilegesTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeTable, 
		false, 
		pServer, 
		pSchema->text(0), 
		pTable->text(0)
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pTable->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run ALTER Table SET TABLESPACE tablespace_name Wizard
void KPoGreView::setTablespaceTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGSetTablespaceWizard wzd(this, 
		"KPGSetTablespaceWizard", 
		pServer->getTablespacesFolder(), 
		"TABLE",
		KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)), 
		pTable->tablespace());
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pTable->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run ALTER Table SET WITHOUT OIDS Wizard
void KPoGreView::setWithoutOIDsTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("ALTER TABLE ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)));
	strSQL.append(" SET WITHOUT OIDS;");
	
	KPG2StepsWizard wzd(this, i18n("Set table without OIDs"), strSQL, false);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;  
}

// Run editable datatable for edit table content
void KPoGreView::editTableContent()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	
	if(pTable->primaryKeyName().length() == 0)
	{
		KMessageBox::sorry(this, i18n("Can't edit table without primary key"));
		return;
	}
	
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(pSchema->isSystemObject() || pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really edit ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	//--- Obtain info about table primary key index
	QString strPrimaryKeyName(pTable->primaryKeyName());
	KPGTableIndexesFolder *pTableIndexesFolder =  pTable->getTableIndexesFolder();
	
	KPGTreeItem *pTreeItem = pTableIndexesFolder->getChildByName(strPrimaryKeyName);
	if(pTreeItem == 0)
	{
		KMessageBox::sorry(this, i18n("Can't find primary key index: " + strPrimaryKeyName));
		return;
	}
	
	KPGTableIndex *pTableIndex = static_cast <KPGTableIndex *> (pTreeItem);
	if(pTableIndex->isPrimary() == false)
	{
		KMessageBox::sorry(this, i18n("Index is not primary key: " + strPrimaryKeyName));
		return;
	}
	
	//--- Dialog for WHERE and ORDER BY predicate 
	KPGDataTableDialog dlg(this);
	if(dlg.exec() != QDialog::Accepted)
	{
		return;
	}
	
	//--- Copy info about table user columns
	ListTableColumns listTableColumns;
	KPGTableColumnsFolder *pTableColumnsFolder = pTable->getTableColumnsFolder();
	QListViewItem * pItem = pTableColumnsFolder->firstChild();
	while(pItem)
	{
		KPGTableColumn *pTableColumn = static_cast <KPGTableColumn *> (pItem);
		
		if(pTableColumn->attNum() > 0) // skip system columns
		{
		  listTableColumns.append(KPGDataTableColumn(pTableColumn->text(0), pTableColumn->typName(), 
		  pTableColumn->isNotNull(), 
		  pTableColumn->hasDefault(), 
		  pTableColumn->defaultValue(),
		  pTableColumn->description(),
		  pTableColumn->createdAs()
		  ));  
		}
		pItem = pItem->nextSibling();
	}
	
	KPGDataTableChildView *pChildView = createDataTableChildView(pDatabase->connection(),
		pSchema->text(0), 
		pTable->text(0),
		listTableColumns,
		pTableIndex->getMapIndexKey(),
		dlg.wherePredicate(),
		dlg.orderByPredicate());
	
	pChildView->getDataTable()->reloadData();
}

// Run query/result window for table
void KPoGreView::queryTable()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTable)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem);
	KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
			
	createQueryResultChildView(pTable->text(0),
		 (pSchema->text(0) == "public") ? QString::null : pSchema->text(0), 
		 pDatabase->text(0));
}

// Run Create View Wizard 
void KPoGreView::createView()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderViews)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QPtrList<QListViewItem> listOfSchemas;
	listOfSchemas.append(pSchema);
	
	if(createViewWizard(pDatabase, listOfSchemas))
		refresh();
}

// Run Drop View Wizard 
void KPoGreView::dropView()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeView)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
    
    KPGView *pView = static_cast <KPGView *> (pSelectedItem);
	KPGViewsFolder *pViewsFolder = static_cast <KPGViewsFolder *> (pView->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pViewsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(pSchema->isSystemObject() || pView->isSystemObject())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system view ! Really drop ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeView, "VIEW", pDatabase->connection(), pSchema->text(0));
}

// Run Create View Wizard 
void KPoGreView::modifyView()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeView)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}

	KPGView *pView = static_cast <KPGView *> (pSelectedItem);
	KPGViewsFolder *pViewsFolder = static_cast <KPGViewsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pViewsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGModifyViewWizard wzd(this, "KPGModifyViewWizard", pDatabase, pSchema->text(0), pView);	
	wzd.setConnection(pDatabase->connection());
				
	if(wzd.exec() != QDialog::Accepted)
     return;
  		
	setWaitCursor();
	try
	{
		pView->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run query/result for view
void KPoGreView::queryView()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeView)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}

	KPGView *pView = static_cast <KPGView *> (pSelectedItem);
	KPGViewsFolder *pViewsFolder = static_cast <KPGViewsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pViewsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	createQueryResultChildView(pView->text(0),
		 (pSchema->text(0) == "public") ? QString::null : pSchema->text(0), 
		 pDatabase->text(0));
}

// Run GRANT privileges Wizard for view
void KPoGreView::grantPrivilegesView()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeView)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGView *pView = static_cast <KPGView *> (pSelectedItem);
	KPGViewsFolder *pViewsFolder = static_cast <KPGViewsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pViewsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeView, 
		true, 
		pServer, 
		pSchema->text(0), 
		pView->text(0)
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pView->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run REVOKE privileges Wizard for view
void KPoGreView::revokePrivilegesView()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeView)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGView *pView = static_cast <KPGView *> (pSelectedItem);
	KPGViewsFolder *pViewsFolder = static_cast <KPGViewsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pViewsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
		
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeView, 
		false, 
		pServer, 
		pSchema->text(0), 
		pView->text(0)
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pView->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run Create Tablespace Wizard 
void KPoGreView::createTablespace()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTablespaces)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGServer *pServer = static_cast <KPGServer *> (pSelectedItem->parent());
	
	createTablespaceWizard(pServer);
	
	refresh();
}
  
// Run Drop Tablespace Wizard 
void KPoGreView::dropTablespace()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTablespace)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTablespacesFolder *pTablespacesFolder = static_cast <KPGTablespacesFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pTablespacesFolder->parent());
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeTablespace, "TABLESPACE", pServer->connection(), "", false);
}
    
// ALTER TABLESPACE name RENAME TO newname Wizard 
void KPoGreView::renameTablespace()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTablespace)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTablespace *pTablespace = static_cast <KPGTablespace *> (pSelectedItem);
	KPGTablespacesFolder *pTablespacesFolder = static_cast <KPGTablespacesFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pTablespacesFolder->parent());
	
	KPGRenameObjectWizard wzd(this, "KPGRenameObjectWizard", 
		KPGUtil::quotedName(pTablespace->text(0)), 
		"TABLESPACE", 
		i18n("tablespace")
		);    
	wzd.setConnection(pServer->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	pTablespacesFolder->refresh();
	setNormalCursor();
	
	pTablespace = static_cast <KPGTablespace *> (pTablespacesFolder->getChildByName(wzd.newObjectName()));
	if(pTablespace)
	{
		m_pViewTree->ensureItemVisible(pTablespace);
		m_pViewTree->setSelected(pTablespace, true);
	}
}

// Run ALTER TABLESPACE name OWNER TO newowner Wizard 
void KPoGreView::setOwnerTablespace()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTablespace)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTablespace *pTablespace = static_cast <KPGTablespace *> (pSelectedItem);
	KPGTablespacesFolder *pTablespacesFolder = static_cast <KPGTablespacesFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pTablespacesFolder->parent());
	
	KPGSetOwnerWizard wzd(this, 
		"KPGSetOwnerWizard", 
		pServer->getUsersFolder(), 
		"TABLESPACE", 
		KPGUtil::quotedName(pTablespace->text(0)), 
		pTablespace->owner()
		);
	wzd.setConnection(pServer->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	// save tablespace name for look-up after refresh tablespaces folder 
	QString strTablespaceName(pTablespace->text(0));  
				
	setWaitCursor();
	try
	{
		pTablespacesFolder->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pTablespace = static_cast <KPGTablespace *> (pTablespacesFolder->getChildByName(strTablespaceName));
	if(pTablespace)
	{
		m_pViewTree->ensureItemVisible(pTablespace);
		m_pViewTree->setSelected(pTablespace, true);
	}
}

// Run GRANT privileges Wizard for tablespace
void KPoGreView::grantPrivilegesTablespace()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTablespace)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTablespace *pTablespace = static_cast <KPGTablespace *> (pSelectedItem);
	KPGTablespacesFolder *pTablespacesFolder = static_cast <KPGTablespacesFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pTablespacesFolder->parent());
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeTablespace, 
		true, 
		pServer, 
		"", 
		pTablespace->text(0));
	wzd.setConnection(pServer->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pTablespace->refresh();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
  
// Run REVOKE privileges Wizard for tablespace
void KPoGreView::revokePrivilegesTablespace()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTablespace)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
  
	KPGTablespace *pTablespace = static_cast <KPGTablespace *> (pSelectedItem);
	KPGTablespacesFolder *pTablespacesFolder = static_cast <KPGTablespacesFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pTablespacesFolder->parent());

    KPGPrivilegesWizard wzd(this, 
    	"KPGPrivilegesWizard", 
    	KPGPrivilegesWizard::typeTablespace, 
    	false, 
    	pServer, 
    	"", 
    	pTablespace->text(0));
  	wzd.setConnection(pServer->connection());
      
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pTablespacesFolder->refresh();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
  
// Run Create User Wizard 
void KPoGreView::createUser()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderUsers)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGServer *pServer = static_cast <KPGServer *> (pSelectedItem->parent());
	
	createUserWizard(pServer);
	
	refresh();
}
	
// Run Drop User Wizard 
void KPoGreView::dropUser()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeUser)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGUsersFolder *pUsersFolder = static_cast <KPGUsersFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pUsersFolder->parent());
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeUser, "USER", pServer->connection(), "");
}
		
// Run Alter User Wizard 
void KPoGreView::modifyUser()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeUser)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGUser *pUser = static_cast <KPGUser *> (pSelectedItem);
	KPGUsersFolder *pUsersFolder = static_cast <KPGUsersFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pUsersFolder->parent());
	
	KPGModifyUserWizard wzd(this, "KPGModifyUserWizard", pUser);
  		
	wzd.setConnection(pServer->connection());
		
	if(wzd.exec() != QDialog::Accepted)
     return;
  		
	setWaitCursor();
	try
	{
		pUsersFolder->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
	
// Run Create Group Wizard 
void KPoGreView::createGroup()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderGroups)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGServer *pServer = static_cast <KPGServer *> (pSelectedItem->parent());
	
	createGroupWizard(pServer);
	
	refresh();
}
	
// Run Drop Group Wizard 
void KPoGreView::dropGroup()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << "KPoGreView::dropGroup: no item selected" << endl;
		return;
	}
		
	KPGGroupsFolder *pGroupsFolder = static_cast <KPGGroupsFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pGroupsFolder->parent());
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeGroup, "GROUP", pServer->connection(), "");
}
		
// Run Alter Group Wizard 
void KPoGreView::modifyGroup()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeGroup)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGGroup *pGroup = static_cast <KPGGroup *> (pSelectedItem);
	KPGGroupsFolder *pGroupsFolder = static_cast <KPGGroupsFolder *> (pSelectedItem->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pGroupsFolder->parent());
	
	KPGModifyGroupWizard wzd(this, "KPGModifyGroupWizard", pGroup, pServer->getUsersFolder());
  		
	wzd.setConnection(pServer->connection());
		
	if(wzd.exec() != QDialog::Accepted)
     return;
  		
	setWaitCursor();
	try
	{
		pGroupsFolder->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run Create Language Wizard 
void KPoGreView::createLanguage()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderLanguages)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSelectedItem->parent());
		
	if(createLanguageWizard(pDatabase))
		refresh();
}
  
// Run Drop Language Wizard 
void KPoGreView::dropLanguage()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeLanguage)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGLanguagesFolder *pLanguagesFolder = static_cast <KPGLanguagesFolder *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pLanguagesFolder->parent());
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeLanguage, "LANGUAGE", pDatabase->connection(), "");
}
  
// Run Alter Language Wizard 
void KPoGreView::modifyLanguage()
{
  KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeLanguage)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGLanguage *pLanguage = static_cast <KPGLanguage *> (pSelectedItem);
	KPGLanguagesFolder *pLanguagesFolder = static_cast <KPGLanguagesFolder *> (pLanguage->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pLanguagesFolder->parent());
	
	KPGRenameObjectWizard wzd(this, 
		"KPGRenameObjectWizard", 
		KPGUtil::quotedName(pLanguage->text(0)), 
		"LANGUAGE", 
		i18n("language")
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{
		pLanguagesFolder->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
    
// Run GRANT privileges Wizard for language
void KPoGreView::grantPrivilegesLanguage()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeLanguage)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGLanguage *pLanguage = static_cast <KPGLanguage *> (pSelectedItem);
	KPGLanguagesFolder *pLanguagesFolder = static_cast <KPGLanguagesFolder *> (pLanguage->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pLanguagesFolder->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeLanguage, 
		true, 
		pServer, 
		"", 
		pLanguage->text(0)
		);
	wzd.setConnection(pDatabase->connection());
	
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pLanguage->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
 
// Run REVOKE privileges Wizard for language
void KPoGreView::revokePrivilegesLanguage()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeLanguage)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGLanguage *pLanguage = static_cast <KPGLanguage *> (pSelectedItem);
	KPGLanguagesFolder *pLanguagesFolder = static_cast <KPGLanguagesFolder *> (pLanguage->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pLanguagesFolder->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeLanguage, 
		false, 
		pServer, 
		"", 
		pLanguage->text(0));
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pLanguage->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}  
  
// Run Create Domain Wizard 
void KPoGreView::createDomain()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderDomains)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QPtrList<QListViewItem> listOfSchemas;
	listOfSchemas.append(pSchema);
	
	if(createDomainWizard(pDatabase, listOfSchemas))
		refresh();
}

// Run DROP DOMAIN Wizard 
void KPoGreView::dropDomain()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << "No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDomain)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDomainsFolder *pDomainsFolder = static_cast <KPGDomainsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pDomainsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	dropObjectWizard(pSelectedItem, KPGTreeItem::nodeDomain, "DOMAIN", pDatabase->connection(), pSchema->text(0));
}

// Run ALTER DOMAIN SET | DROP NOT NULL Wizard 
void KPoGreView::setDomainNull()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDomain)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGDomain *pDomain = static_cast <KPGDomain *> (pSelectedItem);
	KPGDomainsFolder *pFolderDomains = static_cast <KPGDomainsFolder *> (pDomain->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderDomains->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("ALTER DOMAIN ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pDomain->text(0)));
		
	if(!pDomain->isNotNull())
		strSQL.append(" SET NOT NULL;");
	else
		strSQL.append(" DROP NOT NULL;");
		
	KPG2StepsWizard wzd(this, i18n("Set domain NULL"), strSQL, true);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save domain name for look-up after refresh columns folder 
	QString strDomainName(pDomain->text(0));   
	
	setWaitCursor();
	try
	{
		pFolderDomains->refresh();
		setNormalCursor();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	
	pDomain = static_cast <KPGDomain *> (pFolderDomains->getChildByName(strDomainName));
	if(pDomain)
	{
		m_pViewTree->ensureItemVisible(pDomain);
		m_pViewTree->setSelected(pDomain, true);
	}
}

// Run ALTER DOMAIN SET DEFAULT expression Wizard 
void KPoGreView::setDomainDefault()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDomain)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGDomain *pDomain = static_cast <KPGDomain *> (pSelectedItem);
	KPGDomainsFolder *pFolderDomains = static_cast <KPGDomainsFolder *> (pDomain->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderDomains->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGSetDomainDefaultWizard wzd(this, "KPGSetDomainDefaultWizard", pSchema->text(0), pDomain->text(0));
	wzd.setConnection(pDatabase->connection());
	wzd.setDefaultExpression(pDomain->defaultValue());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save domain name for look-up after refresh columns folder 
	QString strDomainName(pDomain->text(0));   
	
	setWaitCursor();
	try
	{
		pFolderDomains->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pDomain = static_cast <KPGDomain *> (pFolderDomains->getChildByName(strDomainName));
	if(pDomain)
	{
		m_pViewTree->ensureItemVisible(pDomain);
		m_pViewTree->setSelected(pDomain, true);
	}
}

// Run ALTER DOMAIN DROP DEFAULT Wizard 
void KPoGreView::dropDomainDefault()
{
  KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDomain)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGDomain *pDomain = static_cast <KPGDomain *> (pSelectedItem);
	KPGDomainsFolder *pFolderDomains = static_cast <KPGDomainsFolder *> (pDomain->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderDomains->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());  
	
	QString strSQL("ALTER DOMAIN ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pDomain->text(0)));
	strSQL.append(" DROP DEFAULT;");
		
	KPG2StepsWizard wzd(this, i18n("Drop domain default"), strSQL, true);
		
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
	
	// save domain name for look-up after refresh columns folder 
	QString strDomainName(pDomain->text(0));   
	
	setWaitCursor();
	try
	{
		pFolderDomains->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pDomain = static_cast <KPGDomain *> (pFolderDomains->getChildByName(strDomainName));
	if(pDomain)
	{
		m_pViewTree->ensureItemVisible(pDomain);
		m_pViewTree->setSelected(pDomain, true);
	}
}

// Run ALTER DOMAIN name OWNER TO new_owner  Wizard 
void KPoGreView::setOwnerDomain()
{
  KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
  if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDomain)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGDomain *pDomain = static_cast <KPGDomain *> (pSelectedItem);
	KPGDomainsFolder *pFolderDomains = static_cast <KPGDomainsFolder *> (pDomain->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderDomains->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());  
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
	
	KPGSetOwnerWizard wzd(this, 
		"KPGSetOwnerWizard", 
		pServer->getUsersFolder(), 
		"DOMAIN", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pDomain->text(0)),
		pDomain->owner()
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	// save domain name for look-up after refresh domain folder 
	QString strDomainName(pDomain->text(0)); 
				
	setWaitCursor();
	try
	{
		pFolderDomains->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pDomain = static_cast <KPGDomain *> (pFolderDomains->getChildByName(strDomainName));
	if(pDomain)
	{
		m_pViewTree->ensureItemVisible(pDomain);
		m_pViewTree->setSelected(pDomain, true);
	}
}

// Run ALTER DOMAIN name ADD domain_constraint Wizard 
void KPoGreView::createDomainConstraint()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderDomainConstraints)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGDomain *pDomain = static_cast <KPGDomain *> (pSelectedItem->parent());
	KPGDomainsFolder *pFolderDomains = static_cast <KPGDomainsFolder *> (pDomain->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderDomains->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGCreateDomainConstraintWizard wzd(this, "KPGCreateDomainConstraintWizard", pSchema->text(0), pDomain->text(0));
	wzd.setConnection(pDatabase->connection());
	
	if(wzd.exec() != QDialog::Accepted)
		return; 
	
	refresh();   
}

// Run ALTER DOMAIN name DROP CONSTRAINT constraint_name Wizard 
void KPoGreView::dropDomainConstraint()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeDomainConstr)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGDomainConstraint *pDomainConstraint = static_cast <KPGDomainConstraint *> (pSelectedItem);
	KPGDomainConstraintsFolder *pDomainConstraintsFolder = static_cast <KPGDomainConstraintsFolder *> (pDomainConstraint->parent());
	KPGDomain *pDomain = static_cast <KPGDomain *> (pDomainConstraintsFolder->parent());
	KPGDomainsFolder *pFolderDomains = static_cast <KPGDomainsFolder *> (pDomain->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderDomains->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("ALTER DOMAIN ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pDomain->text(0)));
	strSQL.append(" DROP CONSTRAINT ");
	strSQL.append(KPGUtil::quotedName(pDomainConstraint->text(0)));
	strSQL.append(";");
	
	KPG2StepsWizard wzd(this, i18n("Drop domain constraint"), strSQL, true);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
	return;
	
	// Refresh parent item
	setWaitCursor();
	try
	{
		pDomainConstraintsFolder->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run Create Function Wizard 
void KPoGreView::createFunction()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderFunctions)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QPtrList<QListViewItem> listOfSchemas;
	listOfSchemas.append(pSchema);
	
	if(createFunctionWizard(pDatabase, listOfSchemas))
		refresh();
}
  
// Run Drop Function Wizard 
void KPoGreView::dropFunction()
{
    KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
    if(! pSelectedItem)
    {
        kdDebug() << k_funcinfo  << " No item selected" << endl;
        return;
    }
        
        if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFunction)
    {
        kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
        return;
    }
    
    KPGFunction *pFunction = static_cast <KPGFunction *> (pSelectedItem);  
    KPGFunctionsFolder *pFunctionsFolder = static_cast <KPGFunctionsFolder *> (pFunction->parent());
    KPGSchema *pSchema = static_cast <KPGSchema *> (pFunctionsFolder->parent());
    KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
    
    if(pSchema->isSystemObject())
    {
        if(KMessageBox::questionYesNo(this, i18n("This is system function ! Really drop ?")) != KMessageBox::Yes) 
        {
            return;
        }
    }
    
    KPGDropObjectWizard wzd(
            this, 
            "KPGDropObjectWizard", 
            "FUNCTION",
            pSchema->text(0),
            pFunction->text(0),
            QString::null,
            pFunction->argumentTypes()
            );
    
	wzd.setConnection(pDatabase->connection());
            
    if(wzd.exec() != QDialog::Accepted)
        return;
        
    // Refresh parent item
    setWaitCursor();
    try
    {
    	pFunctionsFolder->refresh();
    }
    catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
    setNormalCursor();	 	 
}
    
// Run Alter Function Wizard 
void KPoGreView::renameFunction()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFunction)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGFunction *pFunction = static_cast <KPGFunction *> (pSelectedItem);
	KPGFunctionsFolder *pFolderFunctions = static_cast <KPGFunctionsFolder *> (pFunction->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderFunctions->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	// append arguments to function name
	QString strName(KPGUtil::fullyQualifiedName(pSchema->text(0), pFunction->text(0)));
	strName.append(pFunction->argumentTypes()); 
		
	KPGRenameObjectWizard wzd(this, 
		"KPGRenameObjectWizard", 
		strName, 
		"FUNCTION", 
		i18n("function")
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{
		pFolderFunctions->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run Alter Function Wizard 
void KPoGreView::modifyFunction()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFunction)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGFunction *pFunction = static_cast <KPGFunction *> (pSelectedItem);
	KPGFunctionsFolder *pFunctionsFolder = static_cast <KPGFunctionsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFunctionsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGModifyFunctionWizard wzd(this, "KPGModifyFunctionWizard", pSchema->text(0), pFunction);   
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{
		pFunction->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
    
// Run GRANT privileges Wizard for function
void KPoGreView::grantPrivilegesFunction()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFunction)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGFunction *pFunction = static_cast <KPGFunction *> (pSelectedItem);
	KPGFunctionsFolder *pFunctionsFolder = static_cast <KPGFunctionsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFunctionsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeFunction, 
		true, 
		pServer, 
		pSchema->text(0), 
		pFunction->text(0),
		pFunction->argumentTypes());
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pFunction->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
  
// Run REVOKE privileges Wizard for function
void KPoGreView::revokePrivilegesFunction()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFunction)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGFunction *pFunction = static_cast <KPGFunction *> (pSelectedItem);
	KPGFunctionsFolder *pFunctionsFolder = static_cast <KPGFunctionsFolder *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFunctionsFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeFunction, 
		false, 
		pServer, 
		pSchema->text(0), 
		pFunction->text(0),
		pFunction->argumentTypes()
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pFunction->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run Function executor
void KPoGreView::executeFunction()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFunction)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGFunction *pFunction = static_cast <KPGFunction *> (pSelectedItem);
	
	if(pFunction->returnTypName() == QString("trigger"))
	{
		KMessageBox::sorry(this, i18n("Can't execute trigger function"));
		return;
	}
	
	KPGFunctionsFolder *pFolderFunctions= static_cast <KPGFunctionsFolder *> (pFunction->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderFunctions->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	createExecutorChildView(pDatabase->connection(),
		pSchema->text(0), 
		pFunction);
}

// Run Function debugger
void KPoGreView::debugFunction()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFunction)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGFunction *pFunction = static_cast <KPGFunction *> (pSelectedItem);
	
	if(pFunction->returnTypName() == QString("trigger"))
	{
		KMessageBox::sorry(this, i18n("Can't debug trigger function"));
		return;
	}
	
	KPGFunctionsFolder *pFolderFunctions= static_cast <KPGFunctionsFolder *> (pFunction->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderFunctions->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	createDebuggerChildView(pDatabase->connection(),
		pSchema->text(0), 
		pFunction);
}
  
// Run Create Sequence Wizard 
void KPoGreView::createSequence()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderSequences)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QPtrList<QListViewItem> listOfSchemas;
	listOfSchemas.append(pSchema);
	
	if(createSequenceWizard(pDatabase, listOfSchemas))
		refresh();
}
  
// Run Drop Sequence Wizard 
void KPoGreView::dropSequence()
{
    KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
    if(! pSelectedItem)
    {
        kdDebug() << k_funcinfo  << " No item selected" << endl;
        return;
    }
    
    if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSequence)
    {
        kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
        return;
    }
        
    KPGSequence *pSequence = static_cast <KPGSequence *> (pSelectedItem);
    KPGSequencesFolder *pSequencesFolder = static_cast <KPGSequencesFolder *> (pSequence->parent());
    KPGSchema *pSchema = static_cast <KPGSchema *> (pSequencesFolder->parent());
    KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
    
    if(pSchema->isSystemObject() || pSequence->isSystemObject())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system sequence ! Really drop ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
  
    dropObjectWizard(pSelectedItem, KPGTreeItem::nodeSequence, "SEQUENCE", pDatabase->connection(), pSchema->text(0));
}

// Run ALTER Sequence Wizard 
void KPoGreView::modifySequence()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSequence)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGSequence *pSequence = static_cast <KPGSequence *> (pSelectedItem);
	KPGSequencesFolder *pSequencesFolder = static_cast <KPGSequencesFolder *> (pSequence->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSequencesFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGModifySequenceWizard wzd(this, "KPGModifySequenceWizard", pSchema->text(0), pSequence);
	wzd.setConnection(pDatabase->connection());
			
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{
		pSequence->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}

// Run GRANT privileges Wizard for sequence
void KPoGreView::grantPrivilegesSequence()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSequence)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGSequence *pSequence = static_cast <KPGSequence *> (pSelectedItem);
	KPGSequencesFolder *pSequencesFolder = static_cast <KPGSequencesFolder *> (pSequence->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSequencesFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeSequence, 
		true, pServer, 
		pSchema->text(0), 
		pSequence->text(0)
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pSequence->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}  
  
// Run REVOKE privileges Wizard for sequence
void KPoGreView::revokePrivilegesSequence()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeSequence)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGSequence *pSequence = static_cast <KPGSequence *> (pSelectedItem);
	KPGSequencesFolder *pSequencesFolder = static_cast <KPGSequencesFolder *> (pSequence->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSequencesFolder->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGPrivilegesWizard wzd(this, 
		"KPGPrivilegesWizard", 
		KPGPrivilegesWizard::typeSequence, 
		false, pServer, 
		pSchema->text(0), 
		pSequence->text(0));
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
		
	setWaitCursor();
	try
	{
		pSequence->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
}
  
// Run ALTER table ADD Column Wizard
void KPoGreView::createColumn()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTableColumns)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(createColumnWizard(pDatabase, pSchema, pTable))
	{
		refresh();
	}
}
    
// Run ALTER table DROP Column Wizard
void KPoGreView::dropColumn()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
		
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableColumnsFolder *pColumnsFolder = static_cast <KPGTableColumnsFolder *> (pSelectedItem->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pColumnsFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really drop column ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	dropTableObjectWizard(pSelectedItem, "COLUMN", pDatabase->connection(), pSchema->text(0), pTable->text(0)); 
}
       
// Run ALTER table Rename Column Wizard
void KPoGreView::renameColumn()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo  << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << k_funcinfo  << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
	KPGTableColumnsFolder *pFolderColumns = static_cast <KPGTableColumnsFolder *> (pColumn->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pFolderColumns->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGRenameObjectWizard wzd(this, 
		"KPGRenameObjectWizard", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)), 
		KPGUtil::quotedName(pColumn->text(0)), 
		"COLUMN", 
		i18n("column"));
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	setWaitCursor();
	try
	{
		pFolderColumns->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pColumn = static_cast <KPGTableColumn *> (pFolderColumns->getChildByName(wzd.newObjectName()));
	if(pColumn)
	{
		m_pViewTree->ensureItemVisible(pColumn);
		m_pViewTree->setSelected(pColumn, true);
	}
}
       
// Run ALTER table SET/DROP Column NULL Wizard
void KPoGreView::setColumnNull()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
	KPGTableColumnsFolder *pFolderColumns = static_cast <KPGTableColumnsFolder *> (pColumn->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pFolderColumns->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("ALTER TABLE ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)));
	strSQL.append(" ALTER COLUMN ");
	strSQL.append(KPGUtil::quotedName(pColumn->text(0)));
	
	if(!pColumn->isNotNull())
		strSQL.append(" SET NOT NULL;");
	else
		strSQL.append(" DROP NOT NULL;");
		
	KPG2StepsWizard wzd(this, i18n("Set column NULL"), strSQL, true);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save column name for look-up after refresh columns folder 
	QString strColumnName(pColumn->text(0));   
	
	setWaitCursor();
	try
	{
		pFolderColumns->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pColumn = static_cast <KPGTableColumn *> (pFolderColumns->getChildByName(strColumnName));
	if(pColumn)
	{
		m_pViewTree->ensureItemVisible(pColumn);
		m_pViewTree->setSelected(pColumn, true);
	}
}
       
// Run ALTER table ALTER Column SET DEFAULT Wizard
void KPoGreView::setColumnDefault()
{
  KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
	KPGTableColumnsFolder *pFolderColumns = static_cast <KPGTableColumnsFolder *> (pColumn->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pFolderColumns->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGModifyTableColumnWizard wzd(this, "KPGModifyTableColumnWizard", pSchema, pTable, pColumn, KPGModifyTableColumnWizard::modeDefault);
	wzd.setConnection(pDatabase->connection());
	wzd.setDefaultExpression(pColumn->defaultValue());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save column name for look-up after refresh columns folder 
	QString strColumnName(pColumn->text(0));  
		
	setWaitCursor();
	try
	{
		pFolderColumns->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pColumn = static_cast <KPGTableColumn *> (pFolderColumns->getChildByName(strColumnName));
	if(pColumn)
	{
		m_pViewTree->ensureItemVisible(pColumn);
		m_pViewTree->setSelected(pColumn, true);
	}
}

// Run ALTER table ALTER Column DROP DEFAULT Wizard
void KPoGreView::dropColumnDefault()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
	KPGTableColumnsFolder *pFolderColumns = static_cast <KPGTableColumnsFolder *> (pColumn->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pFolderColumns->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QString strSQL("ALTER TABLE ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)));
	strSQL.append(" ALTER COLUMN ");
	strSQL.append(KPGUtil::quotedName(pColumn->text(0)));
	strSQL.append(" DROP DEFAULT;");
		
	KPG2StepsWizard wzd(this, i18n("Drop column default"), strSQL, true);
		
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
	
	// save column name for look-up after refresh columns folder 
	QString strColumnName(pColumn->text(0)); 
		
	setWaitCursor();
	try
	{
		pFolderColumns->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
		
	pColumn = static_cast <KPGTableColumn *> (pFolderColumns->getChildByName(strColumnName));
	if(pColumn)
	{
		m_pViewTree->ensureItemVisible(pColumn);
		m_pViewTree->setSelected(pColumn, true);
	}
}
       
// Run ALTER table ALTER Column TYPE Wizard
void KPoGreView::changeColumnType()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
	KPGTableColumnsFolder *pFolderColumns = static_cast <KPGTableColumnsFolder *> (pColumn->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pFolderColumns->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGModifyTableColumnWizard wzd(this, "KPGModifyTableColumnWizard", pSchema, pTable, pColumn, KPGModifyTableColumnWizard::modeType);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save column name for look-up after refresh columns folder 
	QString strColumnName(pColumn->text(0));  
		
	setWaitCursor();
	try
	{
		pFolderColumns->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pColumn = static_cast <KPGTableColumn *> (pFolderColumns->getChildByName(strColumnName));
	if(pColumn)
	{
		m_pViewTree->ensureItemVisible(pColumn);
		m_pViewTree->setSelected(pColumn, true);
	}
}
       
// Run ALTER table ALTER Column SET STORAGE { PLAIN | EXTERNAL | EXTENDED | MAIN } Wizard
void KPoGreView::setColumnStorage()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << "KPoGreView::setColumnStorage: no item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << "KPoGreView::setColumnStorage: item types mismatch" << endl;
		return;
	}
	
	KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
	KPGTableColumnsFolder *pFolderColumns = static_cast <KPGTableColumnsFolder *> (pColumn->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pFolderColumns->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGModifyTableColumnWizard wzd(this, "KPGModifyTableColumnWizard", pSchema, pTable, pColumn, KPGModifyTableColumnWizard::modeStorage);
	wzd.setConnection(pDatabase->connection());
	wzd.setStorage(pColumn->storage());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save column name for look-up after refresh columns folder 
	QString strColumnName(pColumn->text(0));  
		
	setWaitCursor();
	try
	{
		pFolderColumns->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pColumn = static_cast <KPGTableColumn *> (pFolderColumns->getChildByName(strColumnName));
	if(pColumn)
	{
		m_pViewTree->ensureItemVisible(pColumn);
		m_pViewTree->setSelected(pColumn, true);
	}
}
       
// Run ALTER table ALTER Column SET STATISTICS Wizard
void KPoGreView::setColumnStatistisc()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTableColumn)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
	KPGTableColumnsFolder *pFolderColumns = static_cast <KPGTableColumnsFolder *> (pColumn->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pFolderColumns->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGModifyTableColumnWizard wzd(this, "KPGModifyTableColumnWizard", pSchema, pTable, pColumn, KPGModifyTableColumnWizard::modeStats);
	wzd.setConnection(pDatabase->connection());
	wzd.setStatTarget(pColumn->statTarget());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save column name for look-up after refresh columns folder 
	QString strColumnName(pColumn->text(0));  
		
	setWaitCursor();
	try
	{
		pFolderColumns->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pColumn = static_cast <KPGTableColumn *> (pFolderColumns->getChildByName(strColumnName));
	if(pColumn)
	{
		m_pViewTree->ensureItemVisible(pColumn);
		m_pViewTree->setSelected(pColumn, true);
	}
}

// Run Create Constraint Wizard 
void KPoGreView::createConstraint()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTableConstraints)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(createConstraintWizard(pDatabase, pSchema, pTable))
	{
		refresh();
	}
}

// Run Drop Constraint Wizard 
void KPoGreView::dropConstraint()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
    
	KPGTableConstraintsFolder *pConstraintsFolder = static_cast <KPGTableConstraintsFolder *> (pSelectedItem->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pConstraintsFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
    
    if(pSchema->isSystemObject() || pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really drop constraint ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
  
	dropTableObjectWizard(pSelectedItem, "CONSTRAINT", pDatabase->connection(), pSchema->text(0), pTable->text(0));  
}

// Run Create Index Wizard 
void KPoGreView::createIndex()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTableIndexes)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(createIndexWizard(pDatabase, pSchema, pTable))
	{
		refresh();
		displayProperties();
	}
}

// Run Drop Index Wizard 
void KPoGreView::dropIndex()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if(((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeIndex) &&
     ((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodePrimaryKey)
    )
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
    
  	KPGTableIndexesFolder *pIndexesFolder = static_cast <KPGTableIndexesFolder *> (pSelectedItem->parent());
  	KPGTable *pTable = static_cast <KPGTable *> (pIndexesFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
  	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
  	  
  	if(pSchema->isSystemObject() || pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really drop index ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}  
  	  
  	KPGDropObjectWizard wzd(
		this, 
		"KPGDropObjectWizard", 
		"INDEX",
		pSchema->text(0),
		pSelectedItem->text(0)
		);
  
		wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
     	return;
	
	// Refresh parent item
	setWaitCursor();
	try
	{
		pIndexesFolder->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();	 
}

// Run ALTER Index RENAME Wizard 
void KPoGreView::renameIndex()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if(((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeIndex) &&
		((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodePrimaryKey)
		)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
  
	KPGTableIndexesFolder *pIndexesFolder = static_cast <KPGTableIndexesFolder *> (pSelectedItem->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pIndexesFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
    
  	KPGRenameObjectWizard wzd(this, 
		"KPGRenameObjectWizard", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pSelectedItem->text(0)),
		"INDEX", 
		i18n("index"));
  	wzd.setConnection(pDatabase->connection());
      
	if(wzd.exec() != QDialog::Accepted)
		return;    
	
	setWaitCursor();
	try
	{
		pIndexesFolder->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pSelectedItem = pIndexesFolder->getChildByName(wzd.newObjectName());
	if(pSelectedItem)
	{
		m_pViewTree->ensureItemVisible(pSelectedItem);
		m_pViewTree->setSelected(pSelectedItem, true);
	}   
}

// Run REINDX INDEX Wizard 
void KPoGreView::reindexIndex()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if(((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeIndex) &&
		((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodePrimaryKey)
		)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableIndexesFolder *pIndexesFolder = static_cast <KPGTableIndexesFolder *> (pSelectedItem->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pIndexesFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
	QString strSQL("REINDEX INDEX ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pSelectedItem->text(0)));
	strSQL.append(";");
	
	KPG2StepsWizard wzd(this, i18n("Reindex index"), strSQL, false);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
}

// Run ALTER Index OWNER TO new_owner Wizard
void KPoGreView::setOwnerIndex()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if(((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeIndex) &&
		((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodePrimaryKey)
		)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTableIndex *pIndex = static_cast <KPGTableIndex *> (pSelectedItem);
	KPGTableIndexesFolder *pIndexesFolder = static_cast <KPGTableIndexesFolder *> (pIndex->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pIndexesFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
		
	KPGSetOwnerWizard wzd(this, 
		"KPGSetOwnerWizard", 
		pServer->getUsersFolder(), 
		"INDEX", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pSelectedItem->text(0)),
		""
	);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run ALTER Index SET TABLESPACE indexspace_name Wizard 
void KPoGreView::setTablespaceIndex()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if(((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeIndex) &&
		((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodePrimaryKey)
		)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
  
	KPGTableIndex *pIndex = static_cast <KPGTableIndex *> (pSelectedItem);
	KPGTableIndexesFolder *pIndexesFolder = static_cast <KPGTableIndexesFolder *> (pSelectedItem->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pIndexesFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
		
	KPGSetTablespaceWizard wzd(this, 
		"KPGSetTablespaceWizard", 
		pServer->getTablespacesFolder(), 
		"INDEX", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pSelectedItem->text(0)), 
		pIndex->tablespace()
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return; 
}

// Run Create Rule Wizard 
void KPoGreView::createRule()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderRules)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(createRuleWizard(pDatabase, pSchema, pTable))
	{
		refresh();
	}
}
  
// Run Drop Rule Wizard 
void  KPoGreView::dropRule()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
  	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
		
		if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeRule)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
    
  	KPGRulesFolder *pRulesFolder = static_cast <KPGRulesFolder *> (pSelectedItem->parent());
  	KPGTable *pTable = static_cast <KPGTable *> (pRulesFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
  	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
  
    if(pSchema->isSystemObject() || pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really drop rule ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
  
	KPGDropObjectWizard wzd(
			this, 
			"KPGDropObjectWizard", 
			"RULE",
			pSchema->text(0),
			pSelectedItem->text(0),
			pTable->text(0)
			);
  
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
     return;
	
	// Refresh parent item
	setWaitCursor();
	try
	{
		pRulesFolder->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();	 
}
    
// Run Create Trigger Wizard 
void  KPoGreView::createTrigger()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTriggers)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pSelectedItem->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	if(createTriggerWizard(pDatabase, pSchema, pTable))
	{
		refresh();
		displayProperties();
	}
}
  
// Run Drop Trigger Wizard 
void  KPoGreView::dropTrigger()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
		
		if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTrigger)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
    
  	KPGTriggersFolder *pTriggersFolder = static_cast <KPGTriggersFolder *> (pSelectedItem->parent());
  	KPGTable *pTable = static_cast <KPGTable *> (pTriggersFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
  	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
  
    if(pSchema->isSystemObject() || pTable->isSystemObject() || pTable->isToastTable())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system table ! Really drop trigger ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
	
	KPGDropObjectWizard wzd(
			this, 
			"KPGDropObjectWizard", 
			"TRIGGER",
			pSchema->text(0),
			pSelectedItem->text(0),
			pTable->text(0)
			);
	
		wzd.setConnection(pDatabase->connection());
			
		if(wzd.exec() != QDialog::Accepted)
		return;
		
	// Refresh parent item
	setWaitCursor();
	try
	{
		pTriggersFolder->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();	 
}

// Run ALTER table ENABLE/DISABLE trigger Wizard 
void  KPoGreView::enableTrigger()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTrigger)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
  
	KPGTrigger *pTrigger = static_cast <KPGTrigger *> (pSelectedItem);	
	KPGTriggersFolder *pTriggersFolder = static_cast <KPGTriggersFolder *> (pSelectedItem->parent());
  	KPGTable *pTable = static_cast <KPGTable *> (pTriggersFolder->parent());
  	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
  	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
  
  	QString strSQL("ALTER TABLE ");
	strSQL.append(KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)));
	if(pTrigger->isEnabled())
		strSQL.append(" DISABLE");
	else
		strSQL.append(" ENABLE");
	
	strSQL.append(" TRIGGER ");
	strSQL.append(KPGUtil::quotedName(pTrigger->text(0)));
		
	KPG2StepsWizard wzd(this, i18n("Enable or disable triger"), strSQL, true);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save column name for look-up after refresh columns folder 
	QString strTriggerName(pTrigger->text(0));   
	
	setWaitCursor();
	try
	{
		pTriggersFolder->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pTrigger = static_cast <KPGTrigger *> (pTriggersFolder->getChildByName(strTriggerName));
	if(pTrigger)
	{
		m_pViewTree->ensureItemVisible(pTrigger);
		m_pViewTree->setSelected(pTrigger, true);
	}  
}

// Run ALTER Trigger RENAME Wizard 
void  KPoGreView::renameTrigger()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeTrigger)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGTriggersFolder *pTriggersFolder = static_cast <KPGTriggersFolder *> (pSelectedItem->parent());
	KPGTable *pTable = static_cast <KPGTable *> (pTriggersFolder->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	KPGRenameObjectWizard wzd(this, 
		"KPGRenameObjectWizard", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pTable->text(0)), 
		KPGUtil::quotedName(pSelectedItem->text(0)), 
		"TRIGGER", 
		i18n("trigger")
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
	
	setWaitCursor();
	try
	{
		pTriggersFolder->refresh(pTable->oid());
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pSelectedItem = pTriggersFolder->getChildByName(wzd.newObjectName());
	if(pSelectedItem)
	{
		m_pViewTree->ensureItemVisible(pSelectedItem);
		m_pViewTree->setSelected(pSelectedItem, true);
	}    
}

void KPoGreView::createBaseType()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTypes)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QPtrList<QListViewItem> listOfSchemas;
	listOfSchemas.append(pSchema);
	
	if(createBaseTypeWizard(pDatabase, listOfSchemas))
		refresh();
}

void KPoGreView::createCompositeType()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeFolderTypes)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	
	QPtrList<QListViewItem> listOfSchemas;
	listOfSchemas.append(pSchema);
	
	if(createCompositeTypeWizard(pDatabase, listOfSchemas))
		refresh();
}

void KPoGreView::dropType()
{
    KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
    if(! pSelectedItem)
    {
        kdDebug() << "KPoGreView::dropTable: no item selected" << endl;
        return;
    }
    
    KPGType *pType = static_cast <KPGType *> (pSelectedItem);
    KPGTypesFolder *pTypesFolder = static_cast <KPGTypesFolder *> (pType->parent());
    KPGSchema *pSchema = static_cast <KPGSchema *> (pTypesFolder->parent());
    KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
    
    if(pSchema->isSystemObject() || pType->isSystemObject())
	{
	   if(KMessageBox::questionYesNo(this, i18n("This is system type ! Really drop ?")) != KMessageBox::Yes) 
	   {
		  return;
	   }
	}
    
    KPGDropObjectWizard wzd(
        this, 
        "KPGDropObjectWizard", 
        "TYPE",
        pSchema->text(0),
        pSelectedItem->text(0)
        );
    
    wzd.setConnection(pDatabase->connection());
        
    if(wzd.exec() != QDialog::Accepted)
        return;
    
    // Refresh parent item
    setWaitCursor();
    try
    {
    	pTypesFolder->refresh();
    }
    catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
    setNormalCursor();
}

void KPoGreView::setOwnerType()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
	
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != KPGTreeItem::nodeType)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return;
	}
	
	KPGType *pType = static_cast <KPGType *> (pSelectedItem);
	KPGTypesFolder *pFolderTypes = static_cast <KPGTypesFolder *> (pType->parent());
	KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTypes->parent());
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent()); 
	
	KPGSetOwnerWizard wzd(this, 
		"KPGSetOwnerWizard", 
		pServer->getUsersFolder(), 
		"TYPE", 
		KPGUtil::fullyQualifiedName(pSchema->text(0), pType->text(0)), 
		pType->owner()
		);
	wzd.setConnection(pDatabase->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// save domain name for look-up after refresh types folder 
	QString strTypName(pType->text(0)); 
				
	setWaitCursor();
	try
	{
		pFolderTypes->refresh();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
	setNormalCursor();
	
	pType = static_cast <KPGType *> (pFolderTypes->getChildByName(strTypName));
	if(pType)
	{
		m_pViewTree->ensureItemVisible(pType);
		m_pViewTree->setSelected(pType, true);
	}
}

void KPoGreView::setDescription()
{
	KPGTreeItem * pSelectedItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	if(! pSelectedItem)
	{
		kdDebug() << k_funcinfo << " No item selected" << endl;
		return;
	}
  
  	QString strOldDescription;
  	  	
  	if((pSelectedItem->type() == KPGTreeItem::nodeTable) ||
  	   (pSelectedItem->type() == KPGTreeItem::nodeView) ||
  	   (pSelectedItem->type() == KPGTreeItem::nodeType) ||
  	   (pSelectedItem->type() == KPGTreeItem::nodeFunction) ||
  	   (pSelectedItem->type() == KPGTreeItem::nodeSequence)
  	   )
	{
		KPGObject *pPgObject = static_cast <KPGObject *> (pSelectedItem);
		strOldDescription = pPgObject->description();
		KPGItemsFolder *pFolder = static_cast <KPGItemsFolder *> (pPgObject->parent());
		KPGSchema *pSchema = static_cast <KPGSchema *> (pFolder->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		QString strObjectParameters = QString::null;
		
		if(pSelectedItem->type() == KPGTreeItem::nodeFunction)
		{
			// Function requires full name with arguments
			strObjectParameters = (static_cast <KPGFunction *> (pPgObject))->argumentTypes();
		}
		
		// Run wizard
		KPGSetDescriptionWizard wzd(this, 
			strOldDescription, 
			pPgObject->getObjectType(),
			pSchema->text(0),
			pPgObject->text(0),
			QString::null,
			strObjectParameters
			);
		wzd.setConnection(pDatabase->connection());
	
		if(wzd.exec() != QDialog::Accepted)
			return;
	
		try
		{
			pPgObject->refreshItem();
  			displayProperties();
  		}
  		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	else if(pSelectedItem->type() == KPGTreeItem::nodeTableColumn)
  	{
		KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pSelectedItem);
		KPGTable *pTable = static_cast <KPGTable *> (pColumn->getParentByType(KPGTreeItem::nodeTable));	
		strOldDescription = pColumn->description();	
		
		KPGTablesFolder *pFolderTables = static_cast <KPGTablesFolder *> (pTable->parent());
		KPGSchema *pSchema = static_cast <KPGSchema *> (pFolderTables->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		// Run wizard
		KPGSetDescriptionWizard wzd(this, 
			strOldDescription,
			"COLUMN",
			pSchema->text(0),
			pColumn->text(0),
			pTable->text(0)
			);
		wzd.setConnection(pDatabase->connection());
	
		if(wzd.exec() != QDialog::Accepted)
			return;
	
		try
		{
			pColumn->refreshItem();
  			displayProperties();
  		}
  		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	else if((pSelectedItem->type() == KPGTreeItem::nodeIndex) || 
			(pSelectedItem->type() == KPGTreeItem::nodePrimaryKey)
		   )
	{
		KPGObject *pPgObject = static_cast <KPGObject *> (pSelectedItem);
		KPGItemsFolder *pFolder = static_cast <KPGItemsFolder *> (pPgObject->parent());
		KPGTable *pTable = static_cast <KPGTable *> (pFolder->parent());
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
  	
  		strOldDescription = pPgObject->description();
  		
  		// Run wizard
		KPGSetDescriptionWizard wzd(this, 
			strOldDescription,
			pPgObject->getObjectType(),
			pSchema->text(0),
			pPgObject->text(0)
			);
		wzd.setConnection(pDatabase->connection());
	
		if(wzd.exec() != QDialog::Accepted)
			return;
	
		try
		{
			pPgObject->refreshItem();
  			displayProperties();
  		}
  		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	else if((pSelectedItem->type() == KPGTreeItem::nodePrimaryKeyConstr) || 
			(pSelectedItem->type() == KPGTreeItem::nodeCheckConstr) || 
			(pSelectedItem->type() == KPGTreeItem::nodeRule) || 
			(pSelectedItem->type() == KPGTreeItem::nodeTrigger) || 
			(pSelectedItem->type() == KPGTreeItem::nodeForeignKeyConstr) ||
			(pSelectedItem->type() == KPGTreeItem::nodeUniqueConstr)
		   )
	{
		KPGObject *pPgObject = static_cast <KPGObject *> (pSelectedItem);
		KPGItemsFolder *pFolder = static_cast <KPGItemsFolder *> (pPgObject->parent());
		KPGTable *pTable = static_cast <KPGTable *> (pFolder->parent());
		KPGSchema *pSchema = static_cast <KPGSchema *> (pTable->parent()->parent());
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
  	
  		strOldDescription = pPgObject->description();
  		
  		// Run wizard
		KPGSetDescriptionWizard wzd(this, 
			strOldDescription,
			pPgObject->getObjectType(),
			pSchema->text(0),
			pPgObject->text(0),
			pTable->text(0)
			);
		wzd.setConnection(pDatabase->connection());
	
		if(wzd.exec() != QDialog::Accepted)
			return;
	
		try
		{
			pPgObject->refreshItem();
			displayProperties();
		}
		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	else if((pSelectedItem->type() == KPGTreeItem::nodeSchema))
	{
		KPGSchema *pSchema = static_cast <KPGSchema *> (pSelectedItem);
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
		
		strOldDescription = pSchema->description();
		
		// Run wizard
		KPGSetDescriptionWizard wzd(this, 
			strOldDescription,
			pSchema->getObjectType(),
			pSchema->text(0),
			pSchema->text(0)
			);
		wzd.setConnection(pDatabase->connection());
	
		if(wzd.exec() != QDialog::Accepted)
			return;
	
		try
		{
			pSchema->refreshItem();
  			displayProperties();
  		}
  		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	else
	{
		kdDebug() << k_funcinfo << " Unsupported type" << endl;
	}
}
  
/////////////////////////////////////////////////////////////////////
//                           OTHER SLOTS
/////////////////////////////////////////////////////////////////////

void KPoGreView::slotCurrentChildViewChanged(KMdiChildView * pNewCurrentView)
{
	if(pNewCurrentView == 0) return;
	
	// Deactivate MDI childs, instead of new current one
	KMdiIterator<KMdiChildView*>* it = createIterator();
    for ( it->first(); !it->isDone(); it->next() )
    {
    	KMdiChildView * pMdiChildView = it->currentItem();
        if(pMdiChildView == pNewCurrentView) continue;
        
        if(pMdiChildView->className() == QString("KPGPropertyPageChildView"))
		{
			KPGPropertyPageChildView *pChildView = static_cast <KPGPropertyPageChildView*> (pMdiChildView);
			
			pChildView->slotDeactivated();
		}
		else if(pMdiChildView->className() == QString("KPGQueryResultChildView"))
		{
			KPGQueryResultChildView *pChildView = static_cast <KPGQueryResultChildView*> (pMdiChildView);
			pChildView->slotDeactivated();
		}
		else if(pMdiChildView->className() == QString("KPGDataTableChildView"))
		{
			KPGDataTableChildView *pChildView = static_cast <KPGDataTableChildView*> (pMdiChildView);
			pChildView->slotDeactivated();
		}
		else if(pMdiChildView->className() == QString("KPGExecutorChildView"))
		{
			KPGExecutorChildView *pChildView = static_cast <KPGExecutorChildView*> (pMdiChildView);
			pChildView->slotDeactivated();
		}
		else if(pMdiChildView->className() == QString("KPGDebuggerChildView"))
		{
			KPGDebuggerChildView *pChildView = static_cast <KPGDebuggerChildView*> (pMdiChildView);
			pChildView->slotDeactivated();
		}           
    }
    delete it;
	
	
	if(pNewCurrentView->className() == QString("KPGPropertyPageChildView"))
	{
	   	KPGPropertyPageChildView *pChildView = static_cast <KPGPropertyPageChildView*> (pNewCurrentView);
		
		mdiChildViewActivated(eMdiChildProperties);
		pChildView->slotActivated();
	}
	else if(pNewCurrentView->className() == QString("KPGQueryResultChildView"))
	{
		// Refresh comboboxes that contains available servers and their databases
		
		KPGQueryResultChildView *pChildView = static_cast <KPGQueryResultChildView*> (pNewCurrentView);
		
		// user selected SQL query/result window - update their connections list
		KPGQueryResultWindow* pQueryResultWindow = pChildView->getQueryResultWindow();
		
		// store selected server and database
		QString strServer(pQueryResultWindow->m_pComboBoxServer->currentText());
		QString strDatabase(pQueryResultWindow->m_pComboBoxDatabase->currentText());
		
		// If stored selected server or database is not found don't try reselect it  
		bool bCurrentServerIsFound = false;
		bool bCurrentDatabaseIsFound = false;
		
		pQueryResultWindow->m_pComboBoxServer->clear();
		pQueryResultWindow->m_pComboBoxDatabase->clear();
		
		QStringList strLisOfActiveDbConnections;
		
		// Traverse through servers, check if current server is stil found
		QListViewItem * pItem = m_pViewTree->firstChild();
		while(pItem)
		{
			if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
			{
				if(pItem->text(0) == strServer)
				{
					bCurrentServerIsFound = true;
					break;
				}
			}
			
			pItem = pItem->nextSibling();
		}
		
		// Traverse through servers
		pItem = m_pViewTree->firstChild();
		while(pItem)
		{
			if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
			{
				KPGServer *pServer = static_cast <KPGServer *> (pItem);
								
				//--- traverse list of connected databases
				QListViewItem * pItem2 = pServer->firstChild();
				
				if(pItem2)
					pQueryResultWindow->m_pComboBoxServer->insertItem(*pServer->pixmap(0), pServer->text(0));
					
				if(strServer == pServer->text(0)) // add databases for selected server
				{					
					while(pItem2)
					{
						if((static_cast <KPGTreeItem *> (pItem2))->type() == KPGTreeItem::nodeDatabase)
						{
							KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pItem2);
							if(pDatabase->connection())
							{ 
		                        if(pDatabase->text(0) == strDatabase)
                                    bCurrentDatabaseIsFound = true;      
                                        
                                pQueryResultWindow->m_pComboBoxDatabase->insertItem(*pDatabase->pixmap(0), pDatabase->text(0));
							}
						}
						pItem2 = pItem2->nextSibling();
					}	
				}
								 
			}
			pItem = pItem->nextSibling();
		}
		
		// restore selected values
		if(bCurrentServerIsFound && (strServer.length() > 0))
		{	
			pQueryResultWindow->m_pComboBoxServer->setCurrentText(strServer);
			
			if(bCurrentDatabaseIsFound && bCurrentServerIsFound && (strDatabase.length() > 0))
			{
				pQueryResultWindow->m_pComboBoxDatabase->setCurrentText(strDatabase);
			}
		}
		else
		{
			if(strServer.length() > 0)
			{
				slotRequestDatabasesList(pQueryResultWindow, strServer); 
			}
		}
		
		// Update 'Run Query' action and reload DB objects for code completition
		pQueryResultWindow->slotDatabaseChanged(pQueryResultWindow->m_pComboBoxDatabase->currentText());
		
		mdiChildViewActivated(eMdiChildQueryResult);
		pChildView->slotActivated();
	}
	else if(pNewCurrentView->className() == QString("KPGDataTableChildView"))
	{
	   KPGDataTableChildView *pChildView = static_cast <KPGDataTableChildView*> (pNewCurrentView);
	
	   mdiChildViewActivated(eMdiChildDataTable);
	   pChildView->slotActivated();
	}
	else if(pNewCurrentView->className() == QString("KPGExecutorChildView"))
	{
	   KPGExecutorChildView *pChildView = static_cast <KPGExecutorChildView*> (pNewCurrentView);
	
	   mdiChildViewActivated(eMdiChildExecutor);
	   pChildView->slotActivated();
	}
	else if(pNewCurrentView->className() == QString("KPGDebuggerChildView"))
	{
	   KPGDebuggerChildView *pChildView = static_cast <KPGDebuggerChildView*> (pNewCurrentView);
	
	   mdiChildViewActivated(eMdiChildDebugger);
	   pChildView->slotActivated();
	}
	else
	{
		kdError() <<  k_funcinfo << "Unhandled MDI view: " << pNewCurrentView->className() << endl;
	} 
	
	m_pActEditDeselect->setEnabled(m_pViewTree->selectedItem() != 0);
}

// Show popup menu for item in tree, whem mouse  right button is pressed
void KPoGreView::slotTreeViewRightButtonPressed(QListViewItem* pressedItem, const QPoint& point, int column)
{
	if(column >= 0)
    {
    	KPGTreeItem * pItem = static_cast <KPGTreeItem *> (pressedItem);
			
      	switch(pItem->type())
      	{
        //******************************************************************************************
		//
		// Main objects
		//
		//******************************************************************************************
				
			case KPGTreeItem::nodeServer:
				emit sigContextMenuRequested("popupServer", point);
				break;
				
			case KPGTreeItem::nodeDatabase:
				emit sigContextMenuRequested("popupDatabase", point);
				break; 
				
			case KPGTreeItem::nodeSchema:
				emit sigContextMenuRequested("popupSchema", point);
				break; 
					
			case KPGTreeItem::nodeFolderUsers:
				emit sigContextMenuRequested("popupFolderUsers", point);
				break;
				
			case KPGTreeItem::nodeFolderGroups:
				emit sigContextMenuRequested("popupFolderGroups", point);
				break;

			case KPGTreeItem::nodeFolderTablespaces:
				emit sigContextMenuRequested("popupFolderTablespaces", point);
				break;
					
			case KPGTreeItem::nodeTablespace:
				emit sigContextMenuRequested("popupTablespace", point);
				break; 
												
			//******************************************************************************************
			//
			// Database objects folders
			//
			//******************************************************************************************
				
			case KPGTreeItem::nodeFolderTables:
				emit sigContextMenuRequested("popupFolderTables", point);
				break; 
				
			case KPGTreeItem::nodeFolderViews:
				emit sigContextMenuRequested("popupFolderViews", point);
				break; 
				
			case KPGTreeItem::nodeFolderSequences:
				emit sigContextMenuRequested("popupFolderSequences", point);
				break; 
				
			case KPGTreeItem::nodeFolderFunctions:
				emit sigContextMenuRequested("popupFolderFunctions", point);
				break;
				
			case KPGTreeItem::nodeFolderOperators:
				emit sigContextMenuRequested("popupFolderOperators", point);
				break; 
					
			case KPGTreeItem::nodeFolderOperatorClasses:
				emit sigContextMenuRequested("popupFolderOperatorClasses", point);
				break; 
				
			case KPGTreeItem::nodeFolderAggregates:
				emit sigContextMenuRequested("popupFolderAggregates", point);
				break;
					
			case KPGTreeItem::nodeFolderDomains:
				emit sigContextMenuRequested("popupFolderDomains", point);
				break;
				
			case KPGTreeItem::nodeFolderTypes:
				emit sigContextMenuRequested("popupFolderTypes", point);
				break;
				
			case KPGTreeItem::nodeFolderLanguages:
				emit sigContextMenuRequested("popupFolderLanguages", point);
				break;
				
			case KPGTreeItem::nodeFolderConversions:
				emit sigContextMenuRequested("popupFolderConversions", point);
				break;
					
			case KPGTreeItem::nodeFolderCasts:
				emit sigContextMenuRequested("popupFolderCasts", point);
				break;		
				
			//******************************************************************************************
			//
			// Database objects
			//
			//******************************************************************************************
				
			case KPGTreeItem::nodeTable:
				emit sigContextMenuRequested("popupTable", point);
				break; 
				
			case KPGTreeItem::nodeView:
				emit sigContextMenuRequested("popupView", point);
				break; 
				
			case KPGTreeItem::nodeFunction:
          		emit sigContextMenuRequested("popupFunction", point);
				break; 
				
			case KPGTreeItem::nodeSequence:
          		emit sigContextMenuRequested("popupSequence", point);
				break;
									 
			case KPGTreeItem::nodeOperator:
				break; 
					
			case KPGTreeItem::nodeOperatorClass:
				break; 
					
			case KPGTreeItem::nodeAggregate:
				break;
					
			case KPGTreeItem::nodeDomain:
          		emit sigContextMenuRequested("popupDomain", point);
				break;
					
			case KPGTreeItem::nodeType:
          		emit sigContextMenuRequested("popupType", point);
				break;
					
			case KPGTreeItem::nodeLanguage:
          		emit sigContextMenuRequested("popupLanguage", point);
				break;
					
			case KPGTreeItem::nodeConversion:
				break;
					
			case KPGTreeItem::nodeCast:
				break;	
				 
		    case KPGTreeItem::nodeTypeAttribute:
				break;  
				
			case KPGTreeItem::nodeUser:
				emit sigContextMenuRequested("popupUser", point);
				break; 
				
			case KPGTreeItem::nodeGroup:
				emit sigContextMenuRequested("popupGroup", point);
				break;	 
				
			//******************************************************************************************
			//
			// Table objects folders
			//
			//******************************************************************************************
				
			case KPGTreeItem::nodeFolderTableColumns:
				emit sigContextMenuRequested("popupFolderTableColumns", point);
				break; 
				
			case KPGTreeItem::nodeFolderTableIndexes:
				emit sigContextMenuRequested("popupFolderTableIndexes", point);
				break; 
				
			case KPGTreeItem::nodeFolderTableConstraints:
				emit sigContextMenuRequested("popupFolderTableConstraints", point);
				break;
				
			case KPGTreeItem::nodeFolderRules:
				emit sigContextMenuRequested("popupFolderRules", point);
				break; 
				
			case KPGTreeItem::nodeFolderTriggers:
				emit sigContextMenuRequested("popupFolderTriggers", point);
				break;
				
        	//******************************************************************************************
        	//
        	// Domain objects folders
        	//
			//******************************************************************************************
				
        
	        case KPGTreeItem::nodeFolderDomainConstraints:
				emit sigContextMenuRequested("popupFolderDomainConstraints", point);
				break;
			
			case KPGTreeItem::nodeDomainConstr:
				emit sigContextMenuRequested("popupDomainConstraint", point);
				break;
			
			//******************************************************************************************
			//
			// Table objects
			//
			//******************************************************************************************
												
			case KPGTreeItem::nodeTableColumn:
				emit sigContextMenuRequested("popupTableColumn", point);
				break;
					
			case KPGTreeItem::nodePrimaryKeyConstr:
			case KPGTreeItem::nodeForeignKeyConstr:
			case KPGTreeItem::nodeUniqueConstr:
			case KPGTreeItem::nodeCheckConstr:
				emit sigContextMenuRequested("popupTableConstraint", point);
				break;
										
			case KPGTreeItem::nodePrimaryKey:
			case KPGTreeItem::nodeIndex:
				emit sigContextMenuRequested("popupTableIndex", point);
				break; 
					
			case KPGTreeItem::nodeRule:
				emit sigContextMenuRequested("popupRule", point);
				break; 
					
			case KPGTreeItem::nodeTrigger:
				emit sigContextMenuRequested("popupTrigger", point);
				break; 
			
			//******************************************************************************************
					
			case KPGTreeItem::nodeUnselected:
				break; 
			
			default:
			kdDebug() << k_funcinfo << " Unhandled object type ! " << pItem->text(0) << endl;
			break;
    	}
	}
}

// Checks, which type of item was selected
void KPoGreView::slotSelectionChanged()
{
	setWaitCursor();
		
	KPGTreeItem * pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());

	if ( ! pItem )
	{ 
		m_pActEditDeselect->setEnabled(false);
		m_pActViewNodeUp->setEnabled(false);
		
		emit sigSelectionChanged(KPGTreeItem::nodeUnselected, 0);
      	createPropertyPageChildView(0);
      	setNormalCursor();
		return;
    }
	else
    {
    	m_pActEditDeselect->setEnabled(true);
    	m_pActViewNodeUp->setEnabled(true);
    	
		emit sigSelectionChanged(pItem->type(), pItem);
		createPropertyPageChildView(pItem);
    }
    
    m_pActViewNodeBack->setEnabled(m_stackBackNodes.count() > 0);
	m_pActViewNodeForward->setEnabled(m_stackForwardNodes.count() > 0);
		
	if(pItem->type() != KPGTreeItem::nodeUnselected)
	{
		displayProperties();
		
		// For database, check if connection state is changed
		if(pItem->type() == KPGTreeItem::nodeDatabase)
		{
			KPGDatabase *pDatabase = static_cast <KPGDatabase *>	(pItem);
			if(pDatabase->isConnectionStateChanged())
			{
				pDatabase->clearConnectionStateChanged();
				
				// Inform active MDI child about change of available servers, databases
				KMdiChildView *activeMdiView = activeWindow();
				if(activeMdiView)
				{
					slotCurrentChildViewChanged(activeMdiView);
				}
			}
		}
	}
	
	setNormalCursor();
}

// Caled when user change selected server in SQL query / result window
// Set server's databases to combobox in SQL query / result window
void KPoGreView::slotRequestDatabasesList(KPGQueryResultWindow *pQueryResultWindow, const QString& strServer)
{
	pQueryResultWindow->clearListOfObjectsForCodeCompletion();
	pQueryResultWindow->m_pComboBoxDatabase->clear();
		
	if(strServer.length() == 0)
	{
		pQueryResultWindow->slotDatabaseChanged(QString::null);
		return;	
	}
		
	QListViewItem * pItem = m_pViewTree->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
		{
			KPGServer *pServer = static_cast <KPGServer *> (pItem);
			if(pServer->text(0) != strServer)
			{
				pItem = pItem->nextSibling(); continue;
			}
								
			//--- traverse list of connected databases
			QListViewItem * pItem2 = pServer->firstChild();
			bool bFirstDatabase = false;
			
			while(pItem2)
			{
				if((static_cast <KPGTreeItem *> (pItem2))->type() == KPGTreeItem::nodeDatabase)
				{
					KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pItem2);
					if(pDatabase->connection())
					{
						bFirstDatabase = false;
						
						pQueryResultWindow->m_pComboBoxDatabase->insertItem(*pDatabase->pixmap(0), pDatabase->text(0));
					
					    pQueryResultWindow->setEnableRunQuery(true);
					   
					   	if(bFirstDatabase)
					    {
					    	KPGOidNameList listOfCodeCompletionObjects;
                        	pDatabase->fillListOfObjectsForCodeCompletion(listOfCodeCompletionObjects);
                        	pQueryResultWindow->setListOfObjectsForCodeCompletion(listOfCodeCompletionObjects);
                        }
					}
				}
					
				pItem2 = pItem2->nextSibling();
			}	 
		}
		pItem = pItem->nextSibling();
	}
	
	pQueryResultWindow->slotDatabaseChanged(pQueryResultWindow->m_pComboBoxDatabase->currentText());
}

// Called, when database is selected in SQL query / result window and list of object for code completion is needed
void KPoGreView::slotRequestListOfDatabaseObjectsForCodeCompletion(KPGQueryResultWindow *pQueryResultWindow, const QString& strDatabase)
{
    pQueryResultWindow->clearListOfObjectsForCodeCompletion();
        
    QListViewItem * pItem = m_pViewTree->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
		{
			QString strServer(pQueryResultWindow->m_pComboBoxServer->currentText());
			KPGServer *pServer = static_cast <KPGServer *> (pItem);
			if(pServer->text(0) != strServer)
			{
				pItem = pItem->nextSibling(); continue;
			}
								
			//--- traverse list of connected databases
			QListViewItem * pItem2 = pServer->firstChild();
			
			while(pItem2)
			{
				if((static_cast <KPGTreeItem *> (pItem2))->type() == KPGTreeItem::nodeDatabase)
				{
					KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pItem2);
					if(pDatabase->text(0) != strDatabase)
                    {
                        pItem2 = pItem2->nextSibling(); continue;
                    }
                    
                    kdDebug() << k_funcinfo << "Database found !: " << pDatabase->text(0) << endl;
                    
                    KPGOidNameList listOfCodeCompletionObjects;
                    pDatabase->fillListOfObjectsForCodeCompletion(listOfCodeCompletionObjects);
                    pQueryResultWindow->setListOfObjectsForCodeCompletion(listOfCodeCompletionObjects);
                    return;
				}
					
				pItem2 = pItem2->nextSibling();
			}	 
		}
		pItem = pItem->nextSibling();
	}
}

// Called, when is needed schema childs list, for code completion 
void KPoGreView::slotRequestSchemaChildsListsForCodeCompletion(KPGQueryResultWindow *pQueryResultWindow, pqxx::oid oidSchema)
{
    kdDebug() << k_funcinfo << "oid: " << oidSchema << endl;

    QString strServer(pQueryResultWindow->m_pComboBoxServer->currentText());
	QString strDatabase(pQueryResultWindow->m_pComboBoxDatabase->currentText());
    
    if((strServer.length() == 0) || (strDatabase.length() == 0))
		return;
		
	// Find server
	QListViewItem * pItem = m_pViewTree->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
		{
			QString strServer(pQueryResultWindow->m_pComboBoxServer->currentText());
			KPGServer *pServer = static_cast <KPGServer *> (pItem);
			if(pServer->text(0) != strServer)
			{
				pItem = pItem->nextSibling(); continue;
			}
		
			//--- traverse list of connected databases
			QListViewItem * pItem2 = pServer->firstChild();
			
			while(pItem2)
			{
				if((static_cast <KPGTreeItem *> (pItem2))->type() == KPGTreeItem::nodeDatabase)
				{
					KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pItem2);
					if(pDatabase->text(0) != strDatabase)
                    {
                        pItem2 = pItem2->nextSibling(); continue;
                    }
                    
                    kdDebug() << k_funcinfo << "Database found !: " << pDatabase->text(0) << endl;
                    
                    KPGTreeItem *pItem = pDatabase->getChildByOid(oidSchema);
					if(!pItem)
					{
						kdDebug() << k_funcinfo << " no schema found" << endl;
						return;
					}
					
					KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
					
					KPGOidNameList listOfCodeCompletionObjects;
					pSchema->fillListOfObjectsForCodeCompletion(listOfCodeCompletionObjects);
                    pQueryResultWindow->setListOfSchemaChildsForCodeCompletion(listOfCodeCompletionObjects);
                    return;
				}
					
				pItem2 = pItem2->nextSibling();
			}	 
		}
		pItem = pItem->nextSibling();
	}
}
	
// Called, when is needed table columns list, for code completion 
void KPoGreView::slotRequestTableColumnsListsForCodeCompletion(KPGQueryResultWindow *pQueryResultWindow, const KPGOidNameAliases * pOnaTable)
{
	kdDebug() << k_funcinfo << "oid: " << pOnaTable->oid() << endl;
	
	if(pOnaTable->type() != KPGTreeItem::nodeTable)
	{
		kdError() << k_funcinfo << "Logic error !" << endl;
        return;
	}

	QString strServer(pQueryResultWindow->m_pComboBoxServer->currentText());
	QString strDatabase(pQueryResultWindow->m_pComboBoxDatabase->currentText());
    
    if((strServer.length() == 0) || (strDatabase.length() == 0))
		return;
	
	// Find server
	QListViewItem * pItem = m_pViewTree->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
		{
			KPGServer *pServer = static_cast <KPGServer *> (pItem);
			if(pServer->text(0) != strServer)
			{
				pItem = pItem->nextSibling(); continue;
			}
		
			//--- Get current database
			KPGTreeItem * pChildItem = pServer->getChildByNameAndType(strDatabase, KPGTreeItem::nodeDatabase);
			if(pChildItem == 0) return;	
			KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pChildItem);
			
			kdDebug() << k_funcinfo << "Database found !: " << pDatabase->text(0) << endl;
                    
            pChildItem = pDatabase->getChildByNameAndType(pOnaTable->namespaceName(), KPGTreeItem::nodeSchema);
			if(!pChildItem)
			{
				kdDebug() << k_funcinfo << " no schema found: " << pOnaTable->namespaceName() << endl;
				return;
			}
					
			KPGSchema *pSchema = static_cast <KPGSchema *> (pChildItem);
			KPGTablesFolder *pTablesFolder = pSchema->getTablesFolder();
					
			KPGObject *pObject = pTablesFolder->getChildItemByOid(pOnaTable->oid());
			if(pObject)
			{
				KPGTable *pTable = static_cast <KPGTable *> (pObject);
				kdDebug() << k_funcinfo << "Table found !: " << pTable->text(0) << endl;
						
				KPGTableColumnsFolder *pFolderColumns = pTable->getTableColumnsFolder();
						
				KPGListTableColumns listColumns;
				pFolderColumns->fillListColumns(listColumns); 
						
				pQueryResultWindow->setListOfColumnsForCodeCompletion(listColumns); 
            }

            return;	 
		}
		pItem = pItem->nextSibling();
	}
}

// Called, when is needed function return type attributes list, for code completion 
void KPoGreView::slotRequestFunctionReturnTypeAttributesListsForCodeCompletion(KPGQueryResultWindow *pQueryResultWindow, const KPGOidNameAliases *pOnaFunction)
{
	kdDebug() << k_funcinfo << "oid: " << pOnaFunction->oid() << endl;
	
	if(pOnaFunction->type() != KPGTreeItem::nodeFunction)
	{
		kdError() << k_funcinfo << "Logic error !" << endl;
        return;
	}
	
	QString strServer(pQueryResultWindow->m_pComboBoxServer->currentText());
	QString strDatabase(pQueryResultWindow->m_pComboBoxDatabase->currentText());
    
    if((strServer.length() == 0) || (strDatabase.length() == 0))
		return;
	
	// Find server
	QListViewItem * pItem = m_pViewTree->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeServer)
		{
			QString strServer(pQueryResultWindow->m_pComboBoxServer->currentText());
			KPGServer *pServer = static_cast <KPGServer *> (pItem);
			if(pServer->text(0) != strServer)
			{
				pItem = pItem->nextSibling(); continue;
			}
		
			//--- Get current database
			KPGTreeItem * pChildItem = pServer->getChildByNameAndType(strDatabase, KPGTreeItem::nodeDatabase);
			if(pChildItem == 0) return;	
			KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pChildItem);
			
			kdDebug() << k_funcinfo << "Database found !: " << pDatabase->text(0) << endl;
                    
            pChildItem = pDatabase->getChildByNameAndType(pOnaFunction->namespaceName(), KPGTreeItem::nodeSchema);
			if(!pChildItem)
			{
				kdDebug() << k_funcinfo << " no schema found: " << pOnaFunction->namespaceName() << endl;
				return;
			}
					
			KPGSchema *pSchema = static_cast <KPGSchema *> (pChildItem);
			KPGFunctionsFolder *pFunctionsFolder = pSchema->getFunctionsFolder();
					
			KPGObject *pObject = pFunctionsFolder->getChildItemByOid(pOnaFunction->oid());
			if(pObject)
			{
				KPGFunction *pFunction = static_cast <KPGFunction *> (pObject);
				kdDebug() << k_funcinfo << "Function found !: " << pFunction->nameWithArguments() << endl;
						
				pqxx::oid oidReturnType = pFunction->oidReturnType();
				if(oidReturnType == 0)
				{
				  kdError() << k_funcinfo << "Function has no return type: " << pFunction->nameWithArguments() << endl;
				  return;
				}
						
				KPGTypesFolder *pTypesFolder = pSchema->getTypesFolder();
				pObject = pTypesFolder->getChildItemByOid(oidReturnType);
				if(pObject)
			    {
				    KPGType *pType = static_cast <KPGType *> (pObject);
				                                                            
				    KPGListTableColumns listAttributes;
                    pType->fillListAttributes(listAttributes); 
                            
                    pQueryResultWindow->setListOfColumnsForCodeCompletion(listAttributes);
                }
            }

            return;	 
		}
		pItem = pItem->nextSibling();
	}
}


// Called from property pages when user double-clicks on KPGLinkLabel
void KPoGreView::slotSearchObject(const pqxx::oid _oid)
{
	// Start find from current items parent server
	KPGTreeItem *pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());

	if(!pItem)
	{
	  	KMessageBox::sorry(this, i18n("No item selected "));
		kdError() << k_funcinfo << " Item is not selected " << endl;
		return;    
	}
		
	// Store pointer to old item
	KPGTreeItem *pOldItem = pItem;

	// Go up to parent server
	while(pItem->type() != KPGTreeItem::nodeServer)
	{
		pItem = static_cast <KPGTreeItem *> (pItem->parent());
		if(!pItem)
		{
		  	kdError() << k_funcinfo << " Internal error !!!" << endl;
			return;    
		}
	}

	//--- Search item ---------------------------------
	while(pItem)
	{
		if((pItem->hasOid()))
		{
			KPGObject *pObject = static_cast <KPGObject *> (pItem);
			
			if(pObject->oid() == _oid)
			{
				// store info about previously selected item to stack
				if((pOldItem->hasOid()))
				{
					KPGObject *pOldObject = static_cast <KPGObject *> (pOldItem);
					m_stackBackNodes.push(KPGOidLink(pOldObject->oid(), pOldObject->path()));
				}
				else
					m_stackBackNodes.push(KPGOidLink(0, pOldItem->path()));
				
				m_stackForwardNodes.clear();
					
				// select new item
				selectItem(pItem);
				
				return;
			}
		}
		
		pItem = nextTreeItem(pItem);
	}
	
	KMessageBox::sorry(this, i18n("Searched item not found"));
}

// Called when property page need run Wizard
void KPoGreView::slotRunWizard(const QString &strSQL)
{
	KPGTreeItem *pItem = static_cast <KPGTreeItem *> (m_pViewTree->selectedItem());
	
	if(!pItem)
	{
		KMessageBox::sorry(this, i18n("No item selected "));
		kdError() << k_funcinfo << " Item is not selected " << endl;
		return;    
	}
	
	KPG2StepsWizard wzd(this, i18n("Change privileges"), strSQL, false);
	wzd.setConnection(pItem->connection());
		
	if(wzd.exec() != QDialog::Accepted)
		return;
		
	// refresh only item info, not child items if possible
	try
	{
		pItem->refreshItem();
		displayProperties();
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}
}

// Called when requested change terminal icon in this QTabWidget 
void KPoGreView::slotSetTerminalIcon(KPGQueryResultWindow *pWidget, int iColor)
{
	switch(iColor)
	{
		case 0: ((KMdiChildView *) pWidget->parent())->setIcon(SmallIcon("openterm"));   
				break;
		
		case 1: ((KMdiChildView *) pWidget->parent())->setIcon(UserIcon("opentermred"));
				break;
		
		case 2: ((KMdiChildView *) pWidget->parent())->setIcon(UserIcon("opentermblue"));
				break;
	}
}

/////////////////////////////////////////////////////////////////////
//                       WIZARDS FUNCTIONS
/////////////////////////////////////////////////////////////////////


// Run Create Database Wizard 
bool KPoGreView::createDatabaseWizard(KPGServer *pServer)
{
	KPGCreateDatabaseWizard wzd(this, "Create new database", pServer);
			
	wzd.setConnection(pServer->connection());
		
	if(wzd.exec() != QDialog::Accepted)
        return false;
  
	return true;
}

// Run Create Tablespace Wizard 
bool KPoGreView::createTablespaceWizard(KPGServer *pServer)
{
    KPGCreateTablespaceWizard wzd(this, "KPGCreateTablespaceWizard", pServer);
    wzd.setConnection(pServer->connection());
    
    if(wzd.exec() != QDialog::Accepted)
        return false;
        
    return true;
}

// Run Create Group Wizard 
bool KPoGreView::createGroupWizard(KPGServer *pServer)
{
	KPGCreateGroupWizard wzd(this, "KPGCreateGroupWizard", pServer->getUsersFolder());
	wzd.setConnection(pServer->connection());
	
	if(wzd.exec() != QDialog::Accepted)
        return false;
		 
	return true;
}

// Run Create User Wizard 
bool KPoGreView::createUserWizard(KPGServer *pServer)
{
	KPGCreateUserWizard wzd(this, "KPGCreateUserWizard", pServer);
	wzd.setConnection(pServer->connection());
	
	if(wzd.exec() != QDialog::Accepted)
        return false;
		 
	return true;
}

// Run Create Schema Wizard 
bool KPoGreView::createSchemaWizard(KPGDatabase *pDatabase)
{
	KPGCreateSchemaWizard wzd(this, "KPGCreateSchemaWizard", pDatabase);
	wzd.setConnection(pDatabase->connection());
	
	if(wzd.exec() != QDialog::Accepted)
        return false;
		 
	return true;
}

// Run Create Language Wizard 
bool KPoGreView::createLanguageWizard(KPGDatabase *pDatabase)
{
    KPGCreateLanguageWizard wzd(this, "KPGCreateLanguageWizard", pDatabase);
    wzd.setConnection(pDatabase->connection());
    
    if(wzd.exec() != QDialog::Accepted)
        return false;
        
    return true;
}

// Run Create Table Wizard 
bool KPoGreView::createTableWizard(KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
{
	KPGCreateTableWizard wzd(this, "KPGCreateTableWizard", pDatabase, listOfSchemas);
  	wzd.setConnection(pDatabase->connection());
	
	if(wzd.exec() != QDialog::Accepted)
        return false;
  
	return true;
}

// Run Create Type Wizard 
bool KPoGreView::createBaseTypeWizard(KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
{
    KPGCreateBaseTypeWizard wzd(this, "KPGCreateBaseTypeWizard", pDatabase, listOfSchemas);
    wzd.setConnection(pDatabase->connection());
            
    if(wzd.exec() != QDialog::Accepted)
        return false;
    
    return true;
}

// Run Create Type Wizard 
bool KPoGreView::createCompositeTypeWizard(KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
{
    KPGCreateCompositeTypeWizard wzd(this, "KPGCreateCompositeTypeWizard", pDatabase, listOfSchemas);
    wzd.setConnection(pDatabase->connection());
            
    if(wzd.exec() != QDialog::Accepted)
        return false;
    
    return true;
}

// Run Create View Wizard 
bool KPoGreView::createViewWizard(KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
{
	KPGCreateViewWizard wzd(this, "KPGCreateViewWizard", pDatabase, listOfSchemas);
	wzd.setConnection(pDatabase->connection());
  
	if(wzd.exec() != QDialog::Accepted)
        return false;
  
	return true;
}

// Run Create Domain Wizard 
bool KPoGreView::createDomainWizard(KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
{
    KPGCreateDomainWizard wzd(this, "KPGCreateDomainWizard", pDatabase, listOfSchemas);
    wzd.setConnection(pDatabase->connection());
    
    if(wzd.exec() != QDialog::Accepted)
        return false;
    
    return true;
}

// Run Create Function Wizard 
bool KPoGreView::createFunctionWizard(KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
{
    KPGCreateFunctionWizard wzd(this, "KPGCreateFunctionWizard", pDatabase, listOfSchemas);
    wzd.setConnection(pDatabase->connection());
    
    if(wzd.exec() != QDialog::Accepted)
        return false;
    
    return true;
}

// Run Create Sequence Wizard 
bool KPoGreView::createSequenceWizard(KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
{
    KPGCreateSequenceWizard wzd(this, "KPGCreateSequenceWizard", listOfSchemas);
    wzd.setConnection(pDatabase->connection());
        
    if(wzd.exec() != QDialog::Accepted)
        return false;
    
    return true;
}

// Run simple 2-steps for dropping DB object
bool KPoGreView::dropObjectWizard(
	KPGTreeItem * pSelectedItem, 		// item to DROP
	KPGTreeItem::eNodeType nodeType, 	// object type
	const char *szObjectTypeName, 		// user for  SQL statement - DROP OBJECTYPE
	KPGConnection *pConnection, 		// connection for SQL operation
	const QString &strSchemaName,		// optional schema name
  	bool bWithTransaction              	// run SQL with transaction
	)
{
	if((static_cast <KPGTreeItem *> (pSelectedItem))->type() != nodeType)
	{
		kdDebug() << k_funcinfo << " Item types mismatch" << endl;
		return false;
	}
		
	QString strSQL("DROP ");
	strSQL.append(szObjectTypeName);
	strSQL.append(" ");
	
	if(strSchemaName.length() > 0)
	{
    	strSQL.append(KPGUtil::quotedName(strSchemaName));
			strSQL.append(".");
	}
	
	// object name
	strSQL.append(KPGUtil::quotedName(pSelectedItem->text(0)));
	strSQL.append(";");
	
	KPG2StepsWizard wzd(this, i18n("Drop object"), strSQL, bWithTransaction);
	wzd.setConnection(pConnection);
		
	if(wzd.exec() != QDialog::Accepted)
     return false;
  
	// Refresh parent item
	setWaitCursor();
	
	if(nodeType == KPGTreeItem::nodeSchema)
	{
		KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSelectedItem->parent());
		setWaitCursor();
		try
		{
			pDatabase->refresh();
		}
		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	else
	{		
		KPGItemsFolder *pParentFolder = static_cast <KPGItemsFolder *> (pSelectedItem->parent());
		setWaitCursor();
		try
		{
			pParentFolder->refresh();
		}
		catch (const KPGSqlException &e)
		{
			setNormalCursor();
			KPGSqlDialog dlg(this, e.getSql(), e.what());
			dlg.exec();
		}
	}
	
	setNormalCursor();

	return true;
}

// Run simple 2-steps for dropping Table child object, using ALTER table DROP ...
bool KPoGreView::dropTableObjectWizard(
	KPGTreeItem * pSelectedItem, 			// item to DROP
	const char *szObjectTypeName, 			// user for SQL statement - DROP OBJECTYPE
	KPGConnection *pConnection, 			// connection for SQL operation
	const QString &strNamespace,			// schema name
  	const QString &strTableName				// table name
	)
{
	
	
	KPGDropTableObjectWizard wzd(this, 
        "KPGDropTableObjectWizard", 
        szObjectTypeName, 
        strNamespace,
        pSelectedItem->text(0),
        strTableName
        );
	
	wzd.setConnection(pConnection);
		
	if(wzd.exec() != QDialog::Accepted)
     return false;
  
	// Refresh parent item
	setWaitCursor();
	
	KPGTableItemsFolder *pParentFolder = static_cast <KPGTableItemsFolder *> (pSelectedItem->parent());
	try
	{
		pParentFolder->refresh(); // TODO: When drop constraint, refresh also indexes !
	}
	catch (const KPGSqlException &e)
	{
		setNormalCursor();
		KPGSqlDialog dlg(this, e.getSql(), e.what());
		dlg.exec();
	}	
	setNormalCursor();

	return true;
}

// Run ALTER table ADD Column Wizard
bool KPoGreView::createColumnWizard(KPGDatabase *pDatabase, KPGSchema *pSchema, KPGTable *pTable)
{
	KPGCreateTableColumnWizard wzd(this, 
		"KPGCreateTableColumnWizard", 
		pDatabase, 
		pSchema->text(0), 
		pTable->text(0)
		);
	wzd.setConnection(pDatabase->connection());
	if(wzd.exec() != QDialog::Accepted)
		return false;
	
	return true;
}

// Run Create Constraint Wizard 
bool KPoGreView::createConstraintWizard(KPGDatabase *pDatabase, KPGSchema *pSchema, KPGTable *pTable, int iRaisedWidget)
{
	KPGCreateTableConstraintWizard wzd(this, "KPGCreateTableConstraintWizard", pDatabase, pSchema, pTable, pTable->primaryKeyName().isEmpty(), iRaisedWidget);
	wzd.setConnection(pDatabase->connection());
	if(wzd.exec() != QDialog::Accepted)
		return false;
	
	return true;
}

// Run Create Index Wizard 
bool KPoGreView::createIndexWizard(KPGDatabase *pDatabase, KPGSchema *pSchema, KPGTable *pTable)
{
	KPGCreateTableIndexWizard wzd(this, "KPGCreateTableIndexWizard", pDatabase, pSchema, pTable);
	wzd.setConnection(pDatabase->connection());
	if(wzd.exec() != QDialog::Accepted)
		return false;
	
	return true;
}

// Run Create Rule Wizard 
bool KPoGreView::createRuleWizard(KPGDatabase *pDatabase, KPGSchema *pSchema, KPGTable *pTable)
{
	KPGCreateRuleWizard wzd(this, "KPGCreateRuleWizard", pSchema->text(0), pTable->text(0));
	wzd.setConnection(pDatabase->connection());
	if(wzd.exec() != QDialog::Accepted)
		return false;
	
	return true;
}

// Run Create Trigger Wizard 
bool KPoGreView::createTriggerWizard(KPGDatabase *pDatabase, KPGSchema *pSchema, KPGTable *pTable)
{
	KPGCreateTriggerWizard wzd(this, 
		"KPGCreateTriggerWizard", 
		pDatabase, 
		pSchema->text(0), 
		pTable->text(0));
	wzd.setConnection(pDatabase->connection());
	if(wzd.exec() != QDialog::Accepted)
		return false;
	
	return true;
}

//-------------------------------------------------------------------------
//
// Other slots, that aren't dedicated to KPoGreController
//
//-------------------------------------------------------------------------
    
// Dialog for key binding configuration
void KPoGreView::slotConfigureKeys()
{
  	KKeyDialog::configure(actionCollection(), xmlFile());
}

// Configure toolbars dialog 
void KPoGreView::slotConfigToolbars()
{
  	saveMainWindowSettings(KGlobal::config(), "KPogreMainWindow");
  	KEditToolbar dlg(actionCollection());

	if (dlg.exec())
	{ 
		createGUI(0);
	}
}

// Configure application
void KPoGreView::slotConfigure()
{
	m_pController->slotStatusMsg( i18n("Configure KPoGre ...") );
	configuration()->showDialog();
	m_pController->slotStatusMsg( i18n("Ready.") );
}

// Called when user choose bookmark
void KPoGreView::slotOpenUrl( const QString& strUrl)
{
  	openUrl(strUrl);
}

// Display popup menu
void KPoGreView::slotContextMenuRequested(const QString & strMenuName, const QPoint & pos)
{
	QWidget * pContainer = guiFactory()->container(strMenuName, this);

	if ( ! pContainer )
	{
		kdError() << k_funcinfo << " Couldn't get a container widget for the given menu name (" << strMenuName << ")" << endl;
		return;
	}

	if ( ! pContainer->inherits("KPopupMenu") )
	{
		kdError() << k_funcinfo << " Wrong container widget" << endl;
		return;
	}

	KPopupMenu * pMenu = static_cast <KPopupMenu*> (pContainer);
	pMenu->popup( pos );
}

// Called, when user make right click over property table. Display popup menu
/*void KPoGreView::slotPropertyPageContextMenuRequested(int, int, const QPoint & pos)
{
	KPGAbstractPropertyPage *pPropertyPage = getActivePropertyPage();
	if(pPropertyPage == 0) return;
	
	if(pPropertyPage->tableResult()->numRows() < 1)
		return;
	
	QWidget * pContainer = guiFactory()->container("popupPropertyTable", this);

	if ( ! pContainer )
	{
		kdError() << k_funcinfo << " Couldn't get a container widget for the given menu name (popupResultTable)" << endl;
		return;
	}

	if ( ! pContainer->inherits("KPopupMenu") )
	{
		kdError() << k_funcinfo << " Wrong container widget" << endl;
		return;
	}

	KPopupMenu * pMenu = static_cast <KPopupMenu*> (pContainer);
	pMenu->popup( pos );
}*/

// Updates tooltip text for specific MDI child View
void KPoGreView::slotUpdateTabTooltip(KMdiChildView *pChildView, const QString &strText)
{
	tabWidget()->setTabToolTip(pChildView, strText);
}

// Inform about activate specific MDI child view
void KPoGreView::mdiChildViewActivated(KPoGreView::EMdiChildView eMdiChildView)
{
	if(m_eActiveView == eMdiChildView) return;
	KToolBar * pToolBar;
	
	switch(m_eActiveView)
	{
		case KPoGreView::eMdiChildNone:
		case KPoGreView::eMdiChildProperties:
			break;
			
		case KPoGreView::eMdiChildQueryResult:
			pToolBar = toolBar("queryResultToolBar");
			pToolBar->hide();	
	
			break;
			
		case KPoGreView::eMdiChildDataTable:
			pToolBar = toolBar("dataTableToolBar");
			pToolBar->hide();
	
			break;
			
		case KPoGreView::eMdiChildExecutor:
			pToolBar = toolBar("executorToolBar");
			pToolBar->hide();
			
			break;
			
		case KPoGreView::eMdiChildDebugger:
			pToolBar = toolBar("debuggerToolBar");
			pToolBar->hide();
			break;
			
		default:
			kdError() << k_funcinfo << "Unhandled case" << endl;
	}
	
	switch(eMdiChildView)
	{
		case KPoGreView::eMdiChildProperties:
			break;
			
		case KPoGreView::eMdiChildQueryResult:
			pToolBar = toolBar("queryResultToolBar");
			pToolBar->show();	
	
			break;
			
		case KPoGreView::eMdiChildDataTable:
			pToolBar = toolBar("dataTableToolBar");
			pToolBar->show();
	
			break;
			
		case KPoGreView::eMdiChildExecutor:
			pToolBar = toolBar("executorToolBar");
			pToolBar->show();
			
			break;
			
		case KPoGreView::eMdiChildDebugger:
		    pToolBar = toolBar("debuggerToolBar");
			pToolBar->show();  
			break;
			
		default:
			kdError() << k_funcinfo << "Unhandled case" << endl;
	}
	
	m_eActiveView = eMdiChildView;
}

// Initialize code snippets
void KPoGreView::initializeSnippets()
{
	QStringList list;
	KListBox *pListBox;
	
	//---------------------------------------------------------------------------------------
	list << "to_char(x, format_text)"
			<<	"to_date(text, format_text)"
			<< "to_number(text, format_text)"
			<< "to_timestamp(text, format_text)"
			<< "to_timestamp(double precision)"; 
	
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), "Formatting");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "age(timestamp, timestamp)" 
			<< "age(timestamp)" 
			<< "clock_timestamp()" 
			<< "current_date" 
			<< "current_time" 
			<< "current_timestamp" 
			<< "date_part(string, timestamp)" 
			<< "date_part(string, interval)" 
			<< "date_trunc(string, timestamp)" 
			<< "extract(string from timestamp)"
			<< "extract(field from interval)"
			<< "isfinite(timestamp)" 
			<< "isfinite(interval)" 
			<< "justify_days(interval)"
			<< "justify_hours(interval)"
			<< "justify_interval(interval)"
			<< "localtime" 
			<< "localtimestamp" 
			<< "now()" 
			<< "statement_timestamp()" 
			<< "timeofday()" 
			<< "transaction_timestamp()" 
			<< "SET datestyle TO sql" 
			<< "SET datestyle TO German"
			<< "SET datestyle TO postgres";
	
	
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(*KPGTreeItem::m_pIconColumnDate),  "Date / time");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "ascii(text)"
 			<< "bit_length(string)"
			<< "btrim(string text [, characters text])"
			<< "char_length(string)"
			<< "chr(int)"
			<< "convert(string using conversion_name)"
			<< "convert(string text, [src_encoding name,] dest_encoding name)"
			<< "decode(string text, type text)"
			<< "encode(data bytea, type text)"
			<< "initcap(text)"
			<< "length(string text)"
   			<< "lower(string)"
			<< "lpad(string text, length int [, fill text])"
			<< "ltrim(string text [, characters text])"
			<< "md5(string text)"
			<< "octet_length(string)"
			<< "overlay(string placing string from int [for int])"
			<< "position(substring in string)"
			<< "pg_client_encoding()"
			<< "quote_ident(string text)"
			<< "regexp_replace(string text, pattern text, replacement text [,flags text])"
			<< "repeat(string text, number int)"
			<< "replace(string text, from text, to text)"
			<< "rpad(string text, length int [, fill text])"
			<< "rtrim(string text [, characters text])"
			<< "split_part(string text, delimiter text, field int)"
			<< "strpos(string, substring)"
			<< "substr(string, from [, count])"
			<< "substring(string [from int] [for int])"
			<< "substring(string from pattern)"
			<< "substring(string from pattern for escape)"
			<< "to_ascii(text [, encoding])"
			<< "to_hex(number int or bigint)"
			<< "translate(string text, from text, to text)"
			<< "trim([leading | trailing | both] [characters] from string)"
			<< "upper(string)";
	
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(*KPGTreeItem::m_pIconColumnChar), "String");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "abs(x)"
			<< "cbrt(dp)"
			<< "ceil(dp or numeric)"
			<< "ceiling(dp or numeric)"
			<< "degrees(dp)"
			<< "exp(dp or numeric)"
			<< "floor(dp or numeric)"
			<< "ln(dp or numeric)"
			<< "log(dp or numeric)"
			<< "log(b numeric, x numeric)"
			<< "mod(y, x)"
			<< "pi()"
			<< "power(a dp, b dp)"
			<< "power(a numeric, b numeric)"
			<< "radians(dp)"
			<< "random()"
			<< "round(dp or numeric)"
			<< "round(v numeric, s integer)"
			<< "setseed(dp)"
			<< "sign(dp or numeric)"
			<< "sqrt(dp or numeric)"
			<< "trunc(dp or numeric)"
			<< "trunc(v numeric, s integer)"
			<< "width_bucket(op numeric, b1 numeric, b2 numeric, count integer)";
	
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(QPixmap(SmallIcon("math_sqrt"))), "Mathematical");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "acos(x)"
			<< "asin(x)"
			<< "atan(x)"
			<< "atan2(x, y)"
			<< "cos(x)"
			<< "cot(x)"
			<< "sin(x)"
			<< "tan(x)";
			
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(QPixmap(SmallIcon("math_rsub.png"))), "Trigonometric");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "btrim(string bytea, bytes bytea)"
			<< "decode(string text, type text)"
			<< "encode(string bytea, type text)"
			<< "get_bit(string, offset)"
			<< "get_byte(string, offset)"
			<< "length(string)"
			<< "md5(string)"
			<< "octet_length(string)"
			<< "position(substring in string)"
			<< "set_bit(string, offset, newvalue)"
			<< "set_byte(string, offset, newvalue)"
			<< "substring(string [from int] [for int])"
			<< "trim([both] bytes from string)";
			
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(*KPGTreeItem::m_pIconColumnBin), "Binary string");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "array_append(anyarray, anyelement)"
			<< "array_cat(anyarray, anyarray)"
			<< "array_dims(anyarray)"
			<< "array_lower(anyarray, int)"
			<< "array_prepend(anyelement, anyarray)"
			<< "array_to_string(anyarray, text)"
			<< "array_upper(anyarray, int)"
			<< "string_to_array(text, text)";
			
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(QPixmap(SmallIcon("math_brackets.png"))), "Array");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "currval(regclass)"
			<< "nextval(regclass)"
			<< "setval(regclass, bigint)"
			<< "setval(regclass, bigint, boolean)";
			
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(*KPGTreeItem::m_pIconSequence), "Sequence");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "abbrev(inet)"
			<< "abbrev(cidr)"
			<< "broadcast(inet)"
			<< "family(inet)"
			<< "host(inet)"
			<< "hostmask(inet)"
			<< "masklen(inet)"
			<< "netmask(inet)"
			<< "network(inet)"
			<< "set_masklen(inet, int)"
			<< "set_masklen(cidr, int)"
			<< "text(inet)"
			<< "trunc(macaddr)";
			
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(*KPGTreeItem::m_pIconColumnNet), "Network / MAC");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "area(object)"
			<< "center(object)"
			<< "diameter(circle)"
			<< "height(box)"
			<< "isclosed(path)"
			<< "isopen(path)"
			<< "length(object)"
			<< "npoints(path)"
			<< "npoints(polygon)"
			<< "pclose(path)"
			<< "popen(path)"
			<< "radius(circle)"
			<< "width(box)";
			
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(*KPGTreeItem::m_pIconColumnGeo), "Geometric");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "box(circle)"
			<< "box(point, point)"
			<< "box(polygon)"
			<< "circle(box)"
			<< "circle(point, double precision)"
			<< "circle(polygon)"
			<< "lseg(box)"
			<< "lseg(point, point)"
			<< "path(polygon)"
			<< "point(double precision, double precision)"
			<< "point(box)"
			<< "point(circle)"
			<< "point(lseg)"
			<< "point(polygon)"
			<< "polygon(box)"
			<< "polygon(circle)"
			<< "polygon(npts, circle)"
			<< "polygon(path)";
	
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), "Geo Conversions");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	//---------------------------------------------------------------------------------------
	list << "xmlcomment(text)"
			<< "xmlconcat(xml[, ...])"
			<< "xmlelement(name foo, xmlattributes('xyz' as bar))"
			<< "xmlforest('abc' AS foo, 123 AS bar)"
			<< "xmlpi(name target [, content])"
			<< "xmlroot(xml, version '1.0' , standalone yes)"
			<< "IS DOCUMENT"
			<< "xpath(xpath, xml[, nsarray])"
			<< "table_to_xml(tbl regclass, nulls boolean, tableforest boolean, targetns text)"
			<< "query_to_xml(query text, nulls boolean, tableforest boolean, targetns text)"
			<< "cursor_to_xml(cursor refcursor, count int, nulls boolean, tableforest boolean, targetns text)"
			<< "table_to_xmlschema(tbl regclass, nulls boolean, tableforest boolean, targetns text)"
			<< "query_to_xmlschema(query text, nulls boolean, tableforest boolean, targetns text)"
			<< "cursor_to_xmlschema(cursor refcursor, nulls boolean, tableforest boolean, targetns text)"
			<< "table_to_xml_and_xmlschema(tbl regclass, nulls boolean, tableforest boolean, targetns text)"
			<< "query_to_xml_and_xmlschema(query text, nulls boolean, tableforest boolean, targetns text)"
			<< "schema_to_xml(schema name, nulls boolean, tableforest boolean, targetns text)"
			<< "schema_to_xmlschema(schema name, nulls boolean, tableforest boolean, targetns text)"
			<< "schema_to_xml_and_xmlschema(schema name, nulls boolean, tableforest boolean, targetns text)"
			<< "database_to_xml(nulls boolean, tableforest boolean, targetns text)"
			<< "database_to_xmlschema(nulls boolean, tableforest boolean, targetns text)"
			<< "database_to_xml_and_xmlschema(nulls boolean, tableforest boolean, targetns text)";
			
	m_pViewSnippets->addItem(pListBox = new KListBox(m_pViewSnippets), QIconSet(*KPGTreeItem::m_pIconColumnXml), "XML");
	pListBox->insertStringList(list);
	list.clear();
	connect( pListBox, SIGNAL(returnPressed(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
	connect( pListBox, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotInsertSnippet(QListBoxItem *)));
}

// Called when code snippet is choosed
void KPoGreView::slotInsertSnippet(QListBoxItem *pListBoxItem)
{
	KPGQueryResultWindow *pQueryResultWindow = getActiveQueryResultWindow();
	if(pQueryResultWindow == 0) 
	{
		KMessageBox::sorry(this, i18n("Select Query/result window to insert snippet"));
		return;
	}
	
	pQueryResultWindow->insertSnippet(pListBoxItem->text());
}
