/***************************************************************************
*   Copyright (C) 2007 by Remi Villatel <maxilys@tele2.fr>                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef TEXTPREVIEWWIDGET_H
#define TEXTPREVIEWWIDGET_H

#include <qlabel.h>

#include <kpixmap.h>
#include "kshadowsettings.h"

class QPainter;

class KShadowEngine;

class TextPreviewWidget : public QLabel
{
	Q_OBJECT

	public:
		TextPreviewWidget(QWidget *parent = 0, const char *name = 0);
		virtual ~TextPreviewWidget();

		KShadowSettings::SelectionType selectionType(void) const;
		KShadowSettings::Algorithm algorithm(void) const;
		QString settingsString(void) const;
		int factor(void) const;
		int offsetX(void) const;
		int offsetY(void) const;
		int opacity(void) const;
		int thickness(void) const;

		bool shadowEnabled() const { return p_shadowEnabled; }
		bool useCustomShadow() const { return p_useCustomShadow; }
		QColor foreColor() const { return p_foreColor; }
		QColor backColor() const { return p_backColor; }
		QFont deskFont() const { return p_deskFont; }
		int textWidth() const { return p_textWidth; }
		int textHeight() const { return p_textHeight; }

		void init(QString);
		static int shadowAlgorithm(KShadowSettings::Algorithm);

		void setShadowEnabled(const bool se) { p_shadowEnabled = se; }
		void setCustomShadow(const bool ucs) { p_useCustomShadow = ucs; }
		void setDeskFont(const QFont f) { p_deskFont = f; }
		void setForeColor(const QColor c) { p_foreColor = c; }
		void setBackColor(const QColor c) { p_backColor = c; }
		void preset(const int x, const int y, const int th, 
				const int ds, const int df, const int op);
		void updatePreview();

	private:
		KShadowEngine *p_engine;
		KShadowSettings *p_settings;
		KPixmap p_previewPixmap;
		QRect p_contentRect;
		QColor p_foreColor;
		QColor p_backColor;
		bool p_shadowEnabled;
		bool p_useCustomShadow;
		QFont p_deskFont;
		int p_textWidth;
		int p_textHeight;

	private:
		void cleanup(void);
};

#endif
