/**
 * @file service-list.h Service list
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_SERVICE_LIST_H_
#define _GALAGOD_SERVICE_LIST_H_

#include "coco.h"
#include "meta-service.h"

void galagod_services_add(GalagoService *service);
void galagod_services_remove(GalagoService *service);

void galagod_services_remove_with_coco(GalagodCoCo *coco);

void galagod_services_add_meta_service(GalagodMetaService *meta_service);
void galagod_services_remove_meta_service(GalagodMetaService *meta_service);

const GList *galagod_services_get_meta_services(void);
size_t galagod_services_get_meta_service_count(void);

GalagodMetaService *galagod_services_get_meta_service(const char *id);

void galagod_services_init(void);
void galagod_services_uninit(void);

#endif /* _GALAGOD_SERVICE_LIST_H_ */
