//////////////////////////////////////////////////////////////////////////////
// groverconfig.cc
// -------------------
// Config module for Grover window decoration
// -------------------
// Copyright (c) 2003, 2004 David Johnson <david@usermode.org>
// Please see the header file for copyright and license information.
//////////////////////////////////////////////////////////////////////////////

#include <kconfig.h>
#include <klocale.h>
#include <kglobal.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qwhatsthis.h>

#include "groverconfig.h"
#include "configdialog.h"
#include "../images.h"

//////////////////////////////////////////////////////////////////////////////
// GroverConfig Class                                                        //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// GroverConfig()
// -------------
// Constructor

GroverConfig::GroverConfig(KConfig*, QWidget* parent)
    : QObject(parent), config_(0), dialog_(0)
{
    config_ = new KConfig("kwingroverrc");
    KGlobal::locale()->insertCatalogue("kwin_grover_config");

    dialog_ = new ConfigDialog(parent);

    // load images into titleeffect combo
    KPixmap pix;
    config_->setGroup("WM");
    QColor base = config_->readColorEntry("activeBackground");
    for (int n=0; n<EFFECTCOUNT; ++n) {
        pix.resize(100, 22);
        createGradient(pix, base, effects[n]);
        dialog_->titleeffect->insertItem(pix, effects[n]);
    }

    load(config_);
    dialog_->show();

    // connections
    connect(dialog_->titlealign, SIGNAL(clicked(int)),
            this, SLOT(selectionChanged()));
    connect(dialog_->titleeffect, SIGNAL(activated(int)), 
            this, SLOT(selectionChanged()));
}

//////////////////////////////////////////////////////////////////////////////
// ~GroverConfig()
// --------------
// Destructor

GroverConfig::~GroverConfig()
{
    if (dialog_) delete dialog_;
    if (config_) delete config_;
}

//////////////////////////////////////////////////////////////////////////////
// selectionChanged()
// ------------------
// Selection has changed

void GroverConfig::selectionChanged()
{
    emit changed();
}

//////////////////////////////////////////////////////////////////////////////
// load()
// ------
// Load configuration data

void GroverConfig::load(KConfig*)
{
    config_->setGroup("General");
    
    QString value = config_->readEntry("TitleAlignment", "AlignHCenter");
    QRadioButton *button = (QRadioButton*)dialog_->titlealign->
        child((const char *)value.latin1());
    if (button) button->setChecked(true);

    QString effectname = config_->readEntry("TitleEffect", effects[0]);
    for (int n=0; n<EFFECTCOUNT; ++n) {
	if (effects[n] == effectname) {
	    dialog_->titleeffect->setCurrentItem(n);
	    break;
	}
    }
}

//////////////////////////////////////////////////////////////////////////////
// save()
// ------
// Save configuration data

void GroverConfig::save(KConfig*)
{
    config_->setGroup("General");
    QRadioButton *button = (QRadioButton*)dialog_->titlealign->selected();
    if (button) config_->writeEntry("TitleAlignment", QString(button->name()));

    config_->writeEntry("TitleEffect",
                        effects[dialog_->titleeffect->currentItem()]);
    config_->sync();
}

//////////////////////////////////////////////////////////////////////////////
// defaults()
// ----------
// Set configuration defaults

void GroverConfig::defaults()
{
    QRadioButton *button = (QRadioButton*)dialog_->titlealign->
        child("AlignHCenter");
    if (button) button->setChecked(true);
    dialog_->titleeffect->setCurrentItem(0);
}

//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////

extern "C"
{
    QObject* allocate_config(KConfig* config, QWidget* parent) {
        return(new GroverConfig(config, parent));
    }
}

#include "groverconfig.moc"
