#ifndef _QEMBED_16807
#define _QEMBED_16807
#include <qimage.h>
#include <qdict.h>
static const QRgb clearplastic_data[] = {
    0xf8ffffff,0xd6ffffff,0xaeffffff,0x9cffffff,0x8bffffff,0x79ffffff,0x68ffffff,0x57ffffff,0x46ffffff,0x0,0x0,0x0,0xeffffff,0x1bffffff,
    0x2affffff,0x37ffffff,0x45ffffff,0x53ffffff,0x61ffffff,0x6fffffff,0x9aa2a2a2,0xc14d4d4d
};

/* Generated by qembed */
static const QRgb gradient_data[] = {
    0xe9ffffff,0x82ffffff,0x71ffffff,0x6bffffff,0x65ffffff,0x5fffffff,0x59ffffff,0x53ffffff,0x4dffffff,0x47ffffff,0x41ffffff,0x3bffffff,0x35ffffff,0x30ffffff,
    0x2affffff,0x23ffffff,0x1dffffff,0x18ffffff,0x12ffffff,0xcffffff,0x959f9f9f,0xc14d4d4d
};

static const QRgb metallic_data[] = {
    0x5d6b6b6b,0x276b6b6b,0x95e7e7e7,0xd7f6f6f6,0xc9f1f1f1,0xb5ebebeb,0xa8e4e4e4,0x95dcdcdc,0x85d2d2d2,0x74c5c5c5,0x62b2b2b2,0x559e9e9e,0x4e7f7f7f,0x53636363,
    0x594c4c4c,0x5d393939,0x5e303030,0x5a313131,0x54363636,0x4e3a3a3a,0x47424242,0x3f4a4a4a,0x365c5c5c,0x2f6f6f6f,0x2a848484,0x28949494,0x278e8e8e,0x2e717171,
    0x38555555,0x4f393939,0x70272727,0x61616161
};

static const QRgb reversegradient_data[] = {
    0xe9ffffff,0x82ffffff,0xcffffff,0x12ffffff,0x18ffffff,0x1dffffff,0x23ffffff,0x2affffff,0x30ffffff,0x35ffffff,0x3bffffff,0x41ffffff,0x47ffffff,0x4dffffff,
    0x53ffffff,0x59ffffff,0x5fffffff,0x65ffffff,0x6bffffff,0x71ffffff,0x959f9f9f,0xc14d4d4d
};

static const QRgb stripes_data[] = {
    0x0,0x0,0x0,0x1affffff,0x0,0x0,0x1a000000,0x1affffff,0x0,0x0,0x1a000000,0x1affffff,0x0,0x0,
    0x1a000000,0x1affffff,0x0,0x0,0x1a000000,0x0,0x0,0x0
};

static struct EmbedImage {
    int width, height, depth;
    const unsigned char *data;
    int numColors;
    const QRgb *colorTable;
    bool alpha;
    const char *name;
} embed_image_vec[] = {
    { 1, 22, 32, (const unsigned char*)clearplastic_data, 0, 0, TRUE, "clearplastic" },
    { 1, 22, 32, (const unsigned char*)gradient_data, 0, 0, TRUE, "gradient" },
    { 1, 32, 32, (const unsigned char*)metallic_data, 0, 0, TRUE, "metallic" },
    { 1, 22, 32, (const unsigned char*)reversegradient_data, 0, 0, TRUE, "reversegradient" },
    { 1, 22, 32, (const unsigned char*)stripes_data, 0, 0, TRUE, "stripes" },
    { 0, 0, 0, 0, 0, 0, 0, 0 }
};

static const QImage& qembed_findImage( const QString& name )
{
    static QDict<QImage> dict;
    QImage* img = dict.find( name );
    if ( !img ) {
	for ( int i = 0; embed_image_vec[i].data; i++ ) {
	    if ( strcmp(embed_image_vec[i].name, name.latin1()) == 0 ) {
		img = new QImage((uchar*)embed_image_vec[i].data,
			    embed_image_vec[i].width,
			    embed_image_vec[i].height,
			    embed_image_vec[i].depth,
			    (QRgb*)embed_image_vec[i].colorTable,
			    embed_image_vec[i].numColors,
			    QImage::BigEndian );
		if ( embed_image_vec[i].alpha )
		    img->setAlphaBuffer( TRUE );
		dict.insert( name, img );
		break;
	    }
	}
	if ( !img ) {
	    static QImage dummy;
	    return dummy;
	}
    }
    return *img;
}

#endif

// The stuff above was automatically generated by qembed

//////////////////////////////////////////////////////////////////////////////
// images.h
// -------------------
// Images and image routines for Grover
// -------------------
// Copyright (c) 2003, 2004 David Johnson <david@usermode.org>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//////////////////////////////////////////////////////////////////////////////

#ifndef IMAGES_H
#define IMAGES_H

#include <kpixmap.h>
#include <kimageeffect.h>

const int CONTRAST    = 120;
const int EFFECTCOUNT = 5;

const QString effects[EFFECTCOUNT] = {
    "metallic",
    "clearplastic",
    "reversegradient",
    "stripes",
    "gradient"
};

//////////////////////////////////////////////////////////////////////////////
// createGradient()
// ----------------
// Create a gradient

static void createGradient(KPixmap &pix, const QColor &base, QString effect)
{
    if (pix.width() == 0) return;

    QImage buffer, hilite;
    QColor light, dark;

    light = base.light(CONTRAST);
    dark = base.dark(CONTRAST);

    // create gradient
    if (effect.contains("reverse")) {
        buffer = KImageEffect::gradient(pix.size(), dark, light,
                                        KImageEffect::VerticalGradient);
    } else {
        buffer = KImageEffect::gradient(pix.size(), light, dark,
                                        KImageEffect::VerticalGradient);
    }

    // apply effect
    hilite = qembed_findImage(effect).smoothScale(buffer.size());
    KImageEffect::blendOnLower(0, 0, hilite, buffer);

    pix.convertFromImage(buffer);
}

#endif // IMAGES_H
