/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qsize.h>
#include <qpixmap.h>
#include <qcursor.h>

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>

#include "kblogger.h"
#include "kbloggerconfig.h"

const int MAXPOSTS=20;

KBloggerMenu::KBloggerMenu( KBlog::APIBlog* backend, KBlogger* parent, const char* name ):
KPopupMenu( parent, name ), m_backend( backend ), m_parent( parent ), m_pos( QPoint() ), m_fullMenu( false )
{
	kdDebug() << "KBloggerMenu::KBloggerMenu()" << endl;
	connect( m_backend, SIGNAL( itemOnServer( KBlog::BlogPosting& ) ),
			this, SLOT( addPostingSlot( KBlog::BlogPosting& ) ) );
	connect( m_backend, SIGNAL( fetchingPostsFinished() ),
			this, SLOT( createMenuSlot() ) );
}

void KBloggerMenu::populateMenu(){
	kdDebug() << "KBloggerMenu::populateMenu()" << endl;
	this->clear();
	postings = QValueList<KBlog::BlogPosting>();

	KIO::TransferJob* job = m_backend->createListItemsJob( KURL::KURL( KBloggerConfig::blogId() ) );
	connect( job, SIGNAL( result( KIO::Job* ) ),
			m_backend, SLOT( interpretListItemsJob( KIO::Job* ) ) );
}

void KBloggerMenu::addPostingSlot( KBlog::BlogPosting& posting ){
	kdDebug() << "KBloggerMenu::addPostingSlot()" << endl;
	postings.append( posting );
}

void KBloggerMenu::createMenuSlot() {
	const QPixmap bugIcon = SmallIcon(QString::fromLatin1( "bug" ));
	const QPixmap fileIcon = SmallIcon(QString::fromLatin1("fileopen"));
	const QPixmap logoIcon = SmallIcon(QString::fromLatin1("kblogger"));
	const QPixmap helpIcon = SmallIcon(QString::fromLatin1("help"));
	const QPixmap confIcon = SmallIcon(QString::fromLatin1("configure"));

	insertTitle( logoIcon, i18n("KBlogger"), 0, 0 );
	if( m_fullMenu ) {
		QValueList<KBlog::BlogPosting>::ConstIterator it = postings.begin();
		int i=0;
		for(; it != postings.end(); ++it ){
	// Use a submenu, if more options are available
	// 		KPopupMenu *submenu = new KPopupMenu;
	// 		submenu->insertItem( i18n( "Delete post" ), this, SLOT(deleteSlot(int)), 0, ( *it ).postID().toInt() );
	// 		submenu->insertItem( i18n( "Edit post" ), m_parent, SLOT(editorSlot(int)), 0, ( *it ).postID().toInt() );
	// 		insertItem( ( *it ).title(), submenu );
	
			insertItem( ( *it ).title(), m_parent, SLOT(editorSlot(int)), 0, ( *it ).postID().toInt() );
			if(i++==MAXPOSTS) break;
		}
		insertSeparator();
		insertItem( fileIcon, i18n( "File upload" ), m_parent, SLOT(uploadSlot()) );
	}
	insertItem( bugIcon, i18n("Bugs or Wishes" ), this, SLOT(bugSlot()) );
	insertItem( confIcon, i18n("Configuration"), this, SLOT(configurateSlot()) );
	insertItem( helpIcon, i18n("Help"), this, SLOT(helpSlot()));
	insertItem(logoIcon, i18n("About KBlogger"), this, SLOT(aboutSlot()));

	this->exec( m_pos );
}

void KBloggerMenu::bugSlot() {
	m_parent->reportBug();
}

void KBloggerMenu::configurateSlot() {
	m_parent->preferences();
}

void KBloggerMenu::helpSlot(){
	m_parent->help();
}

void KBloggerMenu::aboutSlot(){
	m_parent->about();
}

void KBloggerMenu::deleteSlot( int postid ){
	kdDebug() << "KBloggerMenu::deleteSlot()" << endl;
	m_backend->createRemoveJob( KURL::KURL( KBloggerConfig::blogId() ), QString( "%1" ).arg( postid ) );
}
