/**************************************************************************

    config.cpp  - KPager config dialog
    Copyright (C) 2000  Antonio Larrosa Jimenez
	Copyright (c) 2003 Sebastian Wolff

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

    changes (c) 2003 Sebastian Wolff

***************************************************************************/

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qstringlist.h>
#include <qvbuttongroup.h>
#include <qvgroupbox.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qgrid.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qspinbox.h>

#include <kapplication.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <kglobal.h>
#include <kglobalaccel.h>
//#include <kicon.h>
#include <kinstance.h>
#include <kjanuswidget.h>
#include <klocale.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kkeydialog.h>
#include <kprocess.h>
#include <kseparator.h>

#include "config.h"
#include "version.h"
//#include "config.moc"
#include "kpagerdesktop.h"
#include "kpager.h"
#include "kpagertaskcontainer.h"


enum {
	//KPDC_SINGLESWITCHER = 1,
	KPDC_SWITCHER = 1,
	KPDC_KDE2,
	KPDC_KDE3,
	KPDC_ELVISH,
	KPDC_ZOOMER,
	KPDC_SHIFTER,
	KPDC_SHADOW,
	KPDC_ELEGANCE
} KPagerConfigDialogThemesEnum;

class KPagerJanusWidget : public KJanusWidget
{
public:
	KPagerJanusWidget(QWidget *parent=0, const char *name=0, int face=Plain):KJanusWidget(parent,name,face){}
	void   addPageWidget (QFrame *page, const QStringList &items, const QString &header, const QPixmap &pixmap) {KJanusWidget::addPageWidget(page,items,header,pixmap);}
};


KPagerConfigDialog::KPagerConfigDialog (KPager2 *parent)
 : KDialogBase ( parent, "configdialog", true, i18n("KPager Settings"), Apply|Ok|Cancel, Ok, true )
{
	QVBox *box = new QVBox( this );
	//box->setSpacing(fontMetrics().lineSpacing());
	box->setSpacing(5);
	setMainWidget(box);
	m_parent = parent;
	box->setMinimumWidth(600);

	
	// create page widgets
	m_general = new KPagerConfigGeneral(this);
	m_custom = new KPagerConfigCustom(this);
	m_3d = new KPagerConfig3d(this);
	{
		m_keys_= new QVBox(this);
		m_keys = new KKeyChooser(m_parent->globalAccel(), m_keys_);
		connect(m_keys,SIGNAL(keyChange()), this, SLOT(slotEnableApply()));
		m_custom_visible=true;
		// explanation
		QLabel * lab = new QLabel(m_keys_);
		lab->setText(i18n("<b>Here</b> you can override the global key accelerators of KWin if you want to use KPager for desktop switching, i.e. 3ddesktop and desktop notification."));
	}
	
	// create Janus Widget
	m_janus = new KPagerJanusWidget(box,"kpagerconfigjanuswidget",KJanusWidget::IconList);
	m_janus->addPageWidget(m_general,QStringList(i18n("General")),i18n("General settings"),
						   KGlobal::instance()->iconLoader()->loadIcon( "configure", KIcon::NoGroup, KIcon::SizeLarge ));
	m_janus->addPageWidget(m_3d,QStringList(i18n("3d")),i18n("General settings"),
						   KGlobal::instance()->iconLoader()->loadIcon( "3ddesktop", KIcon::NoGroup, KIcon::SizeLarge ));
	m_janus->addPageWidget(m_keys_,QStringList(i18n("Keys")),i18n("Global keyboard accelerators"),
						   KGlobal::instance()->iconLoader()->loadIcon( "key_bindings", KIcon::NoGroup, KIcon::SizeLarge ));
	m_janus->addPageWidget(m_custom,QStringList(i18n("Custom")),i18n("Custom Layout settings"),
						   KGlobal::instance()->iconLoader()->loadIcon( "colorize", KIcon::NoGroup, KIcon::SizeLarge ));
	/// TODO!!!!!!!!!!!!!!

	connect(this,SIGNAL(okClicked()),this,SLOT(slotOk()));
    connect(this,SIGNAL(applyClicked()),this,SLOT(slotApply()));
	loadConfiguration();
}

KPagerConfigDialog::~KPagerConfigDialog()
{
}

void KPagerConfigDialog::setControlsFromConfig()
{
	m_general->setControlsFromConfig();
	m_custom->setControlsFromConfig();
	m_3d->setControlsFromConfig();
	//m_keys are already done, since there is no static variable
}

void KPagerConfigDialog::setCustomPageVisible(bool on)
{
	if (!on && m_custom_visible) 
	{
		if (m_custom)
		{
			m_janus->removePage(m_custom);
			m_custom_visible = false;
			//m_custom=0;
		}
		//setDetails(false); // just in case: disable extension, if we use a predefined theme
	}
	else if (on && !m_custom_visible)
	{
		{
			m_custom = new KPagerConfigCustom(this);
			m_janus->addPageWidget(m_custom,QStringList(i18n("Custom")),
									i18n("Custom Layout settings"),
									KGlobal::instance()->iconLoader()->loadIcon( "colorize", KIcon::NoGroup, KIcon::SizeLarge ));
			m_custom_visible=true;
			m_custom->setControlsFromConfig(); // at the end to prevent getting into an endless loop
		}
	}
	
}

void KPagerConfigDialog::loadConfiguration()
{
	if (m_generalTheme!=0)
		enableButton(Details, false);
	else
		enableButton(Details, true);

    m_tmpShowName=m_showName;
    m_tmpShowNumber=m_showNumber;
    m_tmpShowBackground=m_showBackground;
    m_tmpShowWindows=m_showWindows;
    m_tmpWindowDrawMode=m_windowDrawMode;
    m_tmpWindowDragging=m_windowDragging;
    m_tmpShowDragMoving=m_showDragMoving;
    m_tmpShowGradient = m_showGradient;
    m_tmpNumberRows = m_numberRows;
	m_tmpShowOnlyOneDesktop = m_showOnlyOneDesktop;
    m_tmpDesktopDistance=m_desktopDistance;
    m_tmpDesktopMargin = m_desktopMargin;
	m_tmpGeneralBackgroundColor=m_generalBackgroundColor;
	m_tmpGeneralFrame=m_generalFrame;
	m_tmpGeneralTheme=m_generalTheme;
	m_tmpShadowPixmap=m_shadowPixmap;
	m_tmpBevelledSelection=m_bevelledSelection;
	m_tmpDesktopBackgroundColor=m_desktopBackgroundColor;
	m_tmpAnimation=m_animation;
	m_tmpWindowTransparentMode=m_windowTransparentMode;
	m_tmpShowTaskMenu=m_showTaskMenu;
	m_tmpToolTips=m_toolTips;
	m_tmpShowShadowPixmap=m_showShadowPixmap;
	m_tmpShowLauncher = m_showLauncher;
	m_tmpMenuThumbnailHeight = m_menuThumbnailHeight;
	m_tmpMenuThumbnailWidth = m_menuThumbnailWidth;

	//3d
	m_tmpUse3d = m_use3d;
	m_tmp3dMode = m_3dMode;
	m_tmp3dZoom = m_3dZoom;
	
//	m_themebox->setCurrentItem(m_tmpGeneralTheme);
	setControlsFromConfig();
	enableButtonApply(false);
}

extern KConfig * kpagerglobalconfig;
void KPagerConfigDialog::initConfiguration(void)
{
	KConfig *cfg= kpagerglobalconfig;
	cfg->setGroup("KPager2");
	
	m_windowDrawMode=cfg->readNumEntry("windowDrawMode", KPagerDesktop::c_defWindowDrawMode);
	m_showName=cfg->readBoolEntry("showName", KPagerDesktop::c_defShowName);
	m_showNumber=cfg->readBoolEntry("showNumber", KPagerDesktop::c_defShowNumber);
	m_showBackground=cfg->readBoolEntry("showBackground", KPagerDesktop::c_defShowBackground);
	m_showWindows=cfg->readBoolEntry("showWindows", KPagerDesktop::c_defShowWindows);
	m_windowDragging=cfg->readBoolEntry("windowDragging", KPagerDesktop::c_defWindowDragging);
	m_showDragMoving=cfg->readBoolEntry("showDragMoving", KPagerDesktop::c_defShowDragMoving);
	m_animation=cfg->readNumEntry("animation", KPagerDesktop::c_defAnimation);
	m_showGradient =cfg->readBoolEntry("showGradient", KPagerDesktop::c_defShowGradient );
	m_desktopBackgroundColor=cfg->readNumEntry("desktopBackgroundColor", KPagerDesktop::c_defDesktopBackgroundColor);
	m_numberRows=cfg->readNumEntry("numberRows", KPager2::c_defNumberRows);
	m_showOnlyOneDesktop=cfg->readBoolEntry("showOnlyOneDesktop", KPager2::c_defShowOnlyOneDesktop);
	m_showTaskMenu=cfg->readBoolEntry("showTaskMenu", KPager2::c_defShowTaskMenu);
	m_desktopDistance=cfg->readNumEntry("desktopDistance", KPager2::c_defDesktopDistance);
	m_desktopMargin=cfg->readNumEntry("desktopMargin", KPager2::c_defDesktopMargin);
	m_generalBackgroundColor=cfg->readNumEntry("generalBackgroundColor", KPager2::c_defGeneralBackgroundColor);
	m_generalFrame=cfg->readNumEntry("generalFrame", KPager2::c_defGeneralFrame);
	m_generalTheme=cfg->readNumEntry("generalTheme", KPager2::c_defGeneralTheme);
	m_shadowPixmap=cfg->readNumEntry("shadowPixmap", KPagerDesktop::c_defShadowPixmap);
	m_bevelledSelection=cfg->readBoolEntry("bevelledSelection", KPagerDesktop::c_defBevelledSelection);
	m_windowTransparentMode=(KPagerDesktop::WindowTransparentMode)cfg->readNumEntry("windowTransparentMode", KPagerDesktop::c_defWindowTransparentMode);
	m_toolTips=cfg->readBoolEntry("toolTips", KPagerDesktop::c_defToolTips);
	m_showShadowPixmap=cfg->readBoolEntry("showShadowPixmap", KPagerDesktop::c_defShowShadowPixmap);
	m_showLauncher=cfg->readBoolEntry("showLauncher", KPager2::c_defShowLauncher);
	m_menuThumbnailHeight = cfg->readNumEntry("TaskMenuThumbnailHeight", KPagerTaskContainer::c_defMenuThumbnailHeight);
	m_menuThumbnailWidth = cfg->readNumEntry("TaskMenuThumbnailWidth", KPagerTaskContainer::c_defMenuThumbnailWidth);

	
	cfg->setGroup("3d");
	m_use3d  = cfg->readBoolEntry("Use3d",KPager2::c_defUse3d);
	m_3dMode = cfg->readNumEntry ("3dMode",KPager2::c_def3dMode);
	m_3dZoom = cfg->readBoolEntry("3dZoom",KPager2::c_def3dZoom);
	// eventually start 3ddesktop (not necessary, is done at runtime)
	if(m_use3d) // take screenshots of all desktops at the very beginning 
	{
		{
			KProcess process;
			process<<"3ddeskd";
			QStringList args;
			//args<<"--acquire=100";
			args<<"--wm=kde3";
			process<<args;
			//process.start(KProcess::DontCare);		
			//Warning! This is quite dangerous
			process.start(KProcess::Block);		
		}
		{
			KProcess process;
			process<<"3ddesk";
			QStringList args;
			args<<"--acquire=100";
			process<<args;
			process.start(KProcess::DontCare);		
		}
	}
	
	//ok, the following is already done in KPager2's constructor
	//cfg->setGroup("Keys");
	//m_parent->globalAccel->readSettings(&cfg);
	//m_parent->globalAccel->updateConnections();
	//m_keys->listSync();
}

void KPagerConfigDialog::slotOk()
{
  slotApply();
  accept();
}

void KPagerConfigDialog::slotApply()
{
	enableButtonApply(false);

	// apply temporary values to global values
	m_showName=m_tmpShowName;
	m_showNumber=m_tmpShowNumber;
	m_showBackground=m_tmpShowBackground;
	m_showWindows=m_tmpShowWindows;
	m_windowDrawMode=m_tmpWindowDrawMode;
	m_windowDragging=m_tmpWindowDragging;
	m_showDragMoving=m_tmpShowDragMoving;
	m_showGradient = m_tmpShowGradient;
	m_numberRows = m_tmpNumberRows;
	m_showOnlyOneDesktop = m_tmpShowOnlyOneDesktop;
	m_desktopDistance=m_tmpDesktopDistance;
	m_desktopMargin=m_tmpDesktopMargin;
	m_generalBackgroundColor =m_tmpGeneralBackgroundColor;
	m_generalFrame =m_tmpGeneralFrame;
	m_generalTheme =m_tmpGeneralTheme;
	m_shadowPixmap =m_tmpShadowPixmap;
	m_bevelledSelection =m_tmpBevelledSelection;
	m_desktopBackgroundColor =m_tmpDesktopBackgroundColor;
	m_animation =m_tmpAnimation;
	m_windowTransparentMode=m_tmpWindowTransparentMode;
	m_showTaskMenu = m_tmpShowTaskMenu;
	m_toolTips = m_tmpToolTips;
	m_showShadowPixmap = m_tmpShowShadowPixmap;
	m_showLauncher = m_tmpShowLauncher;
	m_menuThumbnailHeight = m_tmpMenuThumbnailHeight;
	m_menuThumbnailWidth = m_tmpMenuThumbnailWidth;

	// 3d
	// eventually start 3ddesktop (not necessary, is done at runtime)
	if(!m_use3d && m_tmpUse3d) // take screenshots of all desktops if the config changed
	{
		{
			KProcess process;
			process<<"3ddeskd";
			QStringList args;
			//args<<"--acquire=100";
			args<<"--wm=kde3";
			process<<args;
			//process.start(KProcess::DontCare);		
			//Warning! This is quite dangerous
			process.start(KProcess::Block);		
		}
		{
			KProcess process;
			process<<"3ddesk";
			QStringList args;
			args<<"--acquire=100";
			process<<args;
			process.start(KProcess::DontCare);		
		}
	}
	
	m_use3d = m_tmpUse3d;
	m_3dMode = m_tmp3dMode;
	m_3dZoom = m_tmp3dZoom;
	
	if(!m_use3d) // stop 3ddesk since it takes to much memory
	{
		KProcess process;
		process<<"3ddesk";
		QStringList args;
		args<<"--stop";
		process<<args;
		process.start(KProcess::DontCare);		
	}
	
	// Keys
	m_keys->commitChanges();
	m_parent->globalAccel()->updateConnections();
	
	// save configuration
	m_parent->slotApplyConfigureFromDialog();
}


/// --------------------------------------------------------------------------------
KPagerConfigGeneral::KPagerConfigGeneral(KPagerConfigDialog * parent)
 : QVBox()
{
	m_parent = parent;
	setSpacing(5);

	// theme
	QLabel *m_themelabel;
	QHBox *thbox = new QHBox(this);
	thbox->setSpacing(5);
	m_themelabel = new QLabel(i18n("Theme:"), thbox);
	QVBox *thbox2 = new QVBox(thbox);
	m_themebox = new QComboBox(false, thbox2);
	m_themelabel->setBuddy(m_themebox);
	m_themebox->insertItem(i18n("Custom"));
	//m_themebox->insertItem(i18n("Single switcher"));
	m_themebox->insertItem(i18n("Switcher"));
	m_themebox->insertItem(i18n("Kde2"));
	m_themebox->insertItem(i18n("Kde3"));
	m_themebox->insertItem(i18n("Elvish"));
	m_themebox->insertItem(i18n("Zoomer, centered"));
	m_themebox->insertItem(i18n("Zoomer, shifted"));
	m_themebox->insertItem(i18n("Shadow"));
	m_themebox->insertItem(i18n("Simple elegance"));
    connect(m_themebox, SIGNAL(activated(int)), this, SLOT(setGeneralTheme(int)));

	// number of rows
	QLabel *m_numrowlabel;
	QHBox *numrowbox = new QHBox(this);
	numrowbox->setSpacing(5);
	m_numrowlabel = new QLabel(i18n("Number of rows:"), numrowbox);
	m_numrowbox = new QSpinBox(1,20,1,numrowbox);
	m_numrowlabel->setBuddy(numrowbox);
    connect(m_numrowbox, SIGNAL(valueChanged(int)), this, SLOT(setNumberOfRows(int)));

	// show Task menu
	QHBox *showtaskmenubox = new QHBox(this);
	showtaskmenubox->setSpacing(5);
	m_chkShowTaskMenu = new QCheckBox(i18n("Show task menu"), showtaskmenubox);
    connect(m_chkShowTaskMenu, SIGNAL(toggled(bool)), this, SLOT(setShowTaskMenu(bool)));

	// show Launcher
	m_chkShowLauncher = new QCheckBox(i18n("Show launcher"), showtaskmenubox);
    connect(m_chkShowLauncher, SIGNAL(toggled(bool)), this, SLOT(setShowLauncher(bool)));
	
	// show only one desktop
	QHBox *showonlyonebox = new QHBox(this);
	showonlyonebox->setSpacing(5);
	m_chkShowOneDesktop = new QCheckBox(i18n("Show only one desktop"), showonlyonebox);
	connect(m_chkShowOneDesktop, SIGNAL(toggled(bool)), this, SLOT(setShowOneDesktop(bool)));

	
	// dummy widget for stretching
	QWidget *w=new QWidget(this);
	setStretchFactor(w,10);
}
void KPagerConfigGeneral::setNumberOfRows(int num)
{
	m_parent->m_tmpNumberRows=num;
	m_parent->enableButtonApply(true);
}
void KPagerConfigGeneral::setGeneralTheme(int theme)
{
	m_parent->enableButtonApply(true);
	m_parent->m_tmpGeneralTheme = theme;
	
	m_parent->setCustomPageVisible(theme == 0);
	
	m_parent->m_custom->setOptionsFromTheme(theme);
}
void KPagerConfigGeneral::setShowTaskMenu(bool show)
{
	m_parent->m_tmpShowTaskMenu = show;
	m_parent->enableButtonApply(true);
}
void KPagerConfigGeneral::setShowLauncher(bool show)
{
	m_parent->m_tmpShowLauncher = show;
	m_parent->enableButtonApply(true);
}
void KPagerConfigGeneral::setShowOneDesktop(bool show)
{
	m_parent->m_tmpShowOnlyOneDesktop=show;
	m_parent->enableButtonApply(true);
}
void KPagerConfigGeneral::setControlsFromConfig()
{
	m_numrowbox				->setValue(m_parent->m_tmpNumberRows);
	m_themebox				->setCurrentItem(m_parent->m_tmpGeneralTheme);
	//m_themebox->setCurrentItem(m_tmpGeneralTheme); //somewhere else!
	m_chkShowTaskMenu		->setChecked(m_parent->m_tmpShowTaskMenu);
	m_chkShowLauncher		->setChecked(m_parent->m_tmpShowLauncher);
	m_chkShowOneDesktop		->setChecked(m_parent->m_tmpShowOnlyOneDesktop);
}


/// --------------------------------------------------------------------------------
KPagerConfigCustom::KPagerConfigCustom(KPagerConfigDialog * parent)
 : QVBox()
{
	m_parent = parent;
	this->setSpacing(5);


	QHBox*grpbox = new QHBox(this);
	grpbox->setSpacing(5);
	QVGroupBox * grpWind = new QVGroupBox(i18n("Windows"),grpbox);
	QVGroupBox * grpDesk = new QVGroupBox(i18n("Desktop"),grpbox);

	// some checkboxes
    m_chkShowName=new QCheckBox(i18n("Show name"),grpDesk,0);
    connect(m_chkShowName, SIGNAL(toggled(bool)), this, SLOT(setShowName(bool)));
    m_chkShowNumber=new QCheckBox(i18n("Show number"),grpDesk,0);
    connect(m_chkShowNumber, SIGNAL(toggled(bool)), this, SLOT(setShowNumber(bool)));
    m_chkShowBackground=new QCheckBox(i18n("Show background"),grpDesk,0);
    connect(m_chkShowBackground, SIGNAL(toggled(bool)), this, SLOT(setShowBackground(bool)));
	m_chkToolTips=new QCheckBox(i18n("Enable tooltips"),grpDesk,0);
    connect(m_chkToolTips, SIGNAL(toggled(bool)), this, SLOT(setToolTips(bool)));
	m_chkShowShadowPixmap=new QCheckBox(i18n("Paint shadow"),grpDesk,0);
    connect(m_chkShowShadowPixmap, SIGNAL(toggled(bool)), this, SLOT(setShowShadowPixmap(bool)));

	m_chkShowWindows=new QCheckBox(i18n("Show windows"),grpWind,0);
    connect(m_chkShowWindows, SIGNAL(toggled(bool)), this, SLOT(setShowWindows(bool)));

	// windowdrawmode
	QLabel *m_windrawmodelabel;
	QHBox *windrawbox = new QHBox(grpWind);
	windrawbox->setSpacing(5);
	m_windrawmodelabel = new QLabel(i18n("Type of window:"), windrawbox);
	m_windrawmodebox = new QComboBox(false, windrawbox);
	m_windrawmodelabel->setBuddy(m_windrawmodebox);
	m_windrawmodebox->insertItem(i18n("Plain"));
	m_windrawmodebox->insertItem(i18n("Icon"));
	m_windrawmodebox->insertItem(i18n("Pixmap"));
    connect(m_windrawmodebox, SIGNAL(activated(int)), this, SLOT(setWindowDrawMode(int)));

	// windowtransparentmode
	QLabel *m_wintransmodelabel;
	QHBox *wintransbox = new QHBox(grpWind);
	wintransbox->setSpacing(5);
	m_wintransmodelabel = new QLabel(i18n("Transparency:"), wintransbox);
	m_wintransmodebox = new QComboBox(false, wintransbox);
	m_wintransmodelabel->setBuddy(m_wintransmodebox);
	m_wintransmodebox->insertItem(i18n("None"));
	m_wintransmodebox->insertItem(i18n("Maximized"));
	m_wintransmodebox->insertItem(i18n("All"));
    connect(m_wintransmodebox, SIGNAL(activated(int)), this, SLOT(setWindowTransparency(int)));

	// animation
	QLabel *m_animlabel;
	QHBox *anbox = new QHBox(grpWind);
	anbox->setSpacing(5);
	m_animlabel = new QLabel(i18n("Animation:"), anbox);
	m_animbox = new QComboBox(false, anbox);
	m_animlabel->setBuddy(m_animbox);
	m_animbox->insertItem(i18n("None"));
	m_animbox->insertItem(i18n("Zoom"));
	m_animbox->insertItem(i18n("Zoom, shifted"));
    connect(m_animbox, SIGNAL(activated(int)), this, SLOT(setAnimation(int)));

	// window dragging
	QLabel *m_draglabel;
	QHBox *drbox = new QHBox(this);
	drbox->setSpacing(5);
	m_draglabel = new QLabel(i18n("Window dragging:"), drbox);
	m_dragbox = new QComboBox(false, drbox);
	m_draglabel->setBuddy(m_dragbox);
	m_dragbox->insertItem(i18n("Disabled"));
	m_dragbox->insertItem(i18n("Set desktop"));
	m_dragbox->insertItem(i18n("Set desktop and position"));
	connect(m_dragbox, SIGNAL(activated(int)), this, SLOT(setWindowDragging(int)));

	// gen. background
	QLabel *m_genblabel;
	QHBox *gbbox = new QHBox(this);
	gbbox->setSpacing(5);
	m_genblabel = new QLabel(i18n("Pager background color:"), gbbox);
	m_genbbox = new QComboBox(false, gbbox);
	m_genblabel->setBuddy(m_genbbox);
	m_genbbox->insertItem(i18n("Black"));
	m_genbbox->insertItem(i18n("Standard background"));
	m_genbbox->insertItem(i18n("Window background"));
	m_genbbox->insertItem(i18n("Button"));
	m_genbbox->insertItem(i18n("Button, dark"));
	connect(m_genbbox, SIGNAL(activated(int)), this, SLOT(setGeneralBackgroundColor(int)));

	// des. background
	QLabel *m_desblabel;
	QHBox *dbbox = new QHBox(this);
	dbbox->setSpacing(5);
	m_desblabel = new QLabel(i18n("Desktop background color:"), dbbox);
	m_desbbox = new QComboBox(false, dbbox);
	m_desblabel->setBuddy(m_desbbox);
	m_desbbox->insertItem(i18n("Black"));
	m_desbbox->insertItem(i18n("Standard background"));
	m_desbbox->insertItem(i18n("Window background"));
	m_desbbox->insertItem(i18n("Button"));
	m_desbbox->insertItem(i18n("Button, dark"));
	m_desbbox->insertItem(i18n("Pager background"));
	connect(m_desbbox, SIGNAL(activated(int)), this, SLOT(setDesktopBackgroundColor(int)));

	QVGroupBox * layoutgrp = new QVGroupBox(i18n("Layout"),this);

	// des. spacing
	QLabel *m_spacinglabel;
	QHBox *spacingbox = new QHBox(layoutgrp);
	spacingbox->setSpacing(5);
	m_spacinglabel = new QLabel(i18n("Spacing:"), spacingbox);
	m_spacingbox = new QSpinBox(0,10,1,spacingbox);
	m_spacinglabel->setBuddy(spacingbox);
    connect(m_spacingbox, SIGNAL(valueChanged(int)), this, SLOT(setDeskSpacing(int)));

	// des. margin
	QLabel *m_marginlabel;
	QHBox *marginbox = new QHBox(layoutgrp);
	marginbox->setSpacing(5);
	m_marginlabel = new QLabel(i18n("Margin:"), marginbox);
	m_marginbox = new QSpinBox(0,10,1,marginbox);
	m_marginlabel->setBuddy(marginbox);
    connect(m_marginbox, SIGNAL(valueChanged(int)), this, SLOT(setDeskMargin(int)));

	// the frame takes the wrong color right now
	// framestyle
	QLabel *m_framelabel;
	QHBox *frbox = new QHBox(layoutgrp);
	frbox->setSpacing(5);
	m_framelabel = new QLabel(i18n("Framestyle:"), frbox);
	m_framebox = new QComboBox(false, frbox);
	m_framelabel->setBuddy(m_framebox);
	m_framebox->insertItem(i18n("None"));
	m_framebox->insertItem(i18n("Raised"));
	m_framebox->insertItem(i18n("Sunken"));
	m_framebox->insertItem(i18n("Plain"));
	connect(m_framebox, SIGNAL(activated(int)), this, SLOT(setGeneralFrame(int)));

	// Size of the task menu items
	QHBox *mtbox = new QHBox(layoutgrp);
	mtbox->setSpacing(5);
	QLabel * m_menuthumbnaillabel = new QLabel(i18n("Task menu item size:"), mtbox);
	m_menuthumbnailbox = new QComboBox(false, mtbox);
	m_menuthumbnaillabel->setBuddy(m_menuthumbnailbox);
	m_menuthumbnailbox->insertItem(i18n("default"));
	m_menuthumbnailbox->insertItem(i18n("16x16"));
	m_menuthumbnailbox->insertItem(i18n("22x22"));
	m_menuthumbnailbox->insertItem(i18n("32x32"));
	m_menuthumbnailbox->insertItem(i18n("48x48"));
	connect(m_menuthumbnailbox, SIGNAL(activated(int)), this, SLOT(setMenuThumbnailSize(int)));
	
	// dummy widget for stretching
	QWidget *w=new QWidget(this);
	setStretchFactor(w,10);
}

void KPagerConfigCustom::setShowShadowPixmap(bool show)
{
	m_parent->m_tmpShowShadowPixmap=show;
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setShowName(bool show)
{
	m_parent->m_tmpShowName=show;
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setShowNumber(bool show)
{
	m_parent->m_tmpShowNumber=show;
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setShowBackground(bool show)
{
	m_parent->m_tmpShowBackground=show;
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setToolTips(bool show)
{
	m_parent->m_tmpToolTips=show;
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setShowWindows(bool show)
{
	m_parent->m_tmpShowWindows=show;
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setWindowDragging(int id)
{
	switch (id)
	{
		case 0:  m_parent->m_tmpWindowDragging = false; m_parent->m_tmpShowDragMoving = false; break;
		case 1:  m_parent->m_tmpWindowDragging = true;  m_parent->m_tmpShowDragMoving = false; break;
		case 2:  m_parent->m_tmpWindowDragging = true;  m_parent->m_tmpShowDragMoving = true;  break;
		default: m_parent->m_tmpWindowDragging = false; m_parent->m_tmpShowDragMoving = false;
	}
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setMenuThumbnailSize(int id)
{
	switch (id)
	{
		case 1:
			m_parent->m_tmpMenuThumbnailHeight = 16;
			m_parent->m_tmpMenuThumbnailWidth  = 16;
			break;
		case 2:
			m_parent->m_tmpMenuThumbnailHeight = 22;
			m_parent->m_tmpMenuThumbnailWidth  = 22;
			break;
		case 3:
			m_parent->m_tmpMenuThumbnailHeight = 32;
			m_parent->m_tmpMenuThumbnailWidth  = 32;
			break;
		case 4:
			m_parent->m_tmpMenuThumbnailHeight = 48;
			m_parent->m_tmpMenuThumbnailWidth  = 48;
			break;
		case 0:
		default:
			m_parent->m_tmpMenuThumbnailHeight = KPagerTaskContainer::c_defMenuThumbnailHeight;
			m_parent->m_tmpMenuThumbnailWidth  = KPagerTaskContainer::c_defMenuThumbnailWidth;
	}
	m_parent->enableButtonApply(true);
}
	
void KPagerConfigCustom::setWindowDrawMode(int type)
{
	m_parent->m_tmpWindowDrawMode=type;
	m_parent->enableButtonApply(true);
}

void KPagerConfigCustom::setAnimation(int show)
{
	m_parent->m_tmpAnimation=show;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setGeneralBackgroundColor(int col)
{
	m_parent->m_tmpGeneralBackgroundColor=col;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setDesktopBackgroundColor(int col)
{
	m_parent->m_tmpDesktopBackgroundColor=col;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setDeskSpacing(int s)
{
	m_parent->m_tmpDesktopDistance = s;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setDeskMargin(int m)
{
	m_parent->m_tmpDesktopMargin = m;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setGeneralFrame(int f)
{
	m_parent->m_tmpGeneralFrame = f;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setWindowTransparency(int t)
{
	m_parent->m_tmpWindowTransparentMode=(KPagerDesktop::WindowTransparentMode)t;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setOptionsFromTheme(int theme)
{
	switch (theme)
	{
		/*
		case KPDC_SINGLESWITCHER: // single switcher, shows desktop name
			setShowName(true);
			setShowNumber(false);
			setShowBackground(false);
			setShowWindows(false);
			setWindowDrawMode(0);
			setAnimation(0);
			setWindowTransparency(0);
			setWindowDragging(0);
			setGeneralBackgroundColor(4);
			setDesktopBackgroundColor(3);
			setDeskSpacing(1);
			setDeskMargin(1);
			setGeneralFrame(0);
			setControlsFromConfig();
			setToolTips(true);
			//setShowOneDesktop(true);
			setShowShadowPixmap(false);
		
		break; */
		case KPDC_SWITCHER: // switcher/simple
			setShowName(false);
			setShowNumber(true);
			setShowBackground(false);
			setShowWindows(false);
			setWindowDrawMode(0);
			setAnimation(0);
			setWindowTransparency(0);
			setWindowDragging(0);
			setGeneralBackgroundColor(4);
			setDesktopBackgroundColor(3);
			setDeskSpacing(1);
			setDeskMargin(1);
			setGeneralFrame(0);
			setControlsFromConfig();
			setToolTips(true);
			//setShowOneDesktop(false);
			setShowShadowPixmap(false);
		break;
		case KPDC_KDE2: // kde2
			setShowName(false);
			setShowNumber(false);
			setShowBackground(true);
			setShowWindows(true);
			setWindowDrawMode(1);
			setAnimation(0);
			setWindowTransparency(2);
			setWindowDragging(1);
			setGeneralBackgroundColor(0);
			setDesktopBackgroundColor(4);
			setDeskSpacing(1);
			setDeskMargin(1);
			setGeneralFrame(0);
			setControlsFromConfig();
			setToolTips(true);
			//setShowOneDesktop(false);
			setShowShadowPixmap(false);
		break;
		case KPDC_KDE3: // kde3
			setShowName(false);
			setShowNumber(false);
			setShowBackground(true);
			setShowWindows(true);
			setWindowDrawMode(2);
			setAnimation(0);
			setWindowTransparency(0);
			setWindowDragging(2);
			setGeneralBackgroundColor(2);
			setDesktopBackgroundColor(4);
			setDeskSpacing(1);
			setDeskMargin(0);
			setGeneralFrame(2);
			setControlsFromConfig();
			setToolTips(true);
			//setShowOneDesktop(false);
			setShowShadowPixmap(false);
		break;
		case KPDC_ELVISH: // Elvish (aka Gnome)
			setShowName(false);
			setShowNumber(false);
			setShowBackground(false);
			setShowWindows(true);
			setWindowDrawMode(1);
			setAnimation(0);
			setWindowTransparency(1);
			setWindowDragging(1);
			setGeneralBackgroundColor(2);
			setDesktopBackgroundColor(4);
			setDeskSpacing(1);
			setDeskMargin(0);
			setGeneralFrame(2);
			setControlsFromConfig();
			setToolTips(true);
			//setShowOneDesktop(false);
			setShowShadowPixmap(false);
		break;
		case KPDC_ZOOMER: //light16 (aka e16)
			setShowName(false);
			setShowNumber(false);
			setShowBackground(true);
			setShowWindows(true);
			setWindowDrawMode(2);
			setAnimation(1);
			setWindowTransparency(1);
			setWindowDragging(2);
			setGeneralBackgroundColor(4);
			setDesktopBackgroundColor(2);
			setDeskSpacing(0);
			setDeskMargin(0);
			setGeneralFrame(3);
			setControlsFromConfig();
			setToolTips(false);
			//setShowOneDesktop(false);
			setShowShadowPixmap(false);
		break;
		case KPDC_SHIFTER: //puma: (aka new)
			setShowName(false);
			setShowNumber(false);
			setShowBackground(true);
			setShowWindows(true);
			setWindowDrawMode(2);
			setAnimation(2);
			setWindowTransparency(1);
			setWindowDragging(2);
			setGeneralBackgroundColor(2);
			setDesktopBackgroundColor(4);
			setDeskSpacing(1);
			setDeskMargin(1);
			setGeneralFrame(2);
			setControlsFromConfig();
			setToolTips(false);
			//setShowOneDesktop(false);
			setShowShadowPixmap(false);
		break;
		case KPDC_SHADOW: //shadow with shifitng
			setShowName(false);
			setShowNumber(false);
			setShowBackground(false);
			setShowWindows(true);
			setWindowDrawMode(2);
			setAnimation(2);
			setWindowTransparency(1);
			setWindowDragging(2);
			setGeneralBackgroundColor(4);
			setDesktopBackgroundColor(1);
			setDeskSpacing(0);
			setDeskMargin(0);
			setGeneralFrame(3);
			setControlsFromConfig();
			setToolTips(false);
			//setShowOneDesktop(false);
			setShowShadowPixmap(true);
		break;
		case KPDC_ELEGANCE: //shadow and wallpapers only
			setShowName(false);
			setShowNumber(false);
			setShowBackground(true);
			setShowWindows(false);
			setWindowDrawMode(2);
			setAnimation(2);
			setWindowTransparency(1);
			setWindowDragging(2);
			setGeneralBackgroundColor(4);
			setDesktopBackgroundColor(1);
			setDeskSpacing(0);
			setDeskMargin(0);
			setGeneralFrame(3);
			setControlsFromConfig();
			setToolTips(false);
			//setShowOneDesktop(false);
			setShowShadowPixmap(true);
		break;
		case 0: // custom - do nothing
		default:
			;
	}
	// and the thumbnail sizes for simplicity:
	setMenuThumbnailSize(0);
	
	
	m_parent->m_tmpGeneralTheme = theme;
	m_parent->enableButtonApply(true);
}
void KPagerConfigCustom::setControlsFromConfig()
{
	m_chkShowName			->setChecked(m_parent->m_tmpShowName);
	m_chkShowNumber			->setChecked(m_parent->m_tmpShowNumber);
	m_chkShowBackground		->setChecked(m_parent->m_tmpShowBackground);
	m_chkShowWindows		->setChecked(m_parent->m_tmpShowWindows);
	m_windrawmodebox		->setCurrentItem(m_parent->m_tmpWindowDrawMode);
	m_animbox				->setCurrentItem(m_parent->m_tmpAnimation);
	m_genbbox				->setCurrentItem(m_parent->m_tmpGeneralBackgroundColor);
	m_desbbox				->setCurrentItem(m_parent->m_tmpDesktopBackgroundColor);
	m_framebox				->setCurrentItem(m_parent->m_tmpGeneralFrame);
	m_spacingbox			->setValue(m_parent->m_tmpDesktopDistance);
	m_marginbox				->setValue(m_parent->m_tmpDesktopMargin);
	m_wintransmodebox		->setCurrentItem(m_parent->m_tmpWindowTransparentMode);
	m_chkToolTips			->setChecked(m_parent->m_tmpToolTips);
	m_chkShowShadowPixmap->setChecked(m_parent->m_tmpShowShadowPixmap);

	if ((!m_parent->m_tmpWindowDragging) && (!m_parent->m_tmpShowDragMoving))
		 m_dragbox->setCurrentItem(0);
	if ((m_parent->m_tmpWindowDragging) && (!m_parent->m_tmpShowDragMoving)) 
		 m_dragbox->setCurrentItem(1);
	if ((m_parent->m_tmpWindowDragging) && (m_parent->m_tmpShowDragMoving))  
		 m_dragbox->setCurrentItem(2);
	
	if (   m_parent->m_tmpMenuThumbnailHeight == 16 &&
		   m_parent->m_tmpMenuThumbnailWidth  == 16)
		m_menuthumbnailbox->setCurrentItem(1);
	else if (   m_parent->m_tmpMenuThumbnailHeight == 22 &&
				m_parent->m_tmpMenuThumbnailWidth  == 22)
		m_menuthumbnailbox->setCurrentItem(2);
	else if (   m_parent->m_tmpMenuThumbnailHeight == 32 &&
				m_parent->m_tmpMenuThumbnailWidth  == 32)
		m_menuthumbnailbox->setCurrentItem(3);
	else if (   m_parent->m_tmpMenuThumbnailHeight == 48 &&
				m_parent->m_tmpMenuThumbnailWidth  == 48)
		m_menuthumbnailbox->setCurrentItem(4);
	else 
		m_menuthumbnailbox->setCurrentItem(0);
	
	m_parent->setCustomPageVisible(m_parent->m_tmpGeneralTheme==0);
}

/// --------------------------------------------------------------------------------

KPagerConfig3d::KPagerConfig3d(KPagerConfigDialog * parent)
	: QVBox()
{
	m_parent = parent;
	setSpacing(5);

	// use3d
	m_chkUse3d = new QCheckBox(i18n("Use 3d"), this);
	connect(m_chkUse3d, SIGNAL(toggled(bool)), this, SLOT(setUse3d(bool)));
	
	// mode
	QLabel *m_themelabel;
	QHBox *thbox = new QHBox(this);
	thbox->setSpacing(5);
	m_themelabel = new QLabel(i18n("Mode:"), thbox);
	QVBox *thbox2 = new QVBox(thbox);
	m_3dModeBox = new QComboBox(false, thbox2);
	m_themelabel->setBuddy(m_3dModeBox);
	m_3dModeBox->insertItem(i18n("Carousel"));
	m_3dModeBox->insertItem(i18n("Cylinder"));
	m_3dModeBox->insertItem(i18n("Linear"));
	m_3dModeBox->insertItem(i18n("Viewmaster"));
	m_3dModeBox->insertItem(i18n("PriceIsRight"));
	m_3dModeBox->insertItem(i18n("Flip"));
	m_3dModeBox->insertItem(i18n("Random"));
	connect(m_3dModeBox, SIGNAL(activated(int)), this, SLOT(set3dMode(int)));

	// Zoom
	m_chk3dZoom = new QCheckBox(i18n("Zoom"), this);
	connect(m_chk3dZoom, SIGNAL(toggled(bool)), this, SLOT(set3dZoom(bool)));
	
	// explanation
	QLabel * lab = new QLabel(this);
	lab->setText(i18n("<b>Note</b> that there has to be 3ddesktop installed if you want to use this feature. 3ddesktop provides animations when switching the active desktop."));
	
	
	// dummy widget for stretching
	QWidget *w=new QWidget(this);
	setStretchFactor(w,10);
}
void KPagerConfig3d::set3dMode(int theme)
{
	m_parent->enableButtonApply(true);
	m_parent->m_tmp3dMode = theme;
}
void KPagerConfig3d::setUse3d(bool show)
{
	m_parent->m_tmpUse3d = show;
	m_parent->enableButtonApply(true);
}
void KPagerConfig3d::set3dZoom(bool show)
{
	m_parent->m_tmp3dZoom = show;
	m_parent->enableButtonApply(true);
}
void KPagerConfig3d::setControlsFromConfig()
{
	m_chkUse3d->setChecked(m_parent->m_tmpUse3d);
	m_3dModeBox->setCurrentItem(m_parent->m_tmp3dMode);
	m_chk3dZoom->setChecked(m_parent->m_tmp3dZoom);
}

		
		
/// --------------------------------------------------------------------------------

bool KPagerConfigDialog::m_showName=KPagerDesktop::c_defShowName;
bool KPagerConfigDialog::m_showNumber=KPagerDesktop::c_defShowNumber;
bool KPagerConfigDialog::m_showBackground=KPagerDesktop::c_defShowBackground;
bool KPagerConfigDialog::m_showWindows=KPagerDesktop::c_defShowWindows;
bool KPagerConfigDialog::m_windowDragging=KPagerDesktop::c_defWindowDragging;
bool KPagerConfigDialog::m_showDragMoving=KPagerDesktop::c_defShowDragMoving;
int  KPagerConfigDialog::m_windowDrawMode=KPagerDesktop::c_defWindowDrawMode;
int  KPagerConfigDialog::m_animation = KPagerDesktop::c_defAnimation;
bool KPagerConfigDialog::m_showGradient = KPagerDesktop::c_defShowGradient;
int  KPagerConfigDialog::m_desktopBackgroundColor= KPagerDesktop::c_defDesktopBackgroundColor;
int  KPagerConfigDialog::m_numberRows=KPager2::c_defNumberRows; // 0 = unlimited; depends on m_orientation (vertical: rows denote columns)
bool KPagerConfigDialog::m_showOnlyOneDesktop=KPager2::c_defShowOnlyOneDesktop;
int  KPagerConfigDialog::m_desktopDistance=KPager2::c_defDesktopDistance;
int  KPagerConfigDialog::m_desktopMargin=KPager2::c_defDesktopMargin;
int  KPagerConfigDialog::m_generalBackgroundColor=KPager2::c_defGeneralBackgroundColor;
int  KPagerConfigDialog::m_generalFrame=KPager2::c_defGeneralFrame;
int  KPagerConfigDialog::m_generalTheme=KPager2::c_defGeneralTheme;
int  KPagerConfigDialog::m_shadowPixmap=KPagerDesktop::c_defShadowPixmap;
bool KPagerConfigDialog::m_bevelledSelection=KPagerDesktop::c_defBevelledSelection;
KPagerDesktop::WindowTransparentMode KPagerConfigDialog::m_windowTransparentMode=KPagerDesktop::c_defWindowTransparentMode;
bool KPagerConfigDialog::m_showTaskMenu = KPager2::c_defShowTaskMenu;
bool KPagerConfigDialog::m_toolTips = KPagerDesktop::c_defToolTips;
bool KPagerConfigDialog::m_showShadowPixmap = KPagerDesktop::c_defShowShadowPixmap;
bool KPagerConfigDialog::m_showLauncher = KPager2::c_defShowLauncher;
int KPagerConfigDialog::m_menuThumbnailHeight = KPagerTaskContainer::c_defMenuThumbnailHeight;
int KPagerConfigDialog::m_menuThumbnailWidth = KPagerTaskContainer::c_defMenuThumbnailWidth;


bool KPagerConfigDialog::m_use3d  = KPager2::c_defUse3d;
bool KPagerConfigDialog::m_3dZoom = KPager2::c_def3dZoom;
int  KPagerConfigDialog::m_3dMode = KPager2::c_def3dMode;


