/**************************************************************************

    config.h  - KPager config dialog
    Copyright (C) 2000  Antonio Larrosa Jimenez
	Copyright (c) 2003 Sebastian Wolff

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

    changes (c) 2003 Sebastian Wolff

***************************************************************************/
#ifndef __KPCONFIG_H
#define __KPCONFIG_H

#include "version.h"

#include <kdialogbase.h>

#include <qvbox.h>

class QCheckBox;
class QButtonGroup;
class QRadioButton;
class KPager2;
class QSpinBox;
class KColorButton;
class QComboBox;
class KPagerDesktop;
class KJanusWidget;
class KKeyChooser;
class KPagerJanusWidget;
#include "kpagerdesktop.h"
//enum KPagerDesktop::WindowTransparentMode;

/**
 * This class is the Config dialog containing a JanusWidget. 
 * All parameters to be set are members of the Config base class,
 * all subpages are own classes that access the main class
 */

class KPagerConfigDialog : public KDialogBase
{
    Q_OBJECT
friend class KPagerConfigGeneral;
friend class KPagerConfigCustom;
friend class KPagerConfig3d;

public:
    KPagerConfigDialog(KPager2 *parent);
	~KPagerConfigDialog();

public slots:


    void loadConfiguration();
	void setControlsFromConfig();
    void slotOk();
    void slotApply();
	void setCustomPageVisible(bool on);
	void slotEnableApply(){enableButtonApply(true);}
public:
    static void initConfiguration(void);

	static bool m_showName;
    static bool m_showNumber;
    static bool m_showBackground;
    static bool m_showWindows;
    static int m_windowDrawMode;
    static bool m_windowDragging;
    static bool m_showDragMoving;
    static int m_animation;
    static bool m_showGradient;
    static int m_desktopBackgroundColor;
    static int m_numberRows;
	static bool m_showOnlyOneDesktop;
	static int m_desktopDistance;
	static int m_desktopMargin;
	static int m_generalBackgroundColor;
	static int m_generalFrame;
	static int m_generalTheme;
	static int m_shadowPixmap;
	static bool m_bevelledSelection;
	static KPagerDesktop::WindowTransparentMode m_windowTransparentMode;
	static bool m_showTaskMenu;
	static bool m_toolTips;
	static bool m_showShadowPixmap;
	static bool m_showLauncher;
	static int m_menuThumbnailHeight;
	static int m_menuThumbnailWidth;
	
	static bool m_use3d;
	static bool m_3dZoom;
	static int  m_3dMode;

protected:
	KPager2 * m_parent;
	KPagerJanusWidget * m_janus;
	KPagerConfigGeneral * m_general;
	KPagerConfigCustom * m_custom;
	KPagerConfig3d * m_3d;
	KKeyChooser * m_keys;
	QVBox * m_keys_;
	bool m_custom_visible;


    bool m_tmpShowName;
    bool m_tmpShowNumber;
    bool m_tmpShowBackground;
    bool m_tmpShowWindows;
    int m_tmpWindowDrawMode;
    bool m_tmpWindowDragging;
    bool m_tmpShowDragMoving;
    bool m_tmpEnlargement;
    int  m_tmpScaleFactor;
    int  m_tmpStepLength;
    int  m_tmpTimeLength;
    bool m_tmpShowGradient;
    int  m_tmpNumberRows;
	bool m_tmpShowOnlyOneDesktop;
    int  m_tmpDesktopDistance;
    int  m_tmpDesktopMargin;
	int  m_tmpDesktopBackgroundColor;
	int  m_tmpAnimation;
	int  m_tmpGeneralBackgroundColor;
	int  m_tmpGeneralFrame;
	int  m_tmpGeneralTheme;
	int  m_tmpShadowPixmap;
	bool m_tmpBevelledSelection;
	bool m_tmpShowTaskMenu;
	bool m_tmpToolTips;
	bool m_tmpShowShadowPixmap;
	bool m_tmpShowLauncher;
	KPagerDesktop::WindowTransparentMode m_tmpWindowTransparentMode;
	int m_tmpMenuThumbnailHeight;
	int m_tmpMenuThumbnailWidth;

	
	bool m_tmpUse3d;
	bool m_tmp3dZoom;
	int  m_tmp3dMode;
};

class KPagerConfigGeneral : public QVBox
{
	Q_OBJECT
public:
	KPagerConfigGeneral(KPagerConfigDialog* parent);

public slots:
	void setControlsFromConfig();

	void setNumberOfRows(int num);
	void setGeneralTheme(int theme);
	void setShowTaskMenu(bool show);
	void setShowLauncher(bool show);
	void setShowOneDesktop(bool show);

protected:
    KPagerConfigDialog *m_parent;

	QSpinBox *m_numrowbox;
	QCheckBox *m_chkShowTaskMenu;
	QComboBox *m_themebox;
	QCheckBox *m_chkShowLauncher;
	QCheckBox *m_chkShowOneDesktop;
};

class KPagerConfigCustom : public QVBox
{
	Q_OBJECT
public:
	KPagerConfigCustom(KPagerConfigDialog* parent);
	void setOptionsFromTheme(int theme);

public slots:
	void setControlsFromConfig();

    void setShowName(bool show);
    void setShowNumber(bool show);
    void setShowBackground(bool show);
    void setShowWindows(bool show);
    void setWindowDrawMode(int mode);
    void setAnimation(int show);
	void setToolTips(bool show);

	void setWindowDragging(int id);
	void setGeneralBackgroundColor(int col);
	void setDesktopBackgroundColor(int col);
	void setDeskSpacing(int s);
	void setDeskMargin(int m);
	void setGeneralFrame(int f);
	void setWindowTransparency(int t);
	void setShowShadowPixmap(bool show);
	void setMenuThumbnailSize(int id);
protected:
    KPagerConfigDialog *m_parent;

	QCheckBox *m_chkShowName;
    QCheckBox *m_chkShowNumber;
    QCheckBox *m_chkShowBackground;
    QCheckBox *m_chkShowWindows;
	QComboBox *m_windrawmodebox;
	QComboBox *m_animbox;
	QComboBox *m_menuthumbnailbox;

	QComboBox *m_dragbox, *m_genbbox, *m_desbbox, *m_framebox, *m_wintransmodebox;
	QSpinBox *m_spacingbox, *m_marginbox;
	QCheckBox * m_chkToolTips, *m_chkShowShadowPixmap;
};

class KPagerConfig3d : public QVBox
{
	Q_OBJECT
	public:
		KPagerConfig3d(KPagerConfigDialog* parent);

	public slots:
		void setControlsFromConfig();

		void set3dMode(int mode);
		void set3dZoom(bool show);
		void setUse3d(bool show);

	protected:
		KPagerConfigDialog *m_parent;

		QCheckBox *m_chkUse3d;
		QComboBox *m_3dModeBox;
		QCheckBox *m_chk3dZoom;
};

#endif
