/**************************************************************************

    kpager.h  - KPager2's main window
    Copyright (C) 2000  Antonio Larrosa Jimenez
			Matthias Ettrich
			Matthias Elter
    changes (c) 2003 Sebastian Wolff


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

***************************************************************************/
#ifndef __KPAGER_H
#define __KPAGER_H

#include "version.h"

#include <qguardedptr.h>
#include <qframe.h>
#include <qintdict.h>
#include <kwin.h>
#include "kpagerIface.h"

class KGlobalAccel;
class KPager2;
class KPagerDesktop;
class KPagerConfigDialog;
class QPopupMenu;
class KPagerMainWindow;
class KPagerAnimation;
class KPagerSingleSwitchButton;
class KPagerTaskManager;
class KWinModule;
class TaskBar;
class MyGridLayout;

typedef QValueList<KPagerDesktop *> KPagerDesktopList;

extern KWinModule * kwin_module; // see taskmanager.cpp

class KPager2 : public QFrame
{
    Q_OBJECT

    friend class KPagerMainWindow;

public:
    KPager2(KPagerMainWindow *parent=0, const char *name=0);
    ~KPager2();

    class KWinModule *kwin() const { return kwin_module; };
    void updateLayout();


    void showPopupMenu( WId wid, QPoint pos, int sender_desk, bool onlyTasks = false);

    QSize sizeHint() const;

    Orientation orientation(){return m_orientation;};
    void setOrientation(Orientation o){m_orientation=o;};
	void setCurrentDesktop(int desk);
	void setCurrentDesktopCounter(int desk);

	KPagerDesktopList desktopList() const;
	KPagerTaskManager* pagerTaskManager(){return m_taskmanager;};
	//TaskBar * taskBar(){return m_taskbar;};

	void updateDesktopLayoutIfOnlyOneVisible(); // if only one desktop should be visible it must be called to verify that only the current desktop is shown, in part. whenever one switches between desktops

	int heightForWidth(int width);
	int widthForHeight(int height);
	
	KGlobalAccel * globalAccel();
	

public slots:
    void redrawDesktops();

    void configureDialog();
	void configureDesktopsDialog();
	void aboutDialog();
	void helpDialog();
    void slotApplyConfigureFromDialog();

    void slotDesktopNamesChanged();
    void slotNumberOfDesktopsChanged(int ndesktops);

	void updateSingleDesktop(int desk); // is called to update the own desktop m_singleDesktop in showOnlyOneDesktop mode
	void redrawSingleDesktop(int desk); // is called to update the own desktop m_singleDesktop in showOnlyOneDesktop mode
	
	void slotActivateRightDesktop();
	void slotActivateLeftDesktop();

protected slots:
    void slotBackgroundChanged(int);

signals:
	void updateLayoutCalled();

protected:
	virtual void wheelEvent(QWheelEvent *e);
	virtual void resizeEvent(QResizeEvent *);

public:
    KPagerDesktopList m_desktops;
	QPtrList<QWidget> m_emptyWidgetList;
	QGuardedPtr<KPagerAnimation> m_anim;
	QPopupMenu * m_menu;
	KPagerDesktop * m_singleDesktop;
    class MyGridLayout *m_layout;
protected:
	class KPager2MainWidget * m_mainwidget;
	QFrame * m_mainwidget2;

    int     m_currentDesktop;
    KPagerMainWindow *m_parent;

    Orientation m_orientation;

	KPagerTaskManager * m_taskmanager;

	void computeRowsCols(int &rows, int &cols);

	KGlobalAccel * m_globalAccel;
	
	KPagerSingleSwitchButton * m_prevDeskButton, *m_nextDeskButton;


public:
    static const int c_defNumberRows;
	static const bool c_defShowOnlyOneDesktop;
    static const int c_defDesktopDistance;
    static const int c_defDesktopMargin;
	static const int c_defGeneralBackgroundColor;
	static const int c_defGeneralFrame;
	static const int c_defGeneralTheme;
	static const bool c_defShowTaskMenu;
	static const bool c_defShowLauncher;
	
	static const bool c_defUse3d;
	static const bool c_def3dZoom;
	static const int  c_def3dMode;
};

class KPager2MainWidget : public QWidget
// a widget that draws a background configurable in KPagerConfigDialog (contains all desktop widgets)
{
	Q_OBJECT
public:
	KPager2MainWidget ( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );
protected:
	virtual void paintEvent(QPaintEvent *e);
};


#include <qlayout.h>
class MyGridLayout : public QGridLayout
{
	public:
		MyGridLayout(QWidget*w,int a,int b, int c, int d):QGridLayout(w,a,b,c,d){}
		bool findWidget(QWidget*w, int *row, int *col){return QGridLayout::findWidget(w,row,col);}
};

#endif
