//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: Sebastian Wolff, (c) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// many ideas for this dialog are taken from KasBar, since its aboutdialog is much nicer than the KDE default. 
//
//

#include <qvbox.h>
#include <qlabel.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kaboutdata.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <ktextbrowser.h>

#ifdef USE_KSPY
#include <kspy.h>
#endif

#include "kpageraboutdlg.h"
#include "version.h"

#define Icon(x) KGlobal::instance()->iconLoader()->loadIcon( x, KIcon::NoGroup, KIcon::SizeMedium )

extern KAboutData * m_aboutdata; // see main.cpp


KPagerAboutDialog::KPagerAboutDialog( QWidget *parent )
   : KDialogBase( KDialogBase::IconList, i18n("About")+" "+m_aboutdata->programName(),
		  KDialogBase::Ok,
		  KDialogBase::Ok,
		  parent, "kpagerAboutDialog", true )
{
#ifdef USE_KSPY
  KSpy::invoke();
#endif

   //
   // General about info
   //
   QVBox *aboutPage = addVBoxPage( i18n("About"),
				   i18n("About")+" "+m_aboutdata->programName(), 
				   Icon( "kpager" ) );
   aboutPage->setSpacing( spacingHint() );

   QHBox *versionBox = new QHBox( aboutPage );
   versionBox->setSpacing( spacingHint() );

	QPixmap icon = KGlobal::instance()->iconLoader()->loadIcon( "kpager", KIcon::NoGroup, KIcon::SizeHuge );
	QLabel* licon = new QLabel("",versionBox);
	licon->setPixmap(icon);

	QLabel * label = new QLabel( i18n( "<qt><body>"
		     "<h2>%1 Version: %2</h2>"
		     //"<b>CVS Id:</b> %3"
		     "</body></qt>" )
	       .arg(m_aboutdata->programName()).arg( VERSION_STRING )//.arg( CVS_ID )
		   ,
	       versionBox );
	versionBox->setStretchFactor(licon,0);
	versionBox->setStretchFactor(label,10);

   KTextBrowser *text5 = new KTextBrowser( aboutPage );
   text5->setText( i18n( "<html><body>"
			 "<p>This is a pager for KDE. Pagers are small applications that "
			 "manage your virtual desktops. KPager2 offers you, however, a "
			 "wide range of features. It is a graphical pager, as well as a "
			 "complete task manager. Learn more about the feature set in "
			 "the help window. "
			 "</p>"
			 "<p>KPager2 started as a fork of the original KPager, but ended up "
			 "as a complete rewrite because of the number of new features. "
			 "</p>"
			 "</body></html>" )
			);

   //
   // Authors info
   //
   QVBox *authorsPage = addVBoxPage( i18n("Authors"),
				     i18n("%1 Authors").arg(m_aboutdata->programName()), 
				     Icon( "tux" ) );

   KTextBrowser *text = new KTextBrowser( authorsPage );
   text->setText( i18n(
     "<html>"

     "<b>Sebastian Wolff</b> <a href=\"mailto:nowhere@world.un\">Email</a>"//"<br>"
     //"<b>Homepage:</b> <a href=\"http://www.ipso-facto.demon.co.uk/\">http://www.ipso-facto.demon.co.uk/</a>"

     "<p>Developer and maintainer of the %1 code, (c) 2003-2004.</p>"

     "<hr/>"

     "<p>Developer of KPager, (c) 1998-2002:</p>"
     "<p>"
	 "<b>Antonio Larrosa Jimenez</b> <a href=\"mailto:larrosa@kde.org\">larrose@kde.org<br>"
	 "<b>Homepage:</b> <a href=\"http://devel-home.kde.org/~larrosa/index.html\">http://devel-home.kde.org/~larrosa/index.html</a>"
     "</p>"
     "<p>"
     "<b>Matthias Elter</b> <a href=\"mailto:elter@kde.org\">elter@kde.org</a><br>"
     "<b>Matthias Ettrich</b> <a href=\"mailto:ettrich@kde.org\">ettrich@kde.org</a>"
     "</p>"
     

     "<p>Antonio, together with Matthias Elter and Ettrich, wrote the original kpager, (c) 1998-2002, "
	 "on which this app is based. There are, however, only little code fragments left "
	 "like class names for example. Without his work kpager2 would not have been possible.</p>"

     "</html>" ).arg(m_aboutdata->programName()) );

   //
   // GPL info
   //
   QVBox *gplPage = addVBoxPage( i18n("GPL License"), QString::null, Icon( "filefind" ) );

   new QLabel( i18n( "%1 may be used under the terms of the GNU Public License." ).arg(m_aboutdata->programName()), gplPage );

   KTextBrowser *text3 = new KTextBrowser( gplPage );
   text3->setText( "Some more text of unsurpassed tediousness goes here." );

   QString gplFile = locate("data", "LICENSES/GPL_V2");
   if ( !gplFile.isEmpty() ) {
     QString result;
     QFile file( gplFile );

     if ( file.open( IO_ReadOnly ) )
     {
        QTextStream str(&file);
        result += str.read();
     }

     text3->setText( result );
   }


   resize( 480, 350 );
}

KPagerAboutDialog::~KPagerAboutDialog()
{

}


