/***************************************************************************
                          kpageranimation.cpp  -  description
                             -------------------
    begin                : Sat Apr 17 2004
    copyright            : (C) 2004 by Sebastian Wolff
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <assert.h>

#include <qapplication.h>
#include <qpainter.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <kwinmodule.h>

#include "config.h"
#include "kpager.h"
#include "kpageranimation.h"
#include "kpagerdesktop.h"
#include "taskmanager.h"
#include "taskpagerman.h"

#include <math.h>

#define KP_ZOOM_ANIM_FRAMES 5 /* 0..4 */
#define KP_SHIFT_ANIM_FRAMES 10 /* 0..9 */
#define SQR(x) ((x)*(x))
#define KP_RETURN_ANIMATION {unFocus(); return;}
//WRONG! #define KP_WAIT(x) {QTimer KP_WAIT_TIMER;KP_WAIT_TIMER.start(x,true);while(KP_WAIT_TIMER.isActive()) kapp->processEvents(x);}
QPixmap scalePixmap(const QPixmap &pixmap, int width, int height);
QPixmap fastScalePixmap(const QPixmap &pixmap, int width, int height);


extern bool guardedContains(TaskPagerMan* man, Task* t );

KPager2 * KPagerAnimation::pager() {return m_pager;}

KPagerAnimation::KPagerAnimation( int desk, QGuardedPtr<Task> t, KPager2 *pager) : QWidget(0, "", /* better not (flicker + slow + sudden popup menu closures): Qt::WType_Popup | */ WStyle_Customize | WX11BypassWM | WMouseNoMask)
{
	m_desk = desk;
	m_task = t;
	m_pager = pager;
	locked = 0;
	hideTimer = 0;

	watch = ((QWidget*)(m_pager->m_desktops[desk-1]));
	//if (watch->isHidden()) watch = m_pager->m_singleDesktop;
	this->installEventFilter(this);
	setMouseTracking(true);

	setBackgroundMode(NoBackground);

}
KPagerAnimation::~KPagerAnimation()
{
}

void KPagerAnimation::checkForUnFocus()
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) 
		KP_RETURN_ANIMATION;
	if (!KWin::windowInfo(task()->window()).valid()) 
		KP_RETURN_ANIMATION;
	if (watch!=0)
		if (!watch->hasMouse() && !this->hasMouse())
			KP_RETURN_ANIMATION;
}

void KPagerAnimation::show()
{
	QWidget::show();
	hideTimer = startTimer(10000);
}
void KPagerAnimation::hide()
{
	QWidget::hide();
	if (hideTimer) killTimer(hideTimer);
	hideTimer = 0;
}

void KPagerAnimation::timerEvent ( QTimerEvent * e)
{
	// The timer id of the timer that checks if the focused widget still has the mouse, if  not we're gonna hide, necessary since some MouseLeave events are not obtained
	if (e)
	if (e->timerId() == hideTimer && hideTimer != 0)
	{
		//checkForUnFocus();
		hide(); // allright, in ANY CASE, we will close the widget after 10 seconds
		return;
	}
	QWidget::timerEvent(e);
}
void KPagerAnimation::unFocus()
{
	// is eventually called when we loose focus and this widget is going to hide (give control back to watched widget)
    hide();
    if (watch) {
	QWidget* tmp = watch;
        watch = 0;
	tmp->update();
    }
    lower();
    setEnabled(false);
}

/* This event filter is very tricky and relies on Qt
   internals. It's written this way to make all panel buttons work
   without modification and to keep advanced functionality like tool
   tips for the buttons alive.

   Don't hack around in this filter unless you REALLY know what you
   are doing. In case of doubt, ask ettrich@kde.org.

   originally token from Kicker sourcecode zoombutton.cpp
*/
bool KPagerAnimation::eventFilter( QObject *o, QEvent * e)
{
    if ( !watch )		return FALSE;
    if ( e == locked )	return FALSE;
    if ( !isVisible() )	return FALSE;
    if ( isHidden() )	return FALSE;
    if ( !isShown() )	return FALSE;
    if ( !isEnabled() )	return FALSE;
    if ( e->type() == QEvent::Leave )
	{
		if (o==this) {
			unFocus();
			return true;
		}
	}
	else if (o==this)
	{
//		if ( e->type() != QEvent::Paint && e->type() != QEvent::Show)
		if ( e->type() == QEvent::MouseButtonPress ||
		     e->type() == QEvent::MouseButtonRelease ||
		     e->type() == QEvent::Timer ||
			 e->type() == QEvent::MouseButtonDblClick ||
			 e->type() == QEvent::KeyPress ||
			 e->type() == QEvent::IMStart ||
			 e->type() == QEvent::IMEnd ||
			 e->type() == QEvent::Wheel  ||
			 e->type() == QEvent::DragEnter ||
			 e->type() == QEvent::DragMove ||
			 e->type() == QEvent::DragLeave ||
			 e->type() == QEvent::Drop ||
		     e->type() == QEvent::MouseMove )
		{
			if (e->type() == QEvent::Timer)
			{
				QTimerEvent * ev = new QTimerEvent(*((QTimerEvent*)e));
				timerEvent(ev);
				delete ev;
			} else 
			if (e->type() == QEvent::MouseMove)
			{
				QMouseEvent * ev = new QMouseEvent(*((QMouseEvent*)e));
				mouseMoveEvent(ev);
				delete ev;
			}
			
			if ( e->type() == QEvent::MouseButtonPress ||
			     e->type() == QEvent::MouseButtonRelease ||
			     e->type() == QEvent::MouseButtonDblClick ||
			     e->type() == QEvent::MouseMove )
			{
				// get a new MouseEvent wherein we transform the coords manually due to a guessed Qt bug
				QPoint p = ((QMouseEvent* )e)->pos();
				KPagerDesktop * d = m_pager->m_desktops[m_desk-1];
				//if (d->isHidden()) d = m_pager->m_singleDesktop;
				QPoint pos;
				// original idea for coordinate transformation
				pos.setX(p.x() - d->mapToGlobal(QPoint(0,0)).x() + this->mapToGlobal(QPoint(0,0)).x());
				pos.setY(p.y() - d->mapToGlobal(QPoint(0,0)).y() + this->mapToGlobal(QPoint(0,0)).y());
				// new hack for coord transformation in case of a bug in mapToGlobal:
				pos.setX(
					p.x() - (
					// begin: global position of desktop
					d->geometry().topLeft().x() +
					((QWidget*)d->parent())->mapToGlobal(((QWidget*)d->parent())->geometry().topLeft()).x()
					// end: global position of desktop
					)+(
					// begin: global position of the thumbnail windowInfo
					this->pos().x()
					// end: global position of the thumbnail windowInfo
					)
				);
				pos.setY(
					p.y() - (
					// begin: global position of desktop
					d->geometry().topLeft().y() +
					((QWidget*)d->parent())->mapToGlobal(((QWidget*)d->parent())->geometry().topLeft()).y()
					// end: global position of desktop
					)+(
					// begin: global position of the thumbnail windowInfo
					this->pos().y()
					// end: global position of the thumbnail windowInfo
					)
				);
				QEvent * ev  = new QMouseEvent(
					e->type(),
					pos,
					((QMouseEvent* )e)->globalPos(),
					((QMouseEvent* )e)->button(),
					((QMouseEvent* )e)->state()
				);

				locked=ev;
				if (watch!=0)
					QApplication::sendEvent(watch,ev);
				locked = 0;
				delete ev;
				return true;
			}
			else
			{
				locked=e;
				if (watch!=0)
					QApplication::sendEvent(watch,e);
				locked = 0;
				return true;
			}
		}
    }
	return false;
}

#include "kpagerdesktop.h"

KPagerZoomAnimation::KPagerZoomAnimation( int desk, QGuardedPtr<Task> t, KPager2 *pager) : KPagerAnimation(desk, t, pager)
{

	if  (!t) return;;
	if (!KWin::windowInfo(t->window()).valid()) return;

	m_INITIALIZED = true;
	
	// start here drawing preparations

	m_desktop = m_pager->m_desktops[m_desk-1];
	//if (m_desktop->isHidden()) m_desktop=m_pager->m_singleDesktop;

	KWin::WindowInfo m_win = KWin::windowInfo(t->window());

	// get the size of the widget
	double scale = 2.0; // zoom factor
	QRect ra =  m_win.geometry(); //m_win->frameGeometry();
	int dw = QApplication::desktop()->width();
	int dh = QApplication::desktop()->height();
	double centx = ra.x()+ra.width()/2.;
	double centy = ra.y()+ra.height()/2.;

	int top = m_desktop->geometry().x();
	int left = m_desktop->geometry().y();
	QWidget * w = m_desktop->parentWidget(true);
	while (w != 0)
	{
		top  += w->geometry().x();
		left += w->geometry().y();
		w = w->parentWidget(true);
	}

	left = m_desktop->mapToGlobal(QPoint(0,0)).x();
	top = m_desktop->mapToGlobal(QPoint(0,0)).y();

	QRect r = QRect(
		(int)round(0.+ (centx-ra.width() /2.*scale) * m_desktop->width() /dw + left),
		(int)round(0.+ (centy-ra.height()/2.*scale) * m_desktop->height()/dh + top),
		(int)round(0.+ (ra.width() *scale) * m_desktop->width() /dw),
		(int)round(0.+ (ra.height()*scale) * m_desktop->height()/dh ));

	resize(r.size());  // set widget's size
	move(  r.topLeft()); // set position, centered over the desktop's thumbnail

	m_rect = r;
	while (m_anim_list.count()<KP_ZOOM_ANIM_FRAMES)
	{
		m_anim_list.append(new QPixmap(r.size()));
	}
	m_anim_counter = -1;
	// m_scale = widgetsize / desktopthumbnailsize  = widgetsize / (window size  /rootwinsize * desktopwidgetsize)
	if (m_pager->orientation() == Qt::Horizontal)
		m_scale = 1.* ( 1. * r.width() ) /
				(1. * ( ra.width() ) /
					( kapp->desktop()->geometry().width() ) *
					( m_desktop->width()  ) );
	else
		m_scale = 1.* ( 1. * r.height() ) /
				(1. * ( ra.height() ) /
					( kapp->desktop()->geometry().height() ) *
					( m_desktop->height()  ) );

//	KConfig config( "kdeglobals" );
//	config.setGroup("KDE");
//	bool effects = ( config.readBoolEntry( "EffectsEnabled", false) );
	bool effects = QApplication::isEffectEnabled(UI_General);
	if (!effects)
	{
		m_anim_counter = KP_ZOOM_ANIM_FRAMES+1;
	}
	

	if (guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task()))
	if (KWin::windowInfo(task()->window()).valid())
	{
		raise();
		show();
	}
    setEnabled(true);
}
KPagerZoomAnimation::~KPagerZoomAnimation()
{
	hide();
	m_anim_list.setAutoDelete(true);
	m_anim_list.clear();
}

void KPagerZoomAnimation::mouseMoveEvent(QMouseEvent * e)
{
	// get the position of the mouse relative to the parent pagerdesktop widget
	// evaluate for this position if we still hover over the right thumbnail
	// if not: close our zoom window and let the pagerdesktop do

	QWidget::mouseMoveEvent(e);

	if (!e) return;

	QPoint p = e->pos();
	KPagerDesktop * d = m_pager->m_desktops[m_desk-1];
	//if (d->isHidden()) d = m_pager->m_singleDesktop;
	QPoint pos;
	pos.setX(p.x() - d->mapToGlobal(QPoint(0,0)).x() + this->mapToGlobal(QPoint(0,0)).x());
	pos.setY(p.y() - d->mapToGlobal(QPoint(0,0)).y() + this->mapToGlobal(QPoint(0,0)).y());
	QGuardedPtr<Task> t = d->windowAtPosition(pos,0);

	bool end = false;

	end = ((Task*)t == 0);
	if (t)
	{
		if (  (t->window()!=task()->window()) || (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), t)) )
		{
			end = true;
		}
	}

	if (end)
	{
		unFocus();
	}
}

void KPagerZoomAnimation::show()
{
	if (!m_INITIALIZED) return;
	if (!KPagerConfigDialog::m_showWindows) return;

	// get the target pixmap
	QPixmap pixmap(m_rect.width(),m_rect.height());
	QPainter p;

	p.begin(&pixmap);
	paintWindow(p, 1.0);
	p.end();
	m_pixmap = pixmap;
	
	if (m_anim_list.count() == KP_ZOOM_ANIM_FRAMES)
	if (m_anim_counter == -1)
	{
/*
		if (isVisible())
		{
			hide();
			QTimer::singleShot(30,this,SLOT(show()));
			return;
		}
*/ // less flicker

		// grab screen
		QWidget *rootWin = qApp->desktop();
		m_screen = QPixmap::grabWindow( rootWin->winId(),
			m_rect.x(), m_rect.y(),
			m_rect.width(), m_rect.height() ); // geometry must contain the gloabl coordinates since we are top-level!

		// fill frames
		QPoint pos;
		double scale;
		for (int i = 0; i < KP_ZOOM_ANIM_FRAMES; i++)
		{
			// get size
			// size starts slow and ends fast
			scale = 1./m_scale + 1.*(i+1)/KP_ZOOM_ANIM_FRAMES*(1-1./m_scale); // linear relation from orig size to widget size
			//scale = 1./m_scale + 1.*(SQR(i+1.))/SQR(KP_ZOOM_ANIM_FRAMES)*(1-1./m_scale); // square relation from orig size to widget size

			// get window pixmap
//			pixmap = QPixmap((int)round(width()*1.*scale), (int)round(height()*1.*scale));
//			qDebug("ZoomAnimation: size (%d, %d)\n", pixmap.width(), pixmap.height());
//			p.begin(&pixmap);
//			paintWindow(p, 1.);
//			p.end();
			pixmap = scalePixmap(m_pixmap, (int)round(m_rect.width()*1.*scale), (int)round(m_rect.height()*1.*scale));


			// get pos
			pos = m_rect.center()-m_rect.topLeft()-pixmap.rect().center();

			// set pixmap
			QPixmap pix = m_screen;
			p.begin(&pix);
			p.drawPixmap(pos, pixmap);
			p.end();
			(*m_anim_list.at(i)) = pix;
		}

		// prepare timers
		m_anim_counter = 0;
		connect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
		m_anim_timer.start(20);
	}
	KPagerAnimation::show();
}

void KPagerZoomAnimation::hide()
{
	m_anim_timer.stop();
	disconnect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
	KPagerAnimation::hide();
/*	KConfig config( "kdeglobals" );
	config.setGroup("KDE");
	bool effects = ( config.readBoolEntry( "EffectsEnabled", false) );
*/
	bool effects = QApplication::isEffectEnabled(UI_General);
	if (!effects)
	{
		m_anim_counter = KP_ZOOM_ANIM_FRAMES+1;
	}
	else
		m_anim_counter = -1;
}

void KPagerZoomAnimation::paintEvent(QPaintEvent *)
{
	if (!isVisible()) return;

	QPixmap pixmap(width(),height());
	QPainter p;


	if ( (m_anim_counter >= KP_ZOOM_ANIM_FRAMES) || (m_anim_counter < 0) )
	{
		m_anim_timer.stop();
		disconnect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
		p.begin(&pixmap);
		paintWindow(p, 1.0);
		p.end();
	}
	else
	{
		pixmap = * (m_anim_list.at(m_anim_counter));
		m_anim_counter++;
	}


	// map to the widget
	p.begin(this);
	p.drawPixmap(0,0,pixmap);
	p.end();
}



void KPagerZoomAnimation::paintWindow(QPainter &p, double scale, bool onDesktop)
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) KP_RETURN_ANIMATION
	if (!KWin::windowInfo(task()->window()).valid()) KP_RETURN_ANIMATION
	switch (static_cast<KPagerDesktop::WindowDrawMode>(KPagerConfigDialog::m_windowDrawMode ) )
	{
	case (KPagerDesktop::Plain)  : paintWindowPlain (p, scale, onDesktop);break;
	case (KPagerDesktop::Icon)   : paintWindowIcon  (p, scale, onDesktop);break;
	case (KPagerDesktop::Pixmap) : paintWindowPixmap(p, scale, onDesktop);break;
	}
}

void KPagerZoomAnimation::paintWindowPlain(QPainter &p, double scale, bool onDesktop)
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) return;
	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor
	QRect dr = ((QPixmap*)p.device())->rect();

	QRect r(
		(int)round (0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round (0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round (0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round (0. + dr.height()/2. + dr.height()/2.*scale));
	if ( !onDesktop ) r.moveTopLeft(QPoint(0,0));
	//bool isActive=(pager()->kwin()->activeWindow() == m_win->win());
	bool isActive=task()->isActive();

	// get the fill color
	QColor col;
	if ( isActive ) col= colorGroup().highlight();
	else col = colorGroup().button();

	QBrush brush = col;
//	if ( m_transparentMode==AllWindows || (m_transparentMode==MaximizedWindows && ( m_win->state() & NET::Max )) )
//		brush.setStyle(QBrush::Dense4Pattern);
// LATER FROm KAPgerConfig
	p.fillRect(r, brush);

	// draw a frame around the thumbnail:
	p.setPen(QPen(colorGroup().dark(),0));
	p.drawRect(r);


}


void KPagerZoomAnimation::paintWindowIcon(QPainter &p, double scale, bool onDesktop)
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) return;
	if (!KWin::windowInfo(task()->window()).valid()) return;
	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor
	QRect dr = ((QPixmap*)p.device())->rect();
	QRect r(
		(int)round(0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round(0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. + dr.height()/2.*scale));
	if ( !onDesktop ) r.moveTopLeft(QPoint(0,0));
//  r = QRect( r.x() * width() / dw, 2 + r.y() * height() / dh,
//      r.width() * width() / dw, r.height() * height() / dh );
/*
  QPixmap icon=KWin::icon( task()->window(), (int)round(r.width()*0.8),
			   (int)round(r.height()*0.8), true);
*/
	QPixmap icon = KWin::icon( task()->window(), int(r.width()*0.8), int(r.height()*0.8), false);
	// now scale it
	double iscale;
	iscale = ( QMIN(r.width(),r.height())*0.8 ) / (QMAX(icon.width(),icon.height()));
	icon = scalePixmap (icon, int(icon.width()*iscale), int(icon.height()*iscale));
	if (QMIN(icon.width(),icon.height()) < 10) icon.resize(0,0); // setNull(true) if the icon is to small to display it accurately

	KWin::WindowInfo  info = KWin::windowInfo(task()->window());
  if ( icon.isNull() || info.windowType(NET::NormalMask)!=NET::Override )
    paintWindowPlain(p,scale,onDesktop);

  if ( !onDesktop )
    r.moveTopLeft(QPoint(0,0));

	p.drawPixmap( r.center()-icon.rect().center(),icon );
}

void KPagerZoomAnimation::paintWindowPixmap(QPainter &p, double scale,
					bool onDesktop)
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) return;
	if (!m_task) return;
	if (m_task->isMinimized()) return;
	if (m_task->isShaded()) return;
//	if (pager()->pagerTaskManager()->taskPagerManager()->tasks().find(m_task)==-1) return;
	if (!guardedContains(pager()->pagerTaskManager()->taskPagerManager(),m_task)) return;

	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor
	QRect dr = ((QPixmap*)p.device())->rect();
	QRect rSmall(
		(int)round(0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round(0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. + dr.height()/2.*scale));
	//if ( !onDesktop ) rSmall.moveTopLeft(QPoint(0,0));

	QGuardedPtr<Task> t = task();
	if (!t->hasThumbnail())
	{
			paintWindowIcon(p, scale, onDesktop);
			return;
	}

	QPixmap pixmap = t->thumbnail();

  if ( !onDesktop )
    rSmall.moveTopLeft(QPoint(0,0));

  if (rSmall.width() != pixmap.width() || rSmall.height() != pixmap.height())
	{
		QPixmap pixmapSmall(fastScalePixmap(pixmap,rSmall.width(),rSmall.height()));
		p.drawPixmap( rSmall.topLeft(), pixmapSmall );
	}
	else
	{
		p.drawPixmap( rSmall.topLeft(), pixmap);
	}

	// draw a frame around the thumbnail:
	p.setPen(QPen(colorGroup().dark(),0));
	p.drawRect(rSmall);

}









KPagerShiftAnimation::KPagerShiftAnimation( int desk, QGuardedPtr<Task> t, KPager2 *pager) : KPagerAnimation(desk, t, pager)
{
	if  (!t) return;;
	if (!KWin::windowInfo(t->window()).valid()) return;

	m_INITIALIZED = true;

//	KPagerAnimation::hide();

	// start here drawing preparations


	m_desktop = m_pager->m_desktops[m_desk-1];
	//if (m_desktop->isHidden()) m_desktop=m_pager->m_singleDesktop;
	KWin::WindowInfo m_win = KWin::windowInfo(t->window());


	// SET THE SIZE
	// set the size as 1.5x the size of a thumbnail desktop. All thumbnails will have the same width
	// if vertical or the same height if horizontal, respectively.
	// the minimum width is 100, height is 67. (4:3 ratio)

	// get the size of the widget
	double scale = 2; // zoom factor
	QRect ra =  m_win.geometry(); //m_win->frameGeometry();  // size of the real app window
	double w,h; // width, height, top, left
	if (pager->orientation()==Horizontal)
	{
		w = scale * m_desktop->width();
		if (w < 100) w = 100;
		h = w * ra.height()/ra.width()*1.0;
		// check maximum dimensions
		if (h > kapp->desktop()->geometry().height()/2)
		{
			h = kapp->desktop()->geometry().height()/2.;
			w = h * ra.width()/ra.height()*1.0;
		}
	}
	else // vertical
	{
		h = scale * m_desktop->height();
		if (h < 100.*kapp->desktop()->geometry().height()/kapp->desktop()->geometry().width())
			w = 100.*kapp->desktop()->geometry().height()/kapp->desktop()->geometry().width(); // = 100.*3/4;
		w = h * ra.width()/ra.height()*1.0;
		// check maximum dimensions
		if (w > kapp->desktop()->geometry().width()/2)
		{
			w = kapp->desktop()->geometry().width()/2.;
			h = w * ra.height()/ra.width()*1.0;
		}
	}

	// SET THE POSITION
	// set the position next to the pager. if horizontally oriented, it will be above or below, depending on the
	// position of the center of gravity of the pager window, if vertically oriented, it will be to the left
	// or right, respectively.

	QPoint cp  = m_pager->geometry().center();                     // center of gravity of the pager (local coord)
	QPoint cpg = m_pager->mapToGlobal(m_pager->geometry().center()); // center of gravity of the pager (global coord)
	QPoint cw  = QPoint((int)round (w/2), (int)round (h/2));                   // center of gravity of the thumbnail (local coo)
	QPoint cwg; // global center of gravity -> to set!!!
	if (pager->orientation()==Horizontal)
	{
		// correct line:
		//cwg.setX( m_desktop->mapToGlobal(m_desktop->geometry().center()).x() );
		// since there is a bug in mapToGlobal in Qt3.x we must do (mapToGlobal takes double widths in GridLayouts)
		// something tricky

		// hack
		cwg.setX(
			m_desktop->geometry().center().x() +
			((QWidget*)m_pager)->mapToGlobal(((QWidget*)m_pager)->geometry().topLeft()).x()
			 );
		// end of hack

		if (cpg.y() < QApplication::desktop()->height()/2 ) // upper domain
			dir = +1;
		else
			dir = -1;
		cwg.setY( cpg.y() + dir*(cp.y()+cw.y()) );
		// do something that prevents overlapping of MTaskContainer and the animation widget (else to many repaints on closure of anim widget) -> move it up! 
		cwg.setY( cwg.y() + 5*dir);
	}
	else // vertical
	{
		// correct line:
		//cwg.setY( m_desktop->mapToGlobal(m_desktop->geometry().center()).y() );
		// hack
		cwg.setY(
			m_desktop->geometry().center().y() +
			((QWidget*)m_desktop->parent())->mapToGlobal(((QWidget*)m_desktop->parent())->geometry().topLeft()).y()
			 );
		// end of hack
		if (cpg.x() < QApplication::desktop()->width()/2 ) // upper domain
			dir = +1;
		else
			dir = -1;
		cwg.setX( cpg.x() + dir*(cp.x()+cw.x()) );
		// do something that prevents overlapping of MTaskContainer and the animation widget (else to many repaints on closure of anim widget) -> move it up! 
		cwg.setX( cwg.x() + 5*dir);
	}

	// set position
	QRect r;
	r.setWidth((int)round(w));
	r.setHeight((int)round(h));
	r.moveCenter(cwg);

	while (m_anim_list.count()<KP_SHIFT_ANIM_FRAMES)
	{
		m_anim_list.append(new QPixmap(r.size()));
	}
	m_anim_counter = -1;

	// check if the widget is full visible on the screen
	QRect deskg = kapp->desktop()->geometry();
	if (r.right()>deskg.right())
	{
		r.moveRight(deskg.right());
	}
	else if (r.left()<deskg.left())
	{
		r.moveLeft(deskg.left());
	}
	if (r.top()<deskg.top())
	{
		r.moveTop(deskg.top());
	}
	else if (r.bottom()>deskg.bottom())
	{
		r.moveBottom(deskg.bottom());
	}

	m_rect = r;

	resize(r.size());  // set widget's size
	move(  r.topLeft()); // set position, centered over the desktop's thumbnail

	// m_scale = widgetsize / desktopthumbnailsize  = widgetsize / (window size  /rootwinsize * desktopwidgetsize)
	if (m_pager->orientation() == Qt::Horizontal)
		m_scale = 1.* ( 1. * r.width() ) /
				(1. * ( ra.width() ) /
					( kapp->desktop()->geometry().width() ) *
					( m_desktop->width()  ) );
	else
		m_scale = 1.* ( 1. * r.height() ) /
				(1. * ( ra.height() ) /
					( kapp->desktop()->geometry().height() ) *
					( m_desktop->height()  ) );
//	qDebug("app name\t%s\n", t->name().latin1());
//	qDebug("m_scale %f.10\th %d\tra.height %d\tkapp->height %d\tm_desk->height %d\n", m_scale, r.height(), ra.height(), kapp->desktop()->geometry().height(), m_desktop->height() );

//	KConfig config( "kdeglobals" );
//	config.setGroup("KDE");
//	bool effects = ( config.readBoolEntry( "EffectsEnabled", false) );
	bool effects = QApplication::isEffectEnabled(UI_General);
	if (!effects)
	{
		m_anim_counter = KP_SHIFT_ANIM_FRAMES+1;
	}
	
	if (guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task()))
	if (KWin::windowInfo(task()->window()).valid())
	{
		raise();
		show();
	}
    setEnabled(true);

/*
	printf("\nrx %d ry %d\t dx %d dy %d\t px %d py %d\n"
		,r.center().x(), r.center().y()
		,m_desktop->mapToGlobal(m_desktop->geometry().center()).x()
		,m_desktop->mapToGlobal(m_desktop->geometry().center()).y()
		,cpg.x(), cpg.y()
	);
	printf("desktop dw %d dh %d\t left %d right %d top %d bottom %d \n"
		,m_desktop->geometry().width()
		,m_desktop->geometry().height()
		,m_desktop->mapToGlobal(m_desktop->geometry().topLeft()).x()
		,m_desktop->mapToGlobal(m_desktop->geometry().bottomRight()).x()
		,m_desktop->mapToGlobal(m_desktop->geometry().topLeft()).y()
		,m_desktop->mapToGlobal(m_desktop->geometry().bottomRight()).y()
	);
*/
}
KPagerShiftAnimation::~KPagerShiftAnimation()
{
	hide();
	m_anim_list.setAutoDelete(true);
	m_anim_list.clear();
}

void KPagerShiftAnimation::show()
{
	if (!m_INITIALIZED) return;
	if (!KPagerConfigDialog::m_showWindows) return;

	// get the target pixmap
	QPixmap pixmap(width(),height());
	QPainter p;

	p.begin(&pixmap);
	paintWindow(p, 1.0);
	p.end();
	m_pixmap = pixmap;
	
	if (m_anim_list.count() == KP_SHIFT_ANIM_FRAMES)
	if (m_anim_counter == -1)
	{
		if (isVisible())
		{
			hide();
			QTimer::singleShot(30,this,SLOT(show()));
			return;
		}

		// grab screen
		QWidget *rootWin = qApp->desktop();
		m_screen = QPixmap::grabWindow( rootWin->winId(),
			m_rect.x(), m_rect.y(),
			m_rect.width(), m_rect.height() ); // geometry must contain the gloabl coordinates since we are top-level!

		// fill frames
		QPoint pos;
		double scale;
		for (int i = 0; i < KP_SHIFT_ANIM_FRAMES; i++)
		{
			// get size
			// size starts slow and ends fast
			// scale = 1./m_scale + 1.*(i+1)/KP_SHIFT_ANIM_FRAMES*(1-1./m_scale); // linear relation from orig size to widget size
			scale = 1./m_scale + 1.*(SQR(i+1.))/SQR(KP_SHIFT_ANIM_FRAMES)*(1-1./m_scale); // square relation from orig size to widget size

			// get window pixmap
			pixmap = scalePixmap(m_pixmap, (int)round(width()*1.*scale), (int)round(height()*1.*scale));

			// get pos
			// pos starts fast and ends slow
			// pos = m_rect.center() - m_rect.topLeft(); // centered
			int w = (m_pager->orientation()==Qt::Horizontal) ? width() : height();
			int h = (m_pager->orientation()==Qt::Horizontal) ? height() : width(); // switch x,y if vertical (hack)
			QPoint deskpx = mapFromGlobal(m_desktop->mapToGlobal(m_desktop->rect().center()));
			int deskcx = (m_pager->orientation()==Qt::Horizontal) ? deskpx.x() : deskpx.y();
			double x, y;
			y = 1.*( SQR( 1.*(i+1.)/KP_SHIFT_ANIM_FRAMES - 1.)) * h ;
			//x = (1.-scale)*w/2.;
			x = w/2. + ((1.*y/h) * (deskcx - w/2.) ) - (scale)*w/2.;
			if (dir>0) y = h - y - h*1.*scale; 
			pos = QPoint ( (int) round(x), (int)round(y));

			if (m_pager->orientation()!=Qt::Horizontal)
			{
				pos = QPoint(pos.y(), pos.x()); // switch x,y
			}
			// qDebug("#%d\tP ( %d, %d )\t\tSize ( %d, %d )\t\tscale %f\t\t m_scale %f\n", i, pos.x(), pos.y(), pixmap.width(), pixmap.height(), scale, m_scale);

			// set pixmap
			QPixmap pix = m_screen;
			p.begin(&pix);
			p.drawPixmap(pos, pixmap);
			p.end();
			(*m_anim_list.at(i)) = pix;
		}

		// prepare timers
		m_anim_counter = 0;
		connect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
		m_anim_timer.start(20);
	}
	KPagerAnimation::show();
}

void KPagerShiftAnimation::hide()
{
	m_anim_timer.stop();
	disconnect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
	KPagerAnimation::hide();
//	KConfig config( "kdeglobals" );
//	config.setGroup("KDE");
//	bool effects = ( config.readBoolEntry( "EffectsEnabled", false) );
	bool effects = QApplication::isEffectEnabled(UI_General);
	if (!effects)
	{
		m_anim_counter = KP_SHIFT_ANIM_FRAMES+1;
	}
	else
		m_anim_counter = -1;
}

void KPagerShiftAnimation::paintEvent(QPaintEvent *)
{
	if (!isVisible()) return;

	QPixmap pixmap(width(),height());
	QPainter p;


	if ( (m_anim_counter >= KP_SHIFT_ANIM_FRAMES) || (m_anim_counter < 0) )
	{
		m_anim_timer.stop();
		disconnect(&m_anim_timer, SIGNAL(timeout()), this, SLOT(update()));
		p.begin(&pixmap);
		paintWindow(p, 1.0);
		p.end();
	}
	else
	{
		pixmap = * (m_anim_list.at(m_anim_counter));
		m_anim_counter++;
	}


	// map to the widget
	p.begin(this);
	p.drawPixmap(0,0,pixmap);
	p.end();
}

//QPixmap scalePixmap(const QPixmap &pixmap, int width, int height);
//QPixmap fastScalePixmap(const QPixmap &pixmap, int width, int height);


void KPagerShiftAnimation::paintWindow(QPainter &p, double scale, bool onDesktop)
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) KP_RETURN_ANIMATION
	if (!KWin::windowInfo(task()->window()).valid()) KP_RETURN_ANIMATION
	switch (static_cast<KPagerDesktop::WindowDrawMode>(KPagerConfigDialog::m_windowDrawMode ) )
	{
	case (KPagerDesktop::Plain)  : paintWindowPlain (p, scale, onDesktop);break;
	case (KPagerDesktop::Icon)   : paintWindowIcon  (p, scale, onDesktop);break;
	case (KPagerDesktop::Pixmap) : paintWindowPixmap(p, scale, onDesktop);break;
	}
}

void KPagerShiftAnimation::paintWindowPlain(QPainter &p, double scale, bool onDesktop)
{
	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor

	QRect dr = ((QPixmap*)p.device())->rect();

	QRect r(
		(int)round (0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round (0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round (0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round (0. + dr.height()/2. + dr.height()/2.*scale));
	if ( !onDesktop ) r.moveTopLeft(QPoint(0,0));
	//bool isActive=(pager()->kwin()->activeWindow() == m_win->win());
	bool isActive=task()->isActive();

	// get the fill color
	QColor col;
	if ( isActive ) col= colorGroup().highlight();
	else col = colorGroup().button();

	QBrush brush = col;
//	if ( m_transparentMode==AllWindows || (m_transparentMode==MaximizedWindows && ( m_win->state() & NET::Max )) )
//		brush.setStyle(QBrush::Dense4Pattern);
// LATER FROm KAPgerConfig
	p.fillRect(r, brush);

	// draw a frame around the thumbnail:
	p.setPen(QPen(colorGroup().dark(),0));
	p.drawRect(r);


}


void KPagerShiftAnimation::paintWindowIcon(QPainter &p, double scale, bool onDesktop)
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) return;
	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor
	QRect dr = ((QPixmap*)p.device())->rect();
	QRect r(
		(int)round(0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round(0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. + dr.height()/2.*scale));
	if ( !onDesktop ) r.moveTopLeft(QPoint(0,0));
//  r = QRect( r.x() * width() / dw, 2 + r.y() * height() / dh,
//      r.width() * width() / dw, r.height() * height() / dh );
/*
  QPixmap icon=KWin::icon( task()->window(), (int)round(r.width()*0.8),
			   (int)round(r.height()*0.8), true);
*/
	QPixmap icon = KWin::icon( task()->window(), int(r.width()*0.8), int(r.height()*0.8), false);
	// now scale it
	double iscale;
	iscale = ( QMIN(r.width(),r.height())*0.8 ) / (QMAX(icon.width(),icon.height()));
	icon = scalePixmap (icon, int(icon.width()*iscale), int(icon.height()*iscale));
	if (QMIN(icon.width(),icon.height()) < 10) icon.resize(0,0); // setNull(true) if the icon is to small to display it accurately

	KWin::WindowInfo  info = KWin::windowInfo(task()->window());
  if ( icon.isNull() || info.windowType(NET::NormalMask)!=NET::Override )
    paintWindowPlain(p,scale,onDesktop);

  if ( !onDesktop )
    r.moveTopLeft(QPoint(0,0));

	p.drawPixmap( r.center()-icon.rect().center(),icon );
}

void KPagerShiftAnimation::paintWindowPixmap(QPainter &p, double scale,
					bool onDesktop)
{
	if (!guardedContains(m_pager->pagerTaskManager()->taskPagerManager(), task())) return;
	if (!m_task) return;
	if (m_task->isMinimized()) return;
	if (m_task->isShaded()) return;
//	if (pager()->pagerTaskManager()->taskPagerManager()->tasks().find(m_task)==-1) return;
	if (!guardedContains(pager()->pagerTaskManager()->taskPagerManager(),m_task)) return;

	// in our case the widget is already centered above the thumbnail, its size is identically the same, only incorporate the scale factor
	QRect dr = ((QPixmap*)p.device())->rect();
	QRect rSmall(
		(int)round(0. + dr.width() /2. - dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. - dr.height()/2.*scale),
		(int)round(0. + dr.width() /2. + dr.width() /2.*scale),
		(int)round(0. + dr.height()/2. + dr.height()/2.*scale));
	//if ( !onDesktop ) rSmall.moveTopLeft(QPoint(0,0));

	QGuardedPtr<Task> t = task();
	if (!t->hasThumbnail())
	{
			paintWindowIcon(p, scale, onDesktop);
			return;
	}

	QPixmap pixmap = t->thumbnail();

  if ( !onDesktop )
    rSmall.moveTopLeft(QPoint(0,0));

  if (rSmall.width() != pixmap.width() || rSmall.height() != pixmap.height())
	{
		QPixmap pixmapSmall(fastScalePixmap(pixmap,rSmall.width(),rSmall.height()));
		p.drawPixmap( rSmall.topLeft(), pixmapSmall );
	}
	else
	{
		p.drawPixmap( rSmall.topLeft(), pixmap);
	}

	// draw a frame around the thumbnail:
	p.setPen(QPen(colorGroup().dark(),0));
	p.drawRect(rSmall);

}

