/***************************************************************************
                          kpageranimation.h  -  description
                             -------------------
    begin                : Sat Apr 17 2004
    copyright            : (C) 2004 by Sebastian Wolff
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#ifndef __KPAGERANIMATION_H
#define __KPAGERANIMATION_H

#include "version.h"

#include <qguardedptr.h>
#include <qwidget.h>
#include <qtimer.h>
#include <kwin.h>

class KPopupMenu;
class KSharedPixmap;

class QPainter;
class QTimer;

class KPager2;
class KPagerDesktop;
class Task;

class KPagerAnimation : public QWidget
{
	// an abstract class for the zoom and shift animation classes
	// it only provides an interface to pass all events to the connected kpager (and that finally to its kdesktops)
    Q_OBJECT

public:
	KPagerAnimation( int desk, QGuardedPtr<Task>, KPager2 *pager=0);
	~KPagerAnimation();
	KPager2 * pager(); 
	QGuardedPtr<Task> task() {return m_task;};


public slots:
	virtual void unFocus();
	void checkForUnFocus();
	virtual void show(); // start hideTimer
	virtual void hide(); // stop hideTimer
protected:
	virtual bool eventFilter( QObject *o, QEvent * e);
	virtual void timerEvent ( QTimerEvent * );	// check hideTimer


	KPager2 * m_pager;		// the connected pager
	QWidget * watch;		// the widget that is hidden by our window
    int hideTimer;			// The timer id of the timer ttha checks if the foxuessed widget still  hahste mouse, if  not we're gonna hide, necessary since some MouseLeave events are not obtained
    QEvent* locked;			// copied from Kickers zoombutton.h
	int m_desk;				// the calling desktop
	QGuardedPtr<Task> m_task; // the refering app window we refer to
	
	
signals:

	
};

class KPagerZoomAnimation : public KPagerAnimation
{
	// an abstract class for the zoom and shift animation classes
	// it only provides an interface to pass all events to the connected kpager (and that finally to its kdesktops)
    Q_OBJECT

public:
	KPagerZoomAnimation( int desk, QGuardedPtr<Task>, KPager2 *pager=0);
	~KPagerZoomAnimation();

public slots:
	
protected:

	virtual void paintEvent(QPaintEvent *);
	virtual void mouseMoveEvent(QMouseEvent * e);
	
	
	void paintWindow(QPainter &p, double scale = 1, bool onDesktop=true); // scale = related to the zoom widget's size
	void paintWindowPlain(QPainter &p, double scale = 1, bool onDesktop=true);
	void paintWindowIcon(QPainter &p, double scale = 1, bool onDesktop=true);
	void paintWindowPixmap(QPainter &p, double scale = 1, bool onDesktop=true);

	KPagerDesktop * m_desktop;
	
	// for animation on startup
	virtual void show(); // prepares m_anim_timer 
	virtual void hide(); // stops the timer 
	QTimer m_anim_timer;
	int m_anim_counter;
	QPtrList<QPixmap> m_anim_list;
	QPixmap m_pixmap; // current pixmap
	QPixmap m_screen; // grabbed screen
	double m_scale; // scale factor between the animation widget and the window size on the desktop
	QRect m_rect;
	bool m_INITIALIZED;
signals:

	
};

class KPagerShiftAnimation : public KPagerAnimation
{
	// an abstract class for the zoom and shift animation classes
	// it only provides an interface to pass all events to the connected kpager (and that finally to its kdesktops)
    Q_OBJECT

public:
	KPagerShiftAnimation( int desk, QGuardedPtr<Task>, KPager2 *pager=0);
	~KPagerShiftAnimation();

public slots:
	
protected:

	virtual void paintEvent(QPaintEvent *);
	
	
	void paintWindow(QPainter &p, double scale = 1, bool onDesktop=true); // scale = related to the zoom widget's size
	void paintWindowPlain(QPainter &p, double scale = 1, bool onDesktop=true);
	void paintWindowIcon(QPainter &p, double scale = 1, bool onDesktop=true);
	void paintWindowPixmap(QPainter &p, double scale = 1, bool onDesktop=true);

	KPagerDesktop * m_desktop;
	
	
	// for animation on startup
	virtual void show(); // prepares m_anim_timer 
	virtual void hide(); // stops the timer 
	QTimer m_anim_timer;
	int m_anim_counter;
	QPtrList<QPixmap> m_anim_list;
	QPixmap m_pixmap; // current pixmap
	QPixmap m_screen; // grabbed screen
	double m_scale; // scale factor between the animation widget and the window size on the desktop
	QRect m_rect;
	bool m_INITIALIZED;
	
	int dir; // a help variable: -1/+1 that specifies the position relative to the pager
	
signals:

	
};

#endif

