
#include "kpagerapplet.h"

#ifdef KPAGER_IS_APPLET


#include <qlayout.h>

#include <kaboutdata.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kmessagebox.h>


KAboutData * m_aboutdata = 0;
const char * m_kpagerversion = VERSION_STRING;

void setAboutData()
{
    m_aboutdata = new KAboutData("kpager2", "KPager2", m_kpagerversion,
						I18N_NOOP("Virtual Desktops Overview"), KAboutData::License_GPL,
						"",
						"(C) 2003-2004, Sebastian Wolff"
						"\n\n"I18N_NOOP("based on KPager")
						"\n(C) 1998-2002, Antonio Larrosa Jimenez"
						);

    m_aboutdata->addCredit("Antonio Larrosa Jimenez",
			 I18N_NOOP("Original Developer of KPager, (C) 1998-2002"),"larrosa@kde.org",
			 "http://devel-home.kde.org/~larrosa/index.html");
    m_aboutdata->addCredit("Matthias Elter",
			 I18N_NOOP("Developer, KPager"),"elter@kde.org", "");
    m_aboutdata->addCredit("Matthias Ettrich",
			 I18N_NOOP("Developer, KPager"),"ettrich@kde.org", "");
}

KConfig * kpagerglobalconfig = 0;

KPagerMainWindow::KPagerMainWindow(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
    : KPanelApplet(configFile, type, actions, parent, name)
{
    // Get the current application configuration handle
	kpagerglobalconfig = config();
	//setBackgroundMode(X11ParentRelative);
	setBackgroundOrigin( AncestorOrigin );

	setAboutData();
	mainView = new KPager2(this);
	connect(mainView, SIGNAL(updateLayoutCalled()), this, SIGNAL(updateLayout()));
	positionChange(position()); // set the mainView->orientation

	// setup Layout
	QHBoxLayout * lay = new QHBoxLayout(this,0,0);
	lay->addWidget(mainView);
}


KPagerMainWindow::~KPagerMainWindow()
{
}


void KPagerMainWindow::about()
{
	mainView->aboutDialog();
}


void KPagerMainWindow::help()
{
	mainView->helpDialog();
}


void KPagerMainWindow::preferences()
{
    mainView->configureDialog();
}

int KPagerMainWindow::widthForHeight(int height) const
{
    return mainView->widthForHeight(height);
}

int KPagerMainWindow::heightForWidth(int width) const
{
    return mainView->heightForWidth(width);
}

void KPagerMainWindow::resizeEvent(QResizeEvent *e)
{
	KPanelApplet::resizeEvent(e);
}
void KPagerMainWindow::positionChange(Position p)
{
	Orientation o;
	if ( (p==pLeft) || (p==pRight) ) o = Qt::Vertical;
	else o = Qt::Horizontal;

	if (o != mainView->orientation())
	{
		disconnect(mainView, SIGNAL(updateLayoutCalled()), this, SIGNAL(updateLayout()));
		mainView->setOrientation(o);
		mainView->updateLayout();
		connect(mainView, SIGNAL(updateLayoutCalled()), this, SIGNAL(updateLayout()));
	}
}


extern "C"
{
    KPanelApplet* init( QWidget *parent, const QString& configFile)
    {
        KGlobal::locale()->insertCatalogue("kpager2");
        return new KPagerMainWindow(configFile, KPanelApplet::Normal,
                             KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                             parent, "kpager2");
    }
}
#endif

