/**************************************************************************

    kpagerdesktop.h  - KPager's desktop
    Copyright (C) 2000  Antonio Larrosa Jimenez
			Matthias Ettrich
			Matthias Elter
    changes (c) 2003 Sebastian Wolff

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

***************************************************************************/
#ifndef __KPAGERDESKTOP_H
#define __KPAGERDESKTOP_H

#include "version.h"

#include <qguardedptr.h>
#include <qwidget.h>
#include <qintdict.h>
#include <qtimer.h>
#include <kwin.h>
#include <kurl.h>

#include "kpagertooltip.h"
#include "kpagertaskmanager.h"

class KSharedPixmap;
class KPopupMenu;

class QPainter;
class QPoint;
class QTimer;
class KPagerToolTip;
class KPager2;

class KPagerAnimation;
class KPagerZoomAnimation;

class KPagerDesktop : public QWidget
{
	friend class KPagerToolTip;
	friend class KPagerAnimation;
	friend class KPagerZoomAnimation;
	friend class KPagerShiftAnimation;

    Q_OBJECT

public:
	KPagerDesktop( int desk, KPager2 *pager=0, QWidget *parent=0,
		const char *name=0);
	~KPagerDesktop();

		int id() const { return m_desk; };
	bool isCurrent() const;

//  int widthForHeight(int height) const;
//  int heightForWidth(int width) const;

	enum WindowDrawMode { Plain=0, Icon=1, Pixmap=2 };
	enum WindowTransparentMode { NoWindows=0, MaximizedWindows=1, AllWindows=2};

	virtual int deskX() const { return 0; };
	virtual int deskY() const { return 0; };
	virtual int deskWidth() const { return width(); };
	virtual int deskHeight() const { return height(); };

	void startDrag(const QPoint &point);
	void dragEnterEvent(QDragEnterEvent *ev);
	void dragLeaveEvent(QDragLeaveEvent *ev);
	void dragMoveEvent(QDragMoveEvent *ev);
	void dropEvent(QDropEvent *ev);
	void convertRectS2P(QRect &r);
	void convertCoordP2S(int &x, int &y);

	QGuardedPtr<Task> windowAtPosition (const QPoint &p, QPoint *internalpos);

	QSize sizeHint() const;

  /**
   * active is a bool that specifies if the frame is the active
   * one or not (so that it's painted highlighted or not), mousehover means true if the mouse hovers over the desktop
   */
	void paintDesktopHighlighting(QPixmap & pixmap, bool selected, bool mousehover);
	class KPager2* pager() const;

	bool shouldPaintWindow( QGuardedPtr<Task> );


	void setAttention(bool);
	bool isAttention();

	void updateToolTip();

	void drawShadowText(QPainter  &p, QRect tr, int tf, const QString & str, int len = -1, QRect * brect = 0, QTextParag ** internal = 0 );


public slots:
	void backgroundLoaded(bool b);

	void loadBgPixmap();

	void repaintDesktop();

	void slotDragSwitch(); // is called by the m_dragSwitchTimer, and switches to the desktop, whenever somebody is dragging from another app and wants to change the desktop

	virtual void redraw(); // fills m_pixmap; and calls update
	virtual void redraw(QPixmap & ); // redraws the desktop on given pixmap

	virtual void update();
	void setDesktop(int desk) {m_desk = desk;}
	
	void slotRunURL(KURL::List list);

protected:
	virtual bool event(QEvent *e);
    bool eventFilter( QObject *o, QEvent *e );

	void mousePressEvent( QMouseEvent *ev );
	void mouseMoveEvent( QMouseEvent *ev );
	void mouseReleaseEvent( QMouseEvent *ev );
	void paintEvent( QPaintEvent *ev );
	bool shouldPaintWindow( KWin::WindowInfo *info );
	void timerEvent(QTimerEvent*);

	void testOnAnimationWidget();

	QPixmap *paintNewWindow(const QGuardedPtr<Task> t);

	void paintWindow(QPainter &p, const QGuardedPtr<Task>, double scale = 1, bool onDesktop=true);
	void paintWindowPlain(QPainter &p, const QGuardedPtr<Task>, double scale = 1, bool onDesktop=true);
	void paintWindowIcon(QPainter &p, const QGuardedPtr<Task>, double scale = 1, bool onDesktop=true);
	void paintWindowPixmap(QPainter &p, const QGuardedPtr<Task>, double scale = 1, bool onDesktop=true);
	void paintShadowPixmap(QPixmap &);

	int m_desk;
	KSharedPixmap *m_bgPixmap;
	bool m_bgDirty;
	QPixmap *m_bgSmallPixmap;
	static QPixmap *m_bgCommonSmallPixmap;
	static bool m_isCommon;

	QColor getHighlightedDesktopColor();
	QColor getSelectedDesktopColor();
	bool m_hadMouse; // is true if hasMouse() was true at the last check.
	KPagerToolTip * m_tooltip;


private:
	QColor getPlainDesktopColor();

	QPoint pressPos;
    QPoint mousePos;

	bool justdragging;
	bool candecode;

	QTimer m_dragSwitchTimer; // for the case that somebody drags from outside and wants to switch the desktops
	int m_dragTaskMenuTimer; // for the case that somebody drags and wants to move it to the task directly
	QWidget * m_dragtaskmenu;

	KPager2 * m_pager;
    bool                        discardNextMouseEvent;
	QTimer m_attentionTimer;
	int m_attentionState;

	QPixmap m_pixmap;

private slots:
	void slotDeleteDragTaskMenu();
	void slotAttentionTimerFired();



public:
  static const bool c_defShowName;					// print text 'Desktop 1'
  static const bool c_defShowNumber;				// print text '1'
  static const bool c_defShowBackground;			// show desktop background image
  static const bool c_defShowWindows;				// show window miniatures
  static const bool c_defWindowDragging;			// allow moving windows on pager
  static const bool c_defShowDragMoving;			// show realtime movement on real desktop when moving windows on pager
  static const int c_defAnimation;					// animation type of the miniatures
  static const bool c_defShowGradient;				// show an ugly gradient
  static const int c_defDesktopBackgroundColor;		// backgroundcolor of pager desktops if desktop background not shown
  static const int c_defShadowPixmap;				// without function, later: nice pixmap effects - inner shadows...
  static const WindowDrawMode c_defWindowDrawMode;	// if windows drawn: frames, icons, or thumbnails?
  static const WindowTransparentMode c_defWindowTransparentMode; // if windows drawn: transparent or fullfill?
  static const bool c_defBevelledSelection;			// no function right now, later: smooth bevel instead of whole desktop marked
  static const bool c_defToolTips;
  static const bool c_defShowShadowPixmap;

signals:
	void aboutToRepaint();


};

#endif
