//
// C++ Implementation: kpagerrmbmenu
//
// Description:
//
//
// Author: Sebastian Wolff <>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include <assert.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kglobalsettings.h>
#include <kiconloader.h>
#include <kimageeffect.h>
#include <klocale.h>
#include <kwinmodule.h>
#include <kwin.h>

#include <qimage.h>
#include <qpixmap.h>
#include <qpainter.h>

#include "kpagerrmbmenu.h"
//#include "kpagerrmbmenu.moc"
#include "taskbar.h"
#include "kpagertaskcontainer.h"
#include "kpager.h"
#include "config.h"
#include "kpagerrunwidget.h"

/*
  Auxiliary class to provide fancy menu items with faded strings
 */
#define BUTTON_MIN_HEIGHT (THUMBNAIL_HEIGHT+2)
#define BUTTON_HEIGHT (THUMBNAIL_HEIGHT+4)
#define BUTTON_MAX_WIDTH 300
#define BUTTON_MIN_WIDTH (THUMBNAIL_WIDTH+4 - 50)
class KPagerMenuItem : public QCustomMenuItem
{
public:
	KPagerMenuItem( const QString& s)
		: blendGradient(), string( s )
	{
	}
	~KPagerMenuItem(){}

	void setFont(const QFont & f)
	{
		font=f;
	}

	void paint( QPainter* p, const QColorGroup& cg, bool act, bool /*enabled*/, int x, int y, int w, int h )
	{
		if ( QFontMetrics( font ).width( string ) > w)
		{
			bool reverse = QApplication::reverseLayout();
			QPixmap * pm = new QPixmap(w,h);
			// copy the already drawn content to our own paintdevice:
			bitBlt(pm,0,0,  p->device(),x,y,w,h,Qt::CopyROP);
			QPainter * painter = new QPainter(pm);
			QRect tr = QRect( x, y-2, w, h);
			int textFlags = AlignVCenter | SingleLine;
			textFlags |= reverse ? AlignRight : AlignLeft;
			if ( blendGradient.isNull() || blendGradient.size() != QSize(w,h) )
			{
				QPixmap bgpm( QSize(w,h) );
				QPainter bgp( &bgpm );
				bgpm.fill( black );
				if ( ! reverse )
				{
					QImage gradient = KImageEffect::gradient( QSize( 30, h ), QColor( 0,0,0 ),
					    QColor( 255,255,255 ), KImageEffect::HorizontalGradient );
					bgp.drawImage( w - 30, 0, gradient );
				} else {
					QImage gradient = KImageEffect::gradient( QSize( 30, h ), QColor( 255,255,255 ),
						QColor( 0,0,0 ), KImageEffect::HorizontalGradient );
					bgp.drawImage( 0, 0, gradient );
				}

				blendGradient = bgpm.convertToImage();
			}

			// draw text into overlay pixmap
			QPixmap tpm( *pm );
			QPainter tp( &tpm );

			tp.setFont ( font );
			tp.setPen( act ? cg.highlightedText() : cg.buttonText() );

			// draw text
			tp.drawText( tr, textFlags, string );

			// blend text into background image
			QImage img = pm->convertToImage();
			QImage timg = tpm.convertToImage();
			KImageEffect::blend( img, timg, blendGradient, KImageEffect::Red );

			pm->convertFromImage( img );
			painter->end();
			p->drawPixmap(x,y, *pm);

			delete painter;
			delete pm;
		}
		else
		{
			p->setFont ( font );
			p->drawText( x, y, w, h, AlignLeft | AlignVCenter | DontClip | ShowPrefix, string );
		}
	}

	QSize sizeHint()
	{
		QSize s = QFontMetrics( font ).size( AlignLeft | AlignVCenter | ShowPrefix | DontClip,  string );
		if (s.width() > BUTTON_MAX_WIDTH) s.setWidth(BUTTON_MAX_WIDTH);
		return s;
	}
private:
	QImage blendGradient;
	QString string;
	QFont font;
};


extern KAboutData * m_aboutdata; // see main.cpp


KPagerRMBMenu::KPagerRMBMenu( Task* task, int desk, KPager2* parent, const char* name )
	: KPopupMenu( parent, name )
	, tasks(0)
{
	m_pager = parent;
	m_sender_desk = desk;
	m_taskbar = 0;
	m_menu1 = 0;
	m_menu2 = 0;
	m_id_rmbmenu = -1;
	m_rmbmenu = 0;
	discardNextMouseEvent=false;
	m_popuppos=QPoint(0,0);

	m_actionCollection = new KActionCollection(this);
#ifndef KPAGER_IS_APPLET
    m_prefs_action = KStdAction::preferences(m_pager, SLOT(configureDialog()), actionCollection());
#endif
#ifdef KPAGER_IS_APPLET
    m_prefs_action = KStdAction::preferences(m_pager, SLOT(configureDialog()), actionCollection());
	m_prefs_action->setText(i18n("&Configure KPager2..."));
#endif


	m_prefs_desktop_action = new KAction(i18n("&Configure Virtual Desktops..."),SmallIcon("desktop"), KShortcut(), m_pager, SLOT(configureDesktopsDialog()), actionCollection());
	//m_about_action = KStdAction::aboutApp(m_pager, SLOT(aboutDialog()), actionCollection());
	m_about_action = new KAction(i18n("&About")+" "+m_aboutdata->programName()+"...", SmallIcon("kpager"), KShortcut(), m_pager, SLOT(aboutDialog()), actionCollection());
	m_help_action = new KAction(i18n("&Help"),SmallIcon("help"), KShortcut(), m_pager, SLOT(helpDialog()), actionCollection());
#ifndef KPAGER_IS_APPLET
    m_quit_action = KStdAction::quit(m_pager, SLOT(slotQuit()), actionCollection());
#endif
	fillMenu( task, m_pager->pagerTaskManager()->taskManager());
	setAcceptDrops(true);
	connect(this,SIGNAL(activated(int)),this,SLOT(slotHighlightedActivated(int)));
	connect(this,SIGNAL(highlighted(int)),this,SLOT(slotHighlightedActivated(int)));
	connect(this,SIGNAL(aboutToHide()),this,SLOT(slotAboutToHide()));
}

KPagerRMBMenu::~KPagerRMBMenu()
{
	if (m_taskbar) delete m_taskbar;
	if (m_menu1) delete m_menu1;
	if (m_menu2) delete m_menu2;
	if (m_rmbmenu) delete m_rmbmenu;
}

#include <qlayout.h>

void KPagerRMBMenu::fillMenu( Task* t, TaskManager* manager)
{
	{
		// this->insertTearOffHandle(); // would be nice to have it... // won't work since we delete the menu after an item was clicked. TODO: Additionally adding new items won't work correctly (positioning in menu, icons not displayed)

		// menu part to manage the hit window:
		if (t)
		{
			fillMenu1(t,manager);

			QString s = t->visibleNameWithState().replace("&", "&&");
			QFont font (KGlobalSettings::menuFont());
			if (QFontMetrics( font ).width( s )>BUTTON_MAX_WIDTH)
			{
				// shorten the title string and  insert "..."
				QString s1,s2;
				QString s3 = "...";
				s1 = s.left(  s.length()/2 );
				s2 = s.right( s.length()-s.length()/2 );
				while (QFontMetrics( font ).width( s1 + s3 + s2 )>BUTTON_MAX_WIDTH)
				{
					s1 = s1.left(s1.length()-1);
					if ((QFontMetrics( font ).width( s1 + s3 + s2 )>BUTTON_MAX_WIDTH))
					{
						s2 = s2.right(s2.length()-1);
					}
				}
				s = s1 + s3 + s2;
			}
			insertItem(  KWin::icon(t->window(),16,16,true), s, (QPopupMenu*)m_menu1);
			insertSeparator();
		}

		// all windows on this desktop:
		// first check if there are any windows on this desktop (including sticky windows)
		int count = 0;
		QValueList<WId>::ConstIterator it;
		for ( it = m_pager->kwin()->stackingOrder().begin();
			it != m_pager->kwin()->stackingOrder().end(); ++it )
		{
			KWin::WindowInfo info = KWin::windowInfo(*it);
			if (!info.valid()) continue;
			int d = info.desktop();
			if ( (info.onAllDesktops() || d==0 || d==m_sender_desk) && !(info.state() & NET::SkipPager)  &&  !((info.windowType(NET::NormalMask) == NET::Dock || info.windowType(NET::NormalMask) == NET::Menu)) )
			{
				count++;
//				m_winsOnDesk.append(*it); // don't do it here, do it when it is needed! (might be changed, if so we want to know!)
//				printf("%s\n",info.name().latin1()); // check here if there is still a kicker bug in KDE3.3
//				workaround:
				if (info.name()=="kicker") count--;
			}
		}
		if (count >= 2)
		{
			fillMenu2(manager);
			insertItem(  i18n("All Windows on Desktop"), (QPopupMenu*)m_menu2);
			insertSeparator();
		}

		// taskmanager menu part:
		if (KPagerConfigDialog::m_showTaskMenu)
		{
			if (m_taskbar) delete m_taskbar;
			QGuardedPtr<TaskBar> tb;
			// tb = taskBar();
			tb = new TaskBar(pager(),this,m_sender_desk);
			if (tb)
			{
				tb->desktopChanged(m_sender_desk);
				tb->configure();
				if (tb->containerCount())
				{
					// insertItem(tb); // already inserted by taskbar itself
					insertSeparator();
					setCheckable(false);
				}
				else
				{
					delete tb;
					tb = 0;
				}
			}
			m_taskbar = tb;
		}

		// standard part:
		m_prefs_action->plug(this);
		m_prefs_desktop_action->plug(this);
		m_about_action->plug(this);
		m_help_action->plug(this);
#ifndef KPAGER_IS_APPLET
		m_quit_action->plug(this);
#endif

		// 'run command' part:
		if (KPagerConfigDialog::m_showLauncher)
		{
			insertSeparator();
			if (!KPagerRunWidget::runWidget()) (void) new KPagerRunWidget(m_sender_desk,this);
			insertItem(KPagerRunWidget::runWidget());
			KPagerRunWidget::runWidget()->setHidden(false);
			connect(KPagerRunWidget::runWidget(), SIGNAL(actionPerformed()), this, SLOT(slotTaskRMBMenuActivated()));
		}
	}

	// hack fue to QPopupMenu limitations:
	// call sizeHint() and we will know if we have to use TaskGrouping, else the indicator 'columns' will still be '1' even if it is greater
	if (m_taskbar)
	{
//printf("count %d\tcols %d\theight %d\n", this->count(), columns(), height());
		sizeHint();
		emit aboutToShow(); // call TaskBar::menuAboutToShow()
//printf("count %d\tcols %d\theight %d\n", this->count(), columns(), height());
//		if (columns()>1) m_taskbar->reGroup();

//		sizeHint();
//printf("count %d\tcols %d\theight %d\n", this->count(), columns(), height());
	}
}

void KPagerRMBMenu::fillMenu1( Task* t, TaskManager* manager )
{
	if (m_menu1) delete m_menu1;
	m_menu1 = new QPopupMenu();

	int id;
	m_menu1->setCheckable( true );

	id = m_menu1->insertItem( i18n( "Mi&nimize" ), t, SLOT( iconify() ) );
	m_menu1->setItemEnabled( id, !t->isIconified() );
	id = m_menu1->insertItem( i18n( "Ma&ximize" ), t, SLOT( maximize() ) );
	m_menu1->setItemEnabled( id, !t->isMaximized() );
	id = m_menu1->insertItem( i18n( "&Restore" ), t, SLOT( restore() ) );
	m_menu1->setItemEnabled( id, t->isIconified() || t->isMaximized() );

	m_menu1->insertSeparator();

	id = m_menu1->insertItem( i18n( "&Shade" ), t, SLOT( toggleShaded() ) );
	m_menu1->setItemChecked( id, t->isShaded() );
	id = m_menu1->insertItem( i18n( "&Always on Top" ), t, SLOT( toggleAlwaysOnTop() ) );
	m_menu1->setItemChecked( id, t->isAlwaysOnTop() );

	m_menu1->insertSeparator();

	id = m_menu1->insertItem( SmallIcon( "fileclose" ), i18n( "&Close" ), t, SLOT( close() ) );

	if ( manager->numberOfDesktops() > 1 )
	{
		m_menu1->insertSeparator();

		id = m_menu1->insertItem( i18n("To &Desktop"), makeDesktopsMenu( t, manager ) );
		id = m_menu1->insertItem( i18n( "&To Current Desktop" ), t, SLOT( toCurrentDesktop() ) );
		m_menu1->setItemEnabled( id, !t->isOnCurrentDesktop() );
	}
}

void KPagerRMBMenu::fillMenu2( TaskManager* manager )
{
// all windows -> cascade, unclutter | maximize, restore, minimize | to desktop, to current desktop
// all transients -> to desktop, to current desktop
	if (m_menu2) delete m_menu2;
	m_menu2 = new QPopupMenu();

	int id;
	m_menu2->setCheckable( true );

	id = m_menu2->insertItem( i18n( "Unclutter Windows" ), this, SLOT( unclutterWins()));
	m_menu2->setItemEnabled( id, m_sender_desk==manager->currentDesktop());
	id = m_menu2->insertItem( i18n( "Cascade Windows" ), this, SLOT( cascadeWins()));
	m_menu2->setItemEnabled( id, m_sender_desk==manager->currentDesktop());
	m_menu2->insertSeparator();

	QValueList<WId> l = getWinList(m_sender_desk);
	QValueList<WId>::ConstIterator it;
	bool enable;

	id = m_menu2->insertItem( i18n( "Mi&nimize All" ), this, SLOT( minimizeWins() ) );
	enable = false;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (!t) continue;
		if (!KWin::windowInfo(t->window()).valid()) continue;
		if( !t->isMinimized() )
		{
			enable = true;
			break;
		}
	}
	m_menu2->setItemEnabled(id,enable);
	id = m_menu2->insertItem( i18n( "Ma&ximize All" ), this, SLOT( maximizeWins() ) );
	enable = false;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (!t) continue;
		if (!KWin::windowInfo(t->window()).valid()) continue;
		if( !t->isMaximized() )
		{
			enable = true;
			break;
		}
	}
	m_menu2->setItemEnabled(id,enable);
	id = m_menu2->insertItem( i18n( "&Restore All" ), this, SLOT( restoreWins() ) );
	enable = false;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (!t) continue;
		if (!KWin::windowInfo(t->window()).valid()) continue;
		if( (t->isMinimized()) || t->isMaximized() )
		{
			enable = true;
			break;
		}
	}
	m_menu2->setItemEnabled(id,enable);
	m_menu2->insertSeparator();

	id = m_menu2->insertItem( SmallIcon( "fileclose" ), i18n( "&Close All" ), this, SLOT( closeWins() ) );

	if ( manager->numberOfDesktops() > 1 )
	{
		m_menu2->insertSeparator();

		id = m_menu2->insertItem( i18n("To &Desktop"), makeDesktopsMenu2( manager ) );
		id = m_menu2->insertItem( i18n( "&To Current Desktop" ), this, SLOT( toCurrentDesktopWins() ) );
		m_menu2->setItemEnabled( id, m_sender_desk != manager->currentDesktop() );
	}
}

QValueList<WId> KPagerRMBMenu::getWinList(int desk)
{
	QValueList<WId> ret = QValueList<WId>();

	QValueList<WId>::ConstIterator it;
	for ( it = m_pager->kwin()->stackingOrder().begin();
		it != m_pager->kwin()->stackingOrder().end(); ++it )
	{
		KWin::WindowInfo info = KWin::windowInfo(*it);
		if (!info.valid()) continue;
		int d = info.desktop();
		if ( (info.onAllDesktops() || d==0 || d==desk) && !(info.state() & NET::SkipPager)  &&  !((info.windowType(NET::NormalMask) == NET::Dock || info.windowType(NET::NormalMask) == NET::Menu)) )
		{
//			printf("%s\n",info.name().latin1()); // check here if there is still a kicker bug in KDE3.3
//			workaround:
			if (info.name()=="kicker") qDebug("KPager2: Warning: bug in kicker - Kicker doesn't have NET::skipPager set."); else
			ret.append(*it);
		}
	}
	return ret;
}

QPopupMenu* KPagerRMBMenu::makeDesktopsMenu( Task* t, TaskManager* manager )
{
	QPopupMenu* m = new QPopupMenu( this );
	m->setCheckable( true );

	int id = m->insertItem( i18n("&All Desktops"), t, SLOT( toDesktop(int) ) );
	m->setItemParameter( id, 0 ); // 0 means all desktops
	m->setItemChecked( id, t->isOnAllDesktops() );

	m->insertSeparator();

	for( int i = 1; i <= manager->numberOfDesktops(); i++ ) {
		QString name = QString( "&%1 %2" ).arg( i ).arg( manager->desktopName( i ) );
		id = m->insertItem( name, t, SLOT( toDesktop(int) ) );
		m->setItemParameter( id, i );
		m->setItemChecked( id, !t->isOnAllDesktops() && t->desktop() == i );
	}

	return m;
}

QPopupMenu* KPagerRMBMenu::makeDesktopsMenu2(TaskManager* manager )
{
	QPopupMenu* m = new QPopupMenu( this );
	m->setCheckable( true );

	int id = m->insertItem( i18n("&All Desktops"), this, SLOT( toDesktopWins(int) ) );
	m->setItemParameter( id, 0 ); // 0 means all desktops

	m->insertSeparator();

	for( int i = 1; i <= manager->numberOfDesktops(); i++ ) {
		QString name = QString( "&%1 %2" ).arg( i ).arg( manager->desktopName( i ) );
		id = m->insertItem( name, this, SLOT( toDesktopWins(int) ) );
		m->setItemParameter( id, i );
		m->setItemChecked( id, m_sender_desk == i );
	}

	return m;
}


void KPagerRMBMenu::unclutterWins()
{
	kapp->dcopClient()->send("kwin", "KWinInterface", "unclutterDesktop()", QString("%1").arg(m_sender_desk));
}
void KPagerRMBMenu::cascadeWins()
{
	kapp->dcopClient()->send("kwin", "KWinInterface", "cascadeDesktop()", QString("%1").arg(m_sender_desk));
}
void KPagerRMBMenu::minimizeWins()
{
	QValueList<WId> l = getWinList(m_sender_desk);
	QValueList<WId>::ConstIterator it;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (t)
		{
			t->iconify();
		}
	}
}
void KPagerRMBMenu::maximizeWins()
{
	QValueList<WId> l = getWinList(m_sender_desk);
	QValueList<WId>::ConstIterator it;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (t)
		{
			t->maximize();
		}
	}
}
void KPagerRMBMenu::restoreWins()
{
	QValueList<WId> l = getWinList(m_sender_desk);
	QValueList<WId>::ConstIterator it;
	for ( it = l.begin(); it != l.end(); ++it )
	{
//		Task* t = (mTaskbar!=0) 
//			? m_pager->pagerTaskManager()->findTaskMan(*it)
//			: m_pager->pagerTaskManager()->findTaskPager(*it);
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (t)
		{
			t->restore();
		}
	}
}
void KPagerRMBMenu::closeWins()
{
	QValueList<WId> l = getWinList(m_sender_desk);
	QValueList<WId>::ConstIterator it;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (t)
		{
			t->close();
		}
	}
}
void KPagerRMBMenu::toDesktopWins(int i)
{
	QValueList<WId> l = getWinList(m_sender_desk);
	QValueList<WId>::ConstIterator it;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (t)
		{
			t->toDesktop(i);
		}
	}
}
void KPagerRMBMenu::toCurrentDesktopWins()
{
	QValueList<WId> l = getWinList(m_sender_desk);
	QValueList<WId>::ConstIterator it;
	for ( it = l.begin(); it != l.end(); ++it )
	{
		Task* t = m_pager->pagerTaskManager()->findTaskMan(*it); //findTaskPager(*it);
		if (t)
		{
			t->toCurrentDesktop();
		}
	}
}

void KPagerRMBMenu::dragEnterEvent(QDragEnterEvent*e)
{
	//TODO dragswitch events (switch to task when drag object hovered over one item for a while)
//printf("dragEnterEvent\n");
	KPopupMenu::dragEnterEvent(e);
}
void KPagerRMBMenu::dragMoveEvent(QDragMoveEvent*e)
{
	//TODO dragswitch events (switch to task when drag object hovered over one item for a while)
//printf("dragMoveEvent\n");
	KPopupMenu::dragMoveEvent(e);
}
void KPagerRMBMenu::dragLeaveEvent(QDragLeaveEvent*e)
{
	//TODO dragswitch events (switch to task when drag object hovered over one item for a while)
//printf("dragLeaveEvent\n");
	KPopupMenu::dragLeaveEvent(e);
}

// This is the code that gives us the proper behavior
// when a popup menu is displayed and we are clicked:
// close the menu, and don't reopen it immediately.
// It's copied from QToolButton. Unfortunately Qt is lame
// as usual and makes interesting stuff private or
// non-virtual, so we have to copy code.
bool KPagerRMBMenu::eventFilter( QObject *o, QEvent *e )
{
    switch ( e->type() ) {
    case QEvent::MouseButtonPress:
    case QEvent::MouseButtonDblClick:
	{
	    QMouseEvent *me = (QMouseEvent*)e;
	    QPoint p = me->globalPos();
	    if ( QApplication::widgetAt( p, TRUE ) == this )
		discardNextMouseEvent = true;
	}
	break;
    default:
	break;
    }
    return QPopupMenu::eventFilter( o, e );
}

bool KPagerRMBMenu::event(QEvent * e)
{
return KPopupMenu::event(e);
/*
	if (e)
	{
		if (e->type()==QEvent::MouseButtonRelease)
		{
			mouseReleaseEvent((QMouseEvent*)e);
			return true;
		}
		else return KPopupMenu::event(e);
	}
	else return KPopupMenu::event(e);
*/
}
void KPagerRMBMenu::mouseReleaseEvent(QMouseEvent * e)
{
	if( discardNextMouseEvent )
	{
		discardNextMouseEvent = false;
		return;
	}

	// close previouly opened menus
	if (m_id_rmbmenu>=0 || m_rmbmenu)
	{
		delete m_rmbmenu;
		m_rmbmenu = 0;
		m_id_rmbmenu = -1;
	}
	// check if we can open a second one
	if (e)
	{
		int id = idAt(e->pos());
		bool iscompetent = true;
		if (e->button()==Qt::LeftButton || e->button()==Qt::MidButton) iscompetent=false;
		// check if there is a container->
		KPagerTaskContainer* c = 0;
		if (iscompetent)
		if (taskBar())
		{
			TaskContainerList l = taskBar()->containerList();
			for ( TaskContainer* it = l.first(); it; it=l.next() )
			{
				KPagerTaskContainer* cit = (KPagerTaskContainer*)it;
				if (cit->id()==id)
				{
					c = cit;
				}
			}
		}
		else iscompetent=false;
		if (!c) iscompetent=false; // not found

		if (iscompetent)
		{
			// open a new popup menu for the specific task item
			m_rmbmenu = c->popupMenu(TaskBar::ShowOperationsMenu);
			if (m_rmbmenu)
			{
				m_id_rmbmenu = id;
				bool b = connect(m_rmbmenu, SIGNAL(actionPerformed()), this, SLOT(slotTaskRMBMenuActivated()));
			}
		}
		else KPopupMenu::mouseReleaseEvent(e);
	}
	else KPopupMenu::mouseReleaseEvent(e);
}

void KPagerRMBMenu::slotHighlightedActivated(int id)
{
	if (id != m_id_rmbmenu)
	{
		m_id_rmbmenu = -1;
		delete m_rmbmenu;
		m_rmbmenu = 0;
	}
}

void KPagerRMBMenu::slotAboutToHide()
{
	if (m_rmbmenu) delete m_rmbmenu;
	m_rmbmenu = 0;
	m_id_rmbmenu = -1;
}

void KPagerRMBMenu::slotTaskRMBMenuActivated()
{
	hide();
}

