//
// C++ Interface: kpagerrmbmenu
//
// Description: 
//
//
// Author: Sebastian Wolff <>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//



#ifndef __kpagerrmbmenu_h__
#define __kpagerrmbmenu_h__

#include "version.h"

#include <qguardedptr.h>
#include <qvaluelist.h>
#include <kaction.h>
#include <kpopupmenu.h>
#include "kpagertaskmanager.h"
#include "taskbar.h"
#include "kpager.h"

class KPager2;

class KPagerRMBMenu : public KPopupMenu
{
	Q_OBJECT
	
public:
	KPagerRMBMenu( Task* tasks, int desk, KPager2 *parent = 0, const char *name = 0 );
	KPagerRMBMenu(){}
	~KPagerRMBMenu();
    KActionCollection * actionCollection() const {return m_actionCollection;};
	KPager2 * pager() {return m_pager;};
	int columns(){return QPopupMenu::columns();}
	void setPopupPos(QPoint pos) {m_popuppos = pos;} // has to be called before exec() or popup() 
	QPoint popupPos(){return m_popuppos;}
	
	
private:
	QGuardedPtr<TaskBar> taskBar() {return m_taskbar;}
	
	void fillMenu1( Task* t, TaskManager* manager ); // fills only task specific items
	void fillMenu2( TaskManager* manager ); // fills actions for all windows on the current desktop
	void fillMenu ( Task* t, TaskManager* manager); // fills additionally to task specific items KPager items 
	QPopupMenu* makeDesktopsMenu( Task* t, TaskManager* manager ); // side menu for "Send to desktop..." 
	QPopupMenu* makeDesktopsMenu2(TaskManager* manager ); // side menu for "Send to desktop..." (for fillmenu2)
	
	QValueList<WId> getWinList(int desk);
	
	// for dragswitches:
	virtual void dragEnterEvent(QDragEnterEvent*);
	virtual void dragMoveEvent(QDragMoveEvent*);
	virtual void dragLeaveEvent(QDragLeaveEvent*);
	QPoint m_lastDragPos;
	
	// for a second rmb menu for each task:
	virtual bool eventFilter( QObject *o, QEvent *e );
	virtual void mouseReleaseEvent(QMouseEvent*);
	virtual bool event(QEvent*);
	bool discardNextMouseEvent;
	QPopupMenu * m_rmbmenu;
	int m_id_rmbmenu;
	
private slots:
	// these slots refer to the menu 'for all windows on that desktop' 
	void unclutterWins();
	void cascadeWins();
	void minimizeWins();
	void maximizeWins();
	void restoreWins();
	void closeWins();
	void toDesktopWins(int);
	void toCurrentDesktopWins();
	
	// for a second rmb menu for each task:
	void slotHighlightedActivated(int); // closes and deletes the second rmb menu
	void slotAboutToHide();
	void slotTaskRMBMenuActivated();

private:
	TaskList* tasks;
	
	KActionCollection * m_actionCollection;
	KAction *m_quit_action;
	KAction *m_prefs_action;
	KAction *m_about_action;
	KAction *m_help_action;
	KAction *m_prefs_desktop_action;
	QGuardedPtr<TaskBar> m_taskbar;
	KPager2 * m_pager;
	int m_sender_desk;
	
	QGuardedPtr<QPopupMenu>  m_menu1; // submenu filled by fillmenu1()
	QGuardedPtr<QPopupMenu>  m_menu2; // submenu filled by fillmenu2()
	QPoint m_popuppos;

};

#endif
