/*****************************************************************

Copyright (c) 2004 Sebastian Wolff
Copyright (c) 2000 Matthias Elter (runapplet.cpp)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <assert.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qstringlist.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qhbox.h>

#include <kapplication.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kconfig.h>
#include <kcombobox.h>
#include <kurifilter.h>
#include <kdialog.h>
#include <krun.h>
#include <kmessagebox.h>
#include <kwin.h>

#include "config.h"
#include "kpagerrunwidget.h"

#ifdef KPAGER_IS_APPLET
extern KConfig * kpagerglobalconfig;
#endif

KPagerRunWidget * RUNWIDGET = 0;

KPagerRunWidget::KPagerRunWidget(int desk, QWidget *parent, const char *name)
  : QWidget(parent, name)
{
	assert(RUNWIDGET==0);
	if (RUNWIDGET==0)
	{
		RUNWIDGET = this;
	}

	_desk = desk;

	setFocusPolicy(StrongFocus);

    // setup label
    _label = new QLabel(i18n("Run command:"), this);
//    QFont f(_label->font());
//    f.setPixelSize(12);
	QFont f = KGlobalSettings::toolBarFont();
    _label->setFixedHeight(QFontMetrics(f).height()+2);
    _label->setFont(f);

    // setup execute button
    _btn = new QPushButton(this);
	_btn->setIconSet(KGlobal::instance()->iconLoader()->loadIcon( "run", KIcon::NoGroup, KIcon::SizeSmall ));
	_btn->setFlat(true);
/*
    f = _btn->font();
    f.setPixelSize(12);
    _btn->setFont(f);
*/
    connect(_btn, SIGNAL(clicked()),
	    SLOT(run_command()));

    // setup history combo
    _input = new KHistoryCombo(this);
    _input->setFocus();
    _input->clearEdit();
//    _input->lineEdit()->installEventFilter( this );
    connect(_input, SIGNAL(activated(const QString&)), SLOT(run_command(const QString&)));

    // setup clear button
    _btnClr = new QPushButton(this);
	_btnClr->setIconSet(KGlobal::instance()->iconLoader()->loadIcon( "editclear", KIcon::NoGroup, KIcon::SizeSmall ));
	_btnClr->setFlat(true);
    connect(_btnClr, SIGNAL(clicked()), _input,
	    SLOT(clearEdit()));

	// setup layout:
	QVBoxLayout * m_lay = new QVBoxLayout(this,6);
	m_lay -> addWidget(_label,0);
	QHBoxLayout * m_lay2=new QHBoxLayout();
	m_lay->addLayout(m_lay2,10);
	m_lay2-> addWidget(_btnClr,0);
	m_lay2-> addWidget(_input,10);
	m_lay2-> addWidget(_btn,0);

	// tool tips:
	QToolTip::add(_input,i18n("<qt>Type the command you want to execute or the URL you want to open</qt>"));
	QToolTip::add(_btn,i18n("<qt>Execute the command</qt>"));
	QToolTip::add(_btnClr,i18n("<qt>Clears the input line</qt>"));

	// read config:
#ifndef KPAGER_IS_APPLET
	KConfig *c= kapp->config();
#endif
#ifdef KPAGER_IS_APPLET
	KConfig *c= kpagerglobalconfig;
#endif
    c->setGroup("KPagerRunWidget");

    // restore history and completion list
    QStringList list = c->readListEntry("Completion list");
    _input->completionObject()->setItems(list);
    list = c->readListEntry("History list");
    _input->setHistoryItems(list);
    int mode = c->readNumEntry( "CompletionMode", KGlobalSettings::completionMode() );
    _input->setCompletionMode( (KGlobalSettings::Completion) mode );

    _filterData = new KURIFilterData();

	/*
	// doesn't work:
	setBackgroundMode(X11ParentRelative);
	_label->setBackgroundMode(X11ParentRelative);
	_btn  ->setBackgroundMode(X11ParentRelative);
	_input->setBackgroundMode(X11ParentRelative);
	*/
}

KPagerRunWidget::~KPagerRunWidget()
{
#ifndef KPAGER_IS_APPLET
	KConfig *c= kapp->config();
#endif
#ifdef KPAGER_IS_APPLET
	KConfig *c= kpagerglobalconfig;
#endif
	c->setGroup("KPagerRunWidget");

	// save history and completion list
	QStringList list = _input->completionObject()->items();
	c->writeEntry("Completion list", list);
	list = _input->historyItems();
	c->writeEntry("History list", list);
	c->writeEntry( "CompletionMode", (int) _input->completionMode() );
	c->sync();

	delete _filterData;
	RUNWIDGET = 0;
}

KPagerRunWidget * KPagerRunWidget::runWidget()
{
	return RUNWIDGET;
}

/*
void KPagerRunWidget::applyNewConfig()
{
}
*/

/*
bool KPagerRunWidget::eventFilter( QObject *o, QEvent * e)
{
    if ( e->type() == QEvent::MouseButtonRelease ) {
	emit requestFocus();
    }
    return KPanelApplet::eventFilter( o, e );
}

void KPagerRunWidget::setButtonText()
{
	QString t;
	if(width() >= 42)
		t = i18n("Run >");
	else
		t = ">";
	_btn->setText(t);
}
*/

void KPagerRunWidget::run_command()
{
	run_command(_input->currentText());
}
void KPagerRunWidget::run_command(const QString& command)
{
	_input->clearEdit();
	bool add;
	if (run_command(command, _desk, _filterData, add)) emit actionPerformed();
	if (add) _input->addToHistory(command);
}
bool KPagerRunWidget::run_command(const QString& command,int _desk,KURIFilterData *_filterData,bool & addToList)
{
    QString exec;

    kapp->propagateSessionManager();

	addToList = true;
	
    _filterData->setData( command.stripWhiteSpace() );
    QStringList filters;
    filters << "kurisearchfilter" << "kshorturifilter";
    KURIFilter::self()->filterURI( *(_filterData), filters );


    QString cmd = (_filterData->uri().isLocalFile() ? _filterData->uri().path():_filterData->uri().url());

    // Nothing interesting. Quit!
    if ( cmd.isEmpty() ){
		KMessageBox::sorry(0L, i18n("You have to enter a command to execute "
				    "or an URL to be opened first."));
		return true;
    }
    else if (cmd == "logout")
	{
	    bool shutdown = kapp->requestShutDown();
	    if( !shutdown )
            {
                // This i18n string is in kdesktop/desktop.cc as well. Maybe we should DCOP to kdesktop instead ?
		KMessageBox::error( 0, i18n("Unable to logout properly.\nThe session manager cannot "
					    "be contacted. You can try to force a shutdown by pressing "
					    "Ctrl+Alt+Backspace. Note, however, that your current "
                                            "session will not be saved with a forced shutdown." ) );
//                emit requestFocus();
            }
		return true;
	}
    else
	{
	    switch( _filterData->uriType() )
		{
		case KURIFilterData::LOCAL_FILE:
		case KURIFilterData::LOCAL_DIR:
		case KURIFilterData::NET_PROTOCOL:
		case KURIFilterData::HELP:
		    {
				if (_desk >= 1 && _desk<=KWin::numberOfDesktops()) // quite dangerous!
				{
					while (KWin::currentDesktop()!=_desk) KWin::setCurrentDesktop(_desk);
				}
		        (void) new KRun( _filterData->uri() );
				return true;
		    }
		case KURIFilterData::EXECUTABLE:
		case KURIFilterData::SHELL:
		    {
		        exec = cmd;
			if( _filterData->hasArgsAndOptions() )
			  cmd += _filterData->argsAndOptions();
			break;
		    }
		case KURIFilterData::UNKNOWN:
		case KURIFilterData::ERROR:
		default:
		    KMessageBox::sorry( 0, i18n("<qt>The program name or command <b>%1</b>\n"
						"cannot be found. Please correct the command\n"
						"or URL and try again</qt>").arg( cmd ) );
			addToList = false; // _input->removeFromHistory( command );
//                    emit requestFocus();
				return true;
		}
	}

	if (_desk >= 1 && _desk<=KWin::numberOfDesktops()) // quite dangerous!
	{
		while (KWin::currentDesktop()!=_desk) KWin::setCurrentDesktop(_desk);
	}
    if (KRun::runCommand( cmd, exec, "" ))
	{
		return true;
	}
    else
	{
	    KMessageBox::sorry( 0, i18n("<qt>Could not run <b>%1</b>.\nPlease correct"
					" the command or URL and try again.</qt>").arg( cmd ) );
		addToList = false; // _input->removeFromHistory( command );
		return true;
	}

    return false;

}
