/*****************************************************************

Copyright (c) 2004 Sebastian Wolff 
Copyright (c) 2000 Matthias Elter (runapplet.h)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __KPAGER_RUNWIDGET_h__
#define __KPAGER_RUNWIDGET_h__

#include "version.h"

#include <qstring.h>
#include <qwidget.h>

class QLabel;
class QHBox;
class QPushButton;
class KHistoryCombo;
class KURIFilterData;

class KPagerRunWidget : public QWidget 
{
    Q_OBJECT

public:
	KPagerRunWidget(int desk, QWidget *parent = 0, const char *name = 0);
	virtual ~KPagerRunWidget();
	static KPagerRunWidget * runWidget();
//	void applyNewConfig();
	static bool run_command(const QString&,int,KURIFilterData *,bool&); // true if performed

protected:
//    void resizeEvent(QResizeEvent*);
//    bool eventFilter( QObject *, QEvent * );

protected slots:
    void run_command();
    void run_command(const QString&);
//    void popup_combo();
//    void setButtonText();

signals:
	void actionPerformed();

private:
    KHistoryCombo  *_input;
    KURIFilterData *_filterData;
    QLabel         *_label;
    QPushButton    *_btn;
    QPushButton    *_btnClr;
    QHBox          *_hbox;
	int            _desk;
};

#endif
