/***************************************************************************
 *   Copyright (C) 2005 by Sebastian Wolff                                 *
 *   wolff3@widget                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kpagersingleswitchbutton.h"
#include <qpainter.h>
#include <qpixmap.h>
#include <qstyle.h>
#include <qtimer.h>
#include <qwidget.h>
#include "kpagerdesktop.h"
 
KPagerSingleSwitchButton::KPagerSingleSwitchButton( QWidget * parent, const char * name ) 
	: QPushButton( parent, name )
{
	init();
}
KPagerSingleSwitchButton::KPagerSingleSwitchButton( const QString & text, QWidget * parent, const char * name) : QPushButton( text, parent, name )
{
	init();
}
KPagerSingleSwitchButton::KPagerSingleSwitchButton( const QIconSet & icon, const QString & text, QWidget * parent, const char * name ) : QPushButton ( icon, text, parent, name  )
{
	init();
}
void KPagerSingleSwitchButton::init()
{
	setBackgroundMode(X11ParentRelative);
	setAcceptDrops(true);
	// to let dragevents from other apps switch desktops
	connect(&m_dragSwitchTimer, SIGNAL( timeout() ), this, SIGNAL( dragSwitch() ) );
}

void KPagerSingleSwitchButton::drawButton( QPainter *paint )
{
	int diw = 0;
	if ( isDefault() || autoDefault() ) {
		diw = style().pixelMetric(QStyle::PM_ButtonDefaultIndicator, this);

		if ( diw > 0 ) {
			if (backgroundMode() == X11ParentRelative) {
				erase( 0, 0, width(), diw );
				erase( 0, 0, diw, height() );
				erase( 0, height() - diw, width(), diw );
				erase( width() - diw, 0, diw, height() );
			} else if ( parentWidget() && parentWidget()->backgroundPixmap() ){
		// pseudo tranparency
				paint->drawTiledPixmap( 0, 0, width(), diw,
										*parentWidget()->backgroundPixmap(),
										x(), y() );
				paint->drawTiledPixmap( 0, 0, diw, height(),
										*parentWidget()->backgroundPixmap(),
										x(), y() );
				paint->drawTiledPixmap( 0, height()-diw, width(), diw,
										*parentWidget()->backgroundPixmap(),
										x(), y() );
				paint->drawTiledPixmap( width()-diw, 0, diw, height(),
										*parentWidget()->backgroundPixmap(),
										x(), y() );
			} else {
				paint->fillRect( 0, 0, width(), diw,
								 colorGroup().brush(QColorGroup::Background) );
				paint->fillRect( 0, 0, diw, height(),
								 colorGroup().brush(QColorGroup::Background) );
				paint->fillRect( 0, height()-diw, width(), diw,
								 colorGroup().brush(QColorGroup::Background) );
				paint->fillRect( width()-diw, 0, diw, height(),
								 colorGroup().brush(QColorGroup::Background) );
			}

		}
	}

	QStyle::SFlags flags = QStyle::Style_Default;
	if (isEnabled())
		flags |= QStyle::Style_Enabled;
	if (hasFocus())
		flags |= QStyle::Style_HasFocus;
	if (isDown())
		flags |= QStyle::Style_Down;
	if (isOn())
		flags |= QStyle::Style_On;
	if (! isFlat() && ! isDown())
		flags |= QStyle::Style_Raised;
	if (isDefault())
		flags |= QStyle::Style_ButtonDefault;

	if (isDown() || hasMouse()) // else transparent
		style().drawControl(QStyle::CE_PushButton, paint, this, rect(), colorGroup(), flags);
	drawButtonLabel( paint );

	//lastEnabled = isEnabled();
}

void KPagerSingleSwitchButton::paintEvent( QPaintEvent* e )
{
	QPushButton::paintEvent(e);
	
	/*
	// get background pixmap for transparency
	// this is necessary since x11parentrelative doesn't work somehow!!! 
	QPixmap pix2 = QPixmap(width(),height());
	if (pix2.isNull()) return;
	if (parent() && parent()->inherits("QWidget"))
	{
		QPoint pos = geometry().topLeft();
		
		// get the parents backgroundPixmap
		QPixmap * bpm;
		if (((QWidget*)parent())->backgroundPixmap()) 
			bpm = new QPixmap(*((QWidget*)parent())->backgroundPixmap()); 
		else 
			bpm = new QPixmap();
		
		// handle some exceptions:
		// (a) there is no background pixmap (eg. if kicker is neither transparent nor uses a background image)
		if (bpm->isNull())
		{
			// use the parent's backgroundcolor 
			bpm->resize(((QWidget*)parent())->size());
			bpm->fill(((QWidget*)parent())->paletteBackgroundColor());
		}
		// (b) the background pixmap is smaller than the parent which will give us some pixel errors
		// (eg. if kicker is using a background image)
		else if (bpm->width()<((QWidget*)parent())->width() || bpm->height()<((QWidget*)parent())->height())
		{
			// stretch the backgroundpixmap by combining all pieces 
			QSize size = bpm->size();
			// resize
			bpm->resize(((QWidget*)parent())->size());
			// fill the added pixels:
			// 1st in x direction
			for (int i=1;i*size.width()<bpm->width();i++)
			{
				bitBlt(bpm,i*size.width(),0, bpm,0,0,size.width(),size.height());
			}
			// 2nd in y direction
			for (int i=1;i*size.height()<bpm->height();i++)
			{
				bitBlt(bpm,0,i*size.height(), bpm,0,0,bpm->width(),size.height());
			}
		}
		
		// map the parent's backgroundpixmap to our own widget
		bitBlt(&pix2,0,0, bpm,pos.x(),pos.y(),width(),height());
		delete bpm;
	}
	
	if there is not parent we would do an invalid painting operation. We !KNOW! that there is the parent, otherwise we don't do anything. Hence: comment the following 
	else 
	{
//		erase(); does not work properly -. leave it out! 
	bitBlt(&pix2,0,0, this,0,0,width(),height());
}

		
	// draw button 
	QPainter p2(&pix2);
	drawButton(&p2);
	p2.end();

	// copy the pixmap to the widget 
	bitBlt(this,0,0, &pix2,0,0,width(),height());
	*/
}


void KPagerSingleSwitchButton::dragEnterEvent(QDragEnterEvent *ev)
{
	m_dragSwitchTimer.start( 3000, false );

	QPushButton::dragEnterEvent(ev);
}

void KPagerSingleSwitchButton::dragLeaveEvent(QDragLeaveEvent *ev)
{
	m_dragSwitchTimer.stop();
	QPushButton::dragLeaveEvent(ev);
}

void KPagerSingleSwitchButton::dropEvent(QDropEvent *ev)
{
	m_dragSwitchTimer.stop();
	QPushButton::dropEvent(ev);
}

