/***************************************************************************
 *   Copyright (C) 2005 by Sebastian Wolff                                 *
 *   wolff3@widget                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**************************************************************************

    kpager.h  - KPager2's main window
    Copyright (C) 2000  Antonio Larrosa Jimenez
			Matthias Ettrich
			Matthias Elter
    changes (c) 2003 Sebastian Wolff


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

***************************************************************************/
#ifndef __KPAGERSINGLESWITCHBUTTON_H
#define __KPAGERSINGLESWITCHBUTTON_H

#include "version.h"

#include <qpushbutton.h>
#include <qtimer.h>


class KPagerSingleSwitchButton : public QPushButton
// a widget that draws a background configurable in KPagerConfigDialog (contains all desktop widgets)
{
	Q_OBJECT
	public:
		KPagerSingleSwitchButton( QWidget * parent, const char * name = 0 );
		KPagerSingleSwitchButton( const QString & text, QWidget * parent, const char * name = 0 );
		KPagerSingleSwitchButton( const QIconSet & icon, const QString & text, QWidget * parent, const char * name = 0 );
	//public slots:
		//void slotDragSwitch(); // is called by the m_dragSwitchTimer, and switches to the desktop, whenever somebody is dragging from another app and wants to change the desktop
	signals:
		void dragSwitch();
	protected:
		void init();
		virtual void paintEvent(QPaintEvent *e);
		virtual void drawButton(QPainter*);
		virtual void dragEnterEvent(QDragEnterEvent *ev);
		virtual void dragLeaveEvent(QDragLeaveEvent *ev);
		virtual void dropEvent(QDropEvent *ev);
		QTimer m_dragSwitchTimer; // for the case that somebody drags from outside and wants to switch the desktops
};


#endif
