/*****************************************************************
 
Copyright (c) 2004 Sebastian Wolff
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.#
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
******************************************************************/

#include <qpainter.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qcolor.h>
#include <qpopupmenu.h>
#include <qtooltip.h>
#include <qstyle.h>
#include <qstylesheet.h>
#include <assert.h>

#include <kdebug.h>
#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kiconeffect.h>
#include <kimageeffect.h>
#include <kglobalsettings.h>
#include <kwinmodule.h>

#include "config.h"
#include "tasklmbmenu.h"
#include "taskrmbmenu.h"
#include "taskcontainer.h"
#include "kpagertaskcontainer.h"

#include "kpager.h"

extern KPager2 * kpager2;

KPagerTaskContainer::KPagerTaskContainer( Task *task, TaskManager* manager, bool show, bool sort, bool icon, bool iconifiedOnly, QPopupMenu * menu) :
                TaskContainer(task, manager, show, sort, icon, iconifiedOnly)
				, QCustomMenuItem()
{
//        connect (this, SIGNAL(clicked()), this, SLOT(slotCloseMenu()));
//        connect (this, SIGNAL(actionPerformed()), this, SLOT(slotCloseMenu()));
//        setToggleButton(true);
	m_id = 0;
	m_menu = menu;
	connect( &animationTimer, SIGNAL( timeout() ), SLOT( slotAnimationTimerFired() ) );
	connect( &attentionTimer, SIGNAL( timeout() ), SLOT( slotAttentionTimerFired() ) );
}

KPagerTaskContainer::KPagerTaskContainer( Startup *startup, PixmapList *startupFrames, TaskManager* manager, bool show, bool sort, bool icon, bool iconifiedOnly, QPopupMenu * menu) :
                TaskContainer(startup, startupFrames, manager, show, sort, icon, iconifiedOnly)
				, QCustomMenuItem()
{
//        connect (this, SIGNAL(clicked()), this, SLOT(slotCloseMenu()));
//        connect (this, SIGNAL(actionPerformed()), this, SLOT(slotCloseMenu()));
//        setToggleButton(true);
	m_id = 0;
	m_menu = menu;
	connect( &animationTimer, SIGNAL( timeout() ), SLOT( slotAnimationTimerFired() ) );
	connect( &attentionTimer, SIGNAL( timeout() ), SLOT( slotAttentionTimerFired() ) );
}


KPagerTaskContainer::~ KPagerTaskContainer()
{}

void KPagerTaskContainer::slotActivated()
{
	performAction(TaskBar::ActivateRaiseOrIconify);
}

void KPagerTaskContainer::slotCloseMenu()
{
        if (!kpager2)
                return;
        if (!kpager2->m_menu)
                return;
        if (kpager2->m_menu->isVisible()) {
                delete kpager2->m_menu;
                kpager2->m_menu = 0;
        }
}

extern QPixmap fastScalePixmap(const QPixmap &pixmap, int width, int height);


void KPagerTaskContainer::slotAnimationTimerFired()
{
	if ( currentFrame >= 9)
		currentFrame = 0;
	else
		currentFrame++;
	m_menu->updateItem(id());
}
void KPagerTaskContainer::slotAttentionTimerFired()
{
    assert( attentionState != -1 );
    if( attentionState < ATTENTION_BLINK_TIMEOUT )
        ++attentionState;
    else
        attentionTimer.stop();
    m_menu->updateItem(id());
}


QString KPagerTaskContainer::name()
{
	if ( ftasks.count() == 1 ) 
	{
		if ( !ftasks.first()->visibleNameWithState().isEmpty() )
	    	return ftasks.first()->visibleNameWithState();
	}
	return TaskContainer::name();
}


void KPagerTaskContainer::paint(QPainter *p, const QColorGroup & cg, bool act, bool enabled, int x, int y, int w, int h)
{
	// construct our paint environment:
	QPixmap * pm = new QPixmap(w,h);
	// copy the already drawn content to our own paintdevice:
	bitBlt(pm,0,0,  p->device(),x,y,w,h,Qt::CopyROP);
	QPainter * painter = new QPainter(pm);

	// for calls of 'size()' ... 
	//resize(QSize(w,h));
	int width = w;
	int height = h;
	
	QFont myfont = p->font();
	
	QPixmap pixmap; // icon
	Task *task = NULL;
	bool iconified = true;

	// draw sunken if we contain the active task
	bool active = FALSE;
	bool demands_attention = false;
	for ( Task* t = ftasks.first(); t ; t = ftasks.next() ) {
		task = t;
		if ( ! task->isIconified() )
			iconified = false;
		if ( t->isActive() )
			active = TRUE;
		if ( t->demandsAttention() )
			demands_attention = true;
	}

	if ( active && aboutToActivate )
		aboutToActivate = false;

	if ( active )
	{
		myfont.setBold( TRUE );
	}

	QColorGroup colors = cg; // colorGroup();
	if ( demands_attention ) 
	{   // blink until blink timeout, then display differently without blinking
		if( attentionState == ATTENTION_BLINK_TIMEOUT || attentionState % 2 == 0 ) 
		{
			colors.setColor( QColorGroup::Button,     colors.highlight() );
			colors.setColor( QColorGroup::Background, colors.highlight() );
			colors.setColor( QColorGroup::ButtonText, colors.highlightedText() );
			colors.setColor( QColorGroup::Text,       colors.highlightedText() );
			
			if (!act)
			{
				// darken the background
				QPixmap attPixmap(QSize(w,h));
				attPixmap.fill(colors.background());
				KIconEffect::semiTransparent( attPixmap );
				QRect attpmr( 0, 0, w, h );
				painter->drawPixmap( attpmr, attPixmap );
			}
		}
	}

	// get the task icon
	if ( task ) 
	{
		QPixmap p1;
		if (task->hasThumbnail() && ftasks.count()<=1) 
		{
			p1 = task->thumbnail();
		} 
		else 
		{
			p1 = task->icon(THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT,false);//task->pixmap();
		}
		// set the size of the thumbnail (must fit in rectangle of THUMBNAIL_WIDTH/THUMBNAIL_HEIGHT)
		int w,h;
		w = THUMBNAIL_WIDTH;
		h = (int) (1.*w/p1.width()*p1.height());
		if (h > THUMBNAIL_HEIGHT) 
		{
			h = THUMBNAIL_HEIGHT;
			w = (int) (1.*h/p1.height()*p1.width());
		}
		pixmap = fastScalePixmap(p1,w,h);
	} 
	else // we must be a startup (and therefore can't be minimized)
	{
		iconified = false;
	}

	bool reverse = QApplication::reverseLayout();
	//QRect br( m_menu->style().subRect( QStyle::SR_PushButtonContents, m_menu );
	QRect br = QRect(0,0,width, height);
	iconRect = QStyle::visualRect( QRect(br.x() + 2, (height - THUMBNAIL_HEIGHT) / 2, THUMBNAIL_WIDTH, THUMBNAIL_HEIGHT), QRect(0,0,width,height) );

	if ( showIcon ) 
	{
		if ( pixmap.isNull() && !startups.isEmpty() )
			pixmap = SmallIcon( startups.first()->icon() );

		if ( !pixmap.isNull() ) 
		{
			// fade out the icon when minimized
			// only do this if we are not showing only iconified windows
			// it looks pretty stupid when they are *all* faded :-)
//			if ( !showOnlyIconified && iconified )
//				KIconEffect::semiTransparent( pixmap );

			// draw icon
			QRect pmr( 0, 0, pixmap.width(), pixmap.height() );
			pmr.moveCenter( iconRect.center() );
			painter->drawPixmap( pmr, pixmap );
			painter->setPen(QPen(colors.dark(),0));
			pmr.setWidth( pmr.width()+2);
			pmr.setHeight(pmr.height()+2);
			pmr.moveCenter( iconRect.center() );
			if (task)
				if (task->hasThumbnail() && ftasks.count()<=1) 
					painter->drawRect(pmr);
		}
	}

	// find text
	QString text = name();

	// modified overlay (that is a small 'disk' icon that indicates that the file must be saved before closing)
	static QString modStr = "[" + i18n( "modified" ) + "]";
	int modStrPos = text.find( modStr );
	int textPos = ( showIcon && !pixmap.isNull() ) ? 2 + THUMBNAIL_WIDTH + 2 : 0;

	if ( modStrPos >= 0 ) 
	{
		// +1 because we include a space after the closing brace.
		text.remove( modStrPos, modStr.length() + 1 );
		QPixmap modPixmap = SmallIcon( "filesave", KGlobal::instance() );
		// draw modified overlay
		if ( ! modPixmap.isNull() ) 
		{
//			if ( !showOnlyIconified && iconified )
//				KIconEffect::semiTransparent( modPixmap );
			QRect r( 0, 0, modPixmap.width(), modPixmap.height() );
			r.moveBottomRight( iconRect.bottomRight() + QPoint(2,1) );
			painter->drawPixmap( r, modPixmap );
		}
	}

	 // draw text
	if ( !text.isEmpty() ) 
	{
		QRect tr = QStyle::visualRect( QRect( br.x() + textPos + 1, 0, width - textPos, height ), QRect(QPoint(x,y), QSize(width, height)) );
		int textFlags = AlignVCenter | SingleLine;
		textFlags |= reverse ? AlignRight : AlignLeft;
		QPen textPen;

		// get the color for the text label
		if ( !showOnlyIconified && iconified )
			textPen = QPen( blendColors(colors.button(), colors.buttonText()) );
		else if ( ! active )
			textPen = QPen( colors.buttonText() );
		else // hack for the dotNET style and others
			textPen = p->pen();

//		if ( QFontMetrics( myfont ).width( text ) > width - br.x() * 2 - textPos ) 
		{
			if ( QFontMetrics( myfont ).width( text ) > width - br.x() * 2 - textPos ) 
			if ( blendGradient.isNull() || blendGradient.size() != QSize(width,height) ) 
			{
				QPixmap bgpm( QSize(width,height) );
				QPainter bgp( &bgpm );
				bgpm.fill( black );
				if ( ! reverse ) 
				{
					QImage gradient = KImageEffect::gradient( QSize( 30, height ), QColor( 0,0,0 ),
					    QColor( 255,255,255 ), KImageEffect::HorizontalGradient );
					bgp.drawImage( width - 30, 0, gradient );
				} else {
					QImage gradient = KImageEffect::gradient( QSize( 30, height ), QColor( 255,255,255 ),
						QColor( 0,0,0 ), KImageEffect::HorizontalGradient );
					bgp.drawImage( 0, 0, gradient );
				}

				blendGradient = bgpm.convertToImage();
			}

			// draw text into overlay pixmap
			QPixmap tpm( *pm );
			QPainter tp( &tpm );

			tp.setFont ( myfont );
			tp.setPen( act ? colors.highlightedText() : colors.buttonText() );

			// draw text
			if (!showAll)
			{
				tp.drawText( tr, textFlags, text );
			}
			else
			{
				// first line: the app name
				QRect tr2 = QRect(tr.left(), tr.top(), tr.width(), tr.height()/2); 
				textFlags = AlignBottom | SingleLine;
				textFlags |= reverse ? AlignRight : AlignLeft;
				tp.drawText( tr2, textFlags, text );
				
				// second line: the desktop name 
				tr2 = QRect(tr.left(), tr.top()+(tr.height()-tr.height()/2), tr.width(), tr.height()/2); 
				textFlags = AlignTop | SingleLine;
				textFlags |= reverse ? AlignRight : AlignLeft;
				tp.drawText( tr2, textFlags, kpager2->kwin()->desktopName( task->desktop() ));
			}

			tp.end();
			
			// blend text into background image
			if ( QFontMetrics( myfont ).width( text ) > width - br.x() * 2 - textPos ) 
			{
/*				if ( !showOnlyIconified && iconified )
				{
					KIconEffect::semiTransparent( blendGradient );
				}
*/
				QImage img = pm->convertToImage();
				QImage timg = tpm.convertToImage();
				KImageEffect::blend( img, timg, blendGradient, KImageEffect::Red );
				pm->convertFromImage( img );
			}
			else 
			{
//				if ( !showOnlyIconified && iconified )
//					KIconEffect::semiTransparent( tpm );
				painter->drawPixmap(QPoint(0,0),tpm);
			}
			
		} 
/*
		else 
		{
			QPixmap tpm( *pm );
			QPainter tp( &tpm );

			tp.setFont ( myfont );
			tp.setPen( act ? colors.highlightedText() : colors.buttonText() );
			if (!showAll)
			{
				tp->drawText( tr, textFlags, text );
			}
			else
			{
				// first line: the app name
				QRect tr2 = QRect(tr.left(), tr.top(), tr.width(), tr.height()/2); 
				textFlags = AlignBottom | SingleLine;
				textFlags |= reverse ? AlignRight : AlignLeft;
				tp->drawText( tr2, textFlags, text );
				
				// second line: the desktop name 
				tr2 = QRect(tr.left(), tr.top()+(tr.height()-tr.height()/2), tr.width(), tr.height()/2); 
				textFlags = AlignTop | SingleLine;
				textFlags |= reverse ? AlignRight : AlignLeft;
				tp->drawText( tr2, textFlags, kpager2->kwin()->desktopName( task->desktop() ));
			}
			QImage img = pm->convertToImage();
			if ( !showOnlyIconified && iconified )
				KIconEffect::semiTransparent( tpm );
			QImage timg = tpm.convertToImage();
			pm->convertFromImage( img );
		}
*/
	}

	if( frames && !startups.isEmpty()) 
	{
		QPixmap *anim = frames->at( currentFrame );
		if ( anim && !anim->isNull() ) 
		{
			// save the background for the other frames
			bitBlt( &animBg, QPoint(0,0), pm, iconRect );
			// draw the animation frame
			bitBlt( pm, iconRect.x(), iconRect.y(), anim );
		}
	}

	if ( !showOnlyIconified && iconified )
	{
		KIconEffect::semiTransparent( *pm );
	}

	
	// draw popup arrow
	if ( ftasks.count() >= 2 ) 
	{
		QStyle::PrimitiveElement e = QStyle::PE_ArrowLeft;

		switch ( arrowType ) 
		{
			case Qt::LeftArrow:
				e = QStyle::PE_ArrowLeft;
				break;
			case Qt::RightArrow:
				e = QStyle::PE_ArrowRight;
				break;
			case Qt::UpArrow:
				e = QStyle::PE_ArrowUp;
				break;
			case Qt::DownArrow:
				e = QStyle::PE_ArrowDown;
				break;
		}
		int flags = QStyle::Style_Enabled;
		QRect ar = QStyle::visualRect( QRect( br.x() + br.width() - 8 - 2, br.y(), 8, br.height() ), QRect(0,0,width,height));
		m_menu->style().drawPrimitive( e, painter, ar, colors, flags );
	}
	
	painter->end();
	p->drawPixmap(x,y, *pm);
	
	delete painter;
	delete pm;
	
	
	m_myRect = QRect(x,y,w,h);
}

#define WINDOWLISTBUTTON_SIZE 12

#define BUTTON_MIN_HEIGHT (THUMBNAIL_HEIGHT+2)
#define BUTTON_HEIGHT (THUMBNAIL_HEIGHT+4)
#define BUTTON_MAX_WIDTH 300
#define BUTTON_MIN_WIDTH (THUMBNAIL_WIDTH+4 - 50)

QSize KPagerTaskContainer::sizeHint()
{
	return QSize(BUTTON_MAX_WIDTH,BUTTON_HEIGHT);
}

// NOTE: the popupmenu has to be deleted by another widget!!!! 
QPopupMenu * KPagerTaskContainer::popupMenu( TaskBar::Action action )
{
	QPopupMenu* menu;
	if( action == TaskBar::ShowTaskList )	
		menu = new TaskLMBMenu( &ftasks );
	else if( action == TaskBar::ShowOperationsMenu )
	{
		if (!kapp->authorizeKAction("kwin_rmb")) return 0;
		menu = new TaskRMBMenu( &ftasks, taskManager );
	}
	else return 0;

    // calc popup menu position
	QPoint pos( m_menu->mapToGlobal( m_myRect.topLeft() ) );

		
	if ( pos.x() + m_myRect.width() + menu->sizeHint().width() < QApplication::desktop()->width() )
	{
		pos.setX( pos.x() + m_myRect.width() );
	}
	else
	{
		pos.setX( pos.x() - menu->sizeHint().width() );
	}
//	menu->installEventFilter( m_menu );
    /*
	menu->exec( pos );

    delete menu;
	*/
	menu->popup( pos );
	return menu;
}
void KPagerTaskContainer::update()
{
	if(m_menu) m_menu->updateItem(id());
}

const int KPagerTaskContainer::c_defMenuThumbnailWidth = 80;
const int KPagerTaskContainer::c_defMenuThumbnailHeight = 60;
