/*****************************************************************

Copyright (c) 2004 Sebastian Wolff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __kpagertaskcontainer_h__
#define __kpagertaskcontainer_h__

#include "version.h"

#include <qmenudata.h>

//#include "taskbar.h"
#include "taskcontainer.h"
//#include "taskmanager.h"

#define THUMBNAIL_WIDTH  (KPagerConfigDialog::m_menuThumbnailWidth)
#define THUMBNAIL_HEIGHT (KPagerConfigDialog::m_menuThumbnailHeight)

class QWidget;
class QPopupMenu;

class KPagerTaskContainer : public TaskContainer, public QCustomMenuItem
{
    Q_OBJECT

public:
    KPagerTaskContainer( Task*, TaskManager*, bool show, bool sort, bool icon, bool iconifiedOnly, QPopupMenu * menu);
    KPagerTaskContainer( Startup*, PixmapList*, TaskManager*, bool show, bool sort, bool icon, bool iconifiedOnly, QPopupMenu * menu);
    virtual ~KPagerTaskContainer();

	// for QCustomMenuItem
	bool isSeparator() const {return false;};
	bool fullSpan() const {return false;};
	QSize sizeHint();
	void paint(QPainter *p, const QColorGroup & cg, bool act, bool enabled, int x, int y, int w, int h);
	void setId(int id) {m_id = id;};
	int id() {return m_id;};

	QPopupMenu * popupMenu( TaskBar::Action action );

		
protected:
	
	QString name();
	
protected slots:
	void slotCloseMenu();
	void slotAnimationTimerFired();
	void slotAttentionTimerFired();
	void update();

public slots:
	void slotActivated();
	
private:
	int m_id;
	QRect m_myRect;
	QPopupMenu * m_menu; // parent pointer 

public:
	static const int c_defMenuThumbnailWidth;
	static const int c_defMenuThumbnailHeight;
};

typedef QPtrList<KPagerTaskContainer> TaskContainerList;
typedef QPtrListIterator<KPagerTaskContainer> TaskContainerIterator;

#endif
