//
// C++ Interface: kpagertaskmanager
//
// Description: 
//
//
// Author: Sebastian Wolff <>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//


#ifndef __KPAGERTASKMANAGER_H
#define __KPAGERTASKMANAGER_H
 
#include "version.h"

#include <kwin.h>

class TaskManager;
class TaskPagerMan;
class Task;
class Startup;

#include <qguardedptr.h>
#include <qobject.h>
#include <qtimer.h>
#include <qptrlist.h>

class KPager2;

class KPagerTaskManager : public QObject
{
	Q_OBJECT
public:
	KPagerTaskManager( KPager2 * );
	~KPagerTaskManager();
	
	TaskManager * taskManager() {return m_taskmanager;}
	TaskPagerMan * taskPagerManager() {return m_taskpagermanager;}
	KPager2 * pager() {return m_pager;}

	QGuardedPtr<Task> findTaskMan(WId w); // Returns the task for a given WId, or 0 if there is no such task. // looks in TaskManager
	QGuardedPtr<Task> findTaskPager(WId w); // Returns the task for a given WId, or 0 if there is no such task. // looks in TaskPagerMan

public slots:

	// slots that listen on taskmanager 
    void slotTaskAdded(Task*); // from TaskManager class
    void slotTaskRemoved(Task*);
    void slotTaskAdded(QGuardedPtr<Task>); // from TaskPagerMan class 
    void slotTaskRemoved(QGuardedPtr<Task>);
    void slotStartupAdded(Startup*); // when a new task is expected.
    void slotStartupRemoved(Startup*); // when a startup item should be removed. 
	void slotDesktopChanged(int); // when the current desktop changes.
    void slotWindowChanged(WId); // when a window changes somehow.
	void slotNumberOfDesktopsChanged(int);
	
	void slotRefreshWindow(WId); // listens on KWinModule::windowChanged and calls Task::refresh()
	void slotRefreshWindow(WId,unsigned int); // listens on KWinModule::windowChanged and calls Task::refresh() (but only for move and resize events) 

	// slots that listen on all tasks: use QObject::sender() to locate the task 
    void slotChanged(); // task has changed in some way.
    void slotIconChanged(); // icon for task has changed.
    void slotActivated(); // task is now the active task.
    void slotDeactivated(); // task is no longer the active task.
    void slotThumbnailChanged(); // thumbnail for task has changed.: update desktop views

	// slots of mine 
/*
	void slotUpdateThumbnail(); // updates the thumbnail for the 'sender' task
	void slotUpdateThumbnail(WId); // updates the thumbnail for WId 
*/
	void slotUpdateThumbnail(QGuardedPtr<Task>); // updates the thumbnail for Task, works only if it is the active task, this works by firing a timer (first give X11 some time to repaint the window, then grab) -> see m_grabtimers 
	void slotRepaintDesktop(uint); // repaint desktop, if int==0: all desktops 
	void slotUpdateActiveThumbnail(); // tries to update the thumbnail of the active window, if any
	void slotGrabTimersFired();
	
	void slotStackingOrderChanged(); // see KWinModule
	
	void slotCheckAttention(QGuardedPtr<Task> t = 0);
	
signals:
	void updateThumbnail(QGuardedPtr<Task>); // emitted when a thumbnail has to be modified, connected with slotUpdateThumbnail
	void updateActiveThumbnail();
	void repaintDesktop(uint); // is connected with slotRepaintDesktop and avoids being repainted twice at one time, m_desktop (int-1)

protected:

	QGuardedPtr<Task> identifyTaskSender(const QObject* sender);// returns 0 if sender is NOT of type Task, else the casted object
	void emitRepaintDesktop(uint); // m_desktop (int-1)

private:
	TaskManager *m_taskmanager; // TaskManager used for the task manager menu (transients, SkipTaskManager)
	TaskPagerMan *m_taskpagermanager; // Task manager used for the pager desktops (no transients, SkipPager)
	KPager2* m_pager;
	int m_currentDesktop;
	QTimer * m_grabtimer; // to grab a window in regular time intervals
	QPtrList<QTimer> m_grabtimers; // connected with void slotGrabTimersFired()
	QPtrList<Task> m_grabwindows;  // slotGrabTimersFired gets the window (Task) that is connect with the fired timer and updates the thumbnail 
	
	QPtrList<QTimer> m_repainttimers;
private slots:
	void slotRepaintDesktop(); // repaint desktop, sender must be m_repainttimers; m_desktop (timer.at)

};

 
#endif
 
 
