/***************************************************************************
                          kpagertooltip.cpp  -  description
                             -------------------
    begin                : Tue Jan 6 2004
    copyright            : (C) 2004 by Sebastian Wolff
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include <klocale.h>
#include "config.h"
#include "kpager.h"
#include "kpagerdesktop.h"
#include "kpagertooltip.h"
#include "taskmanager.h"
#include <kwin.h>
#include <kwinmodule.h>
 
 
 KPagerToolTip::KPagerToolTip(KPagerDesktop* parent) : QToolTip(parent)
 {
 	m_parent = parent;
	m_currentText = "";
	m_oldPos = QPoint(1,1);
 }
 KPagerToolTip::~KPagerToolTip()
 {
 	clear();
 }
 
QString  KPagerToolTip::getText(const QPoint & p)
{
	KPagerDesktop * desk;
	if ( !parentWidget()->inherits( "KPagerDesktop" ) ) return "";
	else desk = (KPagerDesktop*) parentWidget();

    QString s;
	QPoint pos;
	if (KPagerConfigDialog::m_showWindows)
	{
		Task * t = m_parent->windowAtPosition(p,0);
		if ( (!t)/* || (info->state & NET::Max)*/ ) 
		{
			// no window at this position - print desktop name only
			s = "<qt>";
			s += m_parent->pager()->kwin()->desktopName( m_parent->id());
			if (desk->isCurrent()) 
				s+= "<small><br>"+i18n("current desktop")+"</small>";
			if (desk->isAttention()) 
				s+= "<br><small>" + i18n("demands attention") + "</small>";
			s += "</qt>";
		}
		else
		{
			// window found at this position - print its window title
			s = "<qt>";
			s += t->visibleName();
			if (t->isActive()) 
				s += "<br><small>" + i18n("active window") + "</small>";
			if (t->demandsAttention())
				s += "<small><br>" + i18n("demands attention") + "</small>";
			s += "<small><br>"+m_parent->pager()->kwin()->desktopName( m_parent->id()) + "</small>";
			if (desk->isCurrent()) 
				s+= "<br><small>"+i18n("current desktop")+"</small>";
			if (desk->isAttention()) 
				s+= "<small><br>"+i18n("demands attention")+"</small>";
			s += "</qt>";
		}
	}
	else
	{
		// if no windows are shown on the desktops - print only a desktop name
		s = "<qt>";
		s += m_parent->pager()->kwin()->desktopName( m_parent->id());
		if (desk->isCurrent()) 
			s+= "<small><br>"+i18n("current desktop")+"</small>";
		if (desk->isAttention()) 
			s+= "<br><small>" + i18n("demands attention") + "</small>";
		s += "</qt>";
	}
	return s;
 }
 
void KPagerToolTip::maybeTip( const QPoint & p)
{
	QString s = getText(p);
	m_currentText = s;
	tip (m_parent->rect(), s);
}
 

