/*
 * CHANGED:::
 *
 * o desktop()
 * o desktopChanged
 * o updateFilteredTaskList
 * o performAction
 * o name()
 */
 
 
/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>
Copyright (c) 2002 John Firebaugh <jfirebaugh@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.#

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpainter.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qcolor.h>
#include <qtooltip.h>
#include <qstyle.h>
#include <qstylesheet.h>
#include <assert.h>

#include <kdebug.h>
#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kiconeffect.h>
#include <kimageeffect.h>
#include <kglobalsettings.h>

#include "tasklmbmenu.h"
#include "taskrmbmenu.h"
#include "taskcontainer.h"
//#include "taskcontainer.moc"

QImage TaskContainer::blendGradient = QImage();
TaskBar::Action TaskContainer::leftButtonAction = TaskBar::ShowTaskList;
TaskBar::Action TaskContainer::middleButtonAction = TaskBar::ActivateRaiseOrIconify;
TaskBar::Action TaskContainer::rightButtonAction = TaskBar::ShowOperationsMenu;

TaskContainer::TaskContainer( Task *task, TaskManager* manager, bool show, bool sort, bool icon, bool iconifiedOnly)
    : QObject()
    , lastActivated( 0L )
    , arrowType(Qt::RightArrow)
    , taskManager( manager )
    , showAll( show )
    , showOnlyIconified(iconifiedOnly)
    , sortByDesktop( sort )
    , showIcon( icon )

    , discardNextMouseEvent( false )
    , aboutToActivate( false )
{
    init();

    tasks.append( task );
    updateFilteredTaskList();
    sid = task->classClass();
//    setAcceptDrops(true); // Always enabled to activate task during drag&drop.

    connect( task, SIGNAL( changed() ), SLOT( taskChanged() ) );
    connect( task, SIGNAL( activated() ), SLOT( setLastActivated() ) );

    checkAttention( task );
//	setDesktop(manager->currentDesktop());
}

TaskContainer::TaskContainer( Startup *startup, PixmapList *startupFrames, TaskManager* manager, bool show, bool sort, bool icon, bool iconifiedOnly)
    : QObject()
    , lastActivated( 0L )
    , arrowType(Qt::LeftArrow)
    , taskManager( manager )
    , showAll( show )
    , showOnlyIconified(iconifiedOnly)
    , sortByDesktop( sort )
    , showIcon( icon )
    , discardNextMouseEvent( false )
    , aboutToActivate( false )
{
    init();

    startups.append( startup );
    sid = startup->bin();

    frames = startupFrames;

    connect( startup, SIGNAL( changed() ), SLOT( taskChanged() ) );
    animationTimer.start( 100 );
}

void TaskContainer::init()
{
//    setBackgroundMode( NoBackground );

    tasks.setAutoDelete( FALSE );
    ftasks.setAutoDelete( FALSE );
    startups.setAutoDelete( FALSE );

//    connect( this, SIGNAL( clicked() ), SLOT( slotClicked() ) );

//    QToolTip::add( this, "<qt>" + QStyleSheet::escape(name()) + "</qt>" );

    animBg = QPixmap( 16, 16 );

    // timers
//    connect( &animationTimer, SIGNAL( timeout() ), SLOT( animationTimerFired() ) );
//    connect( &dragSwitchTimer, SIGNAL( timeout() ), SLOT( dragSwitch() ) );
//    connect( &attentionTimer, SIGNAL( timeout() ), SLOT( attentionTimerFired() ) );
    currentFrame = 0;
    frames = 0;
    attentionState = -1;
}

TaskContainer::~TaskContainer()
{
    animationTimer.stop();
    dragSwitchTimer.stop();
//	disconnect(0,0,this,0);
}

void TaskContainer::taskChanged()
{
    if ( const Task* task = dynamic_cast< const Task* >( sender() ) )
        checkAttention( task );
    update();
}

/*
void TaskContainer::update()
{
    QString tooltip = "<qt>" + QStyleSheet::escape(name()) + "</qt>";
    if (currentTooltip == tooltip)
    {
        repaint();
        return;
    }

    currentTooltip = tooltip;
    QToolTip::remove( this );
    QToolTip::add( this, tooltip );
    repaint();
}
*/

void TaskContainer::setLastActivated()
{
    for ( Task* t = ftasks.first(); t ; t = ftasks.next() )
        if ( t->isActive() ) {
            lastActivated = t;
            return;
        }
    lastActivated = 0L;
}


/*
void TaskContainer::animationTimerFired()
{
    if (frames && showIcon) {
        QPixmap *pm = frames->at( currentFrame );

        // draw pixmap
        if ( pm && !pm->isNull() ) {
	    // we only have to redraw the background for frames 0, 8 and 9
	    if ( currentFrame == 0 || currentFrame > 7 ) {
		// double buffered painting
		QPixmap composite( animBg );
		bitBlt( &composite, 0, 0, pm );
		bitBlt( this, iconRect.x(), iconRect.y(), &composite );
    	    }
	    else
		bitBlt( this, iconRect.x(), iconRect.y(), pm );
	}

        // increment frame counter
        if ( currentFrame >= 9)
	    currentFrame = 0;
        else
	    currentFrame++;
    }
}
*/

void TaskContainer::checkAttention( const Task* t )
{
    bool attention = t ? t->demandsAttention() : false;
    if( attention && attentionState == -1 ) // was activated
    {
        attentionTimer.start( 500 );
        attentionState = 0;
    }
    else if( !attention && attentionState >= 0 )
    { // need to check all
        for ( Task* t = tasks.first(); t ; t = tasks.next() )
    	    if ( t->demandsAttention())
            {
                attention = true;
                break;
            }
        if( !attention )
        {
            attentionTimer.stop();
            attentionState = -1;
        }
    }
}

/*
void TaskContainer::attentionTimerFired()
{
    assert( attentionState != -1 );
    if( attentionState < ATTENTION_BLINK_TIMEOUT )
        ++attentionState;
    else
        attentionTimer.stop();
    update();
}
*/

/*
QSizePolicy TaskContainer::sizePolicy() const
{
    return QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );
}

void TaskContainer::resizeEvent( QResizeEvent * )
{
    // calculate the icon rect
    QRect br( style().subRect( QStyle::SR_PushButtonContents, this ) );
    iconRect = QStyle::visualRect( QRect(br.x() + 2, (height() - 16) / 2, 16, 16), this );
}
*/

void TaskContainer::add( Task* task )
{
    if ( !task ) return;

    tasks.append( task );
    updateFilteredTaskList();
    connect( task, SIGNAL( changed() ), SLOT( update() ) );
    connect( task, SIGNAL( activated() ), SLOT( setLastActivated() ) );
    if ( sid.isEmpty() )
	sid = task->classClass();
    checkAttention( task );

    update();
}

void TaskContainer::add( Startup* startup )
{
    if ( !startup ) return;

    startups.append( startup );
    if ( sid.isEmpty() )
	sid = startup->bin();

    connect( startup, SIGNAL( changed() ), SLOT( update() ) );
    if ( !animationTimer.isActive() )
	animationTimer.start( 100 );

    update();
}

void TaskContainer::remove( Task* task )
{
    if ( !task ) return;

    tasks.removeRef( task );
    updateFilteredTaskList();
    checkAttention();

    update();
}

void TaskContainer::remove( Startup* startup )
{
    if ( !startup ) return;

    startups.removeRef( startup );
    if ( startups.isEmpty() )
	animationTimer.stop();

    update();
}

bool TaskContainer::contains( Task* task )
{
    if ( !task ) return FALSE;
    return ( tasks.contains( task ) > 0 );
}

bool TaskContainer::contains( Startup* startup )
{
    if ( !startup ) return FALSE;
    return ( startups.contains( startup ) > 0 );
}

bool TaskContainer::contains( WId win )
{
    for ( Task* t = tasks.first(); t ; t = tasks.next() )
	if ( t->window() == win )
	    return TRUE;
    return FALSE;
}

bool TaskContainer::isEmpty()
{
    return ( tasks.isEmpty() && startups.isEmpty() );
}

QString TaskContainer::id()
{
    return sid;
}

QColor TaskContainer::blendColors( QColor c1, QColor c2 )
{
    int r1, g1, b1;
    int r2, g2, b2;

    c1.rgb( &r1, &g1, &b1 );
    c2.rgb( &r2, &g2, &b2 );

    r1 += (int) ( .5 * ( r2 - r1 ) );
    g1 += (int) ( .5 * ( g2 - g1 ) );
    b1 += (int) ( .5 * ( b2 - b1 ) );

    return QColor( r1, g1, b1 );
}


QString TaskContainer::name()
{
    // default to container id
    QString text = id();

    // Upper case first letter: seems to be the right thing to do for most cases
    text = text.left( 1 ).upper() + text.mid( 1 );

    // single task -> use mainwindow caption
    if ( ftasks.count() == 1 ) {
	if ( !ftasks.first()->visibleIconicName().isEmpty() )
	    text = ftasks.first()->visibleIconicName();
    }
    // multiple tasks -> use the common part of all captions
    // if it is more descriptive than the class name
    else if ( ftasks.count() > 1 ) {
	QString match;
	int i = 1;
	bool stop = FALSE;
	while ( match.length() < ftasks.first()->visibleIconicName().length() ) {
	    match = ftasks.first()->visibleIconicName().left( i );
	    for ( Task* t = ftasks.first(); t; t = ftasks.next() )
		if ( match.lower() !=  t->visibleIconicName().left( i ).lower() ) {
		    stop = TRUE;
		    break;
		}

	    if ( stop ) {
		match = ftasks.first()->visibleIconicName().left( --i );
		break;
	    }
	    i++;
	}

	// strip trailing crap
	while( match.length() > 0 && !match[ match.length() - 1].isLetterOrNumber() )
	    match.truncate( match.length() - 1 );

	// more descriptive than id()?
	if ( match.length() >= id().length() )
	    text = match;
    }

    // fall back to startup name
    else {
	for ( Startup* s = startups.first(); s ; s = startups.next() )
	    if ( !s->text().isEmpty() ) {
		text = s->text();
		break;
	    }
    }

    if ( ftasks.count() > 1 ) {
	text += QString(" [%1]").arg(ftasks.count());
    }

    return text;
}

/*
void TaskContainer::mousePressEvent( QMouseEvent* e )
{
    if( discardNextMouseEvent ) {
	discardNextMouseEvent = false;
	return;
    }

    // On left button, only do actions that invoke a menu.
    // Other actions will be handled in slotClicked().
    if( e->button() == LeftButton &&
        ((leftButtonAction == TaskBar::ShowTaskList && ftasks.count() > 1) ||
         leftButtonAction == TaskBar::ShowOperationsMenu) ) {
	performAction( leftButtonAction );
    } else if( e->button() == MidButton ) {
	performAction( middleButtonAction );
    } else if( e->button() == RightButton ) {
	performAction( rightButtonAction );
    } else {
	QToolButton::mousePressEvent( e );
    }
}

void TaskContainer::mouseReleaseEvent( QMouseEvent *e )
{
    // This is to avoid the flicker caused by redrawing the
    // button as unpressed just before it's activated.
    if ( rect().contains( e->pos() ) ) {
    	if ((e->button() == LeftButton && (leftButtonAction == TaskBar::ActivateRaiseOrIconify || leftButtonAction == TaskBar::Activate))
	    || (e->button() == MidButton && (middleButtonAction == TaskBar::ActivateRaiseOrIconify || middleButtonAction == TaskBar::Activate))
	    || (e->button() == RightButton && (rightButtonAction == TaskBar::ActivateRaiseOrIconify || rightButtonAction == TaskBar::Activate)) )
		    aboutToActivate = true;
    }

    QToolButton::mouseReleaseEvent( e );
}

void TaskContainer::slotClicked()
{
    // We've already handled these cases above by
    // showing the menu.
    if((leftButtonAction == TaskBar::ShowTaskList && ftasks.count() > 1 ) ||
        leftButtonAction == TaskBar::ShowOperationsMenu )
	return;

    performAction( leftButtonAction );
}
*/
void TaskContainer::performAction( TaskBar::Action action )
{
    if ( ftasks.isEmpty() )
	return;

    bool forwards = true;

    switch( action ) {
    case TaskBar::ShowTaskList:
	// If there is only one task, the correct behavior is
	// to activate, raise, or iconify it, not show the task menu.
	if( ftasks.count() > 1 ) {
//TODO	    popupMenu( TaskBar::ShowTaskList );
	} else {
	    performAction( TaskBar::ActivateRaiseOrIconify );
	}
	break;
    case TaskBar::ShowOperationsMenu:
//TODO	popupMenu( TaskBar::ShowOperationsMenu );
	break;
    case TaskBar::ActivateRaiseOrIconifyReverse:
	// cause next case to work in reverse
	forwards = false;
    case TaskBar::ActivateRaiseOrIconify:
	if ( ftasks.count() == 1) {
	    ftasks.first()->activateRaiseOrIconify();
	} else { // multiple tasks -> cycle list
	    for ( Task* t = forwards? ftasks.first() : ftasks.last();
		  t ; t = forwards ? ftasks.next() : ftasks.prev() ) {
		if ( t->isActive() ) {
		    // activate next
		    Task *t = forwards ? ftasks.next() : ftasks.prev();
		    if ( !t )
			t = forwards ? ftasks.first() : ftasks.last();
		    t->activateRaiseOrIconify();
		    return;
	        }
	    }
	    if (ftasks.contains(lastActivated))
		lastActivated->activateRaiseOrIconify();
	    else
		ftasks.first()->activateRaiseOrIconify();
	}
	break;
    case TaskBar::Activate:
	ftasks.first()->activate();
	break;
    case TaskBar::Raise:
	ftasks.first()->raise();
	break;
    case TaskBar::Lower:
	ftasks.first()->lower();
	break;
    case TaskBar::Iconify:
	if( ftasks.first()->isIconified() ) {
	    ftasks.first()->restore();
	} else {
	    ftasks.first()->iconify();
	}
	break;
    default:
	kdWarning(1210) << "Unknown taskbar action!" << endl;
	break;
    }
	
	emit actionPerformed();
}





void TaskContainer::setArrowType( Qt::ArrowType at )
{
    if( arrowType == at )
	return;

    arrowType = at;
//    repaint();
}

/*
void TaskContainer::publishIconGeometry( QPoint global )
{
    QPoint p = global + geometry().topLeft();

    for ( Task* t = ftasks.first(); t ; t = ftasks.next() )
	t->publishIconGeometry( QRect( p.x(), p.y(), width(), height() ) );
}
*/

/*
void TaskContainer::dragEnterEvent( QDragEnterEvent* e )
{
    // if a dragitem is held for over a taskbutton for two seconds,
    // activate corresponding window

    if ( ftasks.count() < 1 ) return;

    if( !ftasks.first()->isActive() || ftasks.count() > 1 )
	dragSwitchTimer.start( 1000, TRUE );

    QToolButton::dragEnterEvent( e );
}

void TaskContainer::dragLeaveEvent( QDragLeaveEvent* e )
{
    dragSwitchTimer.stop();

    QToolButton::dragLeaveEvent( e );
}

void TaskContainer::dragSwitch()
{
    if ( ftasks.count() < 1 )
        return;
    else if ( ftasks.count() == 1 )
        ftasks.first()->activate();
    else
        popupMenu( TaskBar::ShowTaskList );
}

void TaskContainer::wheelEvent( QWheelEvent* e )
{
    if ( ftasks.count() > 1 ) {
        if ( e->delta() > 0 ) {
            // scroll away from user, previous task
            performAction( TaskBar::ActivateRaiseOrIconifyReverse );
        } else {
            // scroll towards user, next task
            performAction( TaskBar::ActivateRaiseOrIconify );
        }
    }
}
*/

int TaskContainer::desktop()
{
    if ( tasks.isEmpty() )
	return m_desktop;//taskManager->currentDesktop();

    if ( tasks.count() > 1 )
	return taskManager->numberOfDesktops();

    return tasks.first()->desktop();
}

bool TaskContainer::onCurrentDesktop()
{
    if ( isEmpty() )
	return FALSE;

    if ( tasks.count() < 1
	 && startups.count() > 0 )
	return TRUE;

    for ( Task* t = tasks.first(); t ; t = tasks.next() )
	if ( t->desktop() == m_desktop || t->isOnAllDesktops() ) //t->isOnCurrentDesktop() )
	    return TRUE;

    return FALSE;
}

bool TaskContainer::isIconified()
{
    if ( isEmpty() )
	return FALSE;
    if ( tasks.count() < 1
	 && startups.count() > 0 )
	return TRUE;
    for ( Task* t = tasks.first(); t ; t = tasks.next() )
	if ( t->isIconified() )
	    return TRUE;

    return FALSE;
}

void TaskContainer::setShowAll( bool s )
{
    if ( s == showAll )
	return;

    showAll = s;
    updateFilteredTaskList();
    update();
}

void TaskContainer::setShowIconifiedOnly( bool s )
{
    if ( s == showOnlyIconified )
	return;

    showOnlyIconified = s;
    updateFilteredTaskList();
    update();
}

void TaskContainer::setSortByDesktop( bool s )
{
    if ( s == sortByDesktop )
	return;

    sortByDesktop = s;
    updateFilteredTaskList();
    update();
}

void TaskContainer::setShowIcon( bool s )
{
    if ( s == showIcon )
	return;

    showIcon = s;
    updateFilteredTaskList();
    update();
}

void TaskContainer::updateFilteredTaskList()
{
    ftasks.clear();

    for ( Task* t = tasks.first(); t ; t = tasks.next() ) {
	if ( showAll || t->desktop() == m_desktop || t->isOnAllDesktops())
	    if( !showOnlyIconified || t->isIconified() )
		ftasks.append( t );
    }

    // sort container list by desktop
    if ( sortByDesktop && ftasks.count() > 1 ) {

	TaskList sorted;
	Task *t;
	/* antlarr: residue shouldn't be needed, as "in theory" we already
	iterate through all applications, but kicker is a core app and we
	don't want it to crash nor hang under any circumstance in the real
	world, so in case a window has been moved to an out-of-range desktop
	(which may be possible just by calling NETWinInfo::setDesktop(42) )
	we want to keep sanity */
	TaskList residue = ftasks;
	for ( int desktop = -1; desktop <= taskManager->numberOfDesktops(); desktop++ ) {
	    for ( t = ftasks.first(); t; t = ftasks.next() )
		if ( t->desktop() == desktop )
		{
		    sorted.append( t );
		    residue.remove( t );
		}
	}
	ftasks = sorted;

        for ( t = residue.first(); t; t = residue.next() )
	    ftasks.append( t );

    }
}

void TaskContainer::desktopChanged( int desk)
{
	setDesktop (desk);
    updateFilteredTaskList();
    update();
}

void TaskContainer::windowChanged( WId )
{
    updateFilteredTaskList();
    update();
}


