// NOTE - CHANGED: signals added!!!
/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>
Copyright (c) 2001 John Firebaugh <jfirebaugh@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <klocale.h>
#include <kiconloader.h>
#include <assert.h>

#include "taskrmbmenu.h"
//#include "taskrmbmenu.moc"

TaskRMBMenu::TaskRMBMenu( TaskList* theTasks, TaskManager* manager, QWidget *parent, const char *name )
	: QPopupMenu( parent, name )
	, tasks( theTasks )
{
	m_id_rmbmenu = -1;
	m_rmbmenu = 0;
	assert( tasks->count() > 0 );
	if( tasks->count() == 1 ) {
		fillMenu( tasks->first(), manager );
	} else {
		fillMenu( tasks, manager );
	}
	connect(this,SIGNAL(activated(int)),this,SLOT(slotHighlightedActivated(int)));
	//connect(this,SIGNAL(activated(int)),this,SLOT(slotActionPerformed(int)));
	connect(this,SIGNAL(highlighted(int)),this,SLOT(slotHighlightedActivated(int)));
}

TaskRMBMenu::TaskRMBMenu( Task* task, TaskManager* manager, QWidget* parent, const char* name )
	: QPopupMenu( parent, name )
	, tasks(0)
	, task(0)
{
	m_id_rmbmenu = -1;
	m_rmbmenu = 0;
	fillMenu( task, manager );
	connect(this,SIGNAL(activated(int)),this,SLOT(slotHighlightedActivated(int)));
	//connect(this,SIGNAL(activated(int)),this,SLOT(slotActionPerformed(int)));
	connect(this,SIGNAL(highlighted(int)),this,SLOT(slotHighlightedActivated(int)));
}

void TaskRMBMenu::fillMenu( Task* t, TaskManager* manager )
{
	int id;
	setCheckable( true );

	task = t;

	id = insertItem( i18n( "Mi&nimize" ), this, SLOT( iconify() ) );
	setItemEnabled( id, !t->isIconified() );
	id = insertItem( i18n( "Ma&ximize" ), this, SLOT( maximize() ) );
	setItemEnabled( id, !t->isMaximized() );
	id = insertItem( i18n( "&Restore" ), this, SLOT( restore() ) );
	setItemEnabled( id, t->isIconified() || t->isMaximized() );

	insertSeparator();

	id = insertItem( i18n( "&Shade" ), this, SLOT( toggleShaded() ) );
	setItemChecked( id, t->isShaded() );
	id = insertItem( i18n( "&Always on Top" ), this, SLOT( toggleAlwaysOnTop() ) );
	setItemChecked( id, t->isAlwaysOnTop() );

	insertSeparator();

	id = insertItem( SmallIcon( "fileclose" ), i18n( "&Close" ), this, SLOT( close() ) );

	if ( manager->numberOfDesktops() > 1 )
	{
		insertSeparator();

		id = insertItem( i18n("To &Desktop"), makeDesktopsMenu( t, manager ) );
		id = insertItem( i18n( "&To Current Desktop" ), this, SLOT( toCurrentDesktop() ) );
		setItemEnabled( id, !t->isOnCurrentDesktop() );
	}
}

#include "kpagertaskcontainer.h"
void TaskRMBMenu::fillMenu( TaskList* tasks, TaskManager* manager )
{
	int id;
	setCheckable( true );

	m_containerList.setAutoDelete(false);
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		Task* t = (*it);

//		QPopupMenu * m2 = new TaskRMBMenu( t, manager, this );
//		connect(m2,SIGNAL(actionPerformed()),this,SLOT(slotActionPerformed()));
//		id = insertItem( QIconSet( t->pixmap() ),
//				 t->visibleNameWithState(), m2);
//		setItemChecked( id, t->isActive() );
//		connectItem( id, t, SLOT( activateRaiseOrIconify() ) );

		KPagerTaskContainer *c = new KPagerTaskContainer( t, manager, true, true, true, false, this);
		if (c)
		{
			int id = insertItem((QCustomMenuItem*)c);
			c->setId(id);
			connectItem(id, c, SLOT(slotActivated()));
			connect(c,SIGNAL(actionPerformed()),this,SIGNAL(actionPerformed()));
			m_containerList.append(c);
		}
	}

	insertSeparator();

	bool enable = false;

	id = insertItem( i18n( "Mi&nimize All" ), this, SLOT( slotMinimizeAll() ) );
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		if( !(*it)->isIconified() ) {
			enable = true;
			break;
		}
	}
	setItemEnabled( id, enable );

	enable = false;

	id = insertItem( i18n( "Ma&ximize All" ), this, SLOT( slotMaximizeAll() ) );
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		if( !(*it)->isMaximized() ) {
			enable = true;
			break;
		}
	}
	setItemEnabled( id, enable );

	enable = false;

	id = insertItem( i18n( "&Restore All" ), this, SLOT( slotRestoreAll() ) );
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		if( (*it)->isIconified() || (*it)->isMaximized() ) {
			enable = true;
			break;
		}
	}
	setItemEnabled( id, enable );

	insertSeparator();

	enable = false;

	/*
	id = insertItem( i18n( "&Shade All" ), this, SLOT( slotShadeAll() ), 0, OpMenu::ShadeOp );
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		if( !(*it)->isShaded() ) {
			enable = true;
			break;
		}
	}
	setItemEnabled( id, enable );
	*/

	insertItem( SmallIcon( "remove" ), i18n( "&Close All" ), this, SLOT( slotCloseAll() ) );

	if ( manager->numberOfDesktops() > 1 )
	{
		insertSeparator();

		id = insertItem( i18n("All to &Desktop"), makeDesktopsMenu( tasks, manager ) );

		enable = false;

		id = insertItem( i18n( "All &to Current Desktop" ), this, SLOT( slotAllToCurrentDesktop() ) );
		for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
			if( !(*it)->isOnCurrentDesktop() ) {
				enable = true;
				break;
			}
		}
		setItemEnabled( id, enable );
	}
}

QPopupMenu* TaskRMBMenu::makeDesktopsMenu( Task* t, TaskManager* manager )
{
	QPopupMenu* m = new QPopupMenu( this );
	m->setCheckable( true );

	int id = m->insertItem( i18n("&All Desktops"), this, SLOT( toDesktop(int) ) );
	m->setItemParameter( id, 0 ); // 0 means all desktops
	m->setItemChecked( id, t->isOnAllDesktops() );

	m->insertSeparator();

	for( int i = 1; i <= manager->numberOfDesktops(); i++ ) {
		QString name = QString( "&%1 %2" ).arg( i ).arg( manager->desktopName( i ) );
		id = m->insertItem( name, this, SLOT( toDesktop(int) ) );
		m->setItemParameter( id, i );
		m->setItemChecked( id, !t->isOnAllDesktops() && t->desktop() == i );
	}

	return m;
}

QPopupMenu* TaskRMBMenu::makeDesktopsMenu( TaskList*, TaskManager* manager )
{
	QPopupMenu* m = new QPopupMenu( this );
	m->setCheckable( true );

	int id = m->insertItem( i18n("&All Desktops"), this, SLOT( slotAllToDesktop(int) ) );
	m->setItemParameter( id, 0 ); // 0 means all desktops

	m->insertSeparator();

	for( int i = 1; i <= manager->numberOfDesktops(); i++ ) {
		QString name = QString( "&%1 %2" ).arg( i ).arg( manager->desktopName( i ) );
		id = m->insertItem( name, this, SLOT( slotAllToDesktop(int) ) );
		m->setItemParameter( id, i );
	}

	return m;
}

void TaskRMBMenu::slotMinimizeAll()
{
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		(*it)->iconify();
	}
	emit actionPerformed();
}

void TaskRMBMenu::slotMaximizeAll()
{
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		(*it)->maximize();
	}
	emit actionPerformed();
}

void TaskRMBMenu::slotRestoreAll()
{
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		(*it)->restore();
	}
	emit actionPerformed();
}

void TaskRMBMenu::slotShadeAll()
{
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		(*it)->setShaded( !(*it)->isShaded() );
	}
	emit actionPerformed();
}

void TaskRMBMenu::slotCloseAll()
{
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		(*it)->close();
	}
	emit actionPerformed();
}

void TaskRMBMenu::slotAllToDesktop( int desktop )
{
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		(*it)->toDesktop( desktop );
	}
	emit actionPerformed();
}

void TaskRMBMenu::slotAllToCurrentDesktop()
{
	for( QPtrListIterator<Task> it(*tasks); *it; ++it ) {
		(*it)->toCurrentDesktop();
	}
	emit actionPerformed();
}
void TaskRMBMenu::slotActionPerformed()
{
	emit actionPerformed();
}

#include "taskbar.h"

void TaskRMBMenu::mouseReleaseEvent(QMouseEvent * e)
{
	// close previouly opened menus
	if (m_id_rmbmenu>=0 || m_rmbmenu)
	{
		delete m_rmbmenu;
		m_rmbmenu = 0;
		m_id_rmbmenu = -1;
	}
	// check if we can open a second one
	if (e)
	{
		int id = idAt(e->pos());
		bool iscompetent = true;
		if (e->button()==Qt::LeftButton || e->button()==Qt::MidButton) iscompetent=false;
		// check if there is a container->
		KPagerTaskContainer* c = 0;
		if (iscompetent)
		{
			TaskContainerList l = m_containerList;
			for ( TaskContainer* it = l.first(); it; it=l.next() )
			{
				KPagerTaskContainer* cit = (KPagerTaskContainer*)it;
				if (cit->id()==id)
				{
					c = cit;
				}
			}
		}
		else iscompetent=false;
		if (!c) iscompetent=false; // not found

		if (iscompetent)
		{
			// open a new popup menu for the specific task item
			m_rmbmenu = c->popupMenu(TaskBar::ShowOperationsMenu);
			if (m_rmbmenu)
			{
				m_id_rmbmenu = id;
				bool b = connect(m_rmbmenu, SIGNAL(actionPerformed()), this, SLOT(slotTaskRMBMenuActivated()));
			}
		}
		else QPopupMenu::mouseReleaseEvent(e);
	}
	else QPopupMenu::mouseReleaseEvent(e);
}

void TaskRMBMenu::slotActionPerformed(int)
{
	emit actionPerformed();
}

void TaskRMBMenu::slotHighlightedActivated(int id)
{
	if (id != m_id_rmbmenu)
	{
		m_id_rmbmenu = -1;
		delete m_rmbmenu;
		m_rmbmenu = 0;
	}
}

void TaskRMBMenu::slotAboutToHide()
{
	if (m_rmbmenu) delete m_rmbmenu;
	m_rmbmenu = 0;
	m_id_rmbmenu = -1;
}
void TaskRMBMenu::slotTaskRMBMenuActivated()
{
	slotActionPerformed();
	slotHighlightedActivated(0); // param = anything
}
