// NOTE - CHANGED: signals added!!!

/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>
Copyright (c) 2001 John Firebaugh <jfirebaugh@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __taskrmbmenu_h__
#define __taskrmbmenu_h__

#include <qpopupmenu.h>
#include "taskmanager.h"

#include "version.h"
#include "taskbar.h"
#include <qstringlist.h>

class TaskRMBMenu : public QPopupMenu
{
	Q_OBJECT

public:
	TaskRMBMenu( TaskList* tasks, TaskManager* manager, QWidget *parent = 0, const char *name = 0 );
	TaskRMBMenu( Task* tasks, TaskManager* manager, QWidget *parent = 0, const char *name = 0 );

private:
	void fillMenu( Task* t, TaskManager* manager );
	void fillMenu( TaskList* tasks, TaskManager* manager );
	QPopupMenu* makeDesktopsMenu( Task* t, TaskManager* manager );
	QPopupMenu* makeDesktopsMenu( TaskList* tasks, TaskManager* manager );

	// for a second rmb menu for each task:
	virtual void mouseReleaseEvent(QMouseEvent*);
	QPopupMenu * m_rmbmenu;
	int m_id_rmbmenu;

private slots:
	void slotMinimizeAll();
	void slotMaximizeAll();
	void slotRestoreAll();
	void slotShadeAll();
	void slotCloseAll();
	void slotAllToDesktop( int desktop );
	void slotAllToCurrentDesktop();

	void iconify() {if (task) task->iconify();emit actionPerformed();}
	void maximize() {if (task) task->maximize();emit actionPerformed();}
	void restore() {if (task) task->restore();emit actionPerformed();}
	void toggleShaded() {if (task) task->toggleShaded();emit actionPerformed();}
	void toggleAlwaysOnTop() {if (task) task->toggleAlwaysOnTop();emit actionPerformed();}
	void close() {if (task) task->close();emit actionPerformed();}
	void toCurrentDesktop() {if (task) task->toCurrentDesktop();emit actionPerformed();}
	void toDesktop(int d) {if (task) task->toDesktop(d);emit actionPerformed();}

	void slotActionPerformed(); // emits actionPerformed (if a signal from submenus was received)
	void slotActionPerformed(int); // the same, but emits the own signal and listens on own activation

	// for a second rmb menu for each task (if grouped), copied from KPagerRMBMenu:
	void slotHighlightedActivated(int); // closes and deletes the second rmb menu
	void slotAboutToHide();
	void slotTaskRMBMenuActivated();

signals:
	void actionPerformed();

private:
	TaskList* tasks;
	Task * task;

	TaskContainerList m_containerList;
};

#endif
