/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "buttonisedstate.h"

#include <qapplication.h>
#include <qpainter.h>
#include <qpointarray.h>

#include <kwin.h>

#include "dockstate.h"
#include "ksmoothdock.h"
#include "normalzoomstate.h"
#include "paraboliczoomstate.h"

/// PUBLIC ///

ButtonisedState::ButtonisedState(KSmoothDock* dock)
 : DockState(dock) {
}

/**
 * Paint event handler
 */

void ButtonisedState::paintEvent(QPaintEvent* e) {
    QPainter p(m_buffer.get());
    QPointArray array(3);

    bitBlt(m_buffer.get(), 0, 0, m_background.get(), 0, 0, m_w, m_h);

    p.setPen(m_dock->m_borderColor);
    p.setBrush(m_dock->m_borderColor);

    if (m_dock->m_orientation == Qt::Horizontal) {
        array[0] = QPoint(m_w/3, m_h/2 - m_w/3);
        array[1] = QPoint(m_w/3, m_h/2 + m_w/3);
        array[2] = QPoint(2*m_w/3, m_h/2);
    } else { // Vertical
        array[0] = QPoint(m_w/2 - m_h/3, 2*m_h/3);
        array[1] = QPoint(m_w/2 + m_h/3, 2*m_h/3);
        array[2] = QPoint(m_w/2, m_h/3);
    }

    switch(m_dock->m_position) {
    case LEFT:
        p.drawLine(0, 0, m_w - 1, 0);
        p.drawLine(m_w - 1, 0, m_w - 1, m_h - 1);
        break;
    case RIGHT:
        p.drawLine(0, 0, m_w - 1, 0);
        p.drawLine(0, 0, 0, m_h - 1);
        break;
    case TOP:
        p.drawLine(0, m_h - 1, m_w - 1, m_h - 1);
        p.drawLine(m_w - 1, 0, m_w - 1, m_h - 1);
        break;
    case BOTTOM:
        p.drawLine(0, 0, m_w - 1, 0);
        p.drawLine(m_w - 1, 0, m_w - 1, m_h - 1);
        break;
    default:
        break;
    }
    p.drawPolygon(array);

    bitBlt(m_dock, 0, 0, m_buffer.get(), 0, 0, m_w, m_h);
}

/**
 * Mouse pressed event handler
 */

void ButtonisedState::mousePressEvent(QMouseEvent* e) {
    if (e->button() == Qt::LeftButton) {
        if (m_dock->m_showTooltip) {
            m_dock->m_tooltip.hide();
        }

        KWin::clearState(m_dock->winId(), NET::KeepAbove | NET::Sticky);

        if (m_dock->m_zoomMode == NORMAL_ZOOM) {
            if (m_dock->m_normalZoomState != NULL) {
                m_dock->m_state = m_dock->m_normalZoomState;
            } else if (m_dock->m_parabolicZoomState != NULL) {
                m_dock->m_state = m_dock->m_parabolicZoomState;
            }
        } else { // Parabolic Zoom
            if (m_dock->m_parabolicZoomState != NULL) {
                m_dock->m_state = m_dock->m_parabolicZoomState;
            } else if (m_dock->m_normalZoomState != NULL) {
                m_dock->m_state = m_dock->m_normalZoomState;
            }
        }

        m_dock->loadLaunchers();
        m_dock->initPager();
        m_dock->loadTasks();
        m_dock->initClock();
        m_dock->updateLayout();
        m_dock->updateLayout();
    }
}

/**
 * Mouse moved event handler
 */

void ButtonisedState::mouseMoveEvent(QMouseEvent* e) {
}

/**
 * Enter event handler
 */

void ButtonisedState::enterEvent(QEvent* e) {
    m_dock->m_tooltip.setText("Show KSmoothDock");

    int dw = QApplication::desktop()->width();
    int dh = QApplication::desktop()->height();

    switch(m_dock->m_position) {
    case LEFT:
        m_dock->m_tooltip.move(m_w + TOOLTIP_SPACE, dh - m_dock->m_tooltip.height());
        break;
    case RIGHT:
        m_dock->m_tooltip.move(dw - m_dock->m_tooltip.width() - m_w - TOOLTIP_SPACE, dh - m_dock->m_tooltip.height());
        break;
    case TOP:
        m_dock->m_tooltip.move(0, m_h + TOOLTIP_SPACE);
        break;
    case BOTTOM:
        m_dock->m_tooltip.move(0, dh - m_h - TOOLTIP_SPACE - m_dock->m_tooltip.height());
        break;
    default:
        break;
    }

    m_dock->m_tooltip.show();
}

/**
 * Leave event handler
 */

void ButtonisedState::leaveEvent(QEvent* e) {
    m_dock->m_tooltip.hide();
}

/**
 * Update the layout
 */

void ButtonisedState::updateLayout(bool reset) {
    if (m_dock->m_orientation == Qt::Horizontal) {
        m_h = (m_dock->m_zoomMode == NORMAL_ZOOM) ? m_dock->m_bigIconSize : (m_dock->m_smallIconSize*3/2);
        m_w = m_h / 3;
    } else { // Vertical
        m_w = (m_dock->m_zoomMode == NORMAL_ZOOM) ? m_dock->m_bigIconSize : (m_dock->m_smallIconSize*3/2);
        m_h = m_w / 3;
    }

    m_buffer.reset(new QPixmap(m_w, m_h));
    m_background.reset(new KPixmap(*m_buffer));

    int dw = QApplication::desktop()->width();
    int dh = QApplication::desktop()->height();

    switch(m_dock->m_position) {
    case LEFT:
        m_dock->move(0, dh - m_h);
        break;
    case RIGHT:
        m_dock->move(dw - m_w, dh - m_h);
        break;
    case TOP:
        m_dock->move(0, 0);
        break;
    case BOTTOM:
        m_dock->move(0, dh - m_h);
        break;
    default:
        break;
    }
    KWin::setExtendedStrut(m_dock->winId(), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    KWin::setState(m_dock->winId(), NET::KeepAbove | NET::Sticky);
    updateBackgroundImage();
    m_dock->resize(m_w, m_h);
    m_dock->repaint();
    leaveEvent(NULL);
}

/**
 * Update background
 */

void ButtonisedState::updateBackground() {
    updateBackgroundImage();
    m_dock->repaint();
}

/**
 * Update a specific item
 */

void ButtonisedState::updateItem(int itemIndex) {
}

/// PRIVATE ///

/**
 * Update the background image
 */

void ButtonisedState::updateBackgroundImage() {
    int dw = QApplication::desktop()->width();
    int dh = QApplication::desktop()->height();
    int x = 0;
    int y = 0;

    switch(m_dock->m_position) {
    case LEFT:
        y = (dh - m_h) / 2;
        break;
    case RIGHT:
        x = dw - m_w;
        y = (dh - m_h) / 2;
        break;
    case TOP:
        x = (dw - m_w) / 2;
        break;
    case BOTTOM:
        y = dh - m_h;
        break;
    default:
        break;
    }

    // copy from the wallpaper
    bitBlt(m_background.get(), 0, 0, &m_dock->m_wallpaperManager->getWallpaper(KWin::currentDesktop()), x, y, m_w, m_h);

    // fade the background
    if (m_dock->m_dockOpacity > 0)
        KPixmapEffect::fade(*m_background, ((float)m_dock->m_dockOpacity)*0.01, m_dock->m_backgroundColor);
}


#include "buttonisedstate.moc"

