/***************************************************************************
 *   Copyright (C) 2006 by Viet Dung Dang   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CONSTANTS_H
#define CONSTANTS_H

const int X_DISTANCE_UPDATE = 3; // update when x - last_x <= UPDATE_DIST
const int NZ_DEFAULT_SMALL_SIZE = 28; // normal zoom's default small icon size
const int NZ_DEFAULT_BIG_SIZE = 48; // normal zoom's default big icon size
const int NZ_DEFAULT_BASE_SIZE = 64; // normal zoom's default base icon size
const int PZ_DEFAULT_SMALL_SIZE = 24; // default small icon size parabolic zoom
const int PZ_DEFAULT_BIG_SIZE = 80; // default big icon size
const int PZ_DEFAULT_BASE_SIZE = 64; // parabolic zoom's default base icon size
const int DEFAULT_DOCK_OPACITY = 42; // default dock opacity

const int HIDDEN_WIDTH = 15; // the width of the dock in hidden (buttonised) mode
const int MAX_HIDDEN_HEIGHT = 100; // maximum height of the dock in hidden (buttonised) mode

const int TOOLTIP_SPACE = 5; // the space between the tooltip and the dock

const int SEPARATOR_WIDTH = 1; // the width of the separator between quick launchers and tasks

const int ON_CHANGE_ANIMATION_INTERVAL = 1000; // animation's interval

const int CONFIG_MENU_ICON_BASE_SIZE = 128;

const int CONFIG_MENU_ICON_SIZE = 32;

const int PAGER_ICON_BASE_WIDTH = 128; // used in generating desktop pager icon

const int ON_ALL_DESKTOPS = 0;

const int MAX_LINE_LENGTH = 80;

const int MAX_PATH_LENGTH = 200;

enum PanelPosition {TOP, BOTTOM, LEFT, RIGHT}; // panel's position

enum ZoomMode {NO_ZOOM, NORMAL_ZOOM, PARABOLIC_ZOOM}; // zoom mode
// @NOTE: NO_ZOOM is not in used yet

#endif
