/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "iconlessdockitem.h"

/// PUBLIC ///

IconlessDockItem::IconlessDockItem() {}

/** 
 * Constructor
 * @param parent the parent dock
 * @param itemId id of the item
 * @param desc description of the dock item
 * @param desktop the desktop the dock item is on
 * @param minSize the minimum size (height or width depending on the position of the dock) of the dock item's icon
 * @param maxSize the maximum size (height or width depending on the position of the dock) of the dock item's icon
 * @param whRatio width/height ratio (0 means there is no predefined width/height ratio)
 * @param orientation orienation of the dock
 */

IconlessDockItem::IconlessDockItem(KSmoothDock* parent, int itemId, QString desc, int desktop, int minSize, int maxSize, double whRatio, Qt::Orientation orientation)
 : DockItem(parent, itemId, desc, desktop, orientation), m_minSize(minSize), m_maxSize(maxSize), m_whRatio(whRatio) {
}

/** 
 * Get max width
 */

int IconlessDockItem::getMaxWidth() {
    if (m_whRatio != 0) {
        if (m_orientation == Qt::Horizontal) {
            return (int) (m_whRatio * m_maxSize);
        } else { // Vertical
            return m_maxSize;
        }
    } else {
        return 0;
    }
}

/** 
 * Get max height
 */

int IconlessDockItem::getMaxHeight() {
    if (m_whRatio != 0) {
        if (m_orientation == Qt::Horizontal) {
            return m_maxSize;
        } else { // Vertical
            return (int) (m_maxSize / m_whRatio);
        }
    } else {
        return 0;
    }
}

/** 
 * Get min width
 */

int IconlessDockItem::getMinWidth() {
    if (m_whRatio != 0) {
        if (m_orientation == Qt::Horizontal) {
            return (int) (m_whRatio * m_minSize);
        } else { // Vertical
            return m_minSize;
        }
    } else {
        return 0;
    }
}

/** 
 * Get min height
 */

int IconlessDockItem::getMinHeight() {
    if (m_whRatio != 0) {
        if (m_orientation == Qt::Horizontal) {
            return m_minSize;
        } else { // Vertical
            return (int) (m_minSize / m_whRatio);
        }
    } else {
        return 0;
    }
}

/**
 * Get width for a specific size
 */

int IconlessDockItem::getWidth(int size) {
    if (m_whRatio != 0) {
        if (m_orientation == Qt::Horizontal) {
            return (int) (m_whRatio * size);
        } else { // Vertical
            return size;
        }
    } else {
        return 0;
    }
}
    
/**
 * Get height for a specific size
 */

int IconlessDockItem::getHeight(int size) {
    if (m_whRatio != 0) {
        if (m_orientation == Qt::Horizontal) {
            return size;
        } else { // Vertical
            return (int) (size / m_whRatio);
        }
    } else {
        return 0;
    }
}


