/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ICONLESSDOCKITEM_H
#define ICONLESSDOCKITEM_H

#include "dockitem.h"

/**
 * @short Base class for items that have no icons when initiated 
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

class IconlessDockItem : public DockItem {
public:
    IconlessDockItem();

    IconlessDockItem(KSmoothDock* parent, int itemId, QString desc, int desktop, int minSize, int maxSize, double whRatio, Qt::Orientation orientation);

    /// Get max width
    virtual int getMaxWidth();
    
    /// Get max height
    virtual int getMaxHeight();

    /// Get min width
    virtual int getMinWidth();
    
    /// Get min height
    virtual int getMinHeight();

    /// Get width for a specific size
    virtual int getWidth(int size);
    
    /// Get height for a specific size
    virtual int getHeight(int size);

protected:
    int m_minSize;
    int m_maxSize;
    double m_whRatio; // width/height ratio
};

#endif
