/***************************************************************************
                          confmenudialog.cpp  -  description
                             -------------------
    begin                : Tue Jun 10 22:18:34 BST 2003
    copyright            : (C) 2004 by KSmoothDock team
    email                : dangvd@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/// @TODO: re-format the file according to KSmoothDock v4.0's coding style

#include "launcherconfigdialog.h"

#include <qvariant.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qpixmap.h>

#include <klistbox.h>
#include <kicondialog.h>
#include <kdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <kstandarddirs.h>
#include <kiconloader.h>

#include "launcher.h"

/*
 *  Constructs a LauncherConfigDialog as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
LauncherConfigDialog::LauncherConfigDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
        setName( "Form1" );

    groupBox1 = new QGroupBox( this, "groupBox1" );
    groupBox1->setGeometry( QRect( 20, 20, 820, 470 ) );

    textLabel1 = new QLabel( groupBox1, "textLabel1" );
    textLabel1->setGeometry( QRect( 470, 20, 141, 41 ) );

    btBrowse = new QPushButton( groupBox1, "btBrowse" );
    btBrowse->setGeometry( QRect( 580, 20, 180, 40 ) );

    btFolderLink = new QPushButton( groupBox1, "btFolderLink" );
    btFolderLink->setGeometry( QRect( 580, 70, 180, 40 ) );

    textLabel2 = new QLabel( groupBox1, "textLabel2" );
    textLabel2->setGeometry( QRect( 470, 180, 151, 41 ) );

    textLabel3 = new QLabel( groupBox1, "textLabel3" );
    textLabel3->setGeometry( QRect( 470, 320, 50, 51 ) );

    edtCommand = new QLineEdit( groupBox1, "edtCommand" );
    edtCommand->setGeometry( QRect( 470, 140, 330, 40 ) );

    edtName = new QLineEdit( groupBox1, "edtName" );
    edtName->setGeometry( QRect( 470, 230, 330, 40 ) );

    ibtIcon = new KIconButton( groupBox1, "ibtIcon" );
    ibtIcon->setGeometry( QRect( 570, 320, 101, 101 ) );

    lbItems = new KListBox( groupBox1, "lbItems" );
    lbItems->setGeometry( QRect( 20, 20, 260, 430 ) );
    lbItems->setVariableWidth( FALSE );
    lbItems->setVariableHeight( TRUE );

    buttonGroup1 = new QButtonGroup( groupBox1, "buttonGroup1" );
    buttonGroup1->setGeometry( QRect( 300, 20, 140, 260 ) );

    btMoveDown = new QPushButton( buttonGroup1, "btMoveDown" );
    btMoveDown->setGeometry( QRect( 20, 210, 101, 40 ) );

    btMoveUp_ = new QPushButton( buttonGroup1, "btMoveUp_" );
    btMoveUp_->setGeometry( QRect( 20, 160, 101, 40 ) );

    btUpdate = new QPushButton( buttonGroup1, "btUpdate" );
    btUpdate->setGeometry( QRect( 20, 110, 101, 40 ) );

    btRemove = new QPushButton( buttonGroup1, "btRemove" );
    btRemove->setGeometry( QRect( 20, 60, 101, 40 ) );

    btAdd = new QPushButton( buttonGroup1, "btAdd" );
    btAdd->setGeometry( QRect( 20, 10, 101, 40 ) );

    groupBox2 = new QGroupBox( groupBox1, "groupBox2" );
    groupBox2->setGeometry( QRect( 300, 300, 140, 150 ) );

    btOpenMenuFolder = new QPushButton( groupBox2, "btOpenMenuFolder" );
    btOpenMenuFolder->setGeometry( QRect( 20, 10, 101, 60 ) );

    btSync = new QPushButton( groupBox2, "btSync" );
    btSync->setGeometry( QRect( 20, 80, 101, 60 ) );

    btApply = new QPushButton( this, "btApply" );
    btApply->setGeometry( QRect( 230, 510, 151, 41 ) );

    btClose = new QPushButton( this, "btClose" );
    btClose->setGeometry( QRect( 480, 510, 131, 41 ) );
    languageChange();
    resize( QSize(859, 568).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( btAdd, SIGNAL( clicked() ), this, SLOT( btAdd_clicked() ) );
    connect( btRemove, SIGNAL( clicked() ), this, SLOT( btRemove_clicked() ) );
    connect( btUpdate, SIGNAL( clicked() ), this, SLOT( btUpdate_clicked() ) );
    connect( btMoveUp_, SIGNAL( clicked() ), this, SLOT( btMoveUp__clicked() ) );
    connect( btMoveDown, SIGNAL( clicked() ), this, SLOT( btMoveDown_clicked() ) );
    connect( btBrowse, SIGNAL( clicked() ), this, SLOT( btBrowse_clicked() ) );
    connect( btFolderLink, SIGNAL( clicked() ), this, SLOT( btFolderLink_clicked() ) );
    connect( btApply, SIGNAL( clicked() ), this, SLOT( btApply_clicked() ) );
    connect( btClose, SIGNAL( clicked() ), this, SLOT( btClose_clicked() ) );
    connect( btOpenMenuFolder, SIGNAL( clicked() ), this, SLOT( btOpenMenuFolder_clicked() ) );
    connect( btSync, SIGNAL( clicked() ), this, SLOT( btSync_clicked() ) );
	connect( lbItems, SIGNAL( selectionChanged() ), this, SLOT( selectedItemChanged() ) );
		
	items.setAutoDelete(true);
    menuPath = locateLocal("data", "ksmoothdock") + QString("/menu/");
}

/*
 *  Destroys the object and frees any allocated resources
 */
LauncherConfigDialog::~LauncherConfigDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void LauncherConfigDialog::languageChange()
{
    setCaption( tr2i18n( "KSmoothDock Quick Launch Menu" ) );
    groupBox1->setTitle( QString::null );
    textLabel1->setText( tr2i18n( "Command" ) );
    textLabel2->setText( tr2i18n( "Description" ) );
    textLabel3->setText( tr2i18n( "Icon" ) );
    ibtIcon->setText( QString::null );
    buttonGroup1->setTitle( QString::null );
    btMoveDown->setText( tr2i18n( "Move &Down" ) );
    btMoveDown->setAccel( QKeySequence( tr2i18n( "Alt+D" ) ) );
    QToolTip::add( btMoveDown, tr2i18n( "Move the current item down the list" ) );
    btMoveUp_->setText( tr2i18n( "Move &Up" ) );
    btMoveUp_->setAccel( QKeySequence( tr2i18n( "Alt+U" ) ) );
    QToolTip::add( btMoveUp_, tr2i18n( "Move the current item up the list" ) );
    btUpdate->setText( tr2i18n( "&Update" ) );
    btUpdate->setAccel( QKeySequence( tr2i18n( "Alt+U" ) ) );
    QToolTip::add( btUpdate, tr2i18n( "Update the current item with information from the right hand side" ) );
    btRemove->setText( tr2i18n( "&Remove" ) );
    btRemove->setAccel( QKeySequence( tr2i18n( "Alt+R" ) ) );
    QToolTip::add( btRemove, tr2i18n( "Remove the current item from the Quick Launch Menu" ) );
    btAdd->setText( tr2i18n( "&Add" ) );
    btAdd->setAccel( QKeySequence( tr2i18n( "Alt+A" ) ) );
    QToolTip::add( btAdd, tr2i18n( "Add a new item to the Quick Launch Menu" ) );
    groupBox2->setTitle( QString::null );
    btOpenMenuFolder->setText( tr2i18n( "Open Menu \n"
"&Folder" ) );
    btOpenMenuFolder->setAccel( QKeySequence( tr2i18n( "Alt+F" ) ) );
    QToolTip::add( btOpenMenuFolder, tr2i18n( "Open the folder which contains the menu, so that you can copy/drag&drop existing application links to" ) );
    btSync->setText( tr2i18n( "&Sync With\n"
"Menu Folder" ) );
    btSync->setAccel( QKeySequence( tr2i18n( "Alt+S" ) ) );
    QToolTip::add( btSync, tr2i18n( "Update the content of the dialog with the content of the menu folder, in case you have opened the menu folder and changed its content" ) );
    btBrowse->setText( tr2i18n( "&Browse Executable" ) );
    btBrowse->setAccel( QKeySequence( tr2i18n( "Alt+B" ) ) );
    btFolderLink->setText( tr2i18n( "&Link to Folder" ) );
    btFolderLink->setAccel( QKeySequence( tr2i18n( "Alt+L" ) ) );
    btApply->setText( tr2i18n( "&Apply" ) );
    btApply->setAccel( QKeySequence( tr2i18n( "Alt+A" ) ) );
    QToolTip::add( btApply, tr2i18n( "Apply the change to the KSmoothDock panel" ) );
    btClose->setText( tr2i18n( "&Close" ) );
    btClose->setAccel( QKeySequence( tr2i18n( "Alt+C" ) ) );
    QToolTip::add( btClose, tr2i18n( "Close this dialog" ) );
}

void LauncherConfigDialog::btAdd_clicked()
{
	int i = lbItems->currentItem();
	if (lbItems->isSelected(i)) {		
		lbItems->clearSelection();
		edtName->setText("");
		edtCommand->setText("");
		ibtIcon->setIcon("");
		KMessageBox::information(this, "Please fill in the item information (command, description, icon) then click \"Add\" again.");	
	} else {
		if (edtCommand->text() == "" || edtName->text() == "") {
			KMessageBox::information(this, "Please fill in the item information (command, description, icon) then click \"Add\" again.");	
		} else {
			Launcher *item = new Launcher(edtName->text(), ibtIcon->icon(), edtCommand->text());
			items.append(item);
            
            KIconLoader* iLoader = KGlobal::iconLoader();

            QPixmap pix = iLoader->loadIcon(ibtIcon->icon(), KIcon::NoGroup, LAUNCHER_CONFIG_DIALOG_ICON_SIZE);
			lbItems->insertItem(pix, edtName->text());
			lbItems->setSelected(items.count() - 1, true);
			lbItems->ensureCurrentVisible();
		}
	}
}


void LauncherConfigDialog::btRemove_clicked()
{
	int i = lbItems->currentItem();
	if (lbItems->isSelected(i)) {
		items.remove(i);
		lbItems->removeItem(i);	
		if (i < items.count())
			lbItems->setSelected(i, true);
		else if (items.count() > 0)
			lbItems->setSelected(i - 1, true);
		else {
			edtName->setText("");
			edtCommand->setText("");
			ibtIcon->setIcon("");
		}
	}
}


void LauncherConfigDialog::btUpdate_clicked()
{
	int i = lbItems->currentItem();
	if (lbItems->isSelected(i)) {
		Launcher *item = items.at(i);
		item->setDescription(edtName->text());
		item->setCommand(edtCommand->text());
		item->setIconName(ibtIcon->icon());
		
        KIconLoader* iLoader = KGlobal::iconLoader();
        QPixmap pix = iLoader->loadIcon(ibtIcon->icon(), KIcon::NoGroup, LAUNCHER_CONFIG_DIALOG_ICON_SIZE);
		lbItems->changeItem(pix, item->getDescription(), i);
	}
}


void LauncherConfigDialog::btMoveUp__clicked()
{
	int i = lbItems->currentItem();
	if (lbItems->isSelected(i) && i > 0) {
		items.setAutoDelete(false);
		Launcher *prev = items.at(i - 1);
		Launcher *cur = items.at(i);
		items.replace(i - 1, cur);
		items.replace(i, prev);
		items.setAutoDelete(true);
	
		KIconLoader* iLoader = KGlobal::iconLoader();
        QPixmap pix = iLoader->loadIcon(prev->getIconName(), KIcon::NoGroup, LAUNCHER_CONFIG_DIALOG_ICON_SIZE);
		lbItems->changeItem(pix, prev->getDescription(), i);
		pix = iLoader->loadIcon(cur->getIconName(), KIcon::NoGroup, LAUNCHER_CONFIG_DIALOG_ICON_SIZE);
		lbItems->changeItem(pix, cur->getDescription(), i - 1);		
	}
}


void LauncherConfigDialog::btMoveDown_clicked()
{
	int i = lbItems->currentItem();
	if (lbItems->isSelected(i) && i < items.count() - 1) {
		items.setAutoDelete(false);
		Launcher *prev = items.at(i + 1);
		Launcher *cur = items.at(i);
		items.replace(i + 1, cur);
		items.replace(i, prev);
		items.setAutoDelete(true);
	
		KIconLoader* iLoader = KGlobal::iconLoader();
        QPixmap pix = iLoader->loadIcon(prev->getIconName(), KIcon::NoGroup, LAUNCHER_CONFIG_DIALOG_ICON_SIZE);
		lbItems->changeItem(pix, prev->getDescription(), i);
		pix = iLoader->loadIcon(cur->getIconName(), KIcon::NoGroup, LAUNCHER_CONFIG_DIALOG_ICON_SIZE);
		lbItems->changeItem(pix, cur->getDescription(), i + 1);		
	}
}


void LauncherConfigDialog::btBrowse_clicked()
{
	QString cmd = KFileDialog::getOpenFileName(QString::null, QString::null, 0, "Select Executable");
	if (cmd != "")
		edtCommand->setText(cmd);
}

void LauncherConfigDialog::btFolderLink_clicked() {
    QString cmd = KFileDialog::getExistingDirectory(QString::null,   0, "Select Folder");
    edtCommand->setText("konqueror " + cmd);
}

void LauncherConfigDialog::btApply_clicked()
{
	saveAll();
	emit updated();
}


void LauncherConfigDialog::btClose_clicked()
{
	reject();
}

void LauncherConfigDialog::btOpenMenuFolder_clicked() {	
	KProcess *proc = new KProcess;
  *proc << "konqueror" << menuPath;
  proc->start(KProcess::DontCare);
}

void LauncherConfigDialog::btSync_clicked() {
	update();
}

void LauncherConfigDialog::update() {
    edtName->setText("");
    edtCommand->setText("");
    ibtIcon->setIcon("");
    
    lbItems->clear();
    items.clear();
    
    QDir homeDir = QDir::home();
    if (homeDir.exists(menuPath)) {
        QDir dir(menuPath);
            
        QStringList fileList = dir.entryList( "*");
        for ( QStringList::Iterator it = fileList.begin(); it != fileList.end(); ++it ) {
            if ( (*it) && ((*it) != ".") && ((*it) != "..") ) {
        //        cout << ( *it ) << endl;
                Launcher *item = new Launcher(menuPath + (*it));
                KIconLoader* iLoader = KGlobal::iconLoader();
                QPixmap pix = iLoader->loadIcon(item->getIconName(), KIcon::NoGroup, LAUNCHER_CONFIG_DIALOG_ICON_SIZE);
                lbItems->insertItem(pix, item->getDescription());
                items.append(item);
            }
        }
    }
}

void LauncherConfigDialog::selectedItemChanged() {
	int i = lbItems->currentItem();
	if (i >= 0 && i < items.count()) {
		Launcher *item = items.at(i);
		if (item) {
			edtName->setText(item->getDescription());
			edtCommand->setText(item->getCommand());
			ibtIcon->setIcon(item->getIconName());
		}
	}
}

void LauncherConfigDialog::saveAll() {
    QDir homeDir = QDir::home();
        
        // delete all old files
        
    if (homeDir.exists(menuPath)) {
            
        QDir dir(menuPath);
            
        QStringList fileList = dir.entryList( "*");
        for ( QStringList::Iterator it = fileList.begin(); it != fileList.end(); ++it ) {
        if ( (*it) && ((*it) != ".") && ((*it) != "..") ) {
                    if (dir.exists(*it))
                        dir.remove(*it);
        }
        }
    } else {
        homeDir.mkdir(locateLocal("data", "ksmoothdock"));
        homeDir.mkdir(menuPath);
    }

    // write new files
    
    for (int i = 0; i < items.count(); i++) {
        Launcher *item = items.at(i);
        QString fileName = "";
        
        // naming the file so that they are sorted correctly
        
        if (i < 10)
            fileName = QString::number(i) + " - " + item->getDescription();
        else {
            char c = 'a' + i - 10;
            fileName = c;
            fileName = fileName + " - " + item->getDescription();
        }
        
        item->saveToFile(menuPath + fileName);
    }
}

#include "launcherconfigdialog.moc"

