/***************************************************************************
 *   Copyright (C) 2006 by The KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "separator.h"

#include <qpainter.h>

#include "ksmoothdock.h"

/**
 * Constructor
 */

Separator::Separator(KSmoothDock* parent, int itemId, int desktop, int minSize, int maxSize, double whRatio, Qt::Orientation orientation)
 : IconlessDockItem(parent, itemId, "", desktop, minSize, maxSize, whRatio, orientation) {
}

/**
 * Draw itself into the offscreen buffer
 */

void Separator::draw(QPixmap& buffer, int x, int y, int size) {
    QPainter p(&buffer);

    if (m_parent->getZoomMode() == NORMAL_ZOOM) {
        p.fillRect(x, y, getWidth(size), getHeight(size), m_parent->getSeparatorColor());
    } else if (size == m_minSize) { // Parabolic zoom
        switch(m_parent->getPosition()) {
        case LEFT:
            p.fillRect(x - m_parent->getSmallIconSize()/4, y, getWidth(size), getHeight(size), m_parent->getSeparatorColor());
            break;
        case RIGHT:
            p.fillRect(x + m_parent->getSmallIconSize()/4, y, getWidth(size), getHeight(size), m_parent->getSeparatorColor());
            break;
        case TOP:
            p.fillRect(x, y - m_parent->getSmallIconSize()/4, getWidth(size), getHeight(size), m_parent->getSeparatorColor());
            break;
        case BOTTOM:
            p.fillRect(x, y + m_parent->getSmallIconSize()/4, getWidth(size), getHeight(size), m_parent->getSeparatorColor());
            break;
        default:
            break;
        }        
    }
}

/**
 * Mouse pressed event handler
 */

void Separator::mousePressEvent(QMouseEvent* e) {}

/** 
 * Get max width
 */

int Separator::getMaxWidth() {
    if (m_parent->getZoomMode() == NORMAL_ZOOM) {
        if (m_orientation == Qt::Horizontal) {
            return 1;
        } else { // Vertical
            return m_maxSize;
        }
    } else { // Parabolic zoom
        return 0; // do not show separator when zooming in
    }
}

/** 
 * Get max height
 */

int Separator::getMaxHeight() {
    if (m_parent->getZoomMode() == NORMAL_ZOOM) {
        if (m_orientation == Qt::Horizontal) {
            return m_maxSize;
        } else { // Vertical
            return 1;
        }
    } else { // Parabolic zoom
        return 0; // do not show separator when zooming in
    }
}

/** 
 * Get min width
 */

int Separator::getMinWidth() {
    if (m_orientation == Qt::Horizontal) {
        return 1;
    } else { // Vertical
        if (m_parent->getZoomMode() == NORMAL_ZOOM) {
            return m_maxSize;
        } else { // Parabolic zoom
            return m_minSize*3/2;
        }
    }
}

/** 
 * Get min height
 */

int Separator::getMinHeight() {
    if (m_orientation == Qt::Horizontal) {
        if (m_parent->getZoomMode() == NORMAL_ZOOM) {
            return m_maxSize;
        } else { // Parabolic zoom
            return m_minSize*3/2;
        }
    } else { // Vertical
        return 1;
    }
}

/**
 * Get width for a specific size
 */

int Separator::getWidth(int size) {
    if (size == m_minSize) {
        return getMinWidth();
    } else {
        if (m_parent->getZoomMode() == NORMAL_ZOOM) {
            if (m_orientation == Qt::Horizontal) {
                return 1;
            } else { // Vertical
                return size;
            }
        } else { // Parabolic zoom
            return 0; // do not show separator when zooming in
        }
    }
}
    
/**
 * Get height for a specific size
 */

int Separator::getHeight(int size) {
    if (size == m_minSize) {
        return getMinHeight();
    } else {
        if (m_parent->getZoomMode() == NORMAL_ZOOM) {
            if (m_orientation == Qt::Horizontal) {
                return size;
            } else { // Vertical
                return 1;
            }
        } else { // Parabolic zoom
            return 0; // do not show separator when zooming in
        }
    }
}

