/***************************************************************************
 *   Copyright (C) 2006 by The KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SEPARATOR_H
#define SEPARATOR_H

#include "iconlessdockitem.h"

/**
 * @short Class represents separators (for example, the one between the launchers and the tasks if the pager is not shown)
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

class Separator : public IconlessDockItem
{
public:
    /// Constructor
    Separator(KSmoothDock* parent, int itemId, int desktop, int minSize, int maxSize, double whRatio, Qt::Orientation orientation);

    /// Draw itself into the offscreen buffer
    virtual void draw(QPixmap& buffer, int x, int y, int size);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

    /// Get max width
    virtual int getMaxWidth();
    
    /// Get max height
    virtual int getMaxHeight();

    /// Get min width
    virtual int getMinWidth();
    
    /// Get min height
    virtual int getMinHeight();

    /// Get width for a specific size
    virtual int getWidth(int size);
    
    /// Get height for a specific size
    virtual int getHeight(int size);
};

#endif
