/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WALLPAPERMANAGER_H
#define WALLPAPERMANAGER_H

#include <vector>

#include <qdatetime.h>
#include <qobject.h>

#include <ksharedpixmap.h>

/**
 * @short Wallpaper manager class
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

class WallpaperManager : public QObject {
    Q_OBJECT
public:
    WallpaperManager(int numDesks);

    ~WallpaperManager();

    /// Check if desktop wallpapers have been changed
    bool wallpapersChanged(); 

    /// Load the current wallpaper
    void loadWallpaper();
    
    /// Get a wallpaper
    QPixmap& getWallpaper(int desk);

signals:
    /// Signal that the wallpaper has been loaded successful
    void wallpaperLoaded();
public slots:
    /// Handle the event when the wallpaper has been loaded
    void receiveWallpaper(bool success);

private:
    /// Initiate the wallpapers
    void initWallpapers();

private:
    QString m_configFile; // path to desktop config file
    QDateTime m_lastUpdateTime; // last update time of the config file

    int m_numDesktops; // number of virtual desktops

    std::vector<KSharedPixmap*> m_wallpapers;
    std::vector<bool> m_wallpapersLoaded;
};

#endif
