/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qpixmap.h>
#include <qpaintdevice.h>
#include <kiconeffect.h>
#include <kicontheme.h>
#include <kcursor.h>
#include "clickablelabel.h"

ClickableLabel::ClickableLabel(QWidget *parent, const char *name)
 : QLabel(parent, name)
{
	leftButtonDown = false;
	rightButtonDown = false;
	highlighted = false;
	effectsEnabled = true;
	setFrameStyle(NoFrame);
	setCursor(KCursor::handCursor());
}


ClickableLabel::~ClickableLabel()
{
}

void ClickableLabel::mousePressEvent(QMouseEvent *event)
{
	if (event->stateAfter() & QMouseEvent::LeftButton) {
		leftButtonDown = true;
		event->accept();
	}
	if (event->stateAfter() & QMouseEvent::RightButton) {
		rightButtonDown = true;
		event->accept();
	}
}

void ClickableLabel::mouseReleaseEvent(QMouseEvent *event)
{
	if (!geometry().contains(mapToParent(event->pos()))) return;
	if (leftButtonDown && !(event->stateAfter() & QMouseEvent::LeftButton)) {
		leftButtonDown = false;
		emit clicked();
		event->accept();
	}
	if (rightButtonDown && !(event->stateAfter() & QMouseEvent::RightButton)) {
		rightButtonDown = false;
		emit rightClicked();
		event->accept();
	}
}

void ClickableLabel::enterEvent(QEvent *e)
{
	setHighlighted(effectsEnabled);
	QFrame::enterEvent( e );
}

void ClickableLabel::leaveEvent(QEvent *e)
{
	setHighlighted(false);
	QFrame::leaveEvent( e );
}

void ClickableLabel::setPixmap ( const QPixmap & pixmap )
{
	KIconEffect effect;
	effect.init();
	if (highlighted) {
		otherPixmap = pixmap;
		QLabel::setPixmap(effect.apply(pixmap,KIcon::Panel,KIcon::ActiveState));
	} else {
		otherPixmap = effect.apply(pixmap,KIcon::Panel,KIcon::ActiveState);
		QLabel::setPixmap(pixmap);
	}
}

bool ClickableLabel::isHighlighted()
{
	return highlighted;
}

void ClickableLabel::setHighlighted(bool highlighted)
{
	if (this->highlighted==highlighted)
		return;
	this->highlighted = highlighted;
	if (effectsEnabled) {
		QPixmap temp = *pixmap();
		QLabel::setPixmap(otherPixmap);
		otherPixmap = temp;
	}
}

bool ClickableLabel::isEffectsEnabled()
{
	return effectsEnabled;
}

void ClickableLabel::setEffectsEnabled(bool effectsEnabled)
{
	if (!effectsEnabled)
		setHighlighted(false);
	this->effectsEnabled = effectsEnabled;
}


#include "clickablelabel.moc"
