/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CLICKABLELABEL_H
#define CLICKABLELABEL_H

#include <qlabel.h>

/**
@author Michał Kosmulski
*/
class ClickableLabel : public QLabel
{
Q_OBJECT
public:
    ClickableLabel(QWidget *parent = 0, const char *name = 0);

    ~ClickableLabel();
    
    bool isHighlighted();
    void setHighlighted(bool highlighted);
    bool isEffectsEnabled();
    void setEffectsEnabled(bool enabled);

public slots:
	void setPixmap ( const QPixmap & );

signals:
	void clicked();
	void rightClicked();

protected:
	bool leftButtonDown;
	bool rightButtonDown;
	QPixmap otherPixmap;
	bool highlighted;
	bool effectsEnabled;
	
	void mousePressEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
	void enterEvent(QEvent *e);
	void leaveEvent(QEvent *e);
};

#endif
