/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kconfig.h>
#include "configuration.h"

const QString Configuration::defAnimationFile = KGlobal::dirs()->findResource( "data", "kuote/animations/fishanim-transparent.png");
const int Configuration::defNumFrames = 3;
const int Configuration::defAnimDelay = 1000;
const bool Configuration::defShowFortuneInTT = true;
const bool Configuration::defTruncateLongTT = false;
const bool Configuration::defApplyEffects = true;
//program
const bool Configuration::defUseCustomProgram = false;
const QString Configuration::defFortunesDir = "/usr/share/games/fortunes";
const QString Configuration::defCustomProgram = "fortune linuxcookie -m penguin";
//fortunes
const QStringList Configuration::defSelectedFortunes = QStringList("fortunes");
QValueList<int> zeroList() { QValueList<int> l; l.push_back(0); return l; }
const QValueList<int> Configuration::defSelectedFortunesProbs = zeroList();
const bool Configuration::defConsiderSizes = true;
const Configuration::Lengths Configuration::defLength = Configuration::lenAny;
const Configuration::Types Configuration::defType = Configuration::typeNonOffensive;

Configuration::Configuration()
{
	setDefaults();
}

Configuration& Config()
{
    static Configuration conf;
    return conf;
}

void Configuration::setDefaults()
{
	animationFile = defAnimationFile;
	numFrames = defNumFrames;
	animDelay = defAnimDelay;
	showFortuneInTT = defShowFortuneInTT;
	truncateLongTT = defTruncateLongTT;
	applyEffects = defApplyEffects;
	//program
	useCustomProgram = defUseCustomProgram;
	fortunesDir = defFortunesDir;
	customProgram = defCustomProgram;
	//fortunes
	selectedFortunes = defSelectedFortunes;
	selectedFortunesProbs = defSelectedFortunesProbs;
	considerSizes = defConsiderSizes;
	length = defLength;
	type = defType;
}

void Configuration::read(KConfig *config)
{
	config->setGroup("Animation");
	animationFile = config->readPathEntry("animationFile",defAnimationFile);
	numFrames = config->readNumEntry("numFrames",defNumFrames);
	animDelay = config->readNumEntry("animDelay",defAnimDelay);
	showFortuneInTT = config->readBoolEntry("showFortuneInTT",defShowFortuneInTT);
	truncateLongTT = config->readBoolEntry("truncateLongTT",defTruncateLongTT);
	applyEffects = config->readBoolEntry("applyEffects",defApplyEffects);
	config->setGroup("Program");
	useCustomProgram = config->readBoolEntry("useCustomProgram",defUseCustomProgram);
	fortunesDir = config->readPathEntry("fortunesDir",defFortunesDir);
	customProgram = config->readEntry("customProgram",defCustomProgram);
	config->setGroup("Fortunes");
	selectedFortunes = config->readListEntry("selectedFortunes");
	selectedFortunesProbs = config->readIntListEntry("selectedFortunesProbs");
	//make sure both lists are same length
	if(selectedFortunesProbs.size() < selectedFortunes.size()) {
		for (int i = 0; i < selectedFortunes.size()-selectedFortunesProbs.size(); i++)
			selectedFortunesProbs.push_back(0);
	}
	considerSizes = config->readBoolEntry("considerSizes",defConsiderSizes);
	length = (Lengths)config->readNumEntry("length",defLength);
	type = (Types)config->readNumEntry("type",defType);
}

void Configuration::write(KConfig *config) const
{
	config->setGroup("Animation");
	config->writePathEntry("animationFile",animationFile);
	config->writeEntry("numFrames",numFrames);
	config->writeEntry("animDelay",animDelay);
	config->writeEntry("showFortuneInTT",showFortuneInTT);
	config->writeEntry("truncateLongTT",truncateLongTT);
	config->writeEntry("applyEffects",applyEffects);
	config->setGroup("Program");
	config->writeEntry("useCustomProgram",useCustomProgram);
	config->writePathEntry("fortunesDir",fortunesDir);
	config->writeEntry("customProgram",customProgram);
	config->setGroup("Fortunes");
	config->writeEntry("selectedFortunes",selectedFortunes);
	config->writeEntry("selectedFortunesProbs",selectedFortunesProbs);
	config->writeEntry("considerSizes",considerSizes);
	config->writeEntry("length",length);
	config->writeEntry("type",type);
	config->sync();
}
