/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <kglobal.h>
#include <kstandarddirs.h>

/**
@author Michał Kosmulski
*/
class Configuration{
public:
	//configuration options
	//animation
	QString animationFile; //URL of file with animation image
	int numFrames; //number of frames in animation file
	int animDelay; //animation delay [milliseconds]
	bool showFortuneInTT; //should fortunes be shown in tooltips ?
	bool truncateLongTT; //should long fortunes in tooltips be truncated ?
	bool applyEffects; //should icon effects be applied to animation when mouse is over it ?
	//program
	bool useCustomProgram; //use custom program ? (if not, fortune is used)
	QString fortunesDir; //default directory to scan for fortune files
	QString customProgram; //custom program to run
	//fortunes
	QStringList selectedFortunes; //list of selected fortune file basenames
	QValueList<int> selectedFortunesProbs; //and their probabilities
	bool considerSizes; //take file sizes into account when calculating probabilities ?
	enum Lengths { lenAny, lenLong, lenShort };
	Lengths length;
	enum Types { typeNonOffensive, typeOffensive, typeAny };
	Types type;
	
	//default values
	//animation
	static const QString defAnimationFile;
	static const int defNumFrames;
	static const int defAnimDelay;
	static const bool defShowFortuneInTT;
	static const bool defTruncateLongTT;
	static const bool defApplyEffects;
	//program
	static const bool defUseCustomProgram;
	static const QString defFortunesDir;
	static const QString defCustomProgram;
	//fortunes
	static const QStringList defSelectedFortunes;
	static const QValueList<int> defSelectedFortunesProbs;
	static const bool defConsiderSizes;
	static const Lengths defLength;
	static const Types defType;
	
	void setDefaults();
	void read(KConfig *config);
	void write(KConfig *config) const;
	
private:
    Configuration();
    //Configuration(const Configuration&);

    // allow this function to create one instance
    friend Configuration& Config();
};

#endif
