/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlayout.h>
#include <qpushbutton.h>
#include <ktextbrowser.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <qsize.h>
#include <qiconset.h>
#include "fortunedialog.h"
#include "kuote.h"

FortuneDialog::FortuneDialog(QWidget *parent, const char *name)
 : KDialogBase(Plain,i18n("Fortune"),Close | User1,User1,parent,name,false)
{
	setButtonText(User1,i18n("&Next fortune"));
	actionButton(User1)->setIconSet(QIconSet(KGlobal::iconLoader()->loadIcon("next",KIcon::Small,KIcon::DefaultState,false)));
	QGridLayout *frameLayout = new QGridLayout(plainPage());
	text = new KTextBrowser(plainPage());
	text->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
	text->setWordWrap(KTextBrowser::NoWrap);
	resize(QSize(600,300)); //FIXME: get reasonable size hint out of KTextBrowser
	frameLayout->addWidget(text,0,0);
}


FortuneDialog::~FortuneDialog()
{
}

void FortuneDialog::setText(QString str)
{
	text->setText(str);
	plainPage()->updateGeometry();
}

void FortuneDialog::slotUser1()
{
	setText(((kuote *)parent())->getCurrentFortune());
	//prepare fortune for next time
	((kuote *)parent())->askFortune();
}

void FortuneDialog::slotClose()
{
	KDialogBase::slotClose();
	delayedDestruct();
}

#include "fortunedialog.moc"
