/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qpixmap.h>
#include <qlabel.h>
#include <kurlrequester.h>
#include <klineedit.h>
#include <kimageio.h>
#include <knuminput.h>
#include <qcheckbox.h>
#include <kio/netaccess.h>
#include "prefanimation.h"
#include "configuration.h"

PrefAnimation::PrefAnimation(QWidget *parent, const char *name)
 : PrefAnimationLayout(parent, name)
{
	updateDialog();
	
	imagePreview->setScaledContents(true);
	fileSelector->setFilter(KImageIO::pattern(KImageIO::Reading));
	fileSelector->setMode(KFile::File | KFile::ExistingOnly);
	fileSelector->lineEdit()->setTrapReturnKey(true);
	
	animDelay->setPrecision(1);
	animDelay->setRange(0.1,3600.0,0.1,false);
	
	connect(fileSelector,SIGNAL(urlSelected(const QString &)),this,SLOT(updateImage(const QString &)));
	connect(fileSelector,SIGNAL(returnPressed(const QString &)),this,SLOT(updateImage(const QString &)));
	
	connect(fileSelector,SIGNAL(urlSelected(const QString &)),this,SIGNAL(somethingChanged()));
	connect(fileSelector,SIGNAL(returnPressed(const QString &)),this,SIGNAL(somethingChanged()));
	connect(fileSelector,SIGNAL(textChanged(const QString &)),this,SIGNAL(somethingChanged()));
	connect(numFrames,SIGNAL(valueChanged(int)),this,SIGNAL(somethingChanged()));
	connect(animDelay,SIGNAL(valueChanged(double)),this,SIGNAL(somethingChanged()));
	connect(showFortuneInTT,SIGNAL(toggled(bool)),this,SIGNAL(somethingChanged()));
	connect(truncateLongTT,SIGNAL(toggled(bool)),this,SIGNAL(somethingChanged()));
	connect(applyEffects,SIGNAL(toggled(bool)),this,SIGNAL(somethingChanged()));
}


PrefAnimation::~PrefAnimation()
{
}

void PrefAnimation::updateImage(const QString &fileName)
{
	QString tempFile;
	if (KIO::NetAccess::download(fileName,tempFile)) {
		imagePreview->setPixmap(*(new QPixmap(tempFile)));
		KIO::NetAccess::removeTempFile(tempFile);
	} else {
		imagePreview->clear();
	}
}

void PrefAnimation::updateDialog()
{
	fileSelector->setURL(Config().animationFile);
	updateImage(Config().animationFile);
	numFrames->setValue(Config().numFrames);
	animDelay->setValue(Config().animDelay/1000.0);
	showFortuneInTT->setChecked(Config().showFortuneInTT);
	truncateLongTT->setChecked(Config().truncateLongTT);
	applyEffects->setChecked(Config().applyEffects);
}

void PrefAnimation::updateData()
{
	Config().animationFile = fileSelector->url();
	Config().numFrames = numFrames->value();
	Config().animDelay = (int)(animDelay->value()*1000.0);
	Config().showFortuneInTT = showFortuneInTT->isChecked();
	Config().truncateLongTT = truncateLongTT->isChecked();
	Config().applyEffects = applyEffects->isChecked();
}

void PrefAnimation::loadDefaults()
{
	fileSelector->setURL(Config().defAnimationFile);
	updateImage(Config().defAnimationFile);
	numFrames->setValue(Config().defNumFrames);
	animDelay->setValue(Config().defAnimDelay/1000.0);
	showFortuneInTT->setChecked(Config().defShowFortuneInTT);
	truncateLongTT->setChecked(Config().defTruncateLongTT);
	applyEffects->setChecked(Config().defApplyEffects);
}

#include "prefanimation.moc"
