/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlayout.h>
#include <qframe.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qcombobox.h>
#include <kurlrequester.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <qradiobutton.h>
#include <qsize.h>

#include "clickablelabel.h"
#include "prefanimation.h"
#include "prefprogram.h"
#include "preffortunes.h"
#include "prefdialog.h"
#include "configuration.h"
#include "prefdialog.moc"

PrefDialog::PrefDialog(QWidget *parent, const char *name, WFlags f)
 : KDialogBase(IconList,i18n("Configure"),Default|Ok|Apply|Cancel,Ok,parent,name,f)
{
	QFrame *frame = addPage(i18n("Animation"), i18n("Animation image and timings"),
		KGlobal::iconLoader()->loadIcon("video",KIcon::Desktop,0,false));
	QVBoxLayout *frameLayout = new QVBoxLayout(frame, 0, 0);
	prefAnimation = new PrefAnimation(frame);
	frameLayout->addWidget(prefAnimation);
	
	frame = addPage(i18n("Program"), i18n("Program used for generating quotes"),
		KGlobal::iconLoader()->loadIcon("run",KIcon::Desktop,0,false));
	frameLayout = new QVBoxLayout(frame, 0, 0);
	prefProgram = new PrefProgram(frame);
	frameLayout->addWidget(prefProgram);
	
	frame = addPage(i18n("Fortunes"), i18n("Quotes to be displayed"),
		KGlobal::iconLoader()->loadIcon("ktip",KIcon::Desktop,0,false));
	frameLayout = new QVBoxLayout(frame, 0, 0);
	prefFortunes = new PrefFortunes(frame);
	frameLayout->addWidget(prefFortunes);
	
	connect(prefAnimation,SIGNAL(somethingChanged()),this,SLOT(slotSomethingChanged()));
	connect(prefProgram,SIGNAL(somethingChanged()),this,SLOT(slotSomethingChanged()));
	connect(prefFortunes,SIGNAL(somethingChanged()),this,SLOT(slotSomethingChanged()));
	
	prefAnimation->updateDialog();
	prefProgram->updateDialog();
	prefFortunes->updateDialog();
	enableButtonApply(false);
}


PrefDialog::~PrefDialog()
{
}

void PrefDialog::slotApply()
{
	if (checkOffense())
		updateData();
}

void PrefDialog::slotOk()
{
	if (checkOffense()) {
		updateData();
		close();
	}
}

void PrefDialog::slotDefault()
{
	if (KMessageBox::warningContinueCancel(this, i18n("This will set the default options "
		"in ALL pages of the preferences dialog! Continue?"), i18n("Set default options?"),
		i18n("Set defaults"))==KMessageBox::Continue)	{
		prefAnimation->loadDefaults();
		prefProgram->loadDefaults();
		prefFortunes->loadDefaults();
	}
}

void PrefDialog::slotSomethingChanged()
{
	enableButtonApply(true);
}

bool PrefDialog::checkOffense()
{
	return (prefProgram->useCustomProgram->isChecked()
		|| prefFortunes->type->currentItem()==Configuration::typeNonOffensive
		|| KMessageBox::warningContinueCancel(this,
		i18n("You have chosen to display potentially offensive fortunes!\n"
		"Please, please, please request a potentially offensive fortune if and only if you "
		"believe, deep down in your heart, that you are willing to be "
		"offended. (And that if you are, you’ll just revert to using non-offensive fortunes rather "
		"than give us grief about it, okay?)\nApply setting anyway?"), i18n("Display offensive fortunes?"),
		i18n("I am willing to be offended"))==KMessageBox::Continue);
}

void PrefDialog::updateData()
{
	prefAnimation->updateData();
	prefProgram->updateData();
	prefFortunes->updateData();
	enableButtonApply(false);
	emit settingsChanged();
}
