/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PREFDIALOG_H
#define PREFDIALOG_H

#include <kdialogbase.h>

class PrefAnimation;
class PrefProgram;
class PrefFortunes;

/**
@author Michał Kosmulski
*/
class PrefDialog : public KDialogBase
{
    Q_OBJECT
public:
    PrefDialog(QWidget *parent, const char *name=0, WFlags f=0);

    ~PrefDialog();

	PrefAnimation *prefAnimation;
	PrefProgram *prefProgram;
	PrefFortunes *prefFortunes;

protected:
	bool checkOffense();
	void updateData();

public slots:
	void slotApply();
	void slotOk();
	void slotDefault();
	void slotSomethingChanged();
	
signals:
	void settingsChanged();
};

#endif
