/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <knuminput.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <kfiledialog.h>
#include <klineedit.h>
#include <klistview.h>
#include <klocale.h>
#include "preffortunes.h"
#include "configuration.h"

PrefFortunes::PrefFortunes(QWidget *parent, const char *name)
 : PrefFortunesLayout(parent, name)
{
	updateDialog();
	
	fileSelector->setMode(KFile::File | KFile::Directory | KFile::ExistingOnly);
	fileSelector->lineEdit()->setTrapReturnKey(true);
	
	connect(fileSelector,SIGNAL(urlSelected(const QString &)),this,SIGNAL(somethingChanged()));
	connect(fileSelector,SIGNAL(returnPressed(const QString &)),this,SLOT(slotAdd()));
	connect(probability,SIGNAL(valueChanged(int)),this,SIGNAL(somethingChanged()));
	connect(considerSizes,SIGNAL(toggled(bool)),this,SIGNAL(somethingChanged()));
	connect(length,SIGNAL(activated(int)),this,SIGNAL(somethingChanged()));
	connect(type,SIGNAL(activated(int)),this,SIGNAL(somethingChanged()));
	
	connect(add,SIGNAL(clicked()),this,SLOT(slotAdd()));
	connect(remove,SIGNAL(clicked()),this,SLOT(slotRemove()));
	connect(removeAll,SIGNAL(clicked()),this,SLOT(slotRemoveAll()));
	connect(fortunes,SIGNAL(clicked(QListViewItem *)),this,SLOT(slotClicked(QListViewItem *)));
}


PrefFortunes::~PrefFortunes()
{
}

void PrefFortunes::updateDialog()
{
	fileSelector->completionObject()->setDir(Config().fortunesDir);
	fileSelector->fileDialog()->setURL(Config().fortunesDir);
	updateFortunesFromLists(Config().selectedFortunes,Config().selectedFortunesProbs);
	considerSizes->setChecked(Config().considerSizes);
	length->setCurrentItem(Config().length);
	type->setCurrentItem(Config().type);
}

void PrefFortunes::updateData()
{
	Config().fortunesDir = fileSelector->fileDialog()->baseURL().path();
	Config().selectedFortunes.clear();
	Config().selectedFortunesProbs.clear();
	QListViewItem *item = fortunes->firstChild();
	while(item!=NULL) {
		Config().selectedFortunes.push_back(item->text(0));
		Config().selectedFortunesProbs.push_back(percentString2Int(item->text(1)));
		item = item->nextSibling();
	}
	Config().considerSizes = considerSizes->isChecked();
	Config().length = (Configuration::Lengths)length->currentItem();
	Config().type = (Configuration::Types)type->currentItem();
}

void PrefFortunes::loadDefaults()
{
	fileSelector->completionObject()->setDir(Config().defFortunesDir);
	fileSelector->fileDialog()->setURL(Config().defFortunesDir);
	updateFortunesFromLists(Config().defSelectedFortunes,Config().defSelectedFortunesProbs);
	considerSizes->setChecked(Config().defConsiderSizes);
	length->setCurrentItem(Config().defLength);
	type->setCurrentItem(Config().defType);
}

void PrefFortunes::slotAdd()
{
	if (fileSelector->url().isEmpty())
		return;
	//modify existing item if it is already in the list
	QListViewItem *existingItem = fortunes->findItem(fileSelector->url(),0);
	if(NULL==existingItem) {
		new QListViewItem(fortunes,fileSelector->url(),int2PercentString(probability->value()));
	} else {
		existingItem->setText(1,int2PercentString(probability->value()));
	}
	emit somethingChanged();
}

void PrefFortunes::slotRemove()
{
	delete fortunes->selectedItem();
	emit somethingChanged();
}

void PrefFortunes::slotRemoveAll()
{
	fortunes->clear();
	emit somethingChanged();
}

void PrefFortunes::slotClicked(QListViewItem *item)
{
	fileSelector->setURL(item->text(0));
	probability->setValue(percentString2Int(item->text(1)));
}

int PrefFortunes::percentString2Int(QString str)
{
	if(str==i18n("default")) str="0";
	str.replace("%","");
	return str.toInt();
}

QString PrefFortunes::int2PercentString(int num)
{
	QString value;
	if (num==0) {
		value = i18n("default");
	} else {
		value.setNum(num);
		value+="%";
	}
	return value;
}

void PrefFortunes::updateFortunesFromLists(QStringList files,QValueList<int> probs)
{
	fortunes->clear();
	QStringList::iterator it = files.begin();
	QValueList<int>::iterator it2 = probs.begin();
	while(it!=files.end() && it2!=probs.end()) {
		new QListViewItem(fortunes,*it,int2PercentString(*it2));
		it++;
		it2++;
	}
}

#include "preffortunes.moc"
