/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PREFFORTUNES_H
#define PREFFORTUNES_H

#include <qwidget.h>
#include <klistview.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <PrefFortunesLayout.h>

/**
@author Michał Kosmulski
*/
class PrefFortunes : public PrefFortunesLayout
{
Q_OBJECT
public:
    PrefFortunes(QWidget *parent = 0, const char *name = 0);

    ~PrefFortunes();
    
    void updateDialog();
    void updateData();
    void loadDefaults();

protected:
	int percentString2Int(QString str);
	QString int2PercentString(int num);
	void updateFortunesFromLists(QStringList files,QValueList<int> probs);
    
signals:
	void somethingChanged();
	
public slots:
	void slotAdd();
	void slotRemove();
	void slotRemoveAll();
	void slotClicked(QListViewItem *item);
};

#endif
