/***************************************************************************
 *   Copyright (C) 2004 by Michał Kosmulski                                *
 *   mkosmul <at> users <dot> sourceforge <dot> net                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qradiobutton.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include "prefprogram.h"
#include "configuration.h"

PrefProgram::PrefProgram(QWidget *parent, const char *name)
 : PrefProgramLayout(parent, name)
{
	updateDialog();
	
	connect(useCustomProgram,SIGNAL(toggled(bool)),this,SIGNAL(somethingChanged()));
	connect(customProgram,SIGNAL(textChanged(const QString &)),this,SIGNAL(somethingChanged()));
}


PrefProgram::~PrefProgram()
{
}

void PrefProgram::updateDialog()
{
	if (Config().useCustomProgram)
		useCustomProgram->setChecked(true);
	else
		fortune->setChecked(true);
	customProgram->setText(Config().customProgram);
}

void PrefProgram::updateData()
{
	Config().useCustomProgram = useCustomProgram->isChecked();
	Config().customProgram = customProgram->text();
}

void PrefProgram::loadDefaults()
{
	if (Config().defUseCustomProgram)
		useCustomProgram->setChecked(true);
	else
		fortune->setChecked(true);
	customProgram->setText(Config().defCustomProgram);
}

#include "prefprogram.moc"
