#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/linux_logo.conf.new

# if rc.local doesn't exist, create it
if [ ! -e etc/rc.d/rc.local ]; then
  echo "#!/bin/sh" > etc/rc.d/rc.local
  chmod 755 etc/rc.d/rc.local
fi

if grep "rc.linux_logo" etc/rc.d/rc.local > /dev/null ; then
  true
else
  cat <<EOF>> /etc/rc.d/rc.local
# Start linux_logo:
test -x /etc/rc.d/rc.linux_logo && sh /etc/rc.d/rc.linux_logo start
EOF
fi

echo
echo "Done; linux_logo is successfully installed" 
echo "If you want that linux_logo run automatically"
echo "at the end of the boot process, then "
echo "make the daemon executable"
echo "changing its permisions, for example:"
echo "chmod +x /etc/rc.d/rc.linux_logo"
echo 
echo "HINT: add "linux_logo" line in your .bashrc file" 
echo 

